<?php if (!defined('ABSPATH')) exit;
/**
 * Plugin Name: افزونه ها - سامانه رزرواسیون بلیت رویداد
 * Description:<strong>جامع ترین بستر مدیریت و فروش بلیت کنسرت، سینما، تئاتر  در ایران</strong> 
 * Plugin URI: https://www.rtl-theme.com/author/mardane/products/
 * Author: <strong>افزونه ها</strong>
 * Version: 5.0.0
 * Author URI: https://www.rtl-theme.com/author/mardane/products/
*/
if (!class_exists('EL_Abstract_Payment')) return;
class EL_Payment_Saman extends EL_Abstract_Payment {
	public $id = 'saman';
	function __construct() {
		$this->_title = 'درگاه سامان';
		add_action('wp_ajax_eventlist_saman_request', array($this, 'eventlist_saman_request'));
		add_action('wp_ajax_nopriv_eventlist_saman_request', array($this, 'eventlist_saman_request'));
		add_action('wp_ajax_eventlist_saman_verify', array($this, 'eventlist_saman_verify'));
		add_action('wp_ajax_nopriv_eventlist_saman_verify', array($this, 'eventlist_saman_verify'));
		parent::__construct();
	}

	function fields() {
		return array(
			'title' => 'درگاه سامان',
			'fields' => array(
				'fields' => array(
					array(
						'type' => 'select',
						'label' => __( 'فعال', 'eventlist' ),
						'desc' => __( 'You have to active to use this gateway', 'eventlist' ),
						'atts' => array(
							'id' => 'saman_active',
							'class' => 'saman_active'
						),
						'name' => 'saman_active',
						'options' => array(
							'no' => __( 'خیر', 'eventlist' ),
							'yes' => __( 'بله', 'eventlist' )
						)
					),
					array(
						'type' => 'input',
						'label' => __( 'مرچنت آیدی سامان', 'eventlist' ),
						'desc' => __( 'کد مرچنت بانک سامان', 'eventlist' ),
						'name' => 'saman_merchant',
					),
				),
			)
		);
	}

	function render_form() {
		return 'Payment via Saman';
	}

	function process() {
		$booking_id = EL()->cart_session->get( 'booking_id' );
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total', true ) * 10;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total_after_tax', true ) * 10;
		$red = admin_url('admin-ajax.php?action=eventlist_saman_verify&booking_id='.$booking_id.'&shf_key='.session_id());
		ini_set("soap.wsdl_cache_enabled", "0");
		$client = new SoapClient('https://sep.shaparak.ir/payments/referencepayment.asmx?WSDL');
		$result = $client->RequestToken(EL()->options->checkout->get('saman_merchant'), time(), $total, '', '', '', '', '', '', '', '', '', $red);
		if (is_numeric($result) && 0 > $result) {
			echo json_encode(array('el_message' => 'Saman Payment Error : ' . $result));
			wp_die();
		}
		$_SESSION['eventlist_saman_form'] = '<form name="afzoneha_saman_payment_form" action="https://sep.shaparak.ir/Payment.aspx" method="post">
				<input type="hidden" name="Token" value="'.$result.'" />
				<input type="hidden" name="RedirectURL" value="'.$red.'" />
				<noscript><input type="submit" value="Pay" /></noscript>
			</form><script type="text/javascript" charset="utf-8">
				document.afzoneha_saman_payment_form.submit();
			</script>';
		return array(
			'status' => 'success',
			'url' => admin_url('admin-ajax.php?action=eventlist_saman_request')
		);
	}
	function eventlist_saman_request() {
		if (isset($_SESSION['eventlist_saman_form']) && strlen($_SESSION['eventlist_saman_form']) > 66) {
			echo $_SESSION['eventlist_saman_form'];
			$_SESSION['eventlist_saman_form'] = true;
			exit;
		}
	}
	function eventlist_saman_verify() {
		$MID        = isset($_POST['MID'])       ? $_POST['MID']       : 0;
		$CID        = isset($_POST['CID'])       ? $_POST['CID']       : 0;
		$RRN        = isset($_POST['RRN'])       ? $_POST['RRN']       : 0;
		$State      = isset($_POST['State'])     ? $_POST['State']     : '';
		$RefNum     = isset($_POST['RefNum'])    ? $_POST['RefNum']    : 0;
		$ResNum     = isset($_POST['ResNum'])    ? $_POST['ResNum']    : 0;
		$TraceNo    = isset($_POST['TRACENO'])   ? $_POST['TRACENO']   : 0;
		$ScrPan     = isset($_POST['SecurePan']) ? $_POST['SecurePan'] : 0;
		$booking_id = isset($_GET['booking_id']) ? $_GET['booking_id'] : 0;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total', true ) * 10;
		$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total_after_tax', true ) * 10;
		if (!isset($_SESSION['eventlist_saman_form'])) {
			session_destroy();
			session_id($_GET['shf_key']);
			session_start();
		}
		if (!$booking_id) {
			wp_redirect(get_cart_page());
			exit;
		}
		if (!$total) {
			wp_redirect(get_cart_page());
			exit;
		}
		if (strtolower($State) == 'ok') {
			ini_set("soap.wsdl_cache_enabled", "0");
			$client = new SoapClient('https://sep.shaparak.ir/payments/referencepayment.asmx?WSDL');
			$result = $client->VerifyTransaction($RefNum, EL()->options->checkout->get('saman_merchant'));
			if ($result > 0 && intval($result) == intval($total)) {
				EL_Booking::instance()->booking_success( $booking_id, $this->_title );
				wp_redirect(get_thanks_page());
			} else {
				echo 'Saman Error : ' . $result;
				exit;
			}
		} else {
			wp_redirect(get_cart_page());
			exit;
		}
	}
}

add_filter('el_payment_gateways_avaiable', function($methods) {
	$methods[] = 'EL_Payment_Saman';
	return $methods;
}, 666);

?>