<?php
/**
 * Plugin Name: افزونه ها - سامانه رزرواسیون بلیت رویداد
 * Description:<strong>جامع ترین بستر مدیریت و فروش بلیت کنسرت، سینما، تئاتر  در ایران</strong> 
 * Plugin URI: https://www.rtl-theme.com/author/mardane/products/
 * Author: <strong>افزونه ها</strong>
 * Version: 5.0.0
 * Author URI: https://www.rtl-theme.com/author/mardane/products/
*/

if (!defined('ABSPATH')) exit;

if (!class_exists('EL_Abstract_Payment')) return;
class EL_Setting_SMS extends EL_Abstract_Setting {
	public $_id = 'sms';
	public $_title = null;
	public $_position = 15;

	public function __construct() {
		$this->_title = 'تنظیمات پیامک براساس پترن';
		add_action('updated_postmeta', array($this, 'send_sms'), 666, 4);
		parent::__construct();
	}

	public function send_sms($meta_id, $booking_id, $meta_key, $meta_value) {
		if ($meta_key == OVA_METABOX_EVENT.'status' && $meta_value == 'Completed') {
	    	$full_name = get_post_meta( $booking_id, OVA_METABOX_EVENT.'name', true );
	    	$first_name = get_post_meta( $booking_id, OVA_METABOX_EVENT.'first_name', true );
	    	$last_name = get_post_meta( $booking_id, OVA_METABOX_EVENT.'last_name', true );
	    	$title_event = get_post_meta( $booking_id, OVA_METABOX_EVENT.'title_event', true );
	    	$date_cal = get_post_meta( $booking_id, OVA_METABOX_EVENT.'date_cal', true );
	    	$total = get_post_meta( $booking_id, OVA_METABOX_EVENT.'total', true );
	    	$payment_method = get_post_meta( $booking_id, OVA_METABOX_EVENT.'payment_method', true );
	    	$phone = get_post_meta( $booking_id, OVA_METABOX_EVENT.'phone', true );
	    	if (strtolower($payment_method) == 'saman') {
	    		$payment_method = 'بانک سامان';
	    	} elseif (strtolower($payment_method) == 'mellat') {
	    		$payment_method = 'بانک ملت';
	    	}
			if (EL()->options->sms->get('sms_send_user') && $phone) {
			    try {
			    	$arr = array(
			    		'user_name' => $full_name,
			    		'event_name' => $title_event,
			    		'event_date' => $date_cal,
			    		'booking_id' => $booking_id,
			    		'amount' => $total,
			    		'payment_gateway' => $payment_method
			    	);


			    	$c = new \SoapClient("https://ippanel.com/class/sms/wsdlservice/server.php?wsdl");
			    	$r = $c->sendPatternSms(EL()->options->sms->get('sms_sender'),array($phone),EL()->options->sms->get('sms_username'),EL()->options->sms->get('sms_password'),EL()->options->sms->get('sms_pattern_user'),$arr);
			    } catch (exception $e) { }
			}
			$phone = $phone = EL()->options->sms->get('sms_admin_mobile');
			if (EL()->options->sms->get('sms_send_admin') && $phone) {
			    try {
			    	$arr = array(
			    		'user_name' => $full_name,
			    		'event_name' => $title_event,
			    		'event_date' => $date_cal,
			    		'booking_id' => $booking_id,
			    		'amount' => $total,
			    		'payment_gateway' => $payment_method
			    	);
			    	$c = new \SoapClient("https://ippanel.com/class/sms/wsdlservice/server.php?wsdl");
			    	$r = $c->sendPatternSms(EL()->options->sms->get('sms_sender'),array($phone),EL()->options->sms->get('sms_username'),EL()->options->sms->get('sms_password'),EL()->options->sms->get('sms_pattern_admin'),$arr);
			    } catch (exception $e) { }
			}
		}
	}

	public function load_field() {
		return array(
			'title' => 'SMS Notification',
			'fields' => array(
				'fields' => array(
					array(
						'type' => 'checkbox',
						'name' => 'sms_send_admin',
						'label' => 'ارسال پیامک به مدیرسایت',
						'desc' => 'ارسال پیامک به مدیرسایت',
					),
					array(
						'type' => 'checkbox',
						'name' => 'sms_send_user',
						'label' => 'ارسال پیامک به خریدار',
						'desc' => 'ارسال پیامک به خریدار',
					),
					array(
						'type' => 'input',
						'name' => 'sms_admin_mobile',
						'label' => 'شماره موبایل مدیرسایت',
						'desc' => 'شماره موبایل مدیرسایت',
					),
					array(
						'type' => 'input',
						'name' => 'sms_username',
						'label' => 'نام کاربری',
						'desc' => 'نام کاربری',
					),
					array(
						'type' => 'input',
						'name' => 'sms_password',
						'label' => 'رمزعبور',
						'desc' => 'رمزعبور',
					),
					array(
						'type' => 'input',
						'name' => 'sms_sender',
						'label' => 'شماره خط ارسال کننده',
						'desc' => 'شماره خط ارسال کننده',
					),
					array(
						'type' => 'input',
						'name' => 'sms_pattern_admin',
						'label' => 'کدپترین پیامک مدیرسایت',
						'desc' => 'کدپترین پیامک مدیرسایت',
					),
					array(
						'type' => 'input',
						'name' => 'sms_pattern_user',
						'label' => 'کد پترن پیامک خریدار',
						'desc' => 'کد پترن پیامک خریدار',
					),
				)
			)
		);
	}

}
$GLOBALS['sms_settings'] = new EL_Setting_SMS();

?>