<?php if( ! defined( 'ABSPATH' ) ) exit(); 

get_header();

$author_id = get_query_var( 'author' );
$display_name = get_user_meta( $author_id, 'display_name', true ) ? get_user_meta( $author_id, 'display_name', true ) : get_the_author_meta( 'display_name', $author_id );

$archive_type = 'type3'; // You can change value to typ1, type2, type3, type4, type5
$layout_column = 'single-column'; // You can change value to single-column, two-column, three-column

?>

<div class="author_page">
	
	<div class="author_page_sidebar">
		<?php do_action( 'el_author_info' ); ?>
	</div>

	<!-- Event List -->
	<div class="event_list">

		<h3 class="heading second_font">
			<?php echo esc_html( $display_name ); esc_html_e( '\'s Listing ', 'eventlist' ); ?>
		</h3>
		
		<?php if( have_posts() ): ?>

			<?php
				/**
				 * Hook: el_before_archive_loop
				 * @hooked: 
				 */
				do_action( 'el_before_archive_loop' );
			?>
				
					<div id="el_main_content">
						
						<ul class="event_archive <?php echo $archive_type ?> <?php echo $layout_column ?>">

							<?php while ( have_posts() ) : the_post(); ?>
					
								<?php el_get_template_part( 'content', 'event-'.$archive_type ); ?>

							<?php endwhile; wp_reset_query(); // end of the loop. ?>
							
						</ul>

					</div>
				
			<?php
				/**
				 * Hook: el_after_archive_loop.
				 *
				 * @hooked el_pagination - 10
				 */
				do_action( 'el_after_archive_loop' );
			?>	
		<?php else : ?>
			<p><?php esc_html_e('Event not found', 'eventlist') ?></p>
		<?php endif; ?>
		

	</div>

</div>


<?php

get_footer();