<?php if( ! defined( 'ABSPATH' ) ) exit(); ?>
<?php

$id = get_the_id();

$prefix = OVA_METABOX_EVENT;

$map_lat = (float)get_post_meta( $id, $prefix.'map_lat', true );
$map_lng = (float)get_post_meta( $id, $prefix.'map_lng', true );
$map_address = (string)get_post_meta( $id, $prefix.'address', true );

$event_zoom_map = EL()->options->event->get( 'event_zoom_map', 17 );

if( $map_lat && $map_lng){
?>
<div class="event_map_section event_section_white">
	
	<h3 class="second_font heading map">
		<?php esc_html_e( 'Map', 'eventlist' ); ?>
	</h3>

	<div id="event_map" class="event_map" data-lat="<?php echo esc_attr($map_lat); ?>" data-lng="<?php echo esc_attr($map_lng); ?>" data-address="<?php echo esc_attr($map_address); ?>" data-zoom="<?php echo esc_attr($event_zoom_map); ?>"></div>
	
</div>
<?php } ?>