<?php if (post_password_required()) return; ?>

<div class="content_comments">
	<div id="comments" class="comments">

		<?php if(have_comments()){ ?>
			<div>
				<h4 class="number-comments second_font"> 
					<?php 
					if (is_singular( 'event' )) {
						comments_number( esc_html__('نقد و بررسی', 'meup'), esc_html__( 'نقد و بررسی', 'meup' ).('<span>(1)</span>'), esc_html__( 'نقد و بررسی', 'meup' ).('<span>(%)</span>') ); 
					} else {
						comments_number( esc_html__('نظرات', 'meup'), esc_html__( 'نظر', 'meup' ).('<span>(1)</span>'), esc_html__( 'نظرات', 'meup' ).('<span>(%)</span>') );
					}
					?>
				</h4>
			</div>

		<?php } ?>

		<?php if (have_comments()) { ?>
			<ul class="commentlists">
				<?php wp_list_comments('callback=meup_theme_comment'); ?>
			</ul>
			<?php
      	// Are there comments to navigate through?

			if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
				<footer class="navigation comment-navigation" role="navigation">
					<div class="nav_comment_text"><?php esc_html_e( 'ناوبری نظرات', 'meup' ); ?></div>
					<div class="previous"><?php previous_comments_link(__('&larr; نظرات قدیمی تر', 'meup')); ?></div>
					<div class="next right"><?php next_comments_link(__('نظرات جدیدتر &rarr;', 'meup')); ?></div>
				</footer><!-- .comment-navigation -->
			<?php endif; // Check for comment navigation ?>

			<?php if (!comments_open() && get_comments_number()) { ?>
				<p class="no-comments"><?php esc_html_e( 'نظرات بسته شده است.', 'meup' ); ?></p>
			<?php } ?>

		<?php } ?>

		<?php

		$aria_req = ($req ? " aria-required='true'" : '');

		$commenter = wp_get_current_commenter();
		$consent   = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

		if (is_singular( 'event' )) {
			$title_comment = wp_kses('<h4 class="title-comment second_font">' . esc_html__( 'افزودن یک نظر جدید', 'meup' ) . '</h4>', true);
			$field_author = '<div class="name"><label class="label_field second_font">'.esc_html__( 'نام*', 'meup' ).'</label><input type="text" name="author" value="' . esc_attr($commenter['comment_author']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_attr__('نام خود را وارد کنید','meup') .'" /></div>';
			$field_email = '<div class="email"><label class="label_field second_font">'.esc_html__( 'ایمیل*', 'meup' ).'</label><input type="text" name="email" value="' . esc_attr($commenter['comment_author_email']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_attr__('ایمیل شما','meup') .'" /></div>';
			$field_cookies = '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . esc_attr($consent) . ' />' . '<label for="wp-comment-cookies-consent">'.esc_html__('نام و آدرس ایمیل من را برای دفعات بعدی ذخیره کن.', 'meup').'</label></p>';
			
		} else {
			$title_comment = wp_kses('<h4 class="title-comment second_font">' . esc_html__( 'یک نظر ثبت کنید', 'meup' ) . '</h4>', true);
			$field_author = '<div class="name"><i class="far fa-user"></i><input type="text" name="author" value="' . esc_attr($commenter['comment_author']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_attr__('نام خود را وارد کنید','meup') .'" /></div>';
			$field_email = '<div class="email"><i class="far fa-envelope"></i><input type="text" name="email" value="' . esc_attr($commenter['comment_author_email']) . '" ' . esc_attr($aria_req) . ' class="form-control" placeholder="'. esc_attr__('ایمیل شما','meup') .'" /></div>';
			$field_cookies = '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . esc_attr($consent) . ' />' . '<label for="wp-comment-cookies-consent">'.esc_html__('نام و آدرس ایمیل من را برای دفعات بعدی ذخیره کن.', 'meup').'</label></p>';
		}

		$comment_args = array(
			'title_reply' => $title_comment,
			'fields' => apply_filters('comment_form_default_fields', array(
				'author' => $field_author,
				'email' => $field_email,
				'cookies' => $field_cookies,
			)),
			'comment_field' => '<div class="wrap_comment"><label class="label_field second_font">'.esc_html__( 'نظر', 'meup' ).'</label><textarea class="form-control" rows="4" name="comment" placeholder="'. esc_attr__('نظر شما','meup') .'"></textarea></div>',
			'label_submit' => esc_html__('ارسال نظر','meup'),
			'comment_notes_before' => '',
			'comment_notes_after' => '',
		);
		?>

		<?php global $post; ?>
		<?php if ('open' == $post->comment_status) { ?>
			<div class="wrap_comment_form">
				<div class="row">
					<div class="col-md-12">
						<?php comment_form($comment_args); ?>        
					</div>
				</div>
			</div><!-- end commentform -->
		<?php } ?>


	</div><!-- end comments -->
</div>