<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Rest\Api\V2010\Account\Usage\RecordList;
use Twilio\Rest\Api\V2010\Account\Usage\TriggerContext;
use Twilio\Rest\Api\V2010\Account\Usage\TriggerList;
use Twilio\Version;

/**
 * @property RecordList records
 * @property TriggerList triggers
 * @method TriggerContext triggers(string $sid)
 */
class UsageList extends ListResource {
    protected $_records = null;
    protected $_triggers = null;

    /**
     * Construct the UsageList
     * 
     * @param Version $version Version that contains the resource
     * @param string $accountSid A 34 character string that uniquely identifies
     *                           this resource.
     * @return UsageList
     */
    public function __construct(Version $version, $accountSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('accountSid' => $accountSid, );
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     *
     * @return ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get($name) {
        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $property = $this->$name;
        if (method_exists($property, 'getContext')) {
            return call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Api.V2010.UsageList]';
    }

    /**
     * Access the records
     */
    protected function getRecords() {
        if (!$this->_records) {
            $this->_records = new RecordList($this->version, $this->solution['accountSid']);
        }

        return $this->_records;
    }

    /**
     * Access the triggers
     */
    protected function getTriggers() {
        if (!$this->_triggers) {
            $this->_triggers = new TriggerList($this->version, $this->solution['accountSid']);
        }

        return $this->_triggers;
    }
}