<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

use Codevz_Plus as Codevz_Plus;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

class Xtra_Elementor_Widget_svg extends Widget_Base {

	protected $id = 'cz_svg';

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return esc_html__( 'Svg Cover', 'codevz' );
	}
	
	public function get_icon() {
		return 'xtra-svg';
	}

	public function get_categories() {
		return [ 'xtra' ];
	}

	public function get_keywords() {

		return [

			esc_html__( 'XTRA', 'codevz' ),
			esc_html__( 'Cover', 'codevz' ),
			esc_html__( 'SVG', 'codevz' ),
			esc_html__( 'Photo', 'codevz' ),
			esc_html__( 'Mask', 'codevz' ),

		];

	}

	public function get_style_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function get_script_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function register_controls() {

		$free = Codevz_Plus::is_free();

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Settings', 'codevz' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'codevz' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Codevz_Plus::$url . 'assets/img/p.svg',
				],
			]
		);

		$this->add_control(
			'fill',
			[
				'label' => esc_html( 'Color', 'codevz' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
			]
		);

		$this->add_control(
			'svg',
			[
				'label' => esc_html__( 'Select Mask', 'codevz' ),
				'type' => 'image_select',
				'label_block' => true,
				'default' => '1',
				'options' => array(
					'1' => [
						'title'=> '1',
						'url'=> Codevz_Plus::$url . 'assets/img/svg_1.jpg'
					],
					'2' => [
						'title'=> '2',
						'url'=> Codevz_Plus::$url . 'assets/img/svg_2.jpg'
					],
					'3' => [
						'title'=> '3',
						'url'=> Codevz_Plus::$url . 'assets/img/svg_3.jpg'
					],
					'4' => [
						'title'=> '4',
						'url'=> Codevz_Plus::$url . 'assets/img/svg_4.jpg'
					],
					'5' => [
						'title'=> '5',
						'url'=> Codevz_Plus::$url . 'assets/img/svg_5.jpg'
					],
					'6' => [
						'title'=> '6' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_6.jpg'
					],
					'7' => [
						'title'=> '7' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_7.jpg'
					],
					'8' => [
						'title'=> '8' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_8.jpg'
					],
					'9' => [
						'title'=> '9' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_9.jpg'
					],
					'10' => [
						'title'=> '10' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_10.jpg'
					],
					'11' => [
						'title'=> '11' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_11.jpg'
					],
					'12' => [
						'title'=> '12' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_12.jpg'
					],
					'13' => [
						'title'=> '13' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_13.jpg'
					],
					'14' => [
						'title'=> '14' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_14.jpg'
					],
					'15' => [
						'title'=> '15' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_15.jpg'
					],
					'16' => [
						'title'=> '16' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_16.jpg'
					],
					'17' => [
						'title'=> '17' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_17.jpg'
					],
					'18' => [
						'title'=> '18' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_18.jpg'
					],
					'19' => [
						'title'=> '19' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_19.jpg'
					],
					'20' => [
						'title'=> '20' . ( $free ? ' [' . esc_html__( 'PRO', 'codevz' ) . ']' : '' ),
						'url'=> Codevz_Plus::$url . 'assets/img/svg_20.jpg'
					],
				),
			]
		);

		$this->add_responsive_control(
			'pos',
			[
				'label' => esc_html__( 'Vertical Offset', 'codevz' ),
				'type' => $free ? 'codevz_pro' : Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cz_svg' => 'background-position-y: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'width',
			[
				'label' => esc_html__( 'Custom Width', 'codevz' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 10,
						'max' => 100,
						'step' => 1,
					],
					'px' => [
						'min' => 50,
						'max' => 800,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cz_svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Parallax settings.
		Xtra_Elementor::parallax_settings( $this );

	}

	public function render() {

		// Settings.
		$settings = $this->get_settings_for_display();

		Xtra_Elementor::parallax( $settings );

		?>
		<div class="cz_svg clr" style="background-image: url(<?php echo ( isset( $settings['image']['url'] ) ? $settings['image']['url'] : '' ); ?>);">
			<?php echo self::svg( $settings['svg'], $settings['fill'] ); ?>
		</div>
		<?php

		Xtra_Elementor::parallax( $settings, true );

	}

	public function svg( $svg = '1', $f = '#fff' ) {

		$f = $f . ';stroke:' . $f .';stroke-width: 2px';

		if ( $svg === '1' ) {
			$svg = '<svg xmlns="//www.w3.org/2000/svg" viewBox="0 0 796 382">
<path style="fill:' . $f . '" d="M0,0H796V382H0V0ZM488,35v3h2v1h1V36ZM297,43c6.587,0.223,8.46.787,13-1V41h-4V38c-8.227-.414-15.573-2.636-24-1v1l15,2v3Zm42-7c1.72,0.881,1.278.889,3,0h-3Zm22,0v2h1C361.369,36.246,361.807,37.029,361,36Zm145,0c-1.121,2.091-1.434,1.832-2,5,2.725,1.708,2.5,2.536,7,3,6.089-5.176,20.037,1.537,26-2l-10-2V38C522.73,35.873,510.524,37.718,506,36ZM356,37c1.72,0.881,1.278.889,3,0h-3Zm138,0c1.457,2.124,2.624,2.785,5,4V39a6.107,6.107,0,0,1-2-2h-3ZM298,39h2v1C298.246,39.369,299.029,39.807,298,39Zm38,0c1.35,1.624.64,1.121,3,2V40ZM230,40c-0.771.682-2.232,1.311-3,2a11.565,11.565,0,0,1,2,3,77.912,77.912,0,0,1,17-2V41h-1V40C240.266,41.638,235.651,40.257,230,40Zm184,2v2h6V42h-6ZM249,46c0.828,3.245-.49,1.528,2,3V47c-0.241-1.672-.927-2.37-4-4v2h-1v1h3Zm31,0h4V45l-4-2v3Zm249,0c-0.828-3.245.49-1.528-2-3-0.771.682-2.232,1.311-3,2h2C527.073,45.752,526.946,45.6,529,46ZM327,49l7,1,1-2h-1V47h-3V44h-5v2C326.752,47.073,326.6,46.946,327,49Zm-40-4c1.4,2.006,1.346,2.066,4,3V47h1c-1.021-.8-0.274-0.355-2-1C288.927,45.248,289.054,45.4,287,45Zm6,0v2h2V45h-2Zm42,0v2C336.609,45.812,336.224,46.582,335,45Zm7,1c-0.674,3.152-.666,2.1-2,4C343.762,48.688,344.25,48.327,342,46Zm191,0c1.359,1.261,1.768,1.365,4,2C535.641,46.739,535.232,46.635,533,46ZM74,127a39.937,39.937,0,0,0-13,3v2h8c1.6-1.155,3.474-.176,6-1,5.212-1.7,7.671-6.309,14-1-8.31.147-5.694,3.116-10,6-1.837,1.23-5.332.785-7,2l7,1c-0.287-2.457-.659-0.482,0-3l9-1v1c-2.076.372-1.924,0.242-3,1,2.72-.007,4.6.039,6,1H90c-2.038,1.883-3.835,2-8,2a12.667,12.667,0,0,1-1,4h2c3.779-2.623,11.639-2.131,18-2v1H99c-2.939,3.055-2.739-.27-6,1-3.56,1.387-5.179,6.447-10,8l-1-3c-4.754,1.862-6.341,2.974-7,9-8.625-.893-10.006,2.678-18,2v4c2.076,0.372,1.925.242,3,1-1.393,1.221-2.454,4.112-4,5-5.225,3-9.574.114-12,6-2.84,4.482-.049,12.324,0,18l2,48H62c-0.386,19.458,5.371,33.221,9,49-4.165.125-4.608,0.7-7,2-0.828-3.245.49-1.528-2-3-1.678,2.369-3.16,2.788-6,4v1c6.372-.04,6.172.939,9,4,1.377-2.979,4.306-4.445,7-6-0.2,5.985.354,11.772,3,15,1.073,0.752.946,0.6,3,1,1.008-.693,4-1.287,5-2a6.1,6.1,0,0,1-2-2l15-5v-1H88v-2h2c1.18,0.8,1.681.773,4,1v-1c-3.723-1.541-3.755-3.063-5-4-0.771.682-2.232,1.311-3,2a6.1,6.1,0,0,1,2,2c-3.764.142-3.515-.472-5,2,2.076,0.372,1.924.242,3,1H85v1c-3.048,1.785-4.538,3.317-9,4v-1c2.593-2.45.945-4.761,2-7,2.921-2.187,6.176-4.142,9-6v-1H82c-1.838,1.238-5.7,1.089-9,1l-2-11c5.094-1.107,4.537-3.1,7-4,1.549-1.049,4.085-1.031,7-1v2a12.662,12.662,0,0,0-4,1c1.021,0.8.274,0.355,2,1,4.982,3.113,10.643-2.091,17,0,1.559,0.513,2.787,3.386,4,4,0.211,0.107,6.834-3.664,9-4l2,3c-8.139,1-15.078,7.25-21,6,0.062,2.557.727,1.922-3,3,1.021,0.8.274,0.355,2,1,3.088,1.578,5.06-1.185,7,4,1.221,2.141.388,2.77,0,6h1c1.371-4.22,3.465-4.958,9-5-0.372,2.076-.242,1.924-1,3-1.194.777-4.815,1.2-6,2h1c5.667,3.927,19.462,5.078,27,6a30.439,30.439,0,0,0-1-7l3-1c2.475-2.288,6.3-2.9,11-3v1c-3.568.593-3.367,0.733-5,3h4c1.837-1.738,3.571-2.525,6-1-6.5.968-3.607,2.877-14,3-1.073-.752-0.946-0.6-3-1v2h2c2.289,1.45,4.455.519,6,3-2.328.195-2.826,0.193-4,1h6c-0.022-3.487.127-3.319,6-3,2,2.682,2.273.662,7,0,1.47,2.271,2.1,3.009,5,4,5.121-5.725,11.7.173,17-1l2-3c4.042-1.164,6.333,3.984,11,2,2.8-1.191,1.591-3.483,7-4v2c-2.542,1.287-2.872,1.1-4,4h1v1c2.189-.9,1.443-0.862,3-2v3c4.957,0.119,8.778-.392,11-3a6.1,6.1,0,0,1-2-2h5c0.516,4.376,1.216,3.437,3,6-5.175.112-6.677,1.371-10,3v1c3.647,0.32,6.7,1.733,8,1a23.9,23.9,0,0,1,9-3c0.039,2.306.507,1.723,1,6-2.142.991-5.077,3.393-7,4l-12-1c-4.267,1.33-7.455,5.123-14,6v3c-2.328.195-2.826,0.193-4,1l9,1v-3c6.151-.457,17.16-6.748,20-5l2,1-1-3h2c1.8,0.888,1.81.3,5,0,0.515,4,15.3,8,21,3h-6v-4h-2c-2.655,2.592-7.164,2.384-10,0h-1v-1h12v-3h4c0.052-2.729.072-1.184,2-4h1v3c-2.689,1.809-3.427,2.92-4,7h1v1l9-3c0.708,2.347,1.025,2.234,2,4,2.4-1.157,1.735-2.039,4-1h2v1c-12.173,1.6-16.729,5.994-30,3v2a6.1,6.1,0,0,1,2,2c-4.127.332-11.9-1.633-13-1a11.568,11.568,0,0,0-2,3h2s29.554-.1,32-1c3.421-1.26,3.041-3.979,8-5-0.281,4.062.511,2.708,3,6a29.121,29.121,0,0,0-12,2l1,3h4c6.468-5.817,17.306.5,24,1v-3c3.871-.3,9.575-1.037,12-3,2.849-3.8,1.133-5.7,8-6v1c-1.779,1.878-1.848.793-1,3,1.073,0.752.946,0.6,3,1,4.1-2.925,17.63-2.919,23-1v1c-11.9.1-24.723,5.534-38,6-0.327,2.212,1.038,1.079-1,2-0.286-.195-2.321-2.44-3-2l-1,3c-2.419,1.116-7.248.363-9,1v1h15c1.073,0.752.946,0.6,3,1v-3c19.464-.77,37.19-2.872,52,4,0.98-4.187,3.644-5.361,7-7v-1a34.041,34.041,0,0,1-8-1v-1h1c3.449-2.882,8.243-2.993,13-2v1h-1a19.54,19.54,0,0,1-4,2v1h5l9-3v-1c-4.052.079-2.386,1.636-4-1h-1v-1h6c1.619,2.639.751,2.438,3,2l4-1v-1h-4q-1-5.5-2-11c5.928-.224,1.088-2.583,8-3v1h1c-0.74.872-1.26,1.128-2,2,2.076,0.372,1.924.242,3,1-1.754.631-.971,0.193-2,1,8.81,0.026,16.093,2.307,23,4v1a16.987,16.987,0,0,0-6,1v2c3.042,0.075,2.744.756,4,0,3.4-3.175,1.781-4.592,7-5,2.4-1.5,6.866-1.343,9-3-2.977-.385-3.4-0.525-5-2l9-2,3,4c2.091-1.121,1.832-1.434,5-2,1.8,2.594,4.031,3.6,7,5v1h-1c-1.4.885-5.608,1.085-7,2h2c2.227,2.653,6.655,3.541,11,4v-4a9.257,9.257,0,0,1-4-3h3c3.2,1.554,10.691.106,14-1,5.25-1.755,10.563,1.235,14,2,0.343-5.814,1.852-6.167,8-6,4.428-2.921,13.4-.25,19,0v4c4.108-.2,4.569-0.107,6-3-3.412-1.1-5.267-3.3-7-6,5.933,0.814,9.826-1.465,16,1v1c-4.093-.3-5-0.87-8,0v1c6.141,0.187,7.816,2.124,13,3v-1h1v-1h-1c-0.991-2.867-1.2-.641-3-4,10.5,0.044,11.677-4.791,19-8a16.987,16.987,0,0,0,1,6c6.293-1.524,11.383-5.8,17-8,2.6,0.872,1.529,2.1,4,1,1.577-1.158,3.578-2.043,10-2v1c-1.754.631-.971,0.193-2,1,3.769,0,6.874.385,9,2-2.356,1.1-1.78.959-3,3h4c1.549-1.049,4.085-1.031,7-1q0.5,1,1,2h1v1c-2.532.074-3.716,0.12-5,1h2c1.418,0.961,3.273.976,6,1q0.5-1.5,1-3a11.39,11.39,0,0,1-6-3c4.281-.424,6.879-1.639,10,1,4.169-3.667,10.083-4.975,18-5v1a6.1,6.1,0,0,0-2,2c3.116,0.992,4.934,2.629,8,4-1.254-1.623-2.1-2.007-4-3v-3l7-1c1.456,2.125,2.839,2.5,4,5a14.338,14.338,0,0,0-5,1v1h1c1.47,2.271,2.1,3.009,5,4v-1c0.752-1.073.6-.946,1-3-1.754-.631-0.971-0.193-2-1l12,2v-2c-5.271-3.748-.974-5.812-10-6-2.863-3.972-7.25-2.387-12-3v-1h1c2.567-2.206,11.727-3.084,15-4,0.423,2.688,2.477,2.2,8,2,2.811,1.854,10.487,1.128,15,1q-0.5-2.5-1-5h2v2c0.752,1.073.6,0.946,1,3h4v2c-4.523.331-4.184-.125-5,4h1v1c4.316-1.078,11.511-4.672,15-3,4.165,1.668,3.545,4.05,9,5-0.392-2.933-1.636-1.253,1-3,1.021,0.8.274,0.355,2,1v3c-11.061,1.551-23.286.889-35,0v-4h-1v1h-1a14.124,14.124,0,0,0-1,4l10,2q0.5,1,1,2c1.543,0.527,12.44-.43,15-1l30,1q0.5-1,1-2a6.1,6.1,0,0,1-2-2,36.54,36.54,0,0,1-10,2c-0.384-2.617.743-1.31-2-2-1.073-.752-0.946-0.6-3-1a12.662,12.662,0,0,0-1-4h2a8.894,8.894,0,0,0,3,3v-3c5.879-.871,4.425-3.763,10-5v2h-1v-1c-0.775-1.923-1,2-1,2,1.207,2.111.483,2.232,0,5h2c14.587-21.745,30.084-21.23,52-34-0.74-.872-1.26-1.128-2-2-3.014,1.294-5.453,4.1-9,2,1.754-.631.971-0.193,2-1h-5v-2l9-3v-1c-7.886-.038-16.293-2.108-21-1,1.75,2.105,1.972,1.463,2,3-4.473,2.634-10.571-2.02-17,0-2.521.792-4.7,3.125-8,4v-2c4.879-1.376,7.136-4.276,12-3v-1l-1-1h2c0.86-.649,3.144-1.338,4-2a133.438,133.438,0,0,0-31,3v-2c2.532-.074,3.716-0.12,5-1,0,0-3.971-.438-2-1h1c2.509-3.485,21.206-13.04,26-14a11.568,11.568,0,0,0,3,2c0.158-4.086-.273-1.674,2-5,9.369,1.963,16.023-1.99,24-4v-1l-10-1c-2.636.874-3.018,4.157-7,2h2c3.8-5.237,13.72-7.417,20-10v-1l-6-1v1h1c1.923,0.775-2,1-2,1a4.017,4.017,0,0,1-5,0c1.754-.631.971-0.193,2-1h-5v-2c3.551-.859,5.35-2.417,8-4v-1h-2c-5.065,3.4-13.946.763-18,0v1a11.568,11.568,0,0,1,2,3h-5c-1.9-.933-1.169-0.379-4,0,0.754-4.422,1.959-6.809,2-13,5.362,0.023,8.718,1.055,13,2,0.828-3.245-.49-1.528,2-3,2.311,1.6,7.837.652,10-1a10.965,10.965,0,0,1-5-2h2c2.151-1.988,5.148-2.666,7-5h-1v-1l-5,1c-0.107-5.717-.781-3.7,2-7l-29,3v-1h-1q-0.5-2.5-1-5c2.124-1.127,2.692-2.048,5-3,1.474,2.933,1.082,3.223,5,4,3.435-4.815,12.161-4.762,19-6v-1h-4v-4a20.384,20.384,0,0,1,9,2c-1.33-2.968.966-2.422-4-3-1.295-.877-2.467-0.894-5-1a18.068,18.068,0,0,1-3,4c-1.021-.8-0.274-0.355-2-1-0.384-2.617.743-1.31-2-2-3.545,2.794-11.782,3.58-15,1-0.747-.982-0.81-1.852-2-4,4.756-.486,3.774-1.549,7-3,0.052,2.729.072,1.184,2,4,4.633-2.75,10.058-3.905,16-6v-1c-2.076-.372-1.924-0.242-3-1h1c2.963-2.1,2.772-1.5,5,0,0.674-3.152.666-2.1,2-4-5.656-1.694-8.4-1.008-10-7h13v1c-2.72-.007-4.6.039-6,1,6.406,0.523,3.993,2.812,7,4v-1c2.464-2.064.728-1.4,2-4h3v-7h-2c-4.769,3.874-13.089,1.177-18,0v1c1.624,1.35,1.121.64,2,3h-3c-1.524-1.228-4.177-2.158-6-3v3h5v1h1v2l-7,1c-1.276-3.174-2.895-5.379-4-9h-1c-0.828,3.245.49,1.528-2,3-1.667-3.1-2.1-6.486-2-12a6.1,6.1,0,0,0,2-2h-3v-3c5,0.193,9.39.113,12-2a15.7,15.7,0,0,0-5-1c-1.919,1.772-3.136,1.9-7,2a20.14,20.14,0,0,0-1-7h4a21.42,21.42,0,0,0,2,5h1c0.028-4.488-1.962-3.383,3-4,0.785,0.871,7.841-2.533,9-5-2.328-.195-2.826-0.193-4-1h1c1.231-1.8,2.592-2.481,4-4,4.974,0.4,5.68,1.669,11,2v-2c-2.927-1.306-5.924-2.819-8-5,3.245-.828,1.528.49,3-2h-3c-3.629,2.939-9.494,5.259-15,6q-0.5-1.5-1-3c-2.556,1.479-3.147,2.4-7,3v-2a6.1,6.1,0,0,0,2-2h-3v-6c9.926-.026,15.62,2.635,25,3,0.018-4.5-.9-2.192,1-5-7.8-1.375-13.266-4.025-19-7v-1a6.1,6.1,0,0,0,2-2h-2c-0.829,2.963-.443,2.733-3,4a11.568,11.568,0,0,0-3-2v2c2.076,0.372,1.924.242,3,1-5.8-.582-2.579-1.692-5-3-4.085-2.206-11.6,1.213-15-1,2.328-.195,2.826-0.193,4-1-3.346-.468-2.65-0.508-6,0v-3c8.654,0.284,25.488,4.262,28-1a14.124,14.124,0,0,0-4-1c-1.254,1.623-2.1,2.007-4,3q0.5-2,1-4c-4.015-.118-5.527-0.278-7-3a6.107,6.107,0,0,0,2-2h-4c-1.8,2.594-4.031,3.6-7,5q0.5-2,1-4c-2.328-.2-2.826-0.193-4-1l16-1c1.137,2.506,1.426,3.754,4,5,4.713-4.124,15.007,1.225,22,2V98c-6.233-1.213-14.855-4.439-18-9,2.684-.891,2.589-1.028,4-3-1.215-1.774-.015-1.749-1-3-1.035-1.036-4.292-1.835-5-3l1-3-3-2c-0.7-1.543,1-5,1-5h-2l-16-9c-0.2,2.328-.193,2.826-1,4a8.9,8.9,0,0,0-3-3c-1.609,3.772-4.13,2.8-7,5,8.087,0.286,17.5,3.893,21,9h1v1h-8c-2.508,1.632-9.564,1.825-13,2l-2-3c2.389-.842,1.645-0.4,3-2-1.766-.962-1.68-1.257-4-2-0.287,2.646-.825,2.093-6,2V73c2.389-.842,1.645-0.4,3-2a9.255,9.255,0,0,1-4-3,16.976,16.976,0,0,0,6-1V66H655c-1.658.758-3,.52-5-1-2.577,2.562-2.628,1.542-7,1v3c-3.539.205-5.7,1.494-8,2l-17-1c-2.508,1.217-8.091,6.5-12,8l-2-3c2.467-1.295.681,0.429,2-2-2.389-.842-1.645-0.4-3-2,2.467-1.295.681,0.429,2-2h-4c-1.359,1.261-1.768,1.365-4,2,0.74,0.872,1.26,1.128,2,2h-4a19.555,19.555,0,0,0-4-2c-0.372,2.076-.242,1.924-1,3,0,0-12.818-.525-16,1-0.269.129-2.083,2.838-3,3-4.373.77-3.381-3.472-7-2-4.733,1.617-.064,2.024-5,3-0.631-1.754-.193-0.971-1-2V76h2c4.077-3.454,14.986-2.82,20-5-0.86-1.51-2.848-.742-1-2,1.922-1.251,7.137-2.337,9-3,0.132,4.087.907,3.2,7,3,1.438-1.05,3.922-1.558,6-2V66c-4.978-.5-5.628-1.54-9-2-6.679-.911-12.909,3.8-16,2-1.138-1.845-.2-1.87-1-4-3.346.468-2.65,0.508-6,0l-1-2a8.892,8.892,0,0,0,3-3h-3c-1.073.752-.946,0.6-3,1,0.768,4.437,3.037,5.821,5,9h-5c-4.194,2.852-12.026,1.692-17,1a2.84,2.84,0,0,1,1-1,14.124,14.124,0,0,1-1-4,10.943,10.943,0,0,0,3-2l5,1V58a52.245,52.245,0,0,1-10-2c-4.264-1.07-11.58,1.9-14,1-1.154-.43-1.429-2.916-5-4v2c-1.344,1.681-1.637,3.143-2,6,4.054-.31,15,3,15,3,1.9-1.34.874-1.283,4-2v1h1q-1,3-2,6c-6.039.4-8.814-2.751-13-2v1c3.245,0.828,1.528-.49,3,2h-3c-1.552-1.5-1.838-.777-3-3-0.349-.771-0.053-0.67-4-1-3.8,3.729-9.477-1.906-17,0-0.695.176-3.812,2.957-4,3-1.9.435-1.441-.77-2-1-4.787-1.786-3.527-4.432-10-5v1c2.224,2,.944,1.961,2,5H471v6l-15-2c-0.372,2.076-.242,1.924-1,3-1.18.8-1.681,0.773-4,1-3.955-2.844-12.556-3.041-19-3-1,2.273-.745,2.774-3,4-1.674-2.9-1.442-2.8-6-3-0.828-3.245.49-1.528-2-3-1.122.731-7.983,3.036-10,2l-1-3c-6.914-3.326-29.766,5.376-38-1-1.033-.8-1.443-1.588-2,0-1.972,1.479.559,1.425-3,2-5.825,3.9-15.622.634-20,2v1c-1.012.641-.978,0.651-3,1-1.691-3.139-2.2-2.557-5-5-1.97,2.281-4.543,2.14-9,2l-1-2c6.675,0.3,6.331.31,11-2V68h-1V67c-1.8,1.566-1.281,1.966-4,3-3.847-6.377-15.091-2.9-22-4V65h1c1.133-1.546,1.085-.843,2-3,0.251-.968.784-0.379,0-1l-1-2c-9.877,2.1-19.611-.946-28-3,0.212-3.346,2.153-2.4-1-4-1.549,1.049-4.085,1.031-7,1v1h2c2.993,2.551,3.742,1.206,4,7a12.667,12.667,0,0,1,4,1l-1,2c-4.881,1.618-7.27,1.689-11,3-3.331-4.75-10.861-7.184-18-8v2l5,1v1h-4c-0.695.264-6.4,0.082-10,0V61h8c0.674-3.152.666-2.1,2-4-10.032.543-8.581-.354-16-2q-0.5,4.5-1,9h-1V63a19.563,19.563,0,0,1-2-4H224V58c0.8-1.021.355-.274,1-2,3.523-.589,3.792.147,5-2,1.9-1.639,2.135-3.252,4-6h-1V47c-9.631,4.364-20.473,12.487-26,21l-3-2c0.32,2.842,1.056,2.07,0,4-1.85,1.445-2.684.714-4,3-1.119,1.473-2.087,3.052-1,4v1c1.51-.86.742-2.848,2-1l4,2v1h-1a19.555,19.555,0,0,1-4,2v2c3.769,0,6.874.385,9,2-15.475.837-37.267,2.783-50-2,0.127,4.315,1.429,3.514-1,5-4.016,2.68-9.764,4.259-14,6V93a8.892,8.892,0,0,0,3-3h-3c-1.455,2.543.217,1.128-3,2q0.5-2,1-4c-3.48-.188-4.238-0.376-6-2,2.467-1.295.681,0.429,2-2H128c-3.261-5.194-14.157.785-15,0-1.1-1.027-2.249-4.785-3-6,2.684-.891,2.589-1.028,4-3a14.145,14.145,0,0,0-4-1c-2.085,1.43-3.563.627-5,3h-1v1c4.574,1.226,1.97,2.134,5,3V80h1v8c0.8,1.18.773,1.681,1,4a31.036,31.036,0,0,1,5,3h-1a11.725,11.725,0,0,1-5,2,6.1,6.1,0,0,0-2-2c0.071-1.554.533-6.583-1-9-3.424-3.528-9.756-3.218-17-3V81h1c2.433-2.1,5.391-1.87,7-5a6.107,6.107,0,0,1-2-2c3.136-.552,2.433-0.21,4-2H99V71C88.138,75.879,81.916,83.741,73,90c-4.268,3-9.828,3.966-13,8H59v1h4c1.021-.8.274-0.355,2-1,0.032,2.195,1.036,2.5,1,4-1.411,1.514-2.764,2.209-4,4,5.253,0.082,7.578,1.364,11,3,0.074-2.532.121-3.716,1-5,7.015,4.444,9.7-1.69,17,1-1.021.8-.274,0.355-2,1-2.586,2.309-8.055,3.2-12,4v1h32c2.818-2.817,4.869-2.768,9-2v1h-1c-2.831,2.533-8.251,3.5-12,5a12.662,12.662,0,0,1-1,4l5,1c-1.021.8-.274,0.355-2,1-5.606,6.654-23.089,4.912-32,3,0.468,3.346.508,2.65,0,6H74v-3ZM560,50c0.74,4.66,2.289,5.43,7,6,3.534-2.306,11.16-2.48,15-4l1-2a17.243,17.243,0,0,1-5-3C573.756,48.5,565.569,49.378,560,50ZM256,48c1.936,2.957,4.654,4.523,7,7,1.754-.631.971-0.193,2-1h1V53C262.519,50.7,261.483,48.754,256,48Zm-12,1c-1.438,1.05-3.922,1.558-6,2v3c2.489,0.759,3.259,3.142,4,2l5-6h-1C244.979,49.2,245.726,49.645,244,49Zm24,0v2h2V50Zm34,0c-0.4,2.266-.918,1.084,0,3l2,3,4-2V52C301.921,51.486,305.18,50.131,302,49Zm66,0v2l6,1V51Zm97,0c0.828,3.245-.49,1.528,2,3V50Zm90,0c-2.82,2.593-4.765,1.594-9,1v1h2c1.69,1.142,4.9,1.066,8,1l1-3h-2ZM382,51c-2.532.074-3.716,0.12-5,1a12.667,12.667,0,0,1,4,1,35.383,35.383,0,0,0-3,3h2c1.021-.8.274-0.355,2-1V51ZM267,60c6.122-.855,6.016-3.754,10-6,0.372,2.076.242,1.925,1,3V53h-1V52c-3.544,1.751-5.735,3.832-10,5v3Zm192-8a11.576,11.576,0,0,0,3,2C460.65,52.376,461.36,52.879,459,52Zm12,0c-1.552,1.5-1.838.777-3,3h1v1a25.083,25.083,0,0,1,8-1V54C474.719,52.775,474.749,52.362,471,52Zm146,0a11.576,11.576,0,0,0,3,2V52h-3ZM320,53v2h1C320.369,53.246,320.807,54.029,320,53Zm314,0v2h1C634.369,53.246,634.807,54.029,634,53ZM309,54c-1.041,2.814-2.516,1.367,0,3V56C310.243,54.433,309.642,55.49,309,54Zm285,1c-1.552,1.5-1.838.777-3,3h5c4.587,3.144,17.506.635,21-1V56h-6C607.849,53.934,598.931,54.87,594,55Zm82,0c1.345,2.305,1.219,1.823,2,2h1A11.576,11.576,0,0,0,676,55ZM459,56c0,1.985.728,6.288,3,3C460.505,57.448,461.223,57.162,459,56Zm41,0c1.021,0.8.274,0.355,2,1C500.979,56.2,501.726,56.645,500,56Zm3,0v2c3.568,0.593,3.367.733,5,3-3.863.087-4.261,0.023-6,2h-1v1h9l1-3c-0.859-1.883-.474-0.739,0-3h-2C507.319,56.656,505.857,56.363,503,56Zm124,0c1.66,1.116,1.069,1.77,2,0h-2ZM341,57v2c-3.729-.117-3.867-0.448-6,0a25.766,25.766,0,0,0-2,5h6c1.856-1.288,5.26-1.626,7-3Zm28,0c-2.34,3.349-4.229,3.6-5,9h2c2.254-1.577,5.7-.848,8,0-1.82-2.086-4.833-2.291-7-4,3.668-.692,2.733.044,4-3C370.128,58.26,369.872,57.741,369,57Zm211,0c1.93,3.41,3.656,3.952,9,4-0.34-2.422-.327-0.883,0-4h-1C585.474,58.641,583.244,57.471,580,57ZM467,58v2c4.5,0.434,13.014,2.62,17,0Zm46,0v2c2.72,0.007,4.6-.039,6-1Zm31,0h2v1C544.246,58.369,545.029,58.807,544,58ZM392,62q0.5,2.5,1,5a18.313,18.313,0,0,0,6,1c2.716-4.048,14.059-4.306,18-1a6.107,6.107,0,0,0-2,2h5c0.143-4.194,1.737-3.249,8-3V65c-2.151-1.339-3.583-2.753-6-4v3h-5c-0.772-2.366-.046-1.691-1-4C409.777,60.087,401.6,61.833,392,62ZM247,60l2,2C246.318,62.9,245.661,61.386,247,60Zm386,0c-1.628,1.088-5.859,1.593-8,2v1h6c1.438-1.05,3.922-1.558,6-2V60h-4ZM279,61c-0.328,1.384,1.419,1.451,2,2C281.7,61.937,279.276,61.3,279,61Zm99,0h-5v1h2a11.576,11.576,0,0,0,3,2V61Zm182,0v2l4-1V61h-4ZM178,68V65c-8.853-.791-16.591-4.713-25-1v1c4.726-.064,11.777-0.906,15,1l2,4c2.677,1.348,9.861.563,12,1V69h1V68h-5Zm204-6c2.458,3.821,5.713,5.977,10,8V68C388.511,65.717,386.8,63.3,382,62Zm85,0c-1.552,1.5-1.838.777-3,3h4l1-3h-2Zm132,0,1,3,6-2V62h-7Zm16,0c-1.549,1.049-4.085,1.031-7,1v2h7c1.18,0.8,1.681.773,4,1V64C617.2,62.675,619.458,62.354,615,62Zm53,0a19.079,19.079,0,0,0,4,3C670.6,62.994,670.654,62.934,668,62ZM197,63v2h1C197.369,63.246,197.807,64.029,197,63Zm150,0a19.555,19.555,0,0,1-4,2v2h5l1-3Zm363,0c1.539,4.143,6.012,6.362,11,7V68h-1A15.945,15.945,0,0,0,710,63ZM95,64c-0.4,2.266-.918,1.084,0,3,0.74,0.872,1.26,1.128,2,2a82.9,82.9,0,0,1,15-1,6.1,6.1,0,0,1,2-2V65H97C95.979,64.2,96.726,64.645,95,64Zm148,0h2c0.291,3.757.777,3.739,2,6h-3c-0.961-1.766-1.257-1.68-2-4C242.8,64.979,242.355,65.726,243,64Zm112,0a11.576,11.576,0,0,1-3,2v1h4a11.576,11.576,0,0,1,3-2V64h-4Zm132,4a12.662,12.662,0,0,0-1-4h-2a6.1,6.1,0,0,1-2,2v2h5Zm149-4,1,3h1V64h-2Zm-31,1c-1.041,2.814-2.516,1.367,0,3C605.058,65.094,605.964,66.611,605,65ZM170,66h2v1C170.246,66.369,171.029,66.807,170,66Zm209,0c1.35,1.624.64,1.121,3,2A11.576,11.576,0,0,0,379,66Zm44,4c2.328-.2,2.826-0.193,4-1-2.347-.708-2.234-1.025-4-2v3Zm9-3a11.576,11.576,0,0,1-3,2c1.021,0.8.274,0.355,2,1,1.073,0.752.946,0.6,3,1l-1-3c2.076-.372,1.924-0.242,3-1h-4Zm178,0c0.842,2.389.4,1.645,2,3A10.931,10.931,0,0,0,610,67ZM115,68l-1,3c4.3,0.733,3.7,3.654,5,1C118.759,70.328,118.073,69.63,115,68Zm542,0,3,1v1h-3V68ZM150,70v2l6,1V72l-3-1C151.927,70.248,152.054,70.4,150,70Zm296,0c-1.568,3.531-1.226,2.62,3,3V71Zm79,4c-2.076.372-1.924,0.242-3,1,2.076,0.372,1.924.242,3,1h-8c-1.172-1.151-2.836-1.839-4-3,5.411-.262,7.751-2.754,10-2C525.542,72.456,524.128,70.783,525,74ZM159,71l1,3,3-1V72A12.667,12.667,0,0,1,159,71Zm5,0a12.662,12.662,0,0,1-1,4h1V74h1l1-2Zm272,0v2h3V71h-3Zm103,0h2v1h-2V71Zm117,0c2.127,0.793,5.341,1.644,7,3l-9,2v1c4.967-.407,8.42-0.91,13,0-1.021.8-.274,0.355-2,1-1.685,1.9-3.629,1.67-5,4h2c3.882,2.295,6.568-.259,8,5h-1v1c-3.069-.931-3.749-2.077-7-3-0.828,3.245.49,1.528-2,3-1.295-2.468.429-.681-2-2-1.273,3.239-.879,2.632-5,3V88a6.107,6.107,0,0,0,2-2c-2.84-.715-3.49-1.083-5-3a20.138,20.138,0,0,0,7-1V81H646c-1.438,1.05-3.922,1.558-6,2a20.141,20.141,0,0,0-1-7c-2.72.007-4.6-.039-6-1l8-1c0.287-2.646.825-2.093,6-2a11.576,11.576,0,0,0,3,2c-0.961,1.766-1.257,1.68-2,4h4C653.1,74.454,653.379,74.49,656,71ZM182,72v2h1V72h-1Zm137,0h2v1C319.246,72.369,320.029,72.807,319,72Zm211,0h2v1C530.246,72.369,531.029,72.807,530,72Zm53,0c-1.021.8-.274,0.355-2,1v1h4c1.021-.8.274-0.355,2-1V72h-4Zm123,0c1.35,1.624.64,1.121,3,2V73ZM124,73c2.824,5.5,6.108,6.511,10,6C133.379,75.476,128.161,73.272,124,73Zm24,1v2h1C148.369,74.246,148.807,75.029,148,74Zm243,0h2v1h-2V74Zm91,0c2.076,0.372,1.924.242,3,1h-1c-1.3.877-2.467,0.894-5,1V75C481.076,74.628,480.924,74.758,482,74Zm25,3c-5.577-.267-7.933-0.578-13,0V75c3.609-1.24,9.883-1.071,15-1,1.547,2.484,6.859,2.486,10,3v1c-7.431-.308-7.86-0.769-12,2V77ZM137,75v2h2V75h-2Zm232,0c2.076,0.372,1.924.242,3,1-2.818,2.22-3.1,4.6-7,6V78c1.754-.631.971-0.193,2-1-2.72.007-4.6-.039-6-1C364.09,76.094,367.33,76.141,369,75Zm45,4a38.806,38.806,0,0,0-9,1V78c3.968-.428,6.137-1.638,9-3v4Zm294-4v2h5a2.84,2.84,0,0,1,1-1V75h-6ZM335,76h8v1h-2C338.42,78.762,336.687,77.924,335,76Zm61,0c3.162,0.4,3.8.985,6,2v1c-3.2.257-3.191,0.994-5,0C396.248,77.927,396.4,78.054,396,76Zm147,0c3.816,1.256,3.914,2.028,4,7-1.725.788-1.84,2.627-3,1-0.928-1.2-.186-2.117-1-4l-3-1S542.707,76.456,543,76Zm79,0c2.963,0.714,4.58,1.828,7,3a2.84,2.84,0,0,1-1,1c-1.194.777-4.815,1.2-6,2a12.667,12.667,0,0,1,4,1v1h-2c-4-3.266-9.215-1.184-14,0V82l3-1c1.68-.994,2.29-0.1,4-1a10.943,10.943,0,0,1-3-2C618.149,78.061,619.989,77.852,622,76Zm-90,1c2.962,0.639,3.69.595,5,3h-1c-0.417,1.956,1.536.72,0,2-0.74.872-1.26,1.128-2,2-3.272-.873-11.287-2.828-14-5C525,79.193,529.39,79.113,532,77Zm98,0,4,1v1C630.864,78.448,631.567,78.79,630,77ZM155,81c0.372,2.076.242,1.924,1,3V83h1l2-4h-7c-1.021-.8-0.274-0.355-2-1-0.851,6.014-2.25,2.379-3,7l5,1V84c-2.076-.372-1.924-0.242-3-1h1C151.624,81.505,152.023,81.448,155,81Zm19-3v2a6.107,6.107,0,0,1,2,2l4-2V79Zm200,0a10.971,10.971,0,0,1,5,2h-1c-1.073.752-.946,0.6-3,1Zm93,0c2.076,0.372,1.924.242,3,1C467.924,78.628,468.076,78.758,467,78Zm227,0h5v1c-0.778,1.065-1.489,3.692-2,5-2.8-1.005-5.572-1.405-7-4h1V79C693.076,78.628,692.924,78.758,694,78Zm16,0c1.737,1.077,2.271,1.035,4,0h-4ZM116,79v2h3V80Zm105,0,6,2c-1.021.8-.274,0.355-2,1-4.883,5.141-6.693-.6-11,2-0.883.534-1.707,3.149-3,4a30.438,30.438,0,0,0-1-7h3C216.2,83.408,219.732,82.127,221,79Zm108,0c2.076,0.372,1.924.242,3,1a11.565,11.565,0,0,0-2,3h-1V82C328.141,80.117,328.526,81.262,329,79Zm203,0v2h1C532.369,79.246,532.807,80.029,532,79Zm107,4h-7V82h1c1.639-2.23,1.709-3.009,4-2C639.542,81.456,638.128,79.783,639,83ZM190,80c1.878,1.779.793,1.848,3,1h2V80h-5Zm147,0c3.542,0.344,4.609.435,6,3h-1c-1.341.884-5.446,1.461-7,2C335.506,81.812,335.872,82.08,337,80Zm42,7c0.577-3.652,1.639-4.32,3-7,3.338,1.185,8.522,1.561,10,4h-1C388.252,86.6,384.533,87.059,379,87ZM181,81c0.075,2.235-.217.707,2,1V81h-2Zm73,0c3.255,1.552.7,2.272,2,3,0.634,0.355,8.553-.952,11-1v1h-2c-1.563,2.459-5.11,4.967-7,4-2.479-1.4-3.868-2.047-5-5C253.8,81.979,253.355,82.726,254,81Zm301,0c2.328,0.2,2.826.193,4,1C556.672,81.8,556.174,81.807,555,81Zm20,0c4.279-.154,11.387-0.744,14,1-2.328.2-2.826,0.193-4,1,7.069-.572,12.842-2.393,20-1v1c-6.741.916-15.481,2.2-23,4-0.828-3.245.49-1.528-2-3-1.521,1.954-2.172,2.221-5,3-0.631-1.754-.193-0.971-1-2Q574.5,83,575,81ZM248,82c2.006,1.4,2.066,1.346,3,4l-2,1c-0.968.251-.379,0.784-1,0C247.112,85.2,247.7,85.19,248,82Zm105,0,3,1v1h-3V82Zm-72,2v3l-11,1V87h1c1.834-2.883,2.421-3.607,7-4C279.073,83.752,278.946,83.6,281,84Zm128-1h2v1C409.246,83.369,410.029,83.807,409,83Zm114,0,4,1v1h-4V83Zm105,0h2C628.812,84.609,629.582,84.224,628,83Zm71,0h2v1C699.246,83.369,700.029,83.807,699,83Zm-62,1c3.245,0.828,1.528-.49,3,2h-1C638.26,85.128,637.74,84.872,637,84Zm6,0,3,1v2h-4ZM113,85l3,1v1h-3V85Zm129,0a14.341,14.341,0,0,1-1,5c-2.461-1.139-4.04-2.206-7-3v3h-6l-1-2C231.691,86.849,235.91,85.28,242,85Zm3,0c0.8,1.021.355,0.274,1,2h-1V85Zm130,0h2v1h-1v1C375.2,85.979,375.645,86.726,375,85Zm239,0c3.5,0.4,4.912,1.257,8,2,0.708,2.347,1.025,2.234,2,4h-4C617.853,88.387,615.44,88.536,614,85Zm64,0h14a6.1,6.1,0,0,0,2,2v1h-2C691.544,88.6,680.192,87.989,678,85ZM123,87a50.11,50.11,0,0,1,11,1c-1.021.8-.274,0.355-2,1-2.966,1.956-4.7.267-7-1-0.946,3.393-.385,3.111-4,4-1.214-2.447-2.632-3.857-4-6h2v1c1.01,0.99.988-.985,1-1,1.231,1.341,1.825,3.583,3,5V87Zm549-1,3,1v1h-3V86Zm29,0,3,1v1C701.611,87.158,702.355,87.6,701,86ZM220,87c2.328,0.2,2.826.193,4,1C221.672,87.8,221.174,87.807,220,87Zm30,0h2v2h-1Zm327,0c2.684,0.891,2.589,1.028,4,3h1v1h-3V90l-2,1V90a6.107,6.107,0,0,1-2-2C576.754,87.369,575.971,87.807,577,87Zm23,0c5.863,0.427,5.539,3.457,9,5,6.844,3.051,9.442-2.338,12,5h1v1h-2c-1.295.877-2.467,0.894-5,1V97h1V96l3,2c-1.8-2.594-4.031-3.6-7-5v1a6.107,6.107,0,0,1,2,2h-4c-5.934,2.488-6.721-2.452-12-5ZM291,88c2.467,1.295.681-.429,2,2h1v1h-7V90C290.136,89.448,289.433,89.79,291,88Zm271,0h2a2.84,2.84,0,0,1-1,1v1C562.2,88.979,562.645,89.726,562,88Zm80,0c2.4,1.939,2.623,1.291,2,4C641.974,90.6,642.644,91,642,88ZM235,89c0.35,0.3,2,.523,1,2C234.886,90.512,232.886,89.224,235,89Zm335,0c0.752,1.073.6,0.946,1,3-2.3,1.605-1.51,2.142-5,3-1.073.752-.946,0.6-3,1l-2-3A14.553,14.553,0,0,0,570,89Zm19,0h5c0.961,1.766,1.257,1.68,2,4-0.649.86-1.338,3.144-2,4a11.725,11.725,0,0,0-5-2c-0.327,2.212,1.038,1.079-1,2l-2-3C588.484,92.535,587.556,91.762,589,89Zm42,0h2v4h-1v1h-2A14.341,14.341,0,0,1,631,89Zm17,0,5,1v1l-7,1V90C647.754,89.369,646.971,89.807,648,89Zm48,0,5,1v2h-3C695.519,89.549,696.149,91.983,696,89Zm17,0v2h2V89h-2ZM188,90c6.193-.12,17.889.275,22,3C201.3,93.385,192.266,95.95,188,90Zm515,0h2a2.84,2.84,0,0,1-1,1v1C703.2,90.979,703.645,91.726,703,90Zm31,0c-1.807,3.792,3.5,9.286,8,7,1.754-.631.971-0.193,2-1ZM559,95c-2.076.372-1.924,0.242-3,1-0.649.86-1.338,3.144-2,4V99a19.563,19.563,0,0,1-2-4c3.28-.853,3.949-2.005,7-3v3Zm-23-2c2.076,0.372,1.924.242,3,1h-2l-1,1V93Zm89,0h4l1,3h1v1h-4ZM307,94h2v1C307.246,94.369,308.029,94.807,307,94Zm350,5V96c-2.977-.385-3.4-0.525-5-2h9v1c-1.344,1.681-1.637,3.143-2,6h1v1c2.252-.877,2.58-1.779,4-1h1v1c-4.252.6-5.006,1.707-10,2-1.231-1.8-2.592-2.481-4-4Zm8-5,12,2v2h-5C670.107,96.317,666.864,95.72,665,94ZM219,95c2.9-.06,5.468-0.049,7,1-3.2.458-5.572,2.614-6,2C219.248,96.927,219.4,97.054,219,95Zm355,0a10.971,10.971,0,0,1,5,2h-1v1A9.255,9.255,0,0,1,574,95Zm-17,1h4v1h-1C557.589,97.509,558.772,98.619,557,96Zm-4,6c-2.515-.222-12.453-3.594-14-5,5.642,0.2,8.361.872,13,0v2C552.752,100.073,552.6,99.946,553,102Zm12-5c2.594,1.51,2.722,2.2,4,5h-5a2.834,2.834,0,0,0-1-1Zm5,2c0.35,0.3,2,.523,1,2C569.886,100.512,567.886,99.224,570,99Zm101,0a30.433,30.433,0,0,1,7,1v1h-4c-1.073.752-.946,0.6-3,1V99Zm-468,1h4v1h-1v1l-3,1v-3Zm525,0c1.35,1.624.64,1.121,3,2v-1Zm-52,2c0.35,0.3,2,.523,1,2C675.886,103.512,673.886,102.224,676,102Zm22,1h2v1h-2v-1Zm-44,1,4,2v1h-5v-2h1v-1Zm8,0c3.1,0.718,18.464,4.215,21,6a24.478,24.478,0,0,0-11,2,12.662,12.662,0,0,0-1-4c-3.686.762-6.172,1.286-9-1C661.141,105.117,661.526,106.262,662,104Zm62,0v2c-3.9-.029-4.5-0.5-6,2h1c4,4.947,15.431,8.014,23,9v-2h-1l-15-8q0.5-1.5,1-3h-3Zm9,2c1.021,0.8.274,0.355,2,1C733.979,106.2,734.726,106.645,733,106Zm-613,4c0.828-3.245-.49-1.528,2-3v2h1v1h-3Zm542,1c1.116,1.66,1.77,1.069,0,2-1.073.752-.946,0.6-3,1v-2C661.076,111.628,660.924,111.758,662,111Zm20,1,9,2v1h-3C685.711,113.55,683.545,114.481,682,112Zm9,7v-4h2c1.579,1.218,4.443,1.749,6,3ZM67,117c-1.939,2.817-4.831,4.439-8,6v2h4c1.513-3.484.891-2.642,4-2,0.2-2.328.193-2.826,1-4v1c1.724,1.732,1.5,2.783,4,4,1.552-1.5,1.838-.777,3-3-2.389-.842-1.645-0.4-3-2a6.1,6.1,0,0,0,2-2H67Zm668,0v2h2v-2h-2Zm-9,2c1.35,1.624.64,1.121,3,2v-1ZM86,120a23.313,23.313,0,0,0,3,4c2.347-.708,2.234-1.025,4-2v-1H89C87.927,120.248,88.054,120.4,86,120Zm627,3c1.021,0.8.274,0.355,2,1C713.979,123.2,714.726,123.645,713,123Zm18,2c1.021,0.8.274,0.355,2,1C731.979,125.2,732.726,125.645,731,125Zm-15,4h2v1h-1v1C716.2,129.979,716.645,130.726,716,129Zm8,4c1.35,1.624.64,1.121,3,2A11.568,11.568,0,0,0,724,133Zm10,3v2h2v-2h-2ZM116,147h2v2h-2v-2Zm-11,1h7v2c-4.067.666-8.306,3.335-12,1h2A35.383,35.383,0,0,0,105,148Zm-24,4,7,2v1c-4,.436-4.376.618-8,0Zm11,0h2l-1,3H92v-3Zm652,12q0.5,2.5,1,5l-8,3c-0.052,2.729-.072,1.184-2,4h7c2.358-1.461,3.768-.44,7,0v-2c1.355-2.612-.959-3.051,0-4a8.894,8.894,0,0,1,3-3v-1ZM74,168c2.468,1.295.681-.429,2,2H75v1H74v-3Zm681,1-3,6c2.076,0.372,1.924.242,3,1,4.87-1.375,8.776-2.475,12-5ZM60,170l3,1c-1.021.8-.274,0.355-2,1a4.017,4.017,0,0,1-5,0h2C58.74,171.128,59.26,170.872,60,170Zm11,0c1.624,1.35,1.121.64,2,3H72v-1C71.2,170.979,71.645,171.726,71,170Zm-19,3c2.076,0.372,1.925.242,3,1C52.924,173.628,53.076,173.758,52,173Zm644,13c1.624,1.35,1.121.64,2,3h-2c-1.188.814-4.59,1.489-6,2v-2C692.93,188.4,694.422,187.9,696,186Zm40,5c-1.457,2.124-2.624,2.785-5,4v1h5c1.231-1.8,2.592-2.481,4-4h-1v-1h-3Zm-31,16h2a12.662,12.662,0,0,0,1,4h-2A12.662,12.662,0,0,0,705,207Zm21,2v5l-6-1v1a6.1,6.1,0,0,1,2,2h-3c-2.635-2.358-1.818-2.3-5-4-0.384,2.617.743,1.31-2,2-2.709-1.363-5.679.978-8,0h-1v-1c2.44-.3,10.138-1.8,7-4h16ZM66,243l6,2c-1.021.8-.274,0.355-2,1-1.073.752-.946,0.6-3,1v-1H66v-3Zm23,6c-0.372,2.076-.242,1.924-1,3-1.35-1.624-.64-1.121-3-2-2.641,4.111-5.925,4.276-13,4-1.436-1.817-3.389-2.42-5-4h2c3.394-4.327,11.462-6.961,19-7l4,6H89Zm-11-3c-0.328,1.384,1.419,1.451,2,2C80.7,246.937,78.276,246.3,78,246Zm-22,2v2h1C56.369,248.246,56.807,249.029,56,248Zm671,3v5h1c1.725-1.353,4.847-2.128,7-3v-1A23.654,23.654,0,0,1,727,251ZM57,254v2h1C57.369,254.246,57.807,255.029,57,254Zm653,0c-1.552,1.5-1.838.777-3,3h1v1c2.631-.759,2.385-1.2,5-2v2a21.42,21.42,0,0,0-5,2v1h10c1.418-.961,3.273-0.976,6-1q0.5-1.5,1-3h1v-1h-2c-1.073-.752-0.946-0.6-3-1v1a6.1,6.1,0,0,1,2,2h-3c-2.635-2.358-1.818-2.3-5-4-0.384,2.617.743,1.31-2,2C711.65,254.376,712.36,254.879,710,254ZM69,255h8v1c-0.8,1.021-.355.274-1,2-1.39.467-4.848,1.177-6,2h1c3.054,1.6,5.1-1.636,9,0,2.83,1.187,9.183,7.364,11,10-5.989.621-15.863,2.094-21,4a30.433,30.433,0,0,0-1-7l6-2v-1C67.783,264.184,66.712,260.787,69,255Zm633,2q-0.5,1.5-1,3c-2.2-.731-3.874-1.385-6,0-0.8,1.18-.773,1.681-1,4h2c1.073,0.752.946,0.6,3,1,2.094-3.106,4.093-3.417,5-8h-2Zm-56,1a12.662,12.662,0,0,1,4,1c-0.74.872-1.26,1.128-2,2C644.726,259.489,646.032,260.8,646,258Zm14,1,3,1v1h-1v1A11.568,11.568,0,0,1,660,259Zm7,0c1.779,2.332,1.888,1.712-1,3v-1C666.8,259.979,666.355,260.726,667,259Zm8,0,5,1v1h-7v-1C674.754,259.369,673.971,259.807,675,259ZM58,260v2h1C58.369,260.246,58.807,261.029,58,260Zm596,0h2v2h-2v-2Zm16,1h2v1h-1v1C670.2,261.979,670.645,262.726,670,261ZM75,262c1.737,1.077,2.271,1.035,4,0H75Zm554,2,3,1v1h-3v-2Zm39,0v4a78.839,78.839,0,0,0-9,0v-1h1C661.979,264.425,663.375,264.1,668,264Zm-43,1h2v1C625.246,265.369,626.029,265.807,625,265ZM59,266v2h1C59.369,266.246,59.807,267.029,59,266Zm561,0h2v1C620.246,266.369,621.029,266.807,620,266Zm96,0c0.327,2.212-1.038,1.079,1,2v-1h1C716.979,266.2,717.726,266.645,716,266ZM60,272v2h1C60.369,272.246,60.807,273.029,60,272Zm26,1,3,1v1H86v-2Zm-25,5v2h1v-2H61Zm39,4c-1.565,1.8-1.966,1.281-3,4H96v1h2C99.551,284.512,100.976,284.478,100,282Zm15,0h2v1h-2v-1Zm61,4c-2.532-.074-3.716-0.12-5-1h2a11.568,11.568,0,0,1,3-2v3ZM62,284v2h1v-2H62Zm17,2c0.387,2.53-.581,1.578,3,2v-1h1v-1H79Zm8,0c1.568,1.829.882,1.395,4,2v-1Zm89,0h2v1h-2v-1Zm469,6h4v3c4.427,2.757,11.455,7.46,15,8,1.418-.961,3.273-0.976,6-1v1c-2.079,2.638-1.483.776,0,4H660c-3.648-3.184-7.324-3.2-11-7-0.087.1-1.313,2.886-2,2v-1c-2.006-1.4-2.066-1.346-3-4C644.877,295.705,644.894,294.533,645,292Zm-517,3,3,1c-1.021.8-.274,0.355-2,1a2.834,2.834,0,0,1-1,1v-3Zm435,1a11.568,11.568,0,0,1,2,3h-3v-1C562.8,296.979,562.355,297.726,563,296Zm-443,1h5v1h-1v1l-3,1Zm386,0h2v1h-2v-1Zm104,0h4v1C610.449,297.983,612.267,299.452,610,297Zm31,0h2v1h-2v-1Zm21,1h2v1C662.246,298.369,663.029,298.807,662,298Zm11,0c3.586,0.44,4.3.844,6,3h1v1h-6v-1h-1v-3Zm-548,1h5v1c-1.623,1.254-2.007,2.1-3,4h-3C124.9,300.528,125.414,301.756,125,299Zm61,0a10.965,10.965,0,0,1,5,2C187.236,300.858,187.485,301.472,186,299Zm303,0a10.925,10.925,0,0,1,3,2h-1a8.894,8.894,0,0,1-3,3A14.338,14.338,0,0,1,489,299Zm164,1c-0.02,2.707-1.327,1.61,2,3v-1h1A11.568,11.568,0,0,0,653,300Zm-472,1c3.245,0.828,1.528-.49,3,2C180.422,302.556,181.206,303.63,181,301Zm273,0h4v2h-2v1h-1Zm-334,1h2C120.812,303.609,121.582,303.224,120,302Zm345,0h2v2h-2v-2Zm122,0c2.328,0.195,2.826.193,4,1C588.672,302.805,588.174,302.807,587,302Zm98,0h2v2h-2v-2ZM65,303v2h1v-2H65Zm133,1h2v2h-2v-2Zm33,0h2v1h-2v-1Zm243,0h13v1h-1v1h1c1.923,0.775-2,1-2,1C482.3,308.7,475.475,307.081,474,304Zm-257,1h2a2.834,2.834,0,0,1-1,1c-1.073.752-.946,0.6-3,1v-1C216.754,305.369,215.971,305.807,217,305Zm82,0a17.682,17.682,0,0,1,4,2h-4v-2Zm11,0h2v1h-1v1C310.2,305.979,310.645,306.726,310,305Zm8,0c3.769,0,6.874.385,9,2l-9,1v-3Zm174,0c1.116,1.66,1.77,1.069,0,2v-2Zm92,0h5v1h-2c-1.073.752-.946,0.6-3,1v-2Zm39,1c1.021,0.8.274,0.355,2,1C623.979,306.2,624.726,306.645,623,306Zm-293,1h6v2h-2c-1.073.752-.946,0.6-3,1Zm196,0a12.662,12.662,0,0,1,4,1v2C527.316,309.109,527.411,308.972,526,307Zm100,0v2h3v-1Zm-409,1c2.076,0.372,1.924.242,3,1h-2c-1.72.881-1.278,0.889-3,0C216.754,308.369,215.971,308.807,217,308ZM66,309v2h1v-2H66Zm27,0a21.654,21.654,0,0,0-7,2v1l6,1v-1h1v-3Zm372,0h2C465.812,310.609,466.582,310.224,465,309Zm-315,1v2h1C150.369,310.246,150.807,311.029,150,310Zm5,1c0.384,2.617-.743,1.31,2,2a2.834,2.834,0,0,1,1-1v-1h-3Zm11,0c-2.084,3.988-4.911,5.121-9,7v1h6c0.057,0,10.52-3.2,13-5C168.432,313.928,170.2,311.692,166,311Zm-90,1c0.372,2.076.242,1.924,1,3,1.919,1.772,3.136,1.9,7,2l1-3H83C81.105,312.479,79.411,312.211,76,312Zm259,0c3.441,1.077,4.878,2.6,6,6h-1c-2.312,1.541-8.105,1.119-12,1-1.18-.8-1.681-0.773-4-1l-1-4C328.455,314.536,331.879,315.728,335,312ZM98,314v2h6v-1h1v-1H98Zm10,0c1.021,0.8.274,0.355,2,1C108.979,314.2,109.726,314.645,108,314Zm115,0h2v1C223.246,314.369,224.029,314.807,223,314Zm87,0a21.42,21.42,0,0,1,5,2c-1.021.8-.274,0.355-2,1v1h-1v-1C308.726,315.489,310.032,316.8,310,314Zm243,0c1.841,3.177,2.836,3.127,8,3v-1C557.5,315.6,556.088,314.743,553,314Zm25,0v2l4-1v-1h-4ZM67,315v2h1C67.369,315.246,67.807,316.029,67,315Zm88,0c0.384,2.617-.743,1.31,2,2,1.021-.8.274-0.355,2-1v-1h-4Zm82,0h2v1h-2v-1Zm310,1c0.278,2.588-.466,1.775,4,2v-2h-4Zm49,0v2h1v-2h-1Zm2,0c1.021,0.8.274,0.355,2,1C598.979,316.2,599.726,316.645,598,316Zm6,0v2h1v-2h-1Zm-425,1c0.467,2.87,5.141,2.218,11,2,1.021-.8.274-0.355,2-1v-1A47.641,47.641,0,0,1,179,317Zm173,0c2.962,0.639,3.69.6,5,3h-2A35.383,35.383,0,0,1,352,317Zm273,0v4h2c4.8,4.024,13.067,4.475,19,2v-1C636.982,322.128,631.164,319.675,625,317Zm-426,1c-2.181,3.5-3.018,3.077,1,4a18.711,18.711,0,0,1,5-3v-1h-6Zm166,0h2v1h-2v-1Zm153,0c1.021,0.8.274,0.355,2,1C518.979,318.2,519.726,318.645,518,318Zm-350,1c-2.562,2.764-8.927,1.857-11,5h6c2.689-1.865,8.1-2.7,11-4v-1h-6Zm46,0v2h1v-2h-1Zm138,1v3c-4.149.061-5.989-.148-8-2Zm77,0v4h1a19.54,19.54,0,0,1,4-2v3c-3.763.227-4.557,0.874-7,2-0.452-3.265-1.771-4.715-1-6C427.073,320.248,426.946,320.4,429,320Zm90,0c-0.674,3.152-.666,2.1-2,4,8.49,0.334,16.809,2.394,24,4,9.674,2.16,16.9-2.019,27-2a6.1,6.1,0,0,1,2-2v-1h-5c-8.625,6.753-20.887-1.977-27-3h-2v2C533.159,322.516,524.3,321.172,519,320Zm27,0v2h2v-2h-2Zm20,0c1.66,1.116,1.069,1.77,2,0h-2ZM68,321v2h1v-2H68Zm264,0,3,1v1h-1c-2.069,1.664-4.155,1.91-8,2v-1h1C328.441,322.843,330.666,322.256,332,321Zm4,0,4,2-2,3h-1v-2C336.248,322.927,336.4,323.054,336,321Zm24,1c1.624,1.35,1.121.64,2,3h-2v-3Zm243,0v2h3v-1Zm47,0v2C651.609,322.812,651.224,323.582,650,322Zm-496,1v2h2v-2h-2Zm23,0c-1.35,1.624-.64,1.121-3,2v1h11a2.834,2.834,0,0,1,1-1v-1A38.784,38.784,0,0,1,177,323Zm122,0h5v1h-2c-1.073.752-.946,0.6-3,1v-2Zm237,0h6v1h-2C536.582,326.306,536.262,325.1,536,323Zm42,0c1.837,1.738,3.571,2.525,6,1Zm-317,1h2v1C261.246,324.369,262.029,324.807,261,324Zm-3,6v-4h2c1.71,1.915,5.463-1.039,12,0v2c-1.322,1.737-1.727,1.607-1,3,3.056,1.846,10.97.106,14,2-8.847.986-14.8,3.8-25,4v-1h1c2.138-2.187,6.257-1.332,8-4h-1v-1Zm237-5v1h-1c-1.4-.162,1,1,1,1h2C497.167,325.39,495.451,325.791,495,325Zm106,0v2h2v-1ZM69,330h4v-1c-2.067-1.183-1.882-.684-3-3H69v4Zm205-4h2v1C274.246,326.369,275.029,326.807,274,326Zm19,0c3.811,0.015,5.985.354,8,2C296.715,328.123,294.893,328.147,293,326Zm295,0c1.021,0.8.274,0.355,2,1C588.979,326.2,589.726,326.645,588,326ZM77,327c0.975,4.06,1.177,4.6,6,5v-2H82A9.975,9.975,0,0,0,77,327Zm387,0c1.667,1.938,1.439,1.668,5,2v-1Zm12,0c1.72,0.881,1.278.889,3,0h-3ZM325,338c-0.372-2.076-.242-1.924-1-3-1.567,1.243-.51.642-2,0h1c1.463-2.2,3.272-3.162,5-5l21,1c3.412-.85,5.447-2.556,10-3v1h1v1h-1c-3.406,2.687-3.817-1.078-9,1l-2,3h-9l-3,5Zm-21-9h2C304.812,330.609,305.582,330.224,304,329Zm186,0c0.384,2.617-.743,1.31,2,2v-1h1v-1h-3Zm-193,2h2v1h-1v1C297.2,331.979,297.645,332.726,297,331Zm127,0c2.532,0.074,3.716.12,5,1C426.468,331.926,425.284,331.88,424,331Zm35,0c1.66,1.116,1.069,1.77,2,0h-2ZM70,332v2h1v-2H70Zm348,0-1,3h3v-1C419.128,333.26,418.872,332.74,418,332ZM88,333c1.021,0.8.274,0.355,2,1C88.979,333.2,89.726,333.645,88,333Zm-11,1v2l7,1v-1H83v-1Zm99,1a11.725,11.725,0,0,1-5,2v1h3c2.1-1.273,7.924-.686,10-2A39.469,39.469,0,0,0,176,335Zm31,0a11.568,11.568,0,0,1-3,2v1h5l1-2h-1C207.979,335.2,208.726,335.645,207,335Zm100,0c1.72,0.881,1.278.889,3,0h-3Zm155,6v3c4.449-.23,14.781-1.6,18-4-2.27-2.179-2.507-3.77-6-5-4.437,5.22-17.34,3.049-20,7h4C459.18,341.2,459.681,341.227,462,341Zm-7-5c1.35,1.624.64,1.121,3,2v-1Zm4,0,1,3h1v-1c0.8-1.021.355-.274,1-2h-3Zm23,1c0.4,0.56,3.7,4.856,4,2C486,339,482.4,337.221,482,337Zm-212,1h2v2h-2v-2Zm219,0c0.828,3.245-.49,1.528,2,3v-1h1A11.568,11.568,0,0,0,489,338Zm-167,2h2v2h-2v-2Zm60,0v2h3v-1Zm8,3c1.66,1.116,1.069,1.77,2,0h-2Zm-79,3v2c3.145,1.334,4.856,2.92,8,4a6.1,6.1,0,0,1,2-2c-1.021-.8-0.274-0.355-2-1C316.986,347.109,314.567,346.431,311,346Zm34,4c1.66,1.116,1.069,1.77,2,0h-2Z" />
</svg>';
		} else if ( $svg === '2' ) {
			$svg = '<svg xmlns="//www.w3.org/2000/svg" viewBox="0 0 796 382">
<path style="fill:' . $f . '" d="M0,0H796V259c-2.255-.781-4.8-1.478-7,0l7,1V382H0V0ZM694,2c-3.164,2.427-6.662,2.687-9,6h-1V9c2.328,0.2,2.826.193,4,1,0,0-3.971.438-2,1h1c1.816,1.889,2.642,2.424,6,3l1-2a6.107,6.107,0,0,1-2-2c3.58-.416,2.516.472,4-2C691.957,5.2,698.2,5.344,694,2Zm6,1a16.935,16.935,0,0,1,2,6c-2.963.714-4.58,1.828-7,3,0.552,3.12.453,2.128-1,5h5c1.549-1.049,4.085-1.031,7-1a18.322,18.322,0,0,0,1-6c-0.918-2.032.927-3.669,0-5C705.105,3.479,703.41,3.211,700,3ZM577,20c-4.053.33-3.946,1.064-7,2V21c0.8-1.021.355-.274,1-2,4.026,0.133,5.468.543,7-2,0.778-1.065,1.489-3.692,2-5h-4a10.617,10.617,0,0,0-7,2h1c1.552,1.5,1.838.777,3,3h-5c-1.568-1.828-.882-1.4-4-2v1h-1v2h5c-0.372,2.076-.242,1.924-1,3l-9,3c-0.961-1.766-1.257-1.68-2-4,3.361-1.317,2.9-1.541,3-6a14.145,14.145,0,0,0-4-1c-1.986,1.089-8.358.145-13,0-0.372,2.076-.242,1.925-1,3V14h-2v1c-2.542,1.456-1.128-.217-2,3,1.766,0.962,1.68,1.257,4,2,3.1-2.789,10.41-3.987,15-5v2c-4.063,3.157-2.28,5.814-10,6-10.2-6.727-24.811,3.79-30,5V26c1.623-1.254,2.007-2.1,3-4-2.316-1.615-2.352-1.461-3-5h2l2,3h1l-1,2h1c3.047-2.17,8.042-1.593,10-5h-2c-4.111-3.061-10.5-1.538-16-1q-0.5,5.5-1,11a14.145,14.145,0,0,1-4,1V27c1.829-1.568,1.395-.882,2-4a15.7,15.7,0,0,0-5-1c-1.667,2-3.442,2.7-6,1h2c2.011-2.7,4.24-2.106,7-4l-5-1c-4.544,4.613-8.442,7.121-18,7-6.6-10.021-13.439-2.547-21-1-3.141.643-2.818-1.712-4-2-0.446-.109-14.64,1.889-19,2l-3,6c-1.754-.631-0.971-0.193-2-1-0.752-1.073-.6-0.946-1-3l-21-1v6c-6.188-.28-6.4.652-13,1V30c3.58-.416,2.516.472,4-2h-4c-10.435,8.5-11.395,1.974-20-1-6.52-2.254-12.913,2.335-17,3l-10-2c-2.666,4.344-6.115,8.695-13,9-1.021-.8-0.274-0.355-2-1-0.006-2.616.771-1.958-2-4l1,2h-1c-1.073.752-.946,0.6-3,1-1.674-2.9-1.442-2.8-6-3-1.6,2.274-5.328,4.855-7,4-2.237-1.574-2.655-1.918-7-2-1.742,2.6-3.118,1.872-4,3a19.092,19.092,0,0,0-3,4h4a11.576,11.576,0,0,1,3-2c-0.193,4.509-.5,4.34,6,4,1.18-.8,1.681-0.773,4-1-0.049-3.367.84-4.965,7-5,0.631,1.754.193,0.971,1,2-2.49,12.828-6.3,6.008-16,10-2.627,1.081.3,2.879-3,2-6.035-2.465-3.279-7.407-12-8-1.18.8-1.681,0.773-4,1,0.454-3.485,1.207-4,2-7h-1c-2.366,2.1-2.614.98-5,2-1.431,2.586-3.029,4.874-4,8,2.076,0.372,1.924.242,3,1-2.959,3.242-1.929,5.387-8,6l-1-3c3.176-2.944,5.707-6.091,6-12-0.8-1.021-.355-0.274-1-2h-1v1a18.709,18.709,0,0,0-3,5h-1V42c-1.5-1.552-.777-1.838-3-3-1.617,7.783-10.105,7.423-14,13h1a14.69,14.69,0,0,1,10-4v1c-4.371,3-5.233,7.236-12,8-1.667-1.938-1.439-1.668-5-2-2.275,3.705-3.774,4.99-10,5a11.725,11.725,0,0,0-5-2V57c1.5-1.552.777-1.838,3-3,3.724-3.163,8.177.29,12-1,3.288-1.11,3.655-6.889,6-9l10-2V41l-8-1c-1.091.287-.386,2.429-3,2-0.559-.092-1.763-1.663-4-2-0.372,2.076-.242,1.925-1,3v1c-3.2.257-3.191,0.994-5,0-0.682-.771-1.311-2.232-2-3-2.83,2.774-5.508,4.821-8,8,3.245,0.828,1.528-.49,3,2-4.056-.1-8.354.07-11,1a2.84,2.84,0,0,0,1,1c1.18,0.8,1.681.773,4,1,0.416,2.973,2.108,4.148,1,5-2.836,2.62-7.44,3.056-13,3-0.828-3.245.49-1.528-2-3-1.021.8-.274,0.355-2,1q-0.5-3-1-6h5c1.342-3.378.778-4.131,5-5v2h2V50c3.393-.946,3.111-0.385,4-4h-1c-3.851,2.248-10.919-.586-16,1-9.749,3.042-21.329,8.025-32,11-7.971,2.222-19.882.593-26,5h2a11.725,11.725,0,0,0,5,2v1h-1c-1.552,1.5-1.838.777-3,3,2.382,1.729,5.864,5.065,7,8-3.042.075-2.744,0.756-4,0-2.091-1.121-1.832-1.434-5-2-7.719,6.007-19.753,7.978-33,8V81c5.225-1.65,7.519-1.42,9-7,2.407,1.766,10.306,4.935,12,4a25.766,25.766,0,0,1,5-2V72h5V70c1.344-1.681,1.637-3.143,2-6-3.5.4-4.912,1.257-8,2,0.74,0.872,1.26,1.128,2,2h-3c-0.955-3.593-2.018-3.784-4-6-6.422.168-10.565,1.055-16,0-0.631,1.754-.193.971-1,2,0.631,1.754.193,0.971,1,2,2.769,1.739,7.387.229,12,0v1h-2c-4.205,3.272-13.719,5.507-20,6,0.416,2.973,2.108,4.148,1,5-1.383,3.887-24.7,21.689-29,24v-2a8.892,8.892,0,0,0,3-3H99c-2.751,3.95-9.874,10.9-17,10-1.33-.168-6.086-1.957-9-1-4.615,1.516-5.376,4.786-13,5v4H59v1a56.26,56.26,0,0,0-12,1c0.552,1.922,1.641.857,0,2-4.174,3.107-12.663,4.816-17,7,0.34,2.422.326,0.883,0,4h1a6.107,6.107,0,0,1,2-2v2c-2.1,4.162-.055,6.974-6,10v1h3c2.2-2.418,9.794-8.223,12-7h1c1.023,0.639.2,2.169,1,1,2.006-1.4,2.066-1.346,3-4h3c0.828,3.245-.49,1.528,2,3,3.4-2.664,19.33-9.869,25-10,1.579,1.218,4.443,1.749,6,3-4.4,1.133-3.663,3.236-5,7-1.766-.961-1.68-1.257-4-2-0.188,4.566-.017,5.04-4,6-3.885-1.721-1.432,1.032-4,2-1.9.718-4.888-2.332-8-1-1.4.6-3.894,3.02-6,4,0.124,5.9.493,13.677-1,18-6.987.272-10.931,1.912-19,2-2.39,10.6-9.594,14.543-10,27,2.493,3.65,2.119,8.568,4,13,2.957,6.967,9.648,18.4,16,22,2.59,1.467,5.817-.853,9,1H50c-5.932,5.189-16.808,1.131-23,5-1.541,2.312-1.119,8.1-1,12,2.727,3.988,2.884,11.556,2,16a18.064,18.064,0,0,0-4,3c-5.549-1.807-10.127-1.833-15,2-11.481,16.516,6.415,58,20,60,12.581-10.65,17.168-7.247,32-4,7.193,1.575,11.457-6.007,18-1-2.566,2.853-5,7.923-7,11h3c2.906-2.8,6.956-4.324,11-6,0.372,2.076.242,1.924,1,3,1.275-1.394,4.124-4.288,5-3,1.5,1.552.777,1.838,3,3,6.261-5.833,18.922-9.234,30-7a12.662,12.662,0,0,0,1,4c4.417-2.055,10.313-5.1,13-9,9.014,5.757,15.585-1.253,25-3v2c-4.976,5.421-7.052,14.729-7,25-2.72-.007-4.6.039-6,1-2.952.866-3.786,1.364-5,4-0.359.855,1.087,6.948,1,7-1.344,3.706-2.923,2.934-4,7h1c4.986-5.47,9.07-6.243,16-8,0.658,12.329,8.951,17.835,14,26,6.551-2.559,17.7-9.248,26-8,8.34,1.253,16.076,8.924,28,6,8.933-2.191,21.476-2.157,32-5,5.2-1.4,8.294-5.163,12-7,11.622,2.627,22.61-.968,35-1v-3c22.068,0.306,40.321-3.831,58-9,4.146-1.212,11.383.488,14,1,4.8,0.94,7.05-2.809,13-1,2.883,0.876,8.838,5.034,14,3,3.226-1.271,6.129-5.87,10-7h17c2.439-.67,4.372-3.475,8-3,4.479,0.587,9.487,4.859,17,3,24.579-6.081,55.117-15.669,84-9l16-1c3.782-1.214,8.917-3.984,13-5,14.785-3.678,46.83,10.232,53-6-2.067-1.183-1.882-.684-3-3,7.937-1.587,15.3.513,24-2,4.034-1.166,9.729-6.5,17-4,2.749,0.947,3.719,3.832,7,5v-1c-2.252-2.377-1.092-.35-1-4,1.546-1.133.843-1.085,3-2,2.6,2.659,3.071,1.774,6,0,1.8,1.4,1.071,2.2,4,3v-5c4.946-.528,32.064-3.672,34-5,0.8-1.021.355-.274,1-2H705c-1.952,2.374-10.862,3.253-14,1h2c1.9-2.031,2.872-1.868,4-5-5.038-3.082-11.763-8.077-15-13h7c9.235,5.885,25.205-1.9,32-1v1h1v3c-6.9.145-9.815,2.527-15,4v1c1.665,1.493,1.017.725,1,2-2.478,1.5-5.349.4-7,3h1c1.18,0.8,1.681.773,4,1,7.7-5.711,19.565-7.615,28-12,17.3-8.994,35.975-21.18,55-28v-1l-8,1c-0.408-2.624-1.6-2.165-7-2v-1h2c2.78-3.231,7.949-3,10-7h-2c-5.327,3.892-16.961,1.455-24,1v1c1.624,1.35,1.121.64,2,3-14.723-.282-25.692,8.054-42,5v-1h1c7.583-5.637,23.37-3.007,31-8-34.027-.572-62.644,9.883-93,14,0.245-2.739.722-5.314,2-7,1.073-.752.946-0.6,3-1,1.021,0.8.274,0.355,2,1v2a6.1,6.1,0,0,0-2,2h4c1.993-1.471,4.649-1.812,8-2v-5c7.227,0.136,9.451-1.489,14-3-1.441-2.056-1.553-1.3-2-5h5c0.372,2.076.242,1.924,1,3,0.86-.649,3.144-1.338,4-2-2.252-2.377-1.092-.35-1-4h1v-1c9.255-.537,13.888-4.407,23-5v1h-1c-2.654,2.378-5.732,2.383-8,3v1h10c1.992-1.337,6.507-1.1,10-1v-1c-1.882-.577-7.361-0.91-9-2h1c3.935-2.781,8.693-1.206,10-7h-2c-1.9,1.225-7.642,1.568-10,2v-1a26.36,26.36,0,0,0,4-5c-1.754-.631-0.971-0.193-2-1,9.553,0.49,19.214.422,21-7a12.662,12.662,0,0,0-4,1v-2c5.562-6.008,6.857-12.176,19-12,0.181-4.072.515-3.864,2-6h-3q-0.5-3.5-1-7c2.281-1.225,2.251-1.638,6-2-0.374,3.966-.6,2.786,1,6l3-1v-4c-3.913-1.473-3.779-2.887-10-3q-1-13-2-26a18.324,18.324,0,0,1,6-1v-1h1v2c1.339,2.026,1.718,7.208,2,10l-7,2v2h2c1.79-1.65,2.512-1.746,6-2v4h-2c-1.021-.8-0.274-0.355-2-1,1.354,3.014-.671,2.7,5,3-0.084,3.1-.59,4.023,0,5a19.089,19.089,0,0,0,4,3v-3c-0.8-1.021-.355-0.274-1-2l12-4v-1c-4.835-.685-6.217-4.027-10-2,1.665,1.493,1.017.725,1,2-0.74.872-1.26,1.128-2,2-1.754-.631-0.971-0.193-2-1-2.374-2.058-2.172-5.371-2-10-3.527-5.714-2-14.934-4-22-2.354-8.327-4.941-17.925-7-27q0.5-5.5,1-11c-0.388-1.114-3.472-3.238-4-5q-0.5-12-1-24c-0.884-2.234-4.16-6.087-5-9-0.874-3.032.272-6.016-1-8-0.087,7.77,1.425,11.808,2,18-21.734.523-38.851,9.443-59,12V95a8.892,8.892,0,0,0,3-3,14.347,14.347,0,0,1-5-1V90a6.107,6.107,0,0,0,2-2c2.292,0.76,1.5,2.148,4,2,2.241-.133,7.526-3.3,10-4,3.358-.956,11.422-0.172,12-1V84c-2.076-.372-1.924-0.242-3-1h1c1.418-.961,3.273-0.976,6-1-0.008,3.162-1.694,1.345,1,3V84c0.932-1.891,1.523-10.1,2-14a25.083,25.083,0,0,0-8-1v2c2.252,2.377,1.092.35,1,4-5.641.14-6.757,2.646-8,3a8.892,8.892,0,0,1-3-3,12.667,12.667,0,0,0,4-1q0.5-3.5,1-7c-5.362.023-8.718,1.055-13,2v1h-1v3c2.72-.007,4.6.039,6,1-4.375.38-4.106,1.286-8,2-2.328-4.408-6.969-2.47-11-5h2c0.771-.682,2.232-1.311,3-2-3.795-4.039-2.563-7.012-11-7v1h-1q0.5,2.5,1,5c-6.608-.053-10.068-2.041-14-3-4.582-1.117-5.335,1.672-10,2l-1-2c2.67-1.441,4.221-1.994,9-2,1.9-1.225,7.642-1.568,10-2l1-3c-2.076-.372-1.924-0.242-3-1h2c5.815-4.062,13.062.113,18,1,4.757,0.855,11.1-4.174,16-1-2.076.372-1.924,0.242-3,1h1c1.194,0.777,4.815,1.2,6,2-1.4,2.239-.545,3.276,0,6h13a2.84,2.84,0,0,1,1-1c-1.021-.8-0.274-0.355-2-1-1.529-1.352-4.308-1.748-6-3a6.107,6.107,0,0,0,2-2h-1c-0.86-.649-3.144-1.338-4-2h1c2.038-3.227,3.922-1.99,7-4-5.008-.625-8.133-1.981-15-2V49c5.306-2.349,2.968-8.666,8-11,1.856-1.288,5.26-1.626,7-3l-11-1c0.372-2.076.242-1.925,1-3,2.029-1.39,6-1.556,8-3-2.272-.4-10.143.4-13-1-3.268-1.6-2.341-5.427-7-7v4l-10-2c-0.193,3.6,1.485,2.074-2,3-1.295-.877-2.467-0.894-5-1V23h1c1.073-.752.946-0.6,3-1V18h6V17c-3.09-.879-5.437-0.414-9-1-1.024-2.039-1.906-4.8-4-6-1.757,3.04-2.106,3-7,3V10c-6.724-1.037-7.322-4.086-14-3a16.935,16.935,0,0,0-2,6h1c1.021-.8.274-0.355,2-1-0.212-3.346-2.153-2.4,1-4,1.579,1.218,4.443,1.749,6,3h-1v1c-3.626,1.731-5.254,2.871-11,3v4h-3c0.416-6.427,3.01-8.3,4-14h-1V4c-3.293,1.741-3.64,3.57-6,6-3.3-2.59-8.159-2.034-13-1-1.821.389-2.081-.639-3,0-0.742.516-.582,1.729-1,2-2.962,1.922-5.821-1.72-7-2-1.688-.4-21,2-21,2l-5,6c2.076,0.372,1.924.242,3,1h-2a23.436,23.436,0,0,1-10,5V22c0.8-1.021.355-.274,1-2a14.878,14.878,0,0,0,5-3c-3.97.378-9.406,2.057-11,5l4,1v1h-7c-1.021-.8-0.274-0.355-2-1V20ZM711,7c-0.564,3.637-2.025,4.837-1,7v1c5.032-1.29,6.08-2.138,11-3-0.552-1.922-1.641-.857,0-2,1.021-.8.274-0.355,2-1V8Zm-77,4c4.893,0.486,6.938.108,13,0v2c-3.471,3.372-4.2,5.55-11,6V18h1c1.231-1.8,2.592-2.481,4-4-5.939.509-5.33,2.732-10,4V17C633.2,15.294,633.488,14.579,634,11Zm-50,5c-0.828-3.245.49-1.528-2-3v2h-1v1h3Zm-88,2a30.433,30.433,0,0,0-7,1v1h1c1.624,1.495,2.023,1.552,5,2V21h1V18Zm190,2c1.021,0.8.274,0.355,2,1C686.979,20.2,687.726,20.645,686,20ZM391,26c1.224,2.057,1.649,2.912,4,4a8.9,8.9,0,0,1,3-3V26h-7Zm70,0c3.245,0.828,1.528-.49,3,2-0.8,1.021-.355.274-1,2h-2V26Zm-40,1v3c-2.076-.372-1.924-0.242-3-1-0.8-1.021-.355-0.274-1-2h4Zm27,0c2.408,3.074.672,2.146-2,5-1.754-.631-0.971-0.193-2-1h-1V30C445.84,29.285,446.49,28.917,448,27Zm9,0c2.467,1.295.681-.429,2,2-3.3.973-4.127,1.85-9,2V30h2C453.341,28.769,455.583,28.175,457,27Zm25,0h4v1C482.449,27.983,484.267,29.452,482,27Zm8,0c2.067,1.183,1.882.684,3,3,0.251,0.968.784,0.379,0,1a13.21,13.21,0,0,1-6,4V34C488.67,32.206,489.351,29.88,490,27Zm-19,1h4v2h-4V28Zm27,0a12.667,12.667,0,0,1,4,1v2C497,31.055,496.724,32.091,498,28Zm-73,1c2.573,0.974,2.238.848,1,3C423.327,30.311,425.718,30.952,425,29Zm240,5V30a28.9,28.9,0,0,1,9-1,15.705,15.705,0,0,1,1,5h-1C671.326,32.218,668.278,33.509,665,34ZM459,35V32c4.58-.219,7.229-1.706,9-1,2.467,1.295.681-.429,2,2h-1a24.52,24.52,0,0,1-3,3C464.451,34.951,461.915,34.969,459,35Zm16-4a12.667,12.667,0,0,1,4,1c-1.021.8-.274,0.355-2,1a19.079,19.079,0,0,1-4,3C473.506,32.812,473.872,33.08,475,31Zm256,0c-1.18.8-1.681,0.773-4,1v1h1c1.295,0.877,2.467.894,5,1,1.008-.693,4-1.287,5-2A36.032,36.032,0,0,0,731,31ZM365,38c-0.372,2.076-.242,1.925-1,3-0.74.872-1.26,1.128-2,2-1.754-.631-0.971-0.193-2-1-0.961-1.417-.976-3.273-1-6a38.806,38.806,0,0,0-9,1V35c1.834-1.285,1.712-1.968,4-3,2.814,1.9,6.665.506,10,0v2c-2.316,1.615-2.352,1.461-3,5h1C363.073,38.248,362.946,38.4,365,38Zm17,1c-4.467-.942-3.324-2.514-7-4-0.834,4.93.038,0.051-4,3,1.754,0.631.971,0.193,2,1h-3c-2.3-3.605-2.327-1.36-5-3h1c4.967-4.771,18.173-3.942,22-1h-1c-1.8,1.155-3.023.341-4,1C382.248,37.073,382.4,36.946,382,39Zm28-6c2.467,1.295.681-.429,2,2-1.215,1.774-.015,1.749-1,3-2.025,1.484-7.974,1.453-10,0h2C405.434,35.9,408.391,36.131,410,33Zm70,5a12.662,12.662,0,0,1,1-4,9.255,9.255,0,0,1,4,3h1v1h-6Zm178-4h4v1c-2.464,1.533-2.276,2.291-6,3V37A11.565,11.565,0,0,0,658,34Zm-57,1c1.077,1.737,1.035,2.271,0,4V35Zm138,0c0.372,2.076.242,1.925,1,3V37c0.8-1.021.355-.274,1-2h-2ZM614,36h4v2h-4V36ZM374,39c2.84,0.715,3.49,1.083,5,3h1v1c-6.835.07-6.117,1.926-10,4V45c0.8-1.179.773-1.681,1-4C373.389,40.158,372.645,40.6,374,39Zm43,0h2v1C417.246,39.369,418.029,39.807,417,39Zm198,0c1.322,1.737,1.727,1.607,1,3l-2,4-3-1V42C613.684,41.109,613.589,40.972,615,39ZM392,40h2v1C392.246,40.369,393.029,40.807,392,40Zm199,1h2l-1,3c-1.766.962-1.68,1.257-4,2V44C590.356,42.9,589.78,43.042,591,41Zm28,0c2.467,1.295.681-.429,2,2-0.723.692-1.535,1.056-1,3C615.934,45.295,618.054,42.93,619,41Zm100,0-1,3c6.055,1.559,9.267,4.562,17,5V48C730.038,45.07,726.224,41.989,719,41ZM594,42l3,1v1h-3V42Zm147,0q0.5,6,1,12h2V50C742.611,47.864,742.513,43.936,741,42Zm-39,2c2.389,0.842,1.645.4,3,2h1v1h-2C702.867,45.454,702.915,46.157,702,44Zm-14,1h4v1h-2c-1.35,1.624-.64,1.121-3,2Zm6,0c2.328,0.2,2.826.193,4,1C695.672,45.8,695.174,45.807,694,45Zm-17,1c0.752,1.073.6,0.946,1,3a25.766,25.766,0,0,1-5,2V49C675.684,48.109,675.589,47.972,677,46Zm-92,3c2.076,0.372,1.924.242,3,1C585.924,49.628,586.076,49.758,585,49Zm151,0c1.021,0.8.274,0.355,2,1C736.979,49.2,737.726,49.645,736,49ZM519,50h2v2C518.269,51.264,519.175,52.721,519,50Zm-17,2c2.076,0.372,1.924.242,3,1C502.924,52.628,503.076,52.758,502,52ZM235,54c-1.283,2.072-2.077,2.3-3,5h2V58c0.872-.74,1.128-1.26,2-2C235.369,54.246,235.807,55.029,235,54Zm-18,1c3.245,0.828,1.528-.49,3,2h-3V55Zm4,1h2v1C221.246,56.369,222.029,56.807,221,56Zm211,1h2v1C432.246,57.369,433.029,57.807,432,57Zm220,0c3.245,0.828,1.528-.49,3,2h-3V57Zm31,0c1.021,0.8.274,0.355,2,1C683.979,57.2,684.726,57.645,683,57Zm48,1a17.527,17.527,0,0,1-8,4v1h16c1.473-1.119,3.052-2.087,4-1,0.682,0.771,1.311,2.232,2,3V58h-2C739.914,60.1,734.5,58.531,731,58Zm-10,1c1.021,0.8.274,0.355,2,1C721.979,59.2,722.726,59.645,721,59ZM220,67c2.076,0.372,1.924.242,3,1h-1c-1.073.752-.946,0.6-3,1-1.275-1.394-4.124-4.288-5-3-6.482,1.888-8.293,7.623-14,10l-14,2c-2.911,1.394-1.494,3.931-5,3h-1V80c2.506-1.137,3.754-1.426,5-4-4.481-1.906-8.128-3.231-9-9a14.145,14.145,0,0,1,4-1c5.272,3.33,36.088-5.126,43-5v1C219.761,63.273,220.368,62.879,220,67Zm465-6c0.2,2.328.193,2.826,1,4C685.805,62.673,685.807,62.174,685,61Zm-49,5a12.662,12.662,0,0,0-1-4h2c0.708,2.347,1.025,2.234,2,4h-3ZM200,66l1,3c2.273-.36,1.514-0.221,5,0V68C203.851,66.491,204.068,66.231,200,66Zm413,1h2v1C613.246,67.369,614.029,67.807,613,67Zm67,0c1.116,1.66,1.77,1.069,0,2V67ZM144,74V71c2.418-1.3,2.833-1.8,7-2v2c-1.766.962-1.68,1.257-4,2C145.927,73.752,146.054,73.6,144,74Zm39-5c1.667,3.3.411,4.121,4,5V72c-0.8-1.021-.355-0.274-1-2Zm543,1v2h1V71h1C726.979,70.2,727.726,70.645,726,70Zm-67,1c0.8,1.021.355,0.274,1,2h-1V71Zm66,2c-1.552,1.5-1.838.777-3,3,1.215,1.774.015,1.749,1,3,0.74,0.872,1.26,1.128,2,2,3.562-1.131,10.182-1.982,14-5C734.368,74.987,730.537,73.44,725,73Zm-27,2a17.687,17.687,0,0,1,4,2h-4V75ZM116,77c1.865,2.694,2.377,2.86,7,3V78h-2C119.705,77.123,118.533,77.106,116,77Zm-11,3c1.021,0.8.274,0.355,2,1C105.979,80.2,106.726,80.645,105,80Zm-5,2v5H99V86c-0.775-1.923-1,2-1,2h3c1.021-.8.274-0.355,2-1V86C101.789,84.594,101.48,83.21,100,82Zm55,0h2v2h-2V82Zm539,0c3.28-.117,7.184-0.236,9,1C699.152,83.57,696.1,85.373,694,82Zm65,0c-0.771.682-2.232,1.311-3,2h1v1c2.273-1,2.774-.745,4-3h-2ZM93,85l1,3c1.754-.631.971-0.193,2-1,0.8-1.021.355-.274,1-2H93Zm592,5v3h-6V91Zm65,7-6,1v3h1v1l6,1c-0.218,2.745,1.105,9.676,1,10-0.355,1.1-4.046,4.436-5,8h3c1.073-.752.946-0.6,3-1,1.441,2.67,1.994,4.221,2,9-6.725.013-11.944,1.652-17,3v1h18v1h1v2h-8c-3.852-2.434-29.743-2.059-36-2q-0.5-1-1-2c6.5-.569,14.154-1.77,19-4v-1H719c-1.021.8-.274,0.355-2,1v-1h1c5.725-4.075,22.6-.68,26-7h1v-1h-3c-4.084,3.376-17.524,5.337-22,2,9.788-.463,18.011-6.343,24-11a10.925,10.925,0,0,1-3-2c3.763-.227,4.557-0.874,7-2v-1h-3c-1.919,1.772-3.136,1.9-7,2-0.168-4.176-.487-1.733-2-6l6-2V98c-8.158.234-10.415,2.9-20,3V99l10-3a19.092,19.092,0,0,1-3-4c3.63-.544,5.871-2.009,8-1,1.656,1.217-.382,1.807,5,2a18.331,18.331,0,0,1,7-3Q749.5,93.5,750,97Zm-72-3c2.328,0.2,2.826.193,4,1C679.672,94.8,679.174,94.807,678,94Zm6,0h2C684.812,95.609,685.582,95.224,684,94Zm36,1c2.391,2.673-1.148,5-3,4-0.8-1.021-.355-0.274-1-2h1V96C719.076,95.628,718.924,95.758,720,95Zm15,0c1.021,0.8.274,0.355,2,1C735.979,95.2,736.726,95.645,735,95Zm20,1c1.021,0.8.274,0.355,2,1C755.979,96.2,756.726,96.645,755,96Zm-44,4h2v1h-2v-1ZM97,102l3,1-1,2-2,1v-1C96.293,103.455,96.871,104.865,97,102Zm630,4c3.469,0.643,5.593,1.125,7,4h-1c-1.593,2.7-4.751,2.219-9,2-0.384,2.617.743,1.31-2,2-0.437-1.146-1.154-4.7-2-2h-1l2,3h-6c-1.021-.8-0.274-0.355-2-1q-0.5-1-1-2C716.912,111.066,723.9,109.043,727,106Zm-601,3h2c-1.476,2.449-4.052,4.989-6,4-0.8-1.021-.355-0.274-1-2C123.977,110.615,124.4,110.475,126,109Zm613,0h2v1C739.246,109.369,740.029,109.807,739,109Zm-622,5v5c-3.671.141-8.875,0.435-11-1h2C110.253,115.791,113.052,114.556,117,114Zm603,5v-3c5.817-.1,6.86-1.476,12-2v1h-2C727.53,117.438,724.647,118.66,720,119ZM97,119h5v1h-1c-5.353,5.056-13.338,2.095-20,4v-2C87.748,122.274,93.7,122.125,97,119Zm618,3h4v1a15.923,15.923,0,0,0-5,5h-2c-1.012-2.31-1.712-2.163-3-4C710.39,123.533,713.848,122.823,715,122Zm-10,1h2q-0.5,1.5-1,3h-1v-3Zm1,5h6v1h-1v1a26,26,0,0,1-11,2v-1h1C702.406,129.391,704.311,129.285,706,128Zm-4,5c2.076,0.372,1.924.242,3,1C702.924,133.628,703.076,133.758,702,133Zm55,8a12.662,12.662,0,0,1-4-1q0.5-1.5,1-3h2v1C756.752,139.073,756.6,138.946,757,141ZM36,139v1H35c-1.923.775,2,1,2,1,1.021-.8.274-0.355,2-1v-1H36Zm719,5h2v2h-2v-2Zm6,8q0.5,4,1,8h-2c-1.295-.877-2.467-0.894-5-1a30.439,30.439,0,0,1,1-7h5Zm8,45c4.919,0.01,12.163-1.8,14-5H770A15.7,15.7,0,0,0,769,197Zm-2,3c1.021,0.8.274,0.355,2,1C767.979,200.2,768.726,200.645,767,200Zm3,0q0.5,1.5,1,3h1C771.158,200.611,771.6,201.355,770,200Zm13,0c1.021,0.8.274,0.355,2,1C783.979,200.2,784.726,200.645,783,200Zm-17,2c1.021,0.8.274,0.355,2,1C766.979,202.2,767.726,202.645,766,202Zm6,4v11l3,2v-2C773.26,214.152,773.858,208.6,772,206Zm-34,4h8v1h-1c-2.128,2.2-8.743,5.266-11,4-1.546-1.133-.843-1.085-3-2-1.85,2.4-2.84,2.724-7,3v-1c1.8-1.565,1.281-1.966,4-3C730.1,210.727,735.924,211.314,738,210Zm-28,3h4v2l-4,1v-3Zm-10,2c2.076,0.372,1.924.242,3,1C700.924,215.628,701.076,215.758,700,215Zm75,8c-4.664,6.189-14.205,1.813-21,6,2.744,1.939,2.02,2.677,7,3,4.8-3.112,12.194-1.819,18-4,2.591-.973,4.632-3.079,8-4v-1H775Zm-27,6v3c-4.662.492-7.881,1.994-12,3v1h3c3.221-2.191,9.4-.543,13,0,0.961-1.766,1.257-1.68,2-4a8.894,8.894,0,0,1-3-3c1.754-.631.971-0.193,2-1Zm-15,0c-0.771.682-2.232,1.311-3,2h4C733.369,229.246,733.807,230.029,733,229Zm-14,1c1.322,1.737,1.727,1.607,1,3-1.021.8-.274,0.355-2,1v-2C718.8,230.979,718.355,231.726,719,230Zm62,0v6h2c2.539-1.991,5.787-2.721,8-5C787.9,230.137,784.75,230.656,781,230Zm-95,3h5v2c-2.091,1.121-1.832,1.434-5,2C685.626,234.6,685.37,235.462,686,233Zm81,2c-3.386,2.019-10.073.755-13,3,4.782-.284,6.377-1.4,8,1h-1c-1.406,1.609-3.311,1.715-5,3h2c5.017,3.306,19.129-2.951,22-6a18.324,18.324,0,0,0-6-1v1a6.1,6.1,0,0,1,2,2,34.041,34.041,0,0,0-8,1v-2a6.1,6.1,0,0,0,2-2h-3Zm-96,10c2.076,0.372,1.924.242,3,1h-1C671.459,246.682,669.862,246.925,671,245Zm-46,1,7,2c-1.382,1.78-.988,2.224-2,3-2.226,1.791-4.8,2-9,2a14.124,14.124,0,0,1-1-4C622.84,248.285,623.49,247.917,625,246Zm113,0c1.021,0.8.274,0.355,2,1C738.979,246.2,739.726,246.645,738,246Zm-125,3a14.338,14.338,0,0,1,5,1v1C613.046,251.024,613.2,251.61,613,249Zm153,0c1.021,0.8.274,0.355,2,1C766.979,249.2,767.726,249.645,766,249Zm-132,4h2v5h-1v1h-2Q633.5,256,634,253Zm-34,7h5v1c-2.8,1.477,1.244.772-1,3-2.087,3.032-4.79,4.081-9,5v-1h1c1.271-1.685,2.729-2.316,4-4-2.3-1.345-1.823-1.219-2-2C598.74,261.128,599.26,260.872,600,260Zm47,7h2v1h-2v-1Zm-52,4,3,1v1C595.611,272.158,596.355,272.6,595,271Zm77,4,9,3c-5.336.623-3.88,2.2-9,3C668.659,277.556,669.447,279.231,672,275Zm7,5h4v2l-4,1v-3Zm45,6c2.076,0.372,1.924.242,3,1C724.924,286.628,725.076,286.758,724,286ZM126,301h4v2l-7,1v-1h1C124.74,302.128,125.26,301.872,126,301Zm11,1c2.076,0.372,1.924.242,3,1h-1v1l-3,1v-1C136.8,302.979,136.355,303.726,137,302Zm-33,2h6v2h-6v-2Zm81,0c0.8,1.021.355,0.274,1,2h-1v-2Zm-84,4c3.245,0.828,1.528-.49,3,2C100.422,309.556,101.206,310.63,101,308Zm79,0h8v1h-2c-2.225,1.759-8.169,2.961-11,1h2C177.771,309.318,179.232,308.689,180,308Zm-45,24c-0.828-3.245.49-1.528-2-3-1.359,1.262-1.768,1.365-4,2v-1c1.624-1.35,1.121-.64,2-3-1.766-.961-1.68-1.257-4-2v4c2.711,2.92,1.454,4.395,7,5,0.86-.649,3.144-1.338,4-2h-3Zm-18-4c0.372,2.076.242,1.924,1,3C117.628,328.924,117.758,329.076,117,328Zm-38,2c1.72,0.881,1.278.889,3,0H79Zm66,4c-1.359,1.262-1.768,1.365-4,2,1.021,0.8.274,0.355,2,1l1,2,3-1q0.5-2,1-4h-3Zm-15,4c1.042,4.358,1.59,4.9,7,5,1.359-1.262,1.768-1.365,4-2v-1C137.124,339.128,135.16,338.146,130,338Zm-10,4v2h1v-2h-1Zm1,6v2h1C121.369,348.246,121.807,349.029,121,348Zm2,10c2.076-.372,1.924-0.242,3-1-1.624-1.35-1.121-.64-2-3h-1v4Zm15,2v-3h-6v2h1C134.295,359.877,135.467,359.894,138,360Zm12-3c1.021,0.8.274,0.355,2,1C150.979,357.2,151.726,357.645,150,357Zm0,3c1.021,0.8.274,0.355,2,1C150.979,360.2,151.726,360.645,150,360Zm-26,1v2h1C124.369,361.246,124.807,362.029,124,361Zm8,1c1.725,2.406,5.664,4.313,9,2Z" />
</svg>';
		} else if ( $svg === '3' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 594">
<path style="fill:' . $f . '" d="M0,0H896q-0.5,2.5-1,5h-1l-2-3c0.215,7.072-.673,11.609-4,15-2.832-2.068-1.232-1.485-4-2-1.918,6.806-2.545,1.582-5,5-3.57,7.163-5.449,10.241-6,20l-10-2q-2.5,6.5-5,13c-3.232-.771-2.179-2.873-4,0q-0.5,2-1,4h-1c-0.374-3.721-1.114-13.726-4-12L835,73h-2q0.5-4,1-8l-8,5q0.5-5,1-10c-6.912,4.208-15.03,12.588-12,21-11.64-.082-19.515,3.525-26,4q-0.5-2-1-4c-1.162,12.09-13.205,13.457-22,15-0.133,4.633-.529,5.551-2,8-6.682.672-4.415,2.341-14,3l-3-5-3,5V96l-18,4c-0.795,4.787-1.1,6.163-5,8l-32,3q0.5,5,1,10-0.5-1-1-2-1-3-2-6l-5,4q-1-2-2-4l-11,6c-1-5.327-2.54-7.3-6-10q1,3,2,6l-4-2q1,3.5,2,7l-1-1c-5.2.442-3.868-1.861-8-1q-0.5-3-1-6c-5.175,3.425-5.9,6.584-9,0q-0.5,1-1,2-2.5,4-5,8c-6.6-.437-17.725,2.66-26,4q-0.5,3.5-1,7c-8.44-1.38-13.785-2.382-23-2q-0.5-3.5-1-7h-1l-4,7c-3.172-1.919-5.739-3.835-9-3-4.587,1.282-5.609,2.777-8,6-7.308-4.9-23.335-.029-38-2q-0.5,3-1,6c-6.3-1.835-8.372-4.487-17-5-2.232,5.22-5.217,4.775-10,7l3,13h-5l-6-20h-1l-3,8c-6.967-1.5-5.688-1.679-10,2V130c-8.393-1.006-18.831-4.286-23,2-2.314,4.012-2.22,11.264-2,18l-38,2v10h-3l-6,1q-0.5-6-1-12l-2,1v4l-5-6-4,1q-0.5,3-1,6l-18-4v1c1.694,4.738,2.181,4.734-1,8q-2.5-4.5-5-9v9l-27-9v1c1.119,3.452,1.228,3.585,1,7h-7c-1.86-6.466-5.262-12.329-10-16h-3q-0.5,8-1,16l-5-4-4,5c-1.032-4.476-1.651-4.369-4-7l-5,2c-3,3.282-2.222,11.588-4,16l-3-1q0.5-7.5,1-15c-4.143.494-1.68,1.281-5-3l-19,2q-1,5-2,10c-15.3-4.394-47.1-4.1-53,3h-5l-12-13-37-1c-0.358,6.237-1.247,7.381-5,10l-9-7c-2.268,5.98-4.161,5.006-11,4,3.187,3.691,3.517,2.376,4,7l-3,7-2-1v-7l-5,6c-2.978-2.544-.306-1.783-4-2q-0.5,3-1,6l-2-1q-0.5-4-1-8c-6.858-.449-9.4-2.534-13-6-6.769,5.653-9.557,2.409-17-1-1.981,4.045-2.541,4.34-8,5-0.647-4.728-1.313-6.519-4-9-5.036,2.215-9.917,6.028-8,12,5.743-2.583,6.106-3.127,10,2l58,21c0.248,0.457,62.835,4.065,72,8-2.177,5.53,1.884,10.871,5,17,5.826-3.447,4.06-3.795,9,0v-8h8c1.621,5.7,3.919,7.177,7,11,5.457-2.571,5.086-1.494,9,2q0.5-2.5,1-5c4.431,2.215,6.2,3.339,8-4l2,1c0.312,4.238-.062,3.964,2,6l6,2c3.422-3.306,1.368-4.549,5-3,3.981,1.595,4.893,2.608,7,6l-5,2,3,5c-8.646,1.948-11.8,5.886-16,12l-3-1c-5.944-4.482-10.344-5.97-13-14-4.967,2.113-17,2-17,2l-3-2q1,3,2,6h-1c-3.921-4.363-2.889-6.158-12-6v1q1,6,2,12c-8.729-9.591-30.876-21.469-58-22q-0.5,4.5-1,9c-5.864-3.906-4.88-1.562-10-2q-0.5-3.5-1-7a158.879,158.879,0,0,1-51-17l-2-11-5,4c-1.309,6.3-.414,12.4,1,18H93l-5-2,10,12H91c-1.6-1.984-1.3-1.389-2-5l-2,1-1,5-5-5L70,208l-1,16c-10.1.814-12.034,0.44-18-4l5,11c-6.053,1.006-5.251,3.341-8,4-3.5-7.727-12.408-13.4-22-15l-1,12H24l-7-2c0.038-3.3-1.182-8.216,2-6l-2-3L2,225l-2-3V0ZM898,0h102V594H0V227l5,2,3,15,10-3c2.018,10.234,8.976,14.882,17,19l3-5c0.172,6.629.41,6.8,6,8v-5l2,1c1.343,12.947,7.711,13.556,15,20-2.075,4.776-3.682,5.57-4,13l-2-1-3-9c-5.936,2.709-13.989,3.539-22,5l-1,2c0.734,5.63,2.122,9.458,6,12-1.242-5.855-1.333-6.717,5-8v11c11.445,0.532,11.832,3.251,14,11l60,4q-1-3.5-2-7h1c10.561,6.758,21.12,23.257,27,5,13.236,8.428,27.892,4.217,37,11l8-4q0.5,2.5,1,5l2-2c5.9-1.486,5.749-1.733,6-7l9,6,8-5,15,9,10-7c0.935,4.333,1.36,4.7,4,7h2c3.443-6.266,3.747-3.057,8-9l7,2,1-5v2q1,4,2,8c9.325-4.387,10.537-7.175,17,2,7.212,1.009,11.72-.243,18-2v16c-9.414-.764-13.977,11.667-31,12l-2-4-16,10c-0.575-4.439-.766-4.668-3-7-10.521,6.932-28.807,5.37-44,16-6.962-4.579-18.473-.38-24,2-0.838-4.882-1.1-4.6-4-7h-4q-0.5,4-1,8l-7-3c-4.246,2.623-4.851,5.529-8,9l-1-1c-0.088-5.552,1.154-3.922-2-7q-0.5,4-1,8h-6v-1l4-2c-1.852-4.04-2.37-4.789-6-7l-16,5c0.23,4.7,1.135,3.9-2,7v-9l-2,1v2q-0.5,5-1,10c4.177,0.86,16.03,2.157,19,5,2.405,4.312,2.3,6.677,1,10-4.427-2.022-7.874-3-15-3-1.074,4.1-.448,4.167-4,6l-29-8-1,12c5.053,1.371,6.851,3.028,10,6l15-3c6.63,16.812,33.554,6.581,47,15-2.11,3.033-2.5,2.533-3,8h-3c-4.4-3.1-.233-2.648-5-2l-4,8h-1q-0.5-2.5-1-5c-4.822,1.858-13.616,3.025-13,8v1h-4c-2.913-2.484-3.76-4.321-6-5v5c-8.393.571-16.123,0.958-23-1l-5,7a45.031,45.031,0,0,1-20-4l1,8-11-1c-0.483-4.443-.459-4.866-3-7l-6-2v1l6,6-3,10-1-2-4-6-3,6c-1.114-2.867-1.26-7.208-4-6-0.472,7.408-1.13,5.476-6,8l7,20c0.3-5.588,1.019-5.838,3-9l6-2,3,7c3.208-2.539,1.994-3.307,6-3l-2,8h1l22-4-1,11c6.676-5.032,11.376-9.374,21-12l-4,12c14.284-.349,14.184,4.063,22,9V488c2.936,5.247,4.76,1.168,10,3q1,2.5,2,5l4-3v11l13,1c0.484-7.3,2.757-9.04,5-14h2c0.934,4.634,2.206,6.434,5,9l-1,2c-4.336,1.433-5.72,2.615-8,6,39.589-3.954,73.021,2.656,106-5v1c-4.284,11.373,1.1,24.436-3,31-24.356.075-38.563,1.4-62-1v5l4,5c-2.123,1.3-1.447,1.23-5,2l-5-1q-1-4-2-8l-2,1q1,4,2,8c-7.745-2.2-20.7.143-25-2l-1-3c-5.03,2.441-.934,1.708-7,0q1,2,2,4l-19,6c-4.651-4.051-7.821-4.134-16-6,1.047,5.559,2.941,7.718,6,11,3.816-2.736,3.219-4.023,7-2,4.223,1.956,6.194,4.708,8,9l6-5c0.815,4.948-.668,2.978,3,5l6,1c0.644-3.635.4-3.027,2-5,4.357,1.894,5.326,1.078,11,0-0.21,3.941-1.658,2.487,1,5l7,5c10.277-8.594,23.163-2.42,39-5,9.272-7.209,9.84-.028,20-4,0.215,4.513.708,5.391,2,8,3.854-.033,2.821.379,6-2q1-2,2-4l2,1q0.5,2.5,1,5c31.339-3.789,58.547,1.463,92-5,67.511-13.042,127.884-18.237,186-36l58-28,63-20c43.881-18.913,82.707-45.847,123-68l48-14c17.67-10.044,27.983-27.528,47-37q-0.5,6-1,12c-3.973.124-2.068-.9-5,1q0.5,1.5,1,3l5-1c5.52-14.538,34.983-54.425,50-58,0.427-15.4,3.662-20.911,12-28l8,3c0.261-8.033,2.705-15.828,7-20l9,3c3.783-35.2,56.23-65.809,38-105l-10,2q0.5-5.5,1-11c-10.4,7.208-15.863,16.615-24,26l-2-1q-0.5-1.5-1-3c7.859-19.6,21.239-33.28,31-51l-2-3a39.867,39.867,0,0,1-18-15q-2.5,2.5-5,5V109l-7,2q-0.5,4.5-1,9,0.5-12,1-24c13.181-6.25,35.014-27.1,38-43l3,2c4.54-19.5-1.545-28.412-11-41l-3,5c-7.259-5.543-14.275-2.937-16,9h-1V12c-6.791,5.8-6.893,8.832-15,7-1.479,7.04-3.729,10.813-9,14q-0.5-8.5-1-17c-5.583-1.682-34.19-22.14-31-1l-6-2q-1,2.5-2,5h-1l3-14-5,1V0ZM481,131v4l4-3ZM269,327c1.059,3.651.814,2.941,3,5h1v-1Zm-14,24,2,1ZM87,377l-15,2v1l1,3,15,2Zm4,1v10c6.652-1.94,9.136-1.943,11-9h-1Zm17,1q0.5,3.5,1,7h1l2-1v-4Zm-8,54,5,7q-0.5-2.5-1-5ZM68,448c1.392,1.923.1,0.6,2,2ZM52,475c1.392,1.923.1,0.6,2,2Zm92,68,2,2Z"/>
</svg>';
		} else if ( $svg === '4' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V416H984q-0.5-1-1-2v-1l7-5q-0.5-6-1-12l-10,3v-4c1.925-3.059,3.427-3.763,6-6l-15-3c-9.508,4.1-9.711,1.639-14-6-3.946,1.824-6.684,2.523-10,0l3-3c-20.612-.54-30.521,7.778-48,10v-3c7.829-19.118-1.8-40.392,5-66,2.047-7.709,11.391-15.724,15-22,3-5.219,6.021-13.4,3-18l-5,1q1-3,2-6c-5.943-4.409-6.608-5.221,0-10q1-2.5,2-5l-1-1c-5.423,2.163-7.932,2.291-12-1l5-12-9,3q0.5-1.5,1-3c4.6-3.408,7.4-5.235,8-13l-2-2c-8.826,4.148-8.382.214-17-2a29.966,29.966,0,0,1-15,8v-1l3-4-6,1V218c-8.1,1.154-9.033-.255-14-4l-15,6-2-1q0.5-2,1-4c1.578-8.1,9.577-12.182,14-18-6.2-.3-12.984-0.343-15-5,6.149-3.37,16.261-14.107,18-22l-3-4c-10.571,5.3-16.22,9.533-29,8q0.5-1,1-2c12.472-5.182,13.446-19.63,17-29l-27,2c-0.682-4.53-.29-2.74-4-6,4.721-8.618-1.429-10.861-15-12v-4l5-6h-6v-1c2.543-3.749,2.4-2.127,1-6a17.39,17.39,0,0,1-13-12c1.02-2.021,4.377-24.085,4-25-1.355-2.055-1.12-1.609-3-3-11.363,6.184-27,.47-35-5-0.425-2.6.976-.546-1-3l-30,3c-10.062,3.31-19.593,17.422-31,13,0.7-13.162,2.2-14.414-2-25-3.16-.746-7.986-1.014-10-3q-0.5-3-1-6l8-8q-0.5-7.5-1-15h-1c-4.729,2.215-22.3,7.5-21,0l-1-2c-21.433-2.937-37.8-8.837-58-3l-16,8c-9.671,1.4-27.028-11.44-44-7-47.506,12.429-85.261,45.717-123,68-16,9.449-40.28,6.726-58,16l-56,52c-49.274,38.779-92.945,84.1-140,125-28.414,24.7-57.439,49.1-86,73-16.031,13.413-38.98,23.92-48,44l4,1c-7.363,23.174-34.854,21.989-16,51l9,2c-0.334,12.738-5.89,12.362-10,20l-4,20L2,510,0,523V0ZM1000,800H0V526l8-2v3l-5,7c3.672,0.573,13.738,7.618,19,11-0.131,6.429-1.368,7.8-3,12,5.22,2.232,4.775,5.217,7,10,9.709,0.131,22.2,4.129,29,9-2.606,3.86-5.379,6.828-6,10,13.688-4.263,14.815-7.684,28-6,5.5-8.32,15.784-17.385,29-18q-1,3.5-2,7l10-7c12.667,4.821,16.014,14.3,30,18-1.13,6.511-4.1,7.412-4,12-0.695,4.338-.284,5.233,3,8l15-3c1.868,2.262,1.817,1.4,3,5-2.366.278-1.247-.222-4,1q0.5,1,1,2l9,2-3,18-16,14-11,27q0.5,1,1,2l9-3c0.4,4.636.956,8.358,2,9l10,1c-1.62,3.06-2.053,3.152-2,6l9,3c-1.493,5.386-2.72,6.533-7,9,2.525,4.884,3.663,8.667,1,14,7.959-.859,30.436,7.252,37,11l-2,3-4,1,1,3,2,1c8.751-2.784,32.72-7.66,40-14,6.851-5.967,10.389-10.9,21-14,1.678,3.191-.5,1.136,3,2,3.537-4.257,8.781-6.429,16-7,0.82,5.3,1.042,8.617,5,11,5.356,2.26,7.927,1.473,11,6,3.793-2.335,4.888-4.032,8-2l-1,2-10,7q2,7.5,4,15c6.963-3.05,16.734.967,21,4l-2,4c10.768-1.774,9.959,2.015,20,0-1.975,5.73-5,5.187-7,11h3l8-3,2,2,3,15c7.584-1.323,11.739,1.942,21,1l-1,4c5.793-.916,19.53-4.05,24,0l5,8h11l-6,6,18-9,19,2,60-35c9.528-6.374,28.213-22.464,42-17,1.074,4.1.448,4.167,4,6,12.705,1.879,17.141-.44,33-2q-0.5,1-1,2c-7.07,3.562-10.045,9.562-19,12l3,3c18.96-8.94,35.5-10.693,56-20,1.417-.643,48.966-28.956,49-29,2.943-3.77,2.171-8.124,8-12l43-25c4.89-1.183,5.607,2.725,11-1,5.072-3.5,6.363-11.458,12-15,11.675-7.335,26.205-13.072,34-24,4.342-6.087,4.291-14.895,7-21-3.773-5.162-4.888-3.61-2-9l124-64c29.708-15.181,64.561-25.351,89-46,5.736-4.846,7.437-18.958,12-25-3.366-2.709-2.215-.38-2-5h-5c0.269-6.284,1.839-10.685,5-14-3.419-2.284-8.656-1.229-11-5,6.194-.683,12.372-3.532,16-7-3.61-2.914-1.954-2.991,2-6V800ZM756,632l-4,3v1l3-2h2Q756.5,633,756,632Zm-51,33-6,5C703.725,667.93,705.53,667.186,705,665Z"/>
</svg>';
		} else if ( $svg === '5' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM449,1L390,11c-28.349,6.283-87.8,23.77-105,41,14.485-6.886,29.579-15.624,47-19v1h-2L291,52,249,79l21-19c-19.8,12.085-53.259,29.507-60,54l5-3-26,30c-12.6,16.24-25.795,36.2-32,58h-1q1-4.5,2-9l-3,2-17,62q-3,28.5-6,57-9.5,22.5-19,45c-12.784,42.174-21.314,106.418-11,157l3-2c-0.411,17.6,5.377,40.16,17,46-7.527-25.089-15.305-50.7-17-79q4-16,8-32c2.1-10.115-1.864-20.616-1-29,2.736-26.541,11.79-52.234,18-76h1c0.2,27.392,11.179,66.339,1,92,0.319-9.653,2.417-29.06-2-35q2,33.5,4,67c6.673,33.945,15.194,58.15,9,95q0.5,18,1,36l-3-6c1.64,9.8,2.881,22.4,8,29q-0.5-7-1-14c12.379,114.813,152.337,149.914,267,166v1c-34.229.451-60.58-7.431-89-11l2,3c-5.385.083-8.827,0.69-5-2l2-2c-25.682-3.661-51.877-14.919-73-25q-1,2-2,4c-31.2-11.756-40.31-25.752-65-43,29.845,42.933,102.715,63.824,160,78,18.572,4.6,30.714-4.866,54,0,142.607,29.8,277.024,40.645,367-43q-0.5-1-1-2c-23.1,13.891-45.336,31.639-73,40l-76,14c-15.754,3.927-50.27,13.407-66,3,21.131,0.128,59.394-6.427,71-18-3.935,1.124-7.837,2.747-12,1,15.577-1.331,18.752-11.572,36-12v1h-2l-8,4c23.2-5.527,44.444-16.4,62-28l22-16,27-2c22.073-4.507,59.159-16.324,69-27,0.278-2.366-.222-1.247,1-4l-10,4,26-19c17.068-13.621,33.779-36.986,43-58,9.379-21.376,8.725-53.183,20-75q-0.5,7.5-1,15l4-1q-2,10-4,20V561c-3.183,4.886.648,12.791,0,14-6.537,3.244-11.964,32.838-16,50h1l20-57q3-35,6-70c-3.8-1.652.721-21.371,3-30,7.141-27.036,2.07-65.477,10-95q0.5-12,1-24c0.506,53.216-7.035,96.691-12,140h1c2.746-26.394,8.4-56.394,14-85,10.315-52.708-13.2-142.556-32-173-2.221-3.6-8.839-11.463-12-8l-19-32-31-37,4,2-6-8-2,1,3,4c-10.71-4.945-21.517-24.763-37-34-30.765-18.353-69.44-25.342-101-44L644,44C594.21,14.4,528.024.655,449,1Zm0,3c20.667-.4,47.486-1.953,63,5L447,6l-43,5Zm64,5h4v1Zm-55,1,44,3C488.068,13.323,468.342,14.8,458,10Zm70,1,24,4v1ZM400,12h4v1Zm-4,1h0Zm107,0,17,1ZM393,14h0Zm71,0c77.206-1.23,130.009,23.408,182,47v2h-1L591,53H551L494,38c-43.434-8.246-116.3,15.325-139,33l8-2v1h-2c-80.272,59.546-136.591,86.129-192,174l-22,33h-1c6.426-105.581,99.518-200.346,180-232L428,17Zm57,0c37.327-.578,125.224,31.27,141,52L596,34Zm31,2h0Zm4,1h0Zm25,6h0Zm3,1h0Zm5,2h0Zm2,1,14,4v1h-4ZM344,28h0Zm-3,1h0Zm-3,1h0Zm-3,1h0Zm-3,1h0Zm290,7h0Zm5,2h0ZM465,42l23,1-60,5Zm164,0h0ZM493,43l6,1Zm139,0h0ZM499,44l43,8v1C527.146,53.08,509.926,49.638,499,44Zm-77,5,6,1Zm-5,1h0Zm43,3,36,2c-28.425-.113-92.133,19.569-106,15h2C408.565,57.865,441.852,63.934,460,53ZM279,54l-1,2,2-2h-1Zm292,2,10,1v1ZM274,57l-1,2,2-2h-1Zm118,1,5,1v1l-18,5h2Zm234,4h0Zm-56,1,23,5-6-4c34.242-.538,70.864,5.554,93,19l22,18L686,86c24.88,6.663,37.231,28.071,51,46,27.741,36.123,79.315,80.179,89,131l-2-1-7-14,3,2c-3.917-11.361-33.453-30.887-43-43-41.989-53.274-90.6-94.835-155-126l6,6Zm59,0h0ZM377,66h0Zm-2,1h0Zm-10,4h2l-3,2Zm23,0h0Zm-43,2c-16.172,8.163-32.462,12.518-43,26l48-25V73h-5Zm17,0h0Zm-3,2h0Zm-3,2h0Zm-3,2h0ZM228,97c-0.394,2.8-.712,4.2-5,6Zm488,0c17.635,3.129,34.358,13.921,48,22,77.253,45.754,117.605,106.552,140,208,5.485,24.846,9.765,122.887-4,139,0.342-15.59-1.93-26.037-5-37q-1,2-2,4c0.492-54.1-34.177-126.8-58-163-14.069-21.381-2.375-34.848-24-51l7,14-5-4-6-14,4,3-48-70Zm-7,8,13,15C719.622,112.85,714.831,108.656,709,105Zm-490,1c-0.424.928,0.8,0.676-1,2Q218.5,107,219,106Zm505,14c6.774,14.365,15.954,29.293,30,40l-6-9,5,3c-3.822-6.124-8.756-5.587-10-10,1.224-1.467,1.318-1.553-3-5-1.477,1.9-1.167,1.46-4-2l4,1Zm-440,5h2l-8,6,2-3Zm-91,7-3,5C192.776,135,193.842,135.015,193,132Zm84,9c1.851,8.571-33.5,38.228-40,47a376.513,376.513,0,0,0-67,152c-6.62,34.233,8.595,97.489-14,116v-2l-7-36c-22.472-97.644,33.423-174.73,78-231Zm542,2,3,3Zm-65,18,3,3Zm-584,4-3,6,2-1Q169.5,167.5,170,165Zm63,2h0Zm-5,5h0Zm-66,6q-0.5,2-1,4C162.525,179.714,162.826,180.785,162,178Zm-3,5-2,5c2.806-1.558,2.338-1.471,4-4Zm635,14,2,3Zm-639,2q0.5,1.5,1,3h-1v-3Zm-1,4q0.5,1,1,2Q154.5,204,154,203Zm637,1c3.309,10.937,11.669,23.718,20,30C807.717,223.174,799.169,210.332,791,204Zm-638,2q0.5,1,1,2Q153.5,207,153,206Zm648,1q0.5,1,1,2Q801.5,208,801,207Zm5,6q0.5,1,1,2Q806.5,214,806,213Zm73,10q0.5,1,1,2Q879.5,224,879,223Zm-731,1q0.5,1,1,2Q148.5,225,148,224Zm642,1,8,9C793.777,232.044,791.806,229.292,790,225Zm90,0q0.5,1,1,2Q880.5,226,880,225Zm-733,3q0.5,1.5,1,3h-1v-3Zm-1,3q0.5,1,1,2Q146.5,232,146,231Zm27,22h2l-16,30-17,62h-1C142.917,304.3,162.582,282.979,173,253Zm630,4c12.823,6.2,20.491,24.19,27,37,36.981,72.781,23.049,171.211-21,225,5.273-32.491,17.785-62.551,24-97C844.147,360.214,819.717,299.6,803,257Zm17,5q0.5,1,1,2Q820.5,263,820,262Zm79,3q0.5,1,1,2Q899.5,266,899,265Zm1,2q0.5,1,1,2Q900.5,268,900,267Zm1,3q0.5,1,1,2Q901.5,271,901,270Zm1,2q0.5,1.5,1,3h-1v-3Zm1,3q0.5,1,1,2Q903.5,276,903,275Zm1,2q0.5,1.5,1,3h-1v-3Zm1,3q0.5,1.5,1,3h-1v-3Zm1,3c4.207,6.725,11.326,28.018,8,37Q910,301.5,906,283Zm-69,3q0.5,1,1,2Q837.5,287,837,286Zm11,10q0.5,1,1,2Q848.5,297,848,296Zm-1,4q0.5,1.5,1,3h-1v-3Zm1,4q0.5,1,1,2Q848.5,305,848,304Zm67,16v0Zm1,7v0Zm1,9v0Zm-52,4q0.5,1,1,2Q865.5,341,865,340Zm-14,10c4.188,5.127,10.351,21.565,7,30v-2Zm17,1c21.833,29.33,14.474,81.957,28,120q1-2,2-4v6l-4-1c1.049,7.906,2.494,19.9-2,25C892.9,438.17,874.164,398.741,868,351Zm-4,51c13.932,24.332-7.7,90.877-16,109-32.625,71.205-83.367,117.964-147,158-22.751,14.314-41.143,35.793-76,35v-2c75.661-17.59,126.911-93.553,168-148,18.565-24.6,41.913-47.016,55-77A190.338,190.338,0,0,0,864,402Zm-726,3,1,3h-1v-3Zm741,12c7.663,11.386,16.271,73.369,11,93-12.888,48-81.978,149.115-125,163l6-8c-10.866,8.308-17.481,20.187-32,25l8-10c-23.764,18.041-30.687,32.953-68,33-8.313.011-15.762-.025-20-4,47.554-12.335,110.463-64.752,138-99l26-32c-4.99,27.432-34.067,50.825-49,71,21.087-16.185,31-42.9,50-61-7.78,22.822-27.429,43.592-41,62,9.773-7.192,39.965-39.769,42-51l-2,1-3,5,14-31-2,1-8,13,17-38h1v7l12-29h1q-0.5,3.5-1,7l2-1q7.5-22,15-44C877.537,468.687,878.84,443.9,879,417Zm-743,2c5.992,11.305,14.472,49.988,8,66-2.118-4.951-1.679-1.589-5-2q-1-6.5-2-13l2,1c1.027,5.161,1.34,6.515,5,9C140.054,461.1,136.24,441.664,136,419Zm757,1v4l2-1Zm-18,16q0.5,1,1,2Q875.5,437,875,436Zm-742,4v0Zm35,0,3,4c5.575,10.694-3.869,23.861-7,33l-2-1v-2C156.462,462.545,164.1,448.756,168,440Zm-23,2,1,2Zm-11,3,2,2q-0.5,2-1,4h-1v-6Zm15,11,1,2Zm723,0q0.5,1,1,2Q872.5,457,872,456Zm-736,3,1,2Zm1,4c2.247,3.689,1.757,3.037-1,6Q136.5,466,137,463Zm10,0,3,12h-1Q148,469,147,463Zm24,0c8.93,5.843,6.872,23.4,11,34,8.7,22.334,18.631,48.338,31,68l37,51,34,32c16.149,21.3,29.389,48.293,50,65,12.6,10.217,29.6,17.047,42,28-18.3-4.816-30.184-16.754-44-26-59.886-40.075-99.668-88.156-134-154-7.381-14.156-38.455-61.185-34-81Zm-19,2,1,2Zm717,3q-0.5,4-1,8Q868.5,472,869,468Zm-715,6,1,2Zm-3,2c4.3,5.521,5.262,12.672,5,23h-2C152.783,490.723,148.685,484.921,151,476Zm4,0,1,2Zm2,5,1,3h-1v-3Zm709,1c2.65,6.224-.739,13.24-2,19h-1Zm-719,4c3.231,4.179,4.133,9.216,4,17h-1l-1-2Q148,493.5,147,486Zm-6,1,1,2Zm1,3,1,2Zm764,0v0Zm-746,1c1.923,1.392.6,0.1,2,2Zm745,3v0Zm-743,1,1,2Zm-19,2,1,2Zm15,1q12.5,30.5,25,61c13.529,23.176,32.285,46.406,41,73l-4-3c-4.867-18.153-38.793-67.692-51-83,6.241,20.677,20.27,34.382,28,53-9.261-7.859-46.629-65.068-40-82l5,12C159.742,519.38,157.972,510.939,158,498Zm-14,1,1,3h-1v-3Zm718,2q0.5,1.5,1,3h-1v-3Zm32,2v6h-1Q893.5,506,894,503Zm-742,1c0.991,3,.689,2.675-1,5Q151.5,506.5,152,504Zm709,0q0.5,1,1,2Q861.5,505,861,504Zm-694,4,1,2Zm-13,3c3.232,1.509.643,1.972-1,4Zm703,1q0.5,1.5,1,3h-1v-3Zm37,4h2q-1,4.5-2,9h-1Q893.5,520.5,894,516Zm-6,4q0.5,1.5,1,3h-1v-3Zm-716,2c1.923,1.392.6,0.1,2,2Zm679,0c2.618,7.463-6.533,20.488-11,25v-3Zm48,0q-0.5,12.5-1,25C897.4,533.339,895.833,534.518,899,522Zm-725,4q0.5,1,1,2Q174.5,527,174,526Zm681,0q0.5,1,1,2Q855.5,527,855,526Zm-702,3c24.5,35.588,33.129,85.094,64,114l-2-6c14.714,10.534,37.086,32.509,45,49l-27-22c9.1,14.009,25.082,27.892,40,36-3.065-4.422-3.827-3.222-4-9h1c12.825,6.622,19.542,19.651,31,27,7.557,4.847,22.064,4.453,31,16l-25-13,5,6c18.958,7.97,38.941,21.822,59,30,8.066,3.289,17.392,2.523,23,8-124.878-24.359-235.208-50.856-246-189Q150.5,552.5,153,529Zm729,4c1.485,4.349-.966,10.125-4,13Zm5,3q0.5,1.5,1,3h-1v-3Zm-738,1q0.5,1,1,2Q149.5,538,149,537Zm5,0v0Zm-11,3c-1.387,9.5-7.531,23.042-1,31Q142.5,555.5,143,540Zm14,3,2,3Zm726,1c1.8,5.547-3.245,14.554-7,18Zm-6,2q0.5,1,1,2Q877.5,547,877,546Zm-43,4c3.668,11.966-12.67,22.632-18,30-16.85,23.3-39.478,59.582-69,69C771.77,613.544,817.126,592.416,834,550Zm40,1c1.54,4.986-2.326,11.089-6,14Zm12,1c8.239,11.378-10.842,47.718-15,56-23.4,46.615-53.922,77.942-108,94-6.089,1.808-17.412,6.072-24,4h2l49-33C822.336,649.411,872.284,592.519,886,552Zm-748,1v0Zm733,15q0.5,1,1,2Q871.5,569,871,568Zm-7,1q0.5,1,1,2Q864.5,570,864,569Zm6,1q0.5,1,1,2Q870.5,571,870,570Zm-7,1c0.284,3.462-1.635,7.314-5,10Q860.5,576,863,571Zm-723,2,2,5Zm32,0q1,2,2,4Q173,575,172,573Zm694,3q0.5,1,1,2Q866.5,577,866,576Zm-9,5c-0.22,1.467.414,1-1,3Q856.5,582.5,857,581Zm-715,5v0Zm709,3q0.5,1,1,2Q851.5,590,851,589Zm-1,2c-0.22,1.467.414,1-1,3Q849.5,592.5,850,591Zm6,0c-0.151,3.6-.539,5.19-4,8Zm-8,3q0.5,1,1,2Q848.5,595,848,594Zm-703,2v0Zm-5,1v0Zm57,2,2,3Zm654,0c-0.22,1.467.414,1-1,3Q850.5,600.5,851,599Zm-8,1c1.478,9.01-36.834,49.773-46,54C811.2,635.186,830.868,621.258,843,600Zm-697,1v0Zm53,1q0.5,1,1,2Q199.5,603,199,602Zm587,2c-0.22,1.467.414,1-1,3Q785.5,605.5,786,604Zm-585,1q0.5,1,1,2Q201.5,606,201,605Zm618,0q0.5,1,1,2Q819.5,606,819,605Zm-616,3q0.5,1,1,2Q203.5,609,203,608Zm614,0q0.5,1,1,2Q817.5,609,817,608Zm23,5c-0.471,2.963-1.476,5.361-5,8Q837.5,617,840,613Zm39,0c-2.363,3.612-3.529,4.879-4,11l2-1v-2Q878,617,879,613Zm-735,3v0Zm668,0q0.5,1,1,2Q812.5,617,812,616Zm-666,5c1.8,3.126-.324,2.893,3,2Zm686,1c3.037,0.88.264,1.436-1,3Q831.5,623.5,832,622Zm40,2q-0.5,1.5-1,3l2-2Zm-663,3,5,9-3-2Q210,630.5,209,627Zm551,2c3.037,0.88.264,1.436-1,3Q759.5,630.5,760,629Zm-611,2,2,6,2-2Zm723,3v2C872.977,634.255,872.912,635.78,872,634Zm-53,4c-0.337,6.022-10.05,15.276-17,18Zm48,3-3,6C866.911,644.693,867.71,644.431,867,641Zm-125,3h2l-5,4Zm117,1q-0.5,1-1,2l2-2h-1Zm-2,3-8,10C851.5,656.794,858.49,649,857,648Zm-119,6c0.069,1.8,1.141,1.23-2,3Zm57,0h2c-7.215,9.565-21.4,21.249-33,26Zm-61,3c0.069,1.8,1.141,1.23-2,3Zm-572,1c4.535,9.913,9.74,20.738,18,27Zm635,0h3l-10,11-5,2Zm57,0-4,6C853.044,661.744,854.048,660.751,854,658Zm-131,1,2,1-4,2Zm7,1c0.069,1.8,1.141,1.23-2,3Zm-14,3h4l-2,3-6,2Zm126,2v2C842.977,665.255,842.912,666.78,842,665Zm-120,1h2l-3,2Q721.5,667,722,666Zm-16,4h2l-5,3Zm-393,1,59,32c32.147,13.148,72.3,18.382,110,25,33.723,5.92,111.006-25.087,130-9h-2l-19,12,22-8q-0.5,1-1,2c-18.438,6.859-36.671,17.629-57,24l-49,12c2.9,0.531,4.9-.794,3,2-18.7.749-45.284,9.426-61,0,14.735,1.068,39.521,5.84,49-3C414.828,752.16,349.473,724.52,313,671Zm385,4h0Zm131,1-10,9,13-9h-3Zm-134,1h0Zm79,0h2c-1.83,3.483-.844,2.688-5,4Zm-72,2h2l-3,2Q701.5,680,702,679Zm-12,1h0Zm72,0h0Zm5,2h2q-1,2-2,4l-9,4,4-5Zm-11,1h2q-1,2-2,4l-4,1Zm-69,5h0Zm63,0h2l-3,2Q749.5,689,750,688Zm62,0h2l-3,2Q811.5,689,812,688Zm-8,1h0Zm-618,1,11,13Zm498,0h0Zm118,0h2l-7,4Zm-131,1h0Zm11,0h0Zm55,0,3,1-3,4-19,12C723.708,701.176,732.253,699.037,737,691Zm17,0h2l-3,2Q753.5,692,754,691Zm-3,2h0Zm-85,1h0Zm129,0h0Zm-2,1h0Zm-2,1h0Zm-3,1h3v1c-21.488,6.693-38.824,17.286-68,18q0.5-1,1-2C745.718,713.167,774.436,707.59,788,697Zm-122,3h0Zm-16,2h4q-0.5,1-1,2l-10,3Zm-33,3,15,3-2,1c-3.29,3.945-7,5.629-14,6l-10-5v-1Zm38,1h2l-2,2C653.386,706.818,653.758,707.568,655,706Zm83,2h2l-3,2Q737.5,709,738,708Zm-439,1h0Zm338,0h0Zm-335,2,20,11v1C314.012,721.464,306.57,716.171,302,711Zm343,0h2c-3.5,4.611-7.539,7.234-15,8l2-1Zm8,1,26,5h-2l-11,6,13-4-3,4c-6.887,2.17-18.722,1.659-25,4l17,1q-0.5,1-1,2c-19.228,6.141-94.691,38.847-120,29h2l45-15c12.44-5.327,25.481-16.909,37-21l15,2-7-5h2Zm35,3h4q-0.5,1-1,2C688.1,716.469,686.1,717.794,688,715Zm10,0h2c-3.97,3.809-11.49,5.922-18,7l-2-3v-1l1-1h5l-2,3Zm-485,2h0Zm3,2h0Zm8,2,20,14C239.492,728.8,232.641,722.962,224,721Zm389,1h0Zm66,0h0Zm-57,1c2.769,1.156.525,0.309,0,3l-11,3,2-1Zm81,1h2l-3,2Q702.5,725,703,724Zm-17,5h4l-3,4-8,2q0.5-1,1-2Zm-100,3,2,1Zm16,0h4q-0.5,1-1,2c-5.092,1.184-9,3.939-13,3Zm44,0q-0.5,1-1,2l4-2h-3Zm44,0h2q-1,2-2,4l-12,5,2-3Zm-107,1-2,1v1C583.467,733.617,583.44,735.109,583,733Zm-251,1h0Zm246,1-43,14v1l2,1C547.4,749.083,582.059,735.258,578,735Zm99,0h0Zm-2,1h0Zm-85,2h0Zm39,0h0Zm-42,1h0Zm-2,1h0Zm37,0-5,4,8-3Zm23,0h3l2,2q-0.5,1-1,2C645.681,741.4,645.7,742.131,645,740Zm-62,1h0Zm90,0,2,2-3,3-2-1Zm-413,1h0Zm87,0,10,5C351.184,746.47,349.844,745.18,347,742Zm-85,1,7,1,1,2Zm349,1,2,1Zm32,0h4l-5,2Q642.5,745,643,744Zm-71,1h4q-0.5,1-1,2h-9Zm36,0,2,1Zm48,0h0Zm-384,1,19,7v1C283.839,753.651,275.242,750.491,272,746Zm333,0,2,1Zm35,0h0Zm-3,1h0Zm-19,2h3l-4,2Q617.5,750,618,749Zm-61,1,5,1h-2c-4.426,3.434-16.555,8.469-23,6v-1Zm98,0h2c-1.392,1.923-.1.6-2,2v-2Zm-126,1c-5.2,3.043-10.356,1.969-17,3v1l21-3Zm55,0-6,4,13-3v-1h-7Zm28,1h0Zm-195,1h0Zm187,0h4l-6,3h-1v-2Zm45,0,5,1h-7Zm-353,1c3.651,1.059,2.941.814,5,3l-6-1Zm130,0h0Zm8,1,24,2C442.919,757.325,442.988,761.774,434,755Zm69,0-2,3,5-3h-3Zm89,1c3.635,0.644,3.027.4,5,2l-18,3q0.5-1,1-2Zm19,0h0Zm-181,1,6,1,1,2h-4C429.144,758.231,428.822,760.249,430,757Zm177,0h0Zm-295,1,3,3h-5Zm140,0c4.313,0.208,4.827.262,7,2h-4Zm151,0h4v1l-21,6c-1.191-2.5.64-.984-2-2Zm22,0h0Zm-155,1h3v1C469.883,759.464,472.1,761.365,470,759Zm152,0h0Zm-173,1h0Zm90,0h0Zm80,0h3v1l-25,9q0.5,1,1,2h4l-5,3c-3.88-.406-14.89-0.934-23,4H562l2,3c-18.717-.342-79.636,10.273-96-7C513.086,782.824,586.433,779.953,619,760Zm-94,1,7,1Zm-190,4h0Zm247,0h0Zm-77,1c4.538,0.056,5.747.2,8,2H493Zm71,0,5,1c-17.832,2.124-69.414,16.525-89,6C513.891,773.306,559.275,773.25,576,766Zm-104,4,8,1v1C475.449,772.033,474.105,772.132,472,770Zm16,0h3v1l-4,1Zm-109,4-1,2C379.487,774.33,379.585,776.158,379,774Zm26,3,3,1Zm181,0h3l-3,1v-1Zm-20,3,7,1Z"/>
</svg>';
		} else if ( $svg === '6' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM513,4L309,59l10,57L529,60q-6-28-12-56h-4ZM637,52L236,158v3q4.5,28,9,56L650,109Zm118,49L137,267q4.5,30,9,60h1L774,159l-14-58h-5Zm97,58L75,368l8,62h1L869,220Zm76,66L35,466l8,62L689,355l259-70-17-60h-3Zm-36,98L97,538q4.5,32,9,64L913,386l-16-63h-5ZM840,428L186,604q4.5,33.5,9,67L690,538l123-33c11.517-3.435,39.51-4.569,45-14C854.275,478.836,847.422,433.959,840,428ZM748,546L318,663q5.5,33.5,11,67L767,613q-7.5-33.5-15-67h-4ZM655,667L429,728q6,35.5,12,71l234-64q-7.5-34-15-68h-5Z"/>
</svg>';
		} else if ( $svg === '7' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM674,56V682H973V56H674ZM351,79V705H651V79H351ZM29,102V728H328V102H29Z"/>
</svg>';
		} else if ( $svg === '8' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM495,1c-25.679,12.41-39.258,30.258-58,49l-73,73c-13.354,13.354-38.731,28.992-43,50-5.319,26.176,16.971,37.971,28,49L454,327c10.88,10.88,25.084,35.9,49,32,21.864-3.567,33.964-23.963,47-37l97-97c11.569-11.569,36.65-24.721,31-52-4.406-21.274-76.048-83.048-94-101C564.473,52.474,528.675,1.437,495,1ZM273,220c-46.493,27.9-87.8,81.8-126,120-13.25,13.249-38.679,29.323-44,49-7.01,25.924,15.5,39.5,27,51L236,546c11.151,11.152,25.064,36.309,51,31,19.713-4.036,31.761-23.761,44-36l92-92c12.724-12.724,33.268-25.024,37-46,4.63-26.027-22.351-41.351-34-53l-95-95C314.749,238.749,306.2,219.8,273,220Zm437,0c-44.016,24.39-90.036,83.037-126,119-13.756,13.756-38.368,29.393-44,50-7.158,26.19,15.45,39.45,27,51L673,546c11.18,11.181,24.975,36.321,51,31,19.633-4.014,31.8-23.8,44-36l93-93c12.759-12.758,32.539-24.55,36-46,4.018-24.9-22.586-40.586-34-52l-95-95C751.824,238.824,742.992,219.811,710,220ZM493,438c-45.2,24.016-92.521,84.522-129,121-13.783,13.782-38.564,29.127-43,51-5.355,26.4,17.815,38.815,29,50L457,767c11.172,11.172,23.592,34.395,51,28,17.87-4.169,30.486-24.485,42-36l91-91c12.015-12.015,33.01-24.95,37-44,5.863-27.993-20.118-42.118-32-54l-97-97C533.582,457.582,524.071,437.933,493,438Z"/>
</svg>';
		} else if ( $svg === '9' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM543,99V263H796V99H543ZM224,147V321H523V147H224ZM543,283V440H951V283H543ZM64,341V715H523V341H64ZM543,460V640H832V460H543Z"/>
</svg>';
		} else if ( $svg === '10' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM827,4c-7.76,3.69-15.506,6.272-20,13-12.9,19.311,4.228,47.4,26,45C869.311,58.005,867.965,2.864,827,4ZM637,6c-36.378,17.759-25.768,66.484,12,57C681.024,54.958,676.006,4.437,637,6ZM777,56c-23.382,14.139-39.3,34.3-58,53l-96,96c-15.454,15.305-46.563,30.846-39,62-12.882-6.364-25.347-13.175-42-16l30-30c18.182-41.485-17.879-36.616-11-64,6.142-24.447,63.572-46.491,57-77-1.78-8.265-6.837-13.873-13-18-37.693-25.243-51.155,44.568-82,38-15.649-3.332-20.969-23.805-43-18-16.047,4.228-62.975,58.974-77,73L212,346l-89,89c-8.635,8.633-28.976,20.221-25,40,3.583,17.822,25.629,31.514,44,19,14.373-9.791,51.678-70.676,78-32,20.009,29.4-51.025,82.966-66,98-11.659,11.705-17.271,34.108-1,46,31.966,23.363,79.171-51.363,98-65,16.866-12.216,39.938.056,44,16,5.8,22.771-16.718,34.722-26,44L170,701c-11.538,11.532-44.879,39.165-19,60,23.163,18.649,42.384-6.378,55-19l82-81c8.506-8.509,18.605-26.485,39-22,47.451,10.435-1.944,54.461,15,79,27.494,39.816,53.76-30.963,86-9,33.767,23-34.558,79.442,23,88,20.867,3.1,70.814-57.812,84-71L765,496c13.822-13.82,82.523-70.824,78-93-3.12-15.3-22.977-30.98-42-20l-18,18c-17.139,11.7-39.919.431-44-16-7.084-28.522,60.669-73.844,74-92,9.992-13.607,5.473-34.361-7-42-21.961-13.449-32.4,9.5-48,13-22.954,5.148-25.224-25.5-51-18-16.078,4.677-42.787,37.78-55,50l-18,17-25-29c25.212-1.059,41.066-29.064,55-43L806,99C819.807,76.376,800.949,55.7,777,56Zm94,32c-28.455,15.348-47.987,41.994-70,64l-28,28c-8.221,13.138-1.567,31.249,8,38,8.333,5.88,23.637,5.984,32,0l89-91C911.627,103.913,893.019,87.59,871,88ZM356,96c-23.371,12.64-38.079,32.08-56,50l-81,80c-11.693,11.688-36.829,38.063-13,56,21.369,16.085,40.39-4.387,52-16L385,138C398.435,115.507,377.539,95.851,356,96ZM868,276c1.681,24.7-1.712,10.09-17,18q1,7,2,14l-2,2c-7.849-1.16-11.29-2.5-17,1,2.266,12.69,2.216,18.614-11,13l-5,3c0.453,7.607,2.079,11.167,0,16-8.612-.753-11.321-2.351-17,1q1,7,2,14l-3,2c-7.651-1.14-10.314-2.44-16,1,1.019,6.605,2.608,10.506,0,16l-14-2v1l15,2c3.263-5.951,1.632-8.926,1-18h2c4.818-1.269,10.6,1.4,16-1q-0.5-8-1-16c9.314,0.517,12.016,2.276,18-1q-0.5-8-1-16c8.655,0.83,11.938,2.641,18-1q-1-7.5-2-15h2c4.436-1.043,10.817,1.338,16-1q0.5-1,1-2c-1.764-4.827-2.7-9.063-2-14,9.023,0.632,12.216,2.415,18-1C870.974,286.249,869.713,277.924,868,276ZM792,512c-22.658,13.575-37.954,32.955-56,51l-80,79c-11.685,11.681-35.723,38.216-12,56,20.8,15.592,39.567-4.565,51-16L821,556C836.227,533.552,817.817,511.494,792,512ZM300,687c-2.894,7.3,2.079,14.381-4,19-4.576-1.652-8.588-2.515-13-2l-1,3v15l-16-1-1,3q0.5,7,1,14c-6.22,1.172-12.049-1.651-18,1q1,7.5,2,15l-4,2-10-3-5,3q0.5,8,1,16c-7.565-.64-11.541-2.466-17,0q1,8.5,2,17V772l16,1,2-3q-1-7-2-14h17c1.511-6.738-1.194-12.673,1-18l14,1c1.923-1.392.6-.1,2-2V722l16,1,2-3c-1.048-5.66-2.5-8.986-2-14h15l3-2c-0.665-7.42-2.417-10.6,0-16,5.962,0.87,10.706,3.19,15,0Zm304,12c-7.761,3.293-15.4,4.739-20,11-13.247,18.05-.237,51.566,26,47C644.351,751.021,643.488,698.826,604,699Z"/>
</svg>';
		} else if ( $svg === '11' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM800,442q-0.5-5-1-10h96q0.5-3.5,1-7l-1-1c-33.475.493-93.988,7.747-111-10H896v-1q-0.5-3-1-6l-157-1q-0.5-4.5-1-9H893q-1-3.5-2-7H735l-4-11H886q-0.5-1.5-1-3l-3-4H765c-10.112,0-34.508,3.247-39-3q-0.5-1.5-1-3l4-4H874v-1l-5-6H738v-1l8-9H857v-1l-6-7H755l9-10h1c62.156,0.984,117.1,13.473,138-32,30.043-65.379-41.332-109.758-96-79l59-60c4.144-10.04,12.565-21.728,9-39-5.217-25.275-32.6-52.908-68-40-31.658,11.543-50.731,49.355-76,69,3.272-9.6,10.516-20.29,8-35-5.248-30.679-35.983-63.911-76-48-35.281,14.028-63.122,62.934-93,86,2.724-22.509-13.556-37.769,0-48,3.826-8.239,9.9-15.8,12-26C589.57,38.259,553.772.362,520,6c-56.422,9.42-64.432,60.574-37,105,7.874-.151,10.8,1.455,16,6l-11,11h-1c-1.141-4.932-3.733-7.389-8-6l-5,2v7c4.024,6.811,6.562,2.8,2,10l-6,2c4.811-37.236-24.661-43.2-50-31v-1c-0.172-3.467-1.311-5.035-3-9l-7-1-4,2q-1,4.5-2,9l4,5h7l-4,6c-15.9.906-13.723,14.648-23,22h-1c-1.89-4.6-6.9-8.06-13-5l-6,5c0.038,9.494,2.635,9.743,6,15-8.28.656-9.071,3.674-14,7-0.271-7.042-3.7-10.048-11-13l-2,2c-4.838,1.408-5.142,2.992-8,6,0.2,8.784,7.168,13.288,6,15-6.381-1-8.31,2.06-13,5-1.477-5.517-3.206-7.836-8-10h-7l-6,7v7l7,6c7.392,1.68,10.087-2.514,14-7,0.506,8.62,4.064,9.668,2,15l-9,8q-1-6-2-12l-11-3c-3.2,1.622-4.189,1.849-6,5-3.709,5.415-1.877,8.451,0,14,4.4,1.676,6.831,3.245,12,2l-3,4c-3.7-1.87-7.164-2.028-12-1-5.807,8.937-3.63,19.183-13,25-1.455-6.487-3.2-6.149-8-9a38.685,38.685,0,0,0-11,5l-1,3c1.134,8.482,3.308,9.317,9,13l-1,2c-13.679-1.118-16.6,14.875-24,23-3.894-3.113-4.436-5-11-6l-6,6c0.368,7.248,1.926,7.12,5,11-10.242,13.66-22.21,21.3-36,29,1.824,29.5-12.376,60.082,40,51-9.839,13.648-44.415,51.447-56,43l3-3c3.286-7.849,10.182-17.228,9-29-2.87-28.578-35.43-57.366-68-38-14.088,8.377-29.851,30.691-21,55,2.5,6.862,8.569,11.1,7,17-39.906,18.72-18.21,84.013,13,97,18.56,7.723,41.026-1.876,58,5l-89,89c-3.478,8.39-10.684,18.02-8,32,4.409,22.967,27.692,46.424,58,36,25.428-8.745,40.972-39.343,61-55h1c-8.554,36.412,19.565,72.285,57,49l-22,24c-20.965,33.917,4.664,70,36,75,30.5,4.865,82.044-53.47,95-71,11.332,7.813,21.722,15.735,38,19,11.479,2.3,48-11,48-11l27,28,16,9c-1.89,8.016-7.986,16.693-5,29,4.367,18,29.882,36.189,52,23L662,690c13.676,31.752,61.974,10.667,69-13,5-16.843-4-30.7-11-39l-4-4,23-22v2c51.359,50.026,109.45-7.2,57-60,7.965-3.006,20.952-17.376,26-24-4.52-3.621-2.6-3.578-1-11,11.139,0.633,15.8-.753,19-8H821q-1-5-2-10c14.586,0.559,31.754,2.155,38-6v-1H814l-9-10c18.731,0.271,51.408,4.7,66-2l3-5H776v-1l8-9h98l4-7v-1H793l2-2,3-8c14.721,0.236,86.912,3.39,93-2q1-2.5,2-5H800ZM355,44q-0.5,2.5-1,5l1,1h5l1-3-1-3h-5Zm23,4-3,3c0.859,4.526-.116,2.975,3,5l3,1,3-4V52C381.509,49.645,382.091,49.3,378,48Zm21,7q-0.5,3.5-1,7l3,1,3,1,3-4-2-5h-6Zm-73,4q-1,3.5-2,7l3,2,6-1V62l-2-3h-5Zm96,1c-1.8,2.968-2.162,4.986-1,9,4.513-.215,5.391-0.708,8-2V66q-0.5-2.5-1-5Zm-72,3c-2.133,1.786-2.433,1.352-4,4-0.586,4.112-.925,4.667,3,7,3.058-.016,3.858-0.217,7-2-0.215-4.513-.708-5.391-2-8Zm96,3-3,4-1,3,4,3h4l2-2C451.527,67.339,451.093,67.889,446,66ZM212,68c-22.514,8.526-36.661,10.189-48,29-29.886,49.58,17.569,87.529,64,89,7.026-8.27,25.369-10.424,31-17C294.4,127.659,261.238,70.425,212,68Zm160,1-4,3q-0.5,2.5-1,5l5,5,6-1c1.577-3.724,1.815-5.465,1-10Zm-72,5-5,3c0.215,4.513.708,5.391,2,8,4.513-.215,5.391-0.708,8-2l1-3q-0.5-2-1-4Zm94,0-5,4c0.3,5.588,1.019,5.838,3,9l3,1,5-1,1-3V78C398.9,74.78,398.794,74.761,394,74Zm-74,5-4,3q1,4.5,2,9l6,1,5-5-4-8h-5Zm96,2-3,4c-1.668,4.47-.013,5.881,2,9h1c5.588-.3,5.838-1.019,9-3V90c-0.3-5.588-1.019-5.838-3-9h-6Zm-72,3c-2.3,2-3.345,2.088-5,5v8l5,3c7.049-1.29,8.893-4.682,8-11Zm93,3-3,4c0.611,5.766,1.624,5.628,4,9h5l4-4c-0.3-5.588-1.019-5.838-3-9h-7Zm-73,3c-5.276,4.984-6.289,10.109,0,15,5.988-.126,6.706-0.935,10-3l1-3c-0.714-5.262-1.809-5.761-4-9h-7Zm98,3-4,3q-0.5,2.5-1,5l5,5,6-1c2.269-5.225,1.759-6.664-1-11ZM291,95l-4,5c0.611,5.766,1.624,5.628,4,9h5l4-4q-0.5-4-1-8l-3-1Zm96,1c-11.137,10.048,3.81,21.567,12,9q-2.5-4.5-5-9h-7Zm-74,5-3,4c-2.2,5.47.519,7.644,3,11h1l8-1,1-3v-9l-3-1Zm24,4-6,4c-1.909,8.666,4.573,18.751,13,12C351.477,115.009,344.775,105.768,337,105Zm20,7-4,5c0.007,7.341,1.254,8.118,4,12h1c7.341-.007,8.118-1.254,12-4v-1c-0.007-7.341-1.254-8.118-4-12h-9Zm-72,5-5,7v3c3.318,3.5,3.663,5.059,10,6l6-7q-0.5-3-1-6C291.453,118.206,290.644,117.39,285,117Zm95,0c-3.261,2.94-6.42,5.135-5,10l3,7,9,1,6-6c-0.5-5.635-1.79-7.584-4-11Zm-72,4c-2.3,2-3.345,2.088-5,5-1.653,2.471-2.257,3.869-1,7l5,6,6-1c4.562-2.094,5.459-3.863,6-10C315.39,124.341,313.6,123.076,308,121Zm23,6c-5.523,4.047-11.947,11.911-3,17,4.666,4.141,8.392,2.151,13-1q1-4,2-8C339.365,130.584,338.369,128.033,331,127Zm20,6c-4.8,4.551-9.515,12.337-1,17,3.048,2.46,6.683,2,11,1l4-7q-0.5-3-1-6-2.5-2.5-5-5h-8Zm-72,5-5,4v8c1.9,3.761,3.355,4.134,7,6l8-4C290.539,143.056,288.4,138.727,279,138Zm23,6c-2.3,2-3.345,2.088-5,5-1.685,2.1-1.549,1.975-2,6,2.514,5.2,3.907,7.192,11,8,3.2-1.622,4.189-1.849,6-5,1.75-2.188,1.753-2.686,2-7-1.916-3.006-2.61-4.286-6-6Zm20,5-5,6q0.5,4,1,8l5,6,7-1,6-5c0.115-7.729-1.153-8.972-4-13l-2-1h-8Zm-50,12-5,6q0.5,3,1,6l5,6,6-1,6-5c-0.211-7.643-1.907-7.9-5-12h-8Zm27,4-7,2-3,5q-0.5,3-1,6c1.83,3.018,2.743,4.306,6,6l8,1,4-5q1-3.5,2-7C305.374,168.915,303.475,167.3,299,165Zm-54,13c-3.261,2.94-6.42,5.135-5,10,2.534,10.58,12.394,6.613,16,0-0.875-6.343-2.54-6.7-6-10h-5Zm23,4c-7.539,4.969-9.744,9.73-4,18,8.267,1.35,11.636.162,15-6C278.339,185.9,275.512,183.247,268,182Zm22,6-7,5q0.5,5,1,10l2,4,8,2c8.234-4.9,10.357-11.556,4-20Zm-97,4c-1.179,2.752-1.66,2.2-1,5q0.5,2,1,4l7-1v-6q-0.5-1-1-2h-6Zm23,4-4,5,3,8,10-2q0.5-1.5,1-3l-4-8h-6Zm22,4-6,8c2.35,5.3,3.755,6.6,9,9l8-5v-5C246.449,202.051,245.363,200.4,238,200Zm24,5-6,4q-1,4-2,8c2.983,3.362,5.466,5.151,9,8l9-4q1-4,2-8l-4-6Zm19,6c-4.292,4.145-5.748,7.222-4,15l3,2c6.49,5.446,12.675-.129,16-4-0.113-7.856-1.886-8.778-5-13H281Zm-93,4q-1,3.5-2,7l2,2,6-1q0.5-2.5,1-5l-2-3h-5Zm22,3-3,4c-1.668,4.47-.013,5.881,2,9h1c5.588-.3,5.838-1.019,9-3-0.368-6.386-1.482-6.435-4-10h-5Zm21,6-3,4c-0.008,6.328.857,7.582,3,11,6.845,0.112,8.887-.7,12-4,0.008-6.328-.857-7.582-3-11h-9Zm26,3a39.4,39.4,0,0,0-9,7q0.5,3,1,6l5,6c8.976-.074,10.363-2.868,13-9q-2.5-4.5-5-9Zm-76,11q-0.5,3-1,6l1,1h5l2-3q-0.5-2-1-4h-6Zm24,3-4,3q-0.5,2.5-1,5l3,4,6,1,5-6-3-6Zm20,5-4,5c0.4,5.806,1.047,6.872,5,9h8l1-3c2.246-4.264,1.842-7.978-3-10Zm24,5-6,6q0.5,3,1,6c1.616,3.416,1.628,3.346,5,5l5,1c2.3-2,3.345-2.088,5-5l2-6C257.356,253.409,257.387,251.339,249,251Zm-73,10c-0.738,3.706-.467,3.89,1,7h3l2-4-2-3h-4Zm22,3-3,4q1,3.5,2,7c5.588-.3,5.838-1.019,9-3-0.636-5.052-.479-4.957-4-7Zm24,5c-4.78,3.526-6.269,4.9-5,12l6,3c4.932-2.221,5.732-3.119,8-8l-3-6Zm-29,19-3,5,1,3,2,1h4l2-2v-4l-3-2Zm23,3c-1.723,1.61-2.59,1.875-4,4-2.48,4.174-1.291,5.06,1,9l5,1,5-4q-0.5-3.5-1-7ZM822,649c-27.1,9.969-43.784,12.026-54,38-16.384,41.655,20.135,87.331,65,78C900.363,750.99,896.755,661.4,822,649Z"/>
</svg>';
		} else if ( $svg === '12' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM382,2L299,3l64,118,1-2L428,3V2H382Zm62,4L350,179H539v-1Q491.506,92.008,444,6ZM620,80L445,401l350-1v-1Q707.51,239.516,620,80ZM494,192l-179,2L428,399v-2L540,193v-1H494Zm-202,2L125,500l334-1v-1Zm453,88,64,118,2-1,63-116v-1H745ZM433,414L545,620l2-1q55.494-102.49,111-205H433Zm229,20L561,622l204-1v-1ZM319,513l-116,2L332,751h1L462,513H319Zm151,15L406,646H535v-1ZM639,633l65,118v-2l64-116H639Zm10,47q-32.5,59.495-65,119l129-1v-1Z"/>
</svg>';
		} else if ( $svg === '13' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM387,2q-0.5,17-1,34c12.81-6.172,17.467-5.711,30-2-0.07-7.685.893-9.452,6-12l-3,10,9-1c-3.378-7.538-6.67-9.856-12-15l6-6L409,5l3,10Zm89,1-9,21h13l-9,10v1l16,5C483.345,24.23,483.843,13.608,476,3Zm88,9-8,5,4,4-19,5,4,4,11,16h2l14-27-8,1V12Zm62,4L611,34l27,8ZM357,28q-1,8-2,16l13-9Zm247,5-15,4,1,2,15,10,3-16h-4ZM335,34l-17,7,13,13,4,5C335.628,51.726,339.005,38.386,335,34Zm111,6q1,12,2,24l27-15Zm-40,1-6,10h2l12,4Zm70,7c1.51,5.469,2.546,7.012,1,11l-7,4,1,2c9.414,0.642,10.28,2.824,14,9l5-5a22.252,22.252,0,0,0,11-11ZM371,158l-15,3q1-3.5,2-7c-6.306,2.5-16.37,4.669-22,0v-1l22-12-36-12v1c1.994,6.134,2.817,14.724,1,19h-8v3q2.5,7,5,14l10-7c0.928,8.522-3.923,24.455,0,29-3.485,6.771-8.092,9.145-8,14-6.847-4.153-9.726-7.886-12-14-4.672,1.259-3.339,1.224-8-1l-3,6-2-1-2-6-2,1q-0.5,2.5-1,5l-5-4q-0.5,4-1,8l5-1-3,9h-2l-2-6q-2.5,4.5-5,9c3.493,3.938,2.319,7.249,1,14H269l4-24-22,6,17,21c2.323-3.343,6.787,1.2,8,7l-6,2-6-7v2c-2.124,3.96.394,11.358,2,18h-1c-6.249-2.81-5.7-1.369-11-5l-11-14,10-3c-2.734-4.977-6.714-9.579-12-12q-0.5,11-1,22c-11.761-2.453-15.423-5.363-29-8q4,8,8,16l-11,5-20-20h-1c0.56,13.195-1.082,17.9-7,24,5.749,2.023,4.522,2.925,7,8l5-1c-2.291,2.972-2.4,2.311-3,5l4,2-1,2-7,5,5,1c-3.332,5.327-9.62,8.873-16,11l2,3c4.416,1.978,4.434,1.662,4,6,7.635-.8,9.371,3.378,16,6q1-5.5,2-11l8-2,6,13-4,3c3.114,1.334,3.253,1.377,5,4l-12-1-7,10,1,2,9,1c-0.43-5.613-.794-4.417,2-8l8,7,5,7-2,3h-8l4,9c1.255-.275,12.412,1.118,16,4v1a47.173,47.173,0,0,1-19-3l3,11-5-2-3,15c7.672-.275,11.189-1.588,15-2v8c5.037-1.848,8.787-2,13,0l3,5v2l-5,2-6-7c-19.544,15.428-22.051-8.477-32-22-7.577,8.555-8.284,7.291-21,12l4,10-8,1,2,2,7,13-3,2c8.358,0.446,11.849.622,17,4q0.5-3.5,1-7l-9,1q-1-2.5-2-5l7-11,18,4q1,4,2,8l-8,5h2l20,8h-2l-10,6,1,2c9.529,1.009,16.184,4.061,18,13-5.3,3.923-7.5,4.711-14,8l1,2,5,3q1-2.5,2-5l20,6q-1-6-2-12c4.66-.981,3.37-2.951,7-7,3.392,3.244,3.464.23,7,4-2.068,2.832-1.485,1.232-2,4l13,9-5,5c-2.315,4.209-9.178,6.947-15,9v-8l-4,2-3,1,2,4h-1l-10-2c0.682,4.986.777,6.3-1,10h-3l-13-14c-4.008,15.631-16.839,33.38-32,34l-6-2v-1q1-5.5,2-11l7,2q-2-11-4-22l-3,2c-4,9.543-9.382,11.039-18,16l16,19-3,7c6.2-.391,7.967-0.835,12,1q1,2.5,2,5l3-2,4-8c3.666,1.1,3.389,1.552,7,1l4-10c4.475,1.879,4.575.7,9-2q0.5,2.5,1,5l2-2,32-20v1l-7,12c4.014,1.027,2.077.1,4,5l-5-2-3,10,7-3,2,1q0.5,5.5,1,11h-3c-1.334-3.114-1.377-3.253-4-5v9l-6-1v-3q1-3.5,2-7l-20,4v1l9,14h-3l-11-3q0.5-3.5,1-7l-10,6q2,12,4,24c6.295-6.874,10.737-15.031,22-17l13,5c-0.468,7.866,11.588,11.252,11,21,8.213-1.6,19.625,7.2,24,13v1l-7,6,8,4-4,16h-2c-2.68-12.329-1.916-15.991-7-25-7.588,4.557-11.864.973-22-2l4,12c-3.383.512-2.332-.354-5,3l-7-5-3,13,5-1-9,13,35,7-2-3-12-22,22,10-3,8c3.837,1.413,2.533,1.849,7,3,10.4-3.409,18.716-2.657,25,4l-4,13-24-4,17,31-13,6,3,4,11,9-5,2,8,13h2q2.5-11,5-22l12,2v-1c-1.928-4.926-4.751-13.709-2-20l1,2,6,10c-3.438,2.711.3,4.65,0,11l-14,4,8,8,3-5a84.634,84.634,0,0,0,38,11l-4,12,25,1q1,6.5,2,13l-5-2q-2,9.5-4,19l-10-5q-0.5,12-1,24l27-9-15-10v-1l16-8-3-4c-3.13-1.613-2.354-.913-4-4l9-6v-1c-9.237-2.981-13.54-8.049-17-17l6,3c1.334-3.114,1.377-3.253,4-5,0.356,6.632,1.23,3.944,0,9,9.149-.085,24.462-6.458,33-5q0.5,7,1,14l-5,1q1-4,2-8c-6.407.533-11.3-1.452-13-1l-9,22c17.84-.5,21.646,5.051,32,11l3-19c4.054,1.37,2.957.985,5,4l-2,3,31-5q-2.5-4.5-5-9l11,4-3,9c13.261,0.008,32.042,6.774,36,17l1-2,3-11c-4.371-.527-3.4.322-6-4l16,5v-7l6,6-3,12h1l8-4v1q-1,4-2,8c4.969-3.112,7.679-4.059,15-3q-1,4-2,8c7.8-2.476,6.594-3.441,11,3l11-11,6-2c-1.036-4.427-.985-2.583,2-7l14,13c1.682,3.631,3.464,5.258,7,7l4-7c2.38,2.082-.16.874,3,1,5.079-16.057,15.722-17.952,38-17l-6-6-5-7q4-11.5,8-23l-7-1c2.965-2.676,5.952-3.108,12-3v1c-2.216,5.558-.187,4.248-5,11h2l22,1c-0.656,6.1-2.143,12.551-8,14l8,17,7-5,3,6h1q2.5-7.5,5-15l10-1c-3.855-6.111-3.624-7.288-1-14-4.552.561-5.017,1.259-8-1q0.5-1,1-2l13,2q-0.5,2-1,4c7.816-.989,11.534-1.658,19,0q2.5,5.5,5,11v-2l8-6v-1l-1-1c-7.741.413-9.46,0.022-11-6l8-1-2-2-13-16c-3.906,2.563-.579,2.189-5,1q-0.5-1-1-2,0.5-1,1-2l12-4-11-8,6-3-7-7h-1q-0.5,5-1,10c-3.327-1.381-1.96-1.264-6-1,0.9-11.532,4.657-15.442,11-21l-4-6-5,5q0.5-4,1-8l-12,6V587l18-3q0.5,2.5,1,5l8-3-5-5v-1h7c1.358,11.1,4.347,13.348,2,24h1l14-3q-0.5,4-1,8h6l-17,12h2l11,7q-0.5,1-1,2l-10,4,4,5,8,6q0.5-7.5,1-15l13,7v-2c6.816-12.376,5.549-31.2,9-37-9.876-1.041-15.04-4.269-20-10q-1,2-2,4l-2-2c-6.439-3.257-2.187-4.578-5-9-2.546.267-9.419,0.626-12-2,6.275,0.218,13.868.594,16-1q-0.5-2.5-1-5l20,18q-1,2-2,4l15,1q-0.5,2.5-1,5h17c-0.012-5.206,4.582.435,10,2q1-11,2-22l-10,2v-1l12-21h1q1,3.5,2,7l2-1c3-8.031,7.1-7.744,12-14-3.575-4.177-1.886-5.685,1-11h-2l-26-1v-4l-6,2c4.037,6.624,2.878,8.274-4,13h-1q-0.5-7.5-1-15l1-1,10-1v-1l-8-7q0.5-1,1-2l17,10h1c1.7-10.925,7.886-12.076,1-18q-0.5-1-1-2l3-14h-1l-29,14c1.864,3.923,1.58,5.511,1,11-4.023-1.141-3.827-1.374-6-4,2.252-8.232.073-8.993,1-17l10-6q-2.5-2.5-5-5l4-3h3l3,11,4-4,13-10c-6.587-2.026-8.543-4.533-15-8v-4q0.5-1,1-2c5.274,2.153,2.628,2.366,4,6l9-2-2-3c-3.593-2.4-3.373-5.829-3-12-4.739,1.729-4.928,2.494-8-1,2.119-2.991-.87-8.078-3-13h3c2.97,0.971,1.823-.932,8-2l-5,9,15-3v6l-4,17,10-2q-0.5,1-1,2l-6,3v6c7.931,0.721,22.894,12.484,29,17h1q1-3.5,2-7l6,3q0.5-6.5,1-13l-10,3q-0.5-7-1-14l7,2h1v-1c-5.073-13.917-9.792-30.971-20-40l4-7c-4.383.62-5.32,1.648-8-1a54.322,54.322,0,0,1-13-17v-1c15.852,0.064,26.076,4.822,35,17q0.5-1,1-2c4.938-4.035,11.035-11.236,13-18-8.823-.784-16.144-5.116-21-6,2.368-6.815,1.3-8.908,1-13,3.787-2.714,3.659-1.28,6-7-2.32-2.65-1.3-1.465-1-6l-9,3,2-3,12-22-12,2v-1c2.89-6.155,9.068-14.067,3-14-6.137-4.092-4.249,4.407-14,2-10.208-2.52-27.517-10.7-34-18,16.607,0.6,23.734,8.458,40,10q-0.5-3-1-6c0.9-.534-1.734-12.809-4-17l-10,11-3-17-2,1-4,5h-1q-1-3-2-6l-9,8-6-4-6,10v-9l20-11-2-3-12-8c-2.763,3.06-.419,2.7-4,1-2.042-1.8-.707-0.015-2-3,7.651-.858,10.1,1.348,17,3,0.776-6.771,2.919-7.024,6-11-5.582-1.383-5.819-1.021-6-8l5-1q-0.5,2.5-1,5l11,7c-0.973,2.613-1.622,4.261,1,8l8-4q2-14.5,4-29l-17,11-7-7-2,1c-0.85,5.693-8.372,12.273-15,14l-1-1c0.919-8.689.259-4.085,0-14l-8,7-3-2q-1-2-2-4l2-2,6-10h7l-3,7c8.062-.666,7.95.206,13,4l3-6h1l3,5,2-1,3-5c-4.309-1.6-4.814.381-8-3l6-13v-1c-8.086,1.567-15.47,6.347-23,5l-4-6v2l-8,10-5-3V232l5,4c1.022-12.238,6.253-18.47,16-22q-0.5-1-1-2l-13-3c0.072,5.14,1.347,3.337-3,6h-1v-5c4.063-13.2,4.615-14.868,5-27-13.551,4.1-27.163,1.192-30,12,3.1-1.148,2.972-1.407,6-1q1,2,2,4l-4,4c-5.967-1.766-6.406-4.764-10-4-4.663,1.663-3.2,3.051-7,1-3.083-2.836-2.568-6-5-9l4-3,9,6h1c-0.253-12.014-1.869-12.809-2-23l2,1,3,6h1l4-10,2,2c2.467,2.77.986,5.6,2,9l11-3a19.753,19.753,0,0,1,2-14c4.99-.27,9.51-1.172,12-4-9.4-3.81-14.221-11.645-21-18v2c-1.916,4.557-1.628,11.822-5,15,1.558-11.128.143-19.211-3-35l-11,9-6-7-7,16c4.783-.241,3.715-0.727,7,1l-5,6,12,4q-0.5,1-1,2l-11,5v-5l-7,8c2.451,2.535,1.218.542,2,3h-2c-3.716,1.132-5.636-.322-9-2-0.379,3.72-.053,7.492-3,6,2.456,8.834,5.329,12.245,7,22h-1l-5-7-2,1c-1.918,3.7-3.5,4.819-8,6q-1-3.5-2-7-0.5-8-1-16h1l2,5,2-1,3-6-10-2q-0.5-5.5-1-11l2,1q0.5,2,1,4h1q1-4,2-8l-7,1q0.5-3,1-6l2-1,18,12,2-1q2.5-13.5,5-27l-23,13q2.5-5,5-10l-1-1c-20.965.27-31.8-15.415-46-25-3.535,3.92-9.54,4.487-17,2,1.524,6.893,1.513,18.873-6,25l3-14a29.871,29.871,0,0,1-15,1c-0.03-3.385.6-3.178-2-6h-5l-5-12-2,1c-2.34,6.8-4.119,5.2-9,7,0.935,3.891.53,4.854-1,8l-3-1-6-4,5-1c-2.7-5.888-5.2-7.949-5-12l22-4-2-3L562,78h-1l-3,17-8,1V89c2.508-10.44,3.631-16.975,7-24H543c0.771,3.232,2.873,2.179,0,4-12.611,10.484-26.313-6.077-37-7l-2,1,4,9c2.811-1.774,1.7-1.459,4-2q2.5,12.5,5,25c7.356-3.238,12.752-2.292,16,1l6-5,5,5v1c-4.822,1.322-2.883.661-4,3l4,3q-0.5,3-1,6c-8.116-1.614-12.266-6.1-18-10q1,10,2,20l-11-5c0.169-8.88,1.781-5.971,7-11-8.91-10.293-13.215-15.1-17-32l-3,2L492,91l19,3q0.5,2.5,1,5l-22,14c-2.156-1.214-3.111-.617-6-2l3-3c-7.7-2.98-8.618-5.469-15-8q0.5-4,1-8,0.5,3,1,6a45.6,45.6,0,0,0,16-12l-13-9q0.5,5.5,1,11c-5.761-3.166-8.036-9.269-10-16h-1v2l-8,15-1-3c-3.3-3.268-1.928-11.155-1-16l-20,8,12,13-5,2c-6.02-3.256-15.064-6.474-19-6q-1-9-2-18l-11,7L399,64l-2,5h-1L384,49v2l-9,28,19-2-4,8c5.956-2.525,17.043-7.356,22-4l12,7v2a13.9,13.9,0,0,0-8,8l11,4-1,2-12,9-21-9v1l3,11-8-3,1,5c-9.76-1.612-12.173-2.437-23-3v4l-6-2v4q0.5,3.5,1,7l7-3,2,2v1l-13,5,17,19-4-1Q370.5,154.5,371,158ZM303,51l-9,16,23,3-1-3ZM606,65c0.149,5.673,1.28,11.772,4,15V78l8-10V67ZM364,70l-6,11h1l12-3-3-3Zm269,1q2.5,7,5,14l6-5-4,11,17-6-7-6C647.168,74.645,639.307,73.668,633,71Zm95,2L713,89l18,6C730.782,89.687,731.039,76.208,728,73Zm-53,2,6,15,9-9V80ZM379,82l-20,3,4,20h1l5-3q2.5,4.5,5,9l3-4c1.482,4.916.31,3.518,6,4l2-1v-1c-6.249-8.6-4.687-13.91-2-27h-4Zm-51,8,4,13h1v-2q2.5-5.5,5-11H328Zm293,2-8,5,2,3,6,3h1C622.489,97.571,623.631,94.833,621,92ZM405,95l-6,2c-0.531,3.692-3.047,2.275,0,4l6,5V95ZM293,99q4.5,17.5,9,35l-12-4c-3.354,4.069-1.458,3.312-9,3l4,17,4-2v5h-3c-10.7-3.088-16.151-6.01-24-11v2q-0.5,4-1,8l7-1,7,25c14.911-10.151,31.493-19.722,43-35l-13-6,21-19Zm433,5-11,3,6,9h2l6-12h-3ZM348,117l-9,8c5.583,1.176,9.45,3.447,12-1Zm426,3q-1,12-2,24h-1l-14-4q1.5,9,3,18l4-2,15-10c-3.894-2.2-2.724.164-2-4l16-12v-1Zm-131,5c4.295,3.38,4.412,9.953,7,15h1l6-11,2,1c1.229,5.629,3.274,9.362,1,13-2.063,5.032-5.372,9.344-11,11q1-3.5,2-7c-5.164.24-4.514,0.725-8-1q-0.5-1-1-2l3-5c-8.149-1.1-11.241-3.362-14-10v-1h2Zm-394,2-16,2,11,12,2-1C247.237,134.888,250.109,131.3,249,127Zm-55,11q-1,10.5-2,21l23-8v-1Zm42,12-24,22c20.022,4.258,34.343,19.036,55,23,0.032-4.065-1.4-3.863,5-4-2.2-5.674-2.82-4.295,0-9-4.294-4.271-8.05-7.208-12-12-2.535,2.451-.542,1.218-3,2-1.907-3.79-.428-2.055-3-3-2.024,4.726-7.076,9.278-10,10Q240,164.5,236,150Zm-20,7-8,4,6,5q0.5-1,1-2Q215.5,160.5,216,157Zm552,1q1,4.5,2,9l10-6Zm-458,1c-2.973,6.66-7.586,8.859-13,13,5.733,7.941,12.4,9.412,23,15v-8l7-2-8-9-4,2q1-4,2-8l-5,1Zm542,14-23,28v1l29,7Q855,191,852,173Zm-76,6-9,23h1l23-8Zm-574,1c-5.735,11.774-16.527,25.028-9,41l13-16-11-3,20-7Zm618,15-15,12v1l13,7h1Q819.5,205,820,195Zm-30,16-14,9q0.5,1,1,2l17,4Q792,218.5,790,211Zm-31,17-6,1,5,5h1v-6Zm-534,5c2.383,2.364,2.491,6.745,4,10l9-6v1l-3,8,13,1v8c4.6-1.07,3.4,1.05,8,1l3-6,2,1c0.923,7.279,2.391,6.054,5,9l-2,2-11-1c2.855,4.763,8.266,10.235,6,14l-2-2-10-6h-1q-1,8-2,16c8.223-1.558,12.748-3.825,20-2v1h-2l-16,10-2-1c-1.642-5.466-3.968-7.17-8-10-1.523,5.034-1.716,4.851-8,5-3.016-6.689-8.516,2.761-18-1h2l2-2q-2.5-4-5-8c3.06,1.62,3.152,2.053,6,2A132.744,132.744,0,0,1,225,233Zm14,14-16,15c7.106,2.169,9.908,5.9,12,13l2-1C238.6,268.367,244.055,252.39,239,247Zm594,6q2.5,5.5,5,11l3-2,7-9H833ZM144,264q1.5,17,3,34l24-25Zm682,3-17,11,16,13v1l-11,4,4,5,19,15c3.785-15.508,9.833-11.876,20-20-6.881-7.4-9.249-13.346-17-19-1.343,8-2.806,9.929-10,12C829.747,282.86,829.449,270.52,826,267Zm-28,19q1,4,2,8l8-5v-1Zm-628,7-36,11,22,23,13-27h1l5,15,3-3,12-9-1-2-20-2C170.385,295.791,172.656,294.686,170,293Zm692,3-5,7v1l11,3C867.149,301.982,865.5,298.394,862,296Zm-45,11q-2.5,5.5-5,11l10,1-3-12h-2Zm-631,4-7,4,1,2,8,6C188.3,317.883,188.39,313.389,186,311Zm680,10-39,3c6.88,12.009,12.285,29.426,22,37l3-10h-7l3-3C852.126,339.147,866.174,329.623,866,321Zm-666,3-8,3,1,2,10,5V324h-3Zm-26,7-3,15,18-4Zm653,8-6,8h11C831.069,342.336,830.322,341.141,827,339Zm-707,3,13,31,4-3,14-17v-1ZM87,357l12,32,5-4,14-16v-1Zm792,3-15,19h25C887.817,372.861,883.533,363.163,879,360Zm-40,1c-4.034,7.233-10.088,22.84-19,25,1.231,3.014,1.3,1.83,1,5l36-6-2-2Zm-16,1q-2.5,5.5-5,11l13-3v-1l-3-2C826.384,363.584,826.372,363.654,823,362ZM121,372l-9,22,29,1-2-2Zm-1,26-12,27,35,1v-1l-6-6Zm41,5-13,15,22,1C167.84,413.661,165.814,405.892,161,403Zm14,3-3,10h1l9-4Zm675,6-5,12h10l-3-12h-2ZM168,426q-0.5,6-1,12l10-8h-2Zm32,0-6,12,13-2v-1Zm605,2v14l14-5c-1.431,12.115,7.1,21.326,10,35l-13,7,2,1,8,6h1l3-12c4.549,3.613,1.613,3.8,7,1q2.5-4,5-8l-12-4v-1l9-22C829.683,441.486,813.427,432.321,805,428ZM199,439l-12,5v1h2l12,6C201.3,445.883,201.39,441.389,199,439Zm681,7q-0.5,15-1,30l34-13Zm-731,9c-7.8,7.969-31.245,17.293-31,26h-6l25,31,2-1,12-30c-3.8-.4-1.244,1.124-4-1Q148,467.5,149,455Zm710,32-9,3,2,1,8,6v-2q1-4,2-8h-3Zm-703,8-3,32,24-8-3-3C171.052,509.2,162.529,498.3,156,495Zm635,1q-2.5,6.5-5,13c12.386-3.922,13.271-4.2,6-13h-1Zm41,5-14,27,30-8-5-5Zm-38,11q0.5,6,1,12l-16,8q0.5,1,1,2c4.739,2,7.018,4.8,11,5l3-14h1v9l24-12Zm-554,2q-1,4.5-2,9c-5.977,1.459-8.9.817-10,5l-12-4q0.5,5.5,1,11l13-6,3,6,2-1c2.66-6.334,9.674-11.65,9-15C242.666,515.886,242.623,515.747,240,514Zm-53,5-8,5v2l12,2C189.94,524.3,189.591,521.2,187,519Zm-46,15c-0.646,8.154,7.09,23.87,12,31h1l13-31H141Zm61,9q-1,10-2,20l24-7Zm605,12,13,16-4,8h2l10,1q-0.5-1.5-1-3l-4-4,7-16q-0.5-1-1-2H807Zm-55,8c6.135,2.483,9.245,14.515,10,22l-4,1h-1q-1-2-2-4c-1.749,4.81-2.623,4.944-7,7l-2-1-4-11c-1.61,1.723-1.875,2.59-4,4q2.5-7.5,5-15c4.919,0.141,7.568-.058,10-2Zm24,6,4,25,26-17ZM334,580c12.932,0.859,17,11.082,25,15q0.5-4.5,1-9l4,2q-1,4-2,8l7-1v4l-5,3,9,7c0.7,7.571,4.218,16.227-1,20l-10,2v-1a46.655,46.655,0,0,0,6-18c-5.265.717-6.449,2.033-9,0-3.2-4.684-4.272-7.523-1-11l1-3c-9.534-3.489-10.543-9.32-16-3,3.314,2.018,3.181,2.449,4,7l-4,1c-1.577-2.741.073-1.744-3-1a96.475,96.475,0,0,1-31,8v-5c2.835-1.975,1.97-1.472,6-1q-1-4-2-8l10,4q-0.5-2.5-1-5l19-4Zm-83,3,4,10q0.5-1,1-2,2.5-2.5,5-5Zm-20,7-7,5,10,9C234.511,597.681,235,592.287,231,590Zm584,6-10,3q0.5,1.5,1,3l9,9h1C816.677,603.966,818.83,598.34,815,596Zm-579,8v29l-7,2,2,3,7,6,2-1c2.312-13.441,19.518-20.5,32-23Zm-49,2-30,9q0.5,1,1,2l29,17q1.5-14,3-28h-3Zm460,8c6.2,2.671,7.885,7.338,8,16,11.482-5.407,7.274,4.5,15,5q-0.5,4-1,8l-2-2-5-9-5,3c-6.24-4.345-6.4-6.036-5-14-9.064.561-8.984,0.9-18,3l3,8-8,13h-1l-4-9h-1c-1.219,5.6-1.362,5.812-8,6-1.541-13.341-10-14.047-17-23C614.862,620.676,632.708,623.061,647,614Zm52,8q0.5,5.5,1,11C708.617,629.362,706.022,626.6,699,622ZM259,632l-7,4,7,7V632Zm484,2q4.5,12.5,9,25l15-15,8-7Zm-285,1,9,11v1c-8,1.454-18,6.629-26,5q-0.5-4-1-8h11c-1.5-3.358-1.478-2.807-1-7Zm277,2-14,11v1l20,12C740.357,654.055,739.341,640.788,735,637Zm-19,24-12,30,39-1-8-8-3-4q4-7.5,8-15l-19,4ZM252,671l-27,5v1l18,30,2-1q2.5-10,5-20l17-2v-1l-7-10-2,1-6,9C253.155,676.7,256.048,673.556,252,671Zm107,3-6,10h3l9-2Zm-61,13-12,3,7,12h-7l2,2,5,6c2.547-9.852,4.578-13.5,10-23h-5Zm168,12,12,14,2-1q2.5-6.5,5-13H466Zm-149,4q2.5,6.5,5,13l6-5,2-4Zm239,0c-5.449,9.961-12.364,15.18-17,25l26,9q-0.5-17-1-34l-6,4Q557,705,556,703Zm38,0,21,24-7,12c6.68-.792,19.445-2.295,24-6-3.61-5.735-8.243-13.236-14-14l6-16H594Zm-106,2,3,14,14-11Zm175,3q2.5,13.5,5,27l2-1,15-21v-1Zm-25,4-4,10,13,1-2-3C643.39,716.02,641.793,713.877,638,712Zm-194,7-5,3,6,7h1C446.546,722.6,447.678,721.359,444,719Zm-39,1-8,4,9,9q0.5-6.5,1-13h-2Zm-57,3-17,11,1,2,31,20,3-15-14,8C351.453,742.6,351.767,727,348,723Zm96,14q-0.5,7-1,14l11-8-1-2Zm64,2-12,4,3,3,8,11C507.78,750.4,510.769,742.47,508,739Zm-94,1-24,9,1,3,22,23q2-17.5,4-35h-3Zm-77,5-34,4,13,14,12,11,2-1C331.3,765.035,340.424,749.4,337,745Zm315,0-14,10q0.5,1,1,2l18,10Q654.5,756,652,745ZM471,755q1,9,2,18c-3.149.735-5.048,1.315-7,3l8,7v-2l27-18Zm107,5q-2.5,10.5-5,21l9-1q0.5,4.5,1,9l15-9C588.231,775.563,585.073,766.9,578,760Zm-60,8q-0.5,9-1,18h1l19-6Zm-17,4-3,10h1l9-4Zm-61,4-19,3,2,2,8,16,5-4,12-17h-8Z"/>
</svg>';
		} else if ( $svg === '14' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM486,10c-13.329,7.823-11.736,38.515-5,50,11.639,2.344,34.98,2.692,45-1,3.216-11,4.236-37.625-1-47ZM301,12l-4,4q0.5,20.5,1,41c10.311,5.008,37.056,4.748,46-1V17l-5-5H301Zm365,0-4,3c-5.732,25.713-6.693,44.971,21,45l20-1,6-5c0.217-13.3.832-29.784-2-40C696.756,10.812,679.414,11.855,666,12ZM397,13c-2.706,1.591-4.117,1.5-6,4-5.037,7.658-2.581,33.455,1,40,10.425,2.251,32.431,3.428,42-3q-0.5-19-1-38C424.686,12.153,409.649,12.793,397,13Zm181,0c-9.115,6.828-9,29.717-5,43,12.8,4.137,28.511,3.666,41,1l1-3c3.944-9.054,1.565-33.741-2-40Zm196,2-16,2-1,3q-0.5,9-1,18c0.059,23.4,16.929,21.844,38,17l1-3V18l-3-1ZM213,16c-5.227,8.031-5.9,29.72-1,39,10.32,2.172,29.609,2.17,37-2,1.853-11.827,2.065-29.288-3-37H213Zm-76,9-8,2-1,3V64l3,1c7.68,3.556,31.609,2.179,35-3V28C156.649,24.26,147.2,27.565,137,25Zm705,0-4,4q0.5,17,1,34l3,1h34l1-3c3.694-8.371,1.25-29.339-2-35ZM388,96l-6,4c-2.613,12.22-4.711,50.794,4,56,6.615,5.988,47.4,2.725,55-2,3.484-13.663,3.455-40.336,0-54C430.489,93.229,404.9,95.724,388,96Zm182,0c-2.3,2-3.345,2.088-5,5-5.784,8.725-4.045,50.744,3,55,9.292,5.2,39.615,3.28,51,1,10.48-8.256,8.062-49.973,1-60Zm-79,2c-3.406,1.262-9.462,1.09-12,3l-4,3c-0.649,16.561-4.616,37.311,4,50,12.776,2.771,46.081,4.329,51-5V104l-5-4Zm-192,2-4,5c-4.219,8.5-4.381,42.34,3,47,8.478,5.5,40.633,2.987,48-1,3.4-12.775,4.128-40.173-2-50Zm365,0c-5.37,5.123-12.673,46.858-2,53h45l4-5V104l-5-4H664Zm-455,1-5,4c-1.609,14.336-2.813,37.007,3,47,42.79,6.854,57.792-.236,48-46q-2.5-2.5-5-5H209Zm546,0-4,3c-2.716,13.133-2.81,39.428,3,48,10.407,2.258,40.71,4,46-3,5.371-8.264,3.039-39.9-1-47Zm-633,6-3,5c-2.777,9.289-1.548,27.46,2,34,10.32,2.172,29.609,2.17,37-2C162.609,107.144,159.2,105.383,122,107Zm728,0-3,4c-0.483,10.952-2.436,30.363,4,35,9.521,4.218,30.46.852,36-3q-0.5-17-1-34l-3-1ZM474,180c-12.379,8.933-12.19,49.338-8,70,9.069,6.761,64.357,13.035,72,0,7.8-9.616,4.169-52.822,1-65C526.2,176.511,494.76,179.725,474,180Zm-179,4c-3.131,2.555-5.042,3.024-7,7-2.987,9.876-2.35,55.216,3,59,6,4.241,22.577,2,32,2,8.454,0,21.686,1.678,27-2,9.494-6.57,6.074-48.941,3-61C341.343,181.246,314.3,183.717,295,184Zm91,0c-3.387,2.476-5.04,2.9-7,7-3.322,10.924-4.249,53.754,3,59,9.044,6.545,56.31,3.77,61-3,7.523-11.062,3.567-48.287,0-60C429.023,182.167,404.693,183.85,386,184Zm182,0-6,4c-2.984,10.055-6.743,50.949,0,60,7.112,9.547,53.021,4.28,63,1,5.093-14.194,5.04-47.8,0-62C612.183,181.148,585.823,183.8,568,184Zm92,0-7,4c-2.974,11.189-6.375,50.231,1,59,7.136,10.327,50.824,5.569,62,2,3.283-8.918,3-22.931,3-36C718.986,173.255,696.845,182.941,660,184Zm-451,7c-2.3,2-3.345,2.088-5,5-6.351,11.739-2.685,39.908,2,48,13.236,1.96,38.992,3.282,49-2,3.169-12.339,3.14-35.66,0-48C244.579,189.214,224.1,190.8,209,191Zm546,0c-7.917,7.758-8.085,34.14-5,49l5,4h43l5-5q-0.5-22-1-44l-5-4H755Zm-635,3-5,4c-1.131,15.349-3.646,31.6,3,43,12.584,2.623,35.791,2.381,44-3,0.873-15.211,3.478-31.6-3-43Zm729,0c-2.133,1.786-2.433,1.352-4,4-4.773,7.051-3.719,37.792,2,42,7.874,5.067,33.7,2.437,42,0,3.756-11.2,3.683-36.669-2-45ZM384,267l-11,5c-5.4,17.429-6.589,61.757,2,76,18.071,5.623,62.46,6.458,76-3,4.874-17.062,6.755-60.663-3-75C431.524,265.276,405.141,266.888,384,267Zm181,0-10,5c-4.06,12.63-8.969,67.915,2,76,7.555,5.569,27.663,3,40,3,11.795,0,26.834,1.745,33-4,10.177-6.893,6.34-64.258,2-76C616.773,263.96,586.576,266.817,565,267Zm-92,1-8,4c-4.3,12.983-8.9,67.939,3,75,9.6,8.011,71.248,4.138,75-5,6.435-15.673,3.129-66.978-7-72C523.272,263.067,490.083,267.778,473,268Zm-178,7c-9.376,6.735-13.9,59.1-4,66,8.808,6.139,46.636,3.472,58,1,8.159-11.3,8.386-45.011,4-62C341.343,272.246,314.3,274.717,295,275Zm364,0-6,4c-4.13,13.53-6.645,60.113,6,64h29c32.627,0,31-6.23,31-38,0-9.125,1.22-20.107-3-25C709.512,270.618,674.341,274.593,659,275Zm-452,3-7,4a130.9,130.9,0,0,0,0,54c10.445,6.962,48.484,6.477,59,0,3.477-14.214,4.463-44.86-2-56C244.368,276.091,222.958,277.855,207,278Zm546,0c-11.206,8.284-10.459,42.3-6,59,11.108,5.179,40.659,4.809,55,2l4-6V284l-6-5Zm-625,8-8,2c-1.923,1.392-.6.1-2,2-7.281,10.7-2.515,38.307,6,42,11.022-1.521,24.068,3.414,36-4,2.536-12.079,2.138-33.188-3-41Zm729,0-10,2q-0.5,1.5-1,3c-4.311,9.3-2.4,26.543,0,38,11.706,5.6,26.9,4.273,41,1,4.016-8.6,5.725-32.432-1-43ZM473,354l-13,6c-5.157,16.48-8.979,76.143,5,84,16.507,9.278,77.434.619,81-7,5.523-9.985,2.915-64.546,0-76C525.248,346.347,490.047,357.149,473,354Zm-91,5c-3.493,2.176-5.834,2.315-8,6-6.865,7.9-4.329,68.738,3,73,9.97,8.394,57.169,4.1,70,1,7.771-10.926,12.937-72.278-2-79Zm182,0c-4.219,2.717-6.71,3.192-9,8-6.615,11.443-4.663,65.93,4,71,5.933,4.881,21.484,3,32,3,10.887,0,30.755,2.779,38-2,5.972-3.939,10.3-60.6,5-72C627.773,353.617,583.537,358.379,564,359Zm-272,3-6,3c-8.169,16.709-7.873,55.867,1,71,16.109,4.17,56.231,5.363,69-2,3.444-9.739,3-25.073,3-39C358.993,348.828,335.126,360.889,292,362Zm365,0-8,5c-3.426,11.831-6.752,56.755,1,66,7.639,11.087,62.126,6.233,71,0,4.129-16.372,4.1-49.625,0-66C708.274,358.652,677.609,361.731,657,362ZM207,372l-4,5c-5.93,10.273-2.6,42.23,2,50,13.44,1.986,40.906,3.591,51-2,2.944-10.624,6.028-45.484-3-51C244.347,368.63,219.611,371.756,207,372Zm547,0c-8.163,8.023-8.151,36.721-5,52l5,4c16.446,0.449,36.79,4.34,49-4C814.277,370.435,801.482,370.437,754,372Zm-635,3-5,6c-2.411,7.657-1.574,39.782,4,43,6.225,2.873,39.7,3.466,44-3,4.364-7.7,2.956-31.449,1-41q-2.5-2.5-5-5H119Zm728,0-4,3c-2.458,11.947-2.893,37.227,2,46,13.394,3.024,34.094,5.454,46-2,2.458-11.947,2.893-37.227-2-46ZM386,449l-13,5c-8.382,11.163-4.415,59.14-1,73,8.218,5.912,68.88,11.468,78,2,7.751-8.047,2.808-69.925-2-77C425.33,445.924,403.794,452.082,386,449Zm181,0-11,4c-6.974,14.038-9.628,73.055,5,79,11.9,4.836,66.961,1.636,71-5,8.673-9.173,4.316-65.46-2-75C608.266,445.92,592.912,451.908,567,449Zm-93,1c-4.926,2.686-10.284,4.311-12,10-4.029,13.358-.23,65.388,6,69,10.047,8.586,66.474,2.545,74-3,3.913-16.051,7.29-69.008-6-75Zm-177,7c-4.521,2.454-6.644,2.224-9,7-5.253,18.858-4.144,35.671,0,56,8.328,6.128,56.675,10.691,64,0,6.927-10.222,3.99-45.663,1-58C342.47,454.964,317.394,456.729,297,457Zm363,0-6,3c-4.375,8.946-7.709,56.69,1,63,3.062,2.219,49.058,4.316,56,2,12.865-4.293,9.782-50.062,6-64C703.969,454.905,679.076,456.81,660,457Zm-453,3c-13.795,9.167-10.91,42.215-7,58,7.207,4.9,52.9,9.081,59,0,7.438-11.069,2.037-49.574-3-57Zm547,0c-10.144,6.466-15.318,53.233-4,60,10.142,7.684,49.42,1.839,56-3V465l-6-5H754Zm-629,8-8,4c-2.085,9.364-3.718,35.529,3,40,7.16,4.341,34.718,3.836,39-2,4.982-7.567,2.677-33.6-1-40Zm742,0-20,2q-0.5,1.5-1,3c-4.572,10.266-2.856,31.72,2,40,12.6,1.934,32.627,2.349,41-3,1.343-13.8,2.189-26.189-1-39C881.106,468.213,874.892,469.965,867,468ZM476,544c-4.929,2.669-7.519,2.771-10,8-3.425,11.773-4.773,60.274,3,66,7.024,5.174,53.784,3.364,65,1,7.227-5.461,12.338-61.757,4-71C530.72,539.93,493.351,543.5,476,544Zm-180,4-7,4c-4.071,14.139-5.028,51.148,2,62,11.909,3.544,54.481,6.26,61-3,6.87-10.381,4.012-45.55,1-58C341.424,545.384,315.138,547.724,296,548Zm92,0-8,4c-3.9,14.076-4,43.3-1,59,5.362,4,57.471,11.4,64,0,7.361-9.029,3.8-46.583,1-58C432.529,545.51,406.951,547.728,388,548Zm181,0-6,3c-4.716,9.621-7.575,58.449,2,64,10.669,6.185,56.887-.361,61-3,2.43-9.145,2-22.949,2-35C627.985,537.382,605.739,546.982,569,548Zm91,0c-2.882,2.235-5.034,2.633-7,6-3.329,5.711-2,18.171-2,27,0,9.078-2.2,25.383,2,31,4.363,5.842,46.591,7.819,58,4,12.794-4.283,9.783-49.148,6-63C705.424,545.384,679.138,547.724,660,548Zm-450,7-7,5c-1.09,16.512-4.542,35.012,3,48,13.011,2.774,36.957,4.852,49-2,3.207-12.507,2.97-35.449,0-48C244.6,553.416,224.977,554.81,210,555Zm547,0-7,4c-1.924,13.551-2.329,36.026,1,48,11.092,3.542,35.3,3.479,48,1l4-5c0.379-15.582,2.11-37.56-4-47Zm-636,3-5,3c-3.494,14.682-4.345,34.6,3,45,14.74,0.386,34.224,1.7,43-4,0.992-15.054,1.991-27.545-1-41C151.681,556.877,134.731,557.808,121,558Zm729,0c-7.337,5.251-13.158,40.468-2,47,9.327,4.045,35.5,1.693,42-2V564l-5-6H850ZM390,642l-8,5v53c11.91,7.817,37.95,6.675,56,3l4-6c3.933-13.629,2.316-43.779-3-53C425.8,641.019,406.285,641.907,390,642Zm182,0c-11.633,7.575-13.668,47.116-5,61,13.726,2.857,44.734,5.471,53-1,7.2-4.92,9.225-52.216,1-58C612.745,638.2,584.476,641.5,572,642Zm-91,3c-10.012,9.388-10.431,42.325-3,55,14.526,3.409,41.759,4.085,52-3,2.611-13.242,2.27-37.3-1-49C517.427,643.784,497.137,644.836,481,645Zm-180,1-6,4c-3.338,16.128-4.48,37.625,2,49,13.248,3.04,36.752,5.819,50-3,1.5-12.535,4.68-41.924-4-48C334.452,643.28,313.2,645.773,301,646Zm365,0-7,4c-2.588,12.672-3.017,39.522,2,49,18.042,3.55,32.2,3.082,47,0,5.975-8.915,6.553-40.679,1-51C697.669,645.225,680.382,645.9,666,646Zm-455,1-6,3c-2.892,10.363-5.786,42.556,3,48,10.778,5.749,34.251,2.561,45,0,5.17-11.158,4.842-40.25-1-50Zm545,0c-7.716,7.431-9.47,39.656-3,51,13.546,3.62,36.691,4.734,48-2C811.1,648.471,799.65,645.466,756,647Zm-632,6c-2.65,2.063-3.272,1.736-5,5-2.679,9.28-1.1,26.009,1,34,10.466,2.494,31.2,5.408,37-2,4.516-7.659,2.557-29.532-1-36Zm728,0-5,4q0.5,17,1,34l3,1c7.222,3.422,27.21,3.012,35-1,2.142-10.14,2.326-29.849-2-37ZM132,735l-4,4c-0.343,12.013-1.433,28.582,3,36l35-1,1-3c3.694-8.371,1.25-29.339-2-35Zm708,1-3,4q0.5,17,1,34l3,1c9.521,4.218,30.46.852,36-3q-0.5-17-1-34l-3-1Zm-356,3c-4.342,3.5-7.309,5.5-6,12-2.908,10.914-1.494,25.429,1,36,11.305,5.116,31.191,4.3,44,2l5-5q-0.5-20.5-1-41l-5-4H484Zm-181,1c-2.3,2-3.345,2.088-5,5-4.532,10.408-1.3,36.753,3,43l41-1c4.129-8.55,6.68-39.693-2-45C329.986,736.982,314.268,741.834,303,740Zm367,0-8,4c-2.362,11.4-2.65,34.693,2,43,13.124,2.709,35.662,2.876,44-2,2.362-11.4,2.65-34.693-2-43C696.565,739.678,682.358,739.9,670,740Zm-276,2c-5.223,5.489-9.859,37.026-1,43,7.567,4.982,33.6,2.677,40-1,2.3-11.04,2.489-33-2-41Zm183,0c-2.133,1.786-2.433,1.352-4,4-3.953,6.918-2.8,27.354-1,36l5,5c13.9,0.393,30.881,1.289,39-4,0.317-10.243,2.737-31.6-2-38C608.9,739.361,587.336,741.642,577,742Zm-362,2-5,3c-1.127,13.8-2.036,23.78,1,36,8.931,2.587,30.8,5.812,37-2,4.76-7.163,2.479-29.993-1-36Zm546,0-5,4c-0.337,12.186-1.273,28.332,3,36,11.551,0.714,25.227,3.448,36-2,2.172-10.32,2.17-29.609-2-37Z"/>
</svg>';
		} else if ( $svg === '15' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM728,3L666,37,619,66l46-40q-0.5-3.5-1-7c-1.67-2.415-2.422-2.554-5-4-9.319,1.874-57.093,29.645-61,36-2.179,5.891,1.13,7.545,4,11h-2l-55,48q0.5,2.5,1,5c4.059,8.3,11.5,3.518,18,1q-0.5,1-1,2c-16.511,6.483-46.988,26.55-55,42l4,8c20.57-.351,31.1-15.012,47-21q-0.5,1-1,2c-18.694,7.428-38.851,25.059-52,39q0.5,4,1,8l3,1c11.3,4.528,23.4-7.774,32-11q-0.5,1-1,2c-15.79,6.246-31.975,20.3-43,32q0.5,4,1,8l3,1c13.74,5.126,69.1-33.723,81-41,75.773-46.348,149.222-92.088,229-134l1-3c-0.96-6.959-2.288-6.161-7-9-17.714,5.986-29.664,16.935-46,23,14.975-15.367,37.109-23.469,52-39-0.126-5.988-.935-6.706-3-10l-2-1c-14.965,1-25.6,10.807-36,17L669,92c23.152-23.543,84.1-42.493,97-72-13.349-17.319-65.717,27.361-83,34,15.036-15.818,37.751-24.316,53-40-0.126-5.988-.935-6.706-3-10ZM844,47L775,82,472,263,282,378l154-99c9.729-6.22,46.987-25.887,45-37l-2-5c-7.5-1.405-11.57,1.04-18,3,11.285-11.556,28.168-16.908,38-30-0.126-5.988-.935-6.706-3-10-21.473-3.453-42.1,20.563-60,27,7.621-7.749,21.3-10.443,23-24l-3-5c-14.615-.106-19.421,6.274-30,10,10.554-10.615,32.121-15.214,36-32l-3-5c-25.372-2.719-46.945,24.128-68,32,21.464-21.9,54.757-31.782,76-54-0.368-6.386-1.482-6.435-4-10h-1c-13.633.317-19.517,7.314-30,11,6.99-7.086,14.586-8.854,19-19-8.7-18.475-44.735,12.528-56,17l16-15q-0.5-4-1-8l-3-1c-11.748-4.686-24.991,8.63-34,12,8.917-8.93,25.644-12.783,28-28l-4-5c-31.458.675-53.3,30.357-79,40,19.574-19.942,56.117-27.865,70-53-3.333-20.13-32.221,3.463-41,7,7.131-7.064,17.955-8.671,19-22l-1-3-3-1c-16.126-5.52-87.619,49.7-107,57,17.319-17.655,49.1-25.384,61-48-0.786-6.1-1.828-6.548-6-9-24.681,3.91-39.617,24-61,32,15.635-15.987,40.44-22.929,54-41-0.3-5.588-1.019-5.838-3-9l-3-1c-37.37,6.49-72.487,47.02-107,61l2-3c18.307-7.97,37.734-26.986,51-41-0.368-6.386-1.482-6.435-4-10-10.947.563-116.185,62.589-122,70,0.786,6.1,1.828,6.548,6,9l22-10c-12.2,14.181-30.96,23.423-44,37,0.126,5.988.935,6.706,3,10h1c10.016-.092,12.831-3.464,20-6q-0.5,1-1,2c-11.648,4.442-38.313,21-40,35l1,3,5,3c14.315-2.207,22.016-10.707,34-15q-0.5,1-1,2c-18.3,7.255-39.077,24.347-52,38l1,7,5,3,19-7-1,2c-7.718,3.1-12.749,9.382-18,15l1,5,3,5c32.294-1,55.227-32.008,82-42q-0.5,1-1,2c-19.617,7.708-68.175,40.083-80,56l1,8,3,1c12.961,4.924,31.035-12.692,41-17-10.352,11.8-27.043,18.587-38,30l1,5c2.142,4.4,3.5,4.924,10,5l-1,2c-8.191,3.192-31.343,17.426-29,27l2,5c16.454,3.038,28-10.363,41-15l-1,2L98,348l1,5c6.5,12.461,25.334-3.01,33-6l-1,2c-17.221,6.825-34.967,22.226-47,35,0.21,5.661,1.084,6.714,3,10l3,1c14.451-2.119,23.285-10.149,35-15l-23,20q0.5,2.5,1,5c7.286,13.35,41.408-13.222,51-17l-1,2c-13.515,5.32-27.551,17.031-37,27q0.5,2.5,1,5l2,4c20.821,3.674,39.8-17.227,56-24-7.392,8.395-17.446,11.374-23,22l4,8c13.219,0.133,16.955-4.707,26-8-11.437,12.692-42.18,19.138-44,40l3,4,2,1c16.23-.693,24.985-10.45,38-15-5.09,6.081-9.183,10.305-4,19l13-1-1,2c-6.891,2.963-10.272,7.755-13,15,3.26,7.819,7.117,8.484,17,7-3.931,4.218-11.673,8.36-9,16l3,5,15-2v1c-5.4,2.1-12.653,9.127-10,16q1,2,2,4c6.294,1.268,11.232.126,17-1l-8,9c0.166,6.9,1.362,7.27,4,11h1c19.48-.467,29.692-12.657,45-18-3.537,6.031-5.121,10.562-1,17,9.058,0.5,14.2-2.332,22-5l-9,10q0.5,4.5,1,9l3,1c6.665,2.882,13.715-1.17,19-3-2.521,3.99-4.195,5.822-5,12l6,6,12-2-1,2c-10.2,3.941-23.108,13.446-28,23,2.991,17.559,23.307,3.362,32,0-3.87,4.707-6.937,5.989-8,14,12.018,11.8,26.725-2.751,39-6v1h-2c-5.859,6.119-11.413,8.135-15,17,1.4,2.6,1.612,3.334,4,5,7.985,5.026,18.777-3.328,26-6l-12,12c-0.008,6.328.857,7.582,3,11l2,1c16.81-1.072,25.619-11.271,39-16l-1,2c-9.879,3.5-43.015,22.545-39,35l2,4c16.116,2.93,27.634-9.3,40-14l-1,2-14,12c-0.008,6.328.857,7.582,3,11l2,1c15.1-1.056,22.95-9.769,35-14l-1,2c-10.907,4.648-19.375,13.877-27,22q0.5,2.5,1,5l3,5c29.714-.555,49.1-27.02,73-36l-1,2c-14.826,5.847-29.976,18.765-40,30q0.5,3.5,1,7l10,3,55-29-1,2c-11.642,4.581-21.966,14.471-30,23q0.5,2.5,1,5c7.218,13.2,40.434-13.22,50-17l-1,2c-21.194,8.367-51.887,29.429-65,47l4,8c34.152-.335,92.97-56.96,126-69q-0.5,1-1,2c-17.249,6.814-77.292,47.491-84,63,2.826,3.742,3.41,4.819,8,7,24.848-8.762,41.814-26.407,65-36-13.845,15.871-35.333,25.708-50,41,0.439,7.259,1.846,7.675,7,10l39-21-3,4c-11.191,4.951-27.42,18.155-33,29,1.164,5.307,2.078,5.68,6,8,14.632-2.639,29.773-15.268,41-23v-9c12.511-5.388,73.889-53.322,75-66l-3-4-3-1-22,10c12.358-12.576,42.8-22.875,46-43l-4-5h-7q0.5-1,1-2c13.09-5.108,68.841-43.334,71-56l-7-6-16,6c13.991-14.05,53.716-24.461,57-47l-4-5c-13.12.281-18.36,6.5-28,10,9.809-10.178,23.179-16.751,33-27-0.21-5.661-1.084-6.714-3-10-7.75-.114-10.882,1.307-16,3l2-3c14.463-4.906,37.942-21.1,45-34-1.4-13.307-13.041-8.128-21-5,14.668-14.9,35.747-22.554,50-38-0.259-8.346-1.82-7.908-7-11l-18,7,2-3c18.094-6.2,38.675-22.94,51-36-0.21-5.661-1.084-6.714-3-10l-16,1c17.684-5.945,49.751-26.969,58-43-2.044-16.745-20.914-5.155-29-2,6.444-6.583,15.253-8.492,17-20l-4-5H847q0.5-1,1-2c14.34-5.674,28.036-18.407,38-29q-0.5-4-1-8c-4.11-1.97-5.128-2.615-10-2l2-3c12.224-4.784,22.09-14.614,29-25q-1-3-2-6l-3-1c-7.942-3.342-14.494,2.273-21,4l10-13c-1.1-7.283-5.884-8.981-6-11,13.021-13.338,32.056-20.5,45-34-0.126-5.988-.935-6.706-3-10l-2-1c-11.449.044-16.633,4.116-25,7,2.976-4.06,5.035-5.45,6-12l-6-6-13,3,2-3c9.586-3.54,24.166-12.534,25-25l-3-5H899q0.5-1,1-2c7.981-3.168,16.2-9.378,17-20l-3-5h-2c-7.09-1.668-14.295,2.151-20,5,3.076-5.027,5.946-6.265,7-14-2.825-3.044-3.747-4.073-8-6l-8,2,13-13q-0.5-4.5-1-9c-8.181-3.742-13.423-.831-22,2,4.313-4.64,9.239-7.663,13-13-0.126-5.988-.935-6.706-3-10h-2c-10.676-2.236-20.823,6.734-30,10,3.56-4.652,6.243-6.037,7-14a11.144,11.144,0,0,0-4-4ZM681,54h0Zm77,11h0ZM616,67h0Zm139,0h0ZM667,92h2l-6,4,2-3Zm-6,4h0Zm-3,2h0Zm-411,5h2l-3,2Q246.5,104,247,103Zm516,2h0Zm-3,2h0Zm-2,1h0Zm-2,1h2l-5,3Zm-5,3h2l-40,24-88,52Zm-563,1h2l-3,2Q187.5,114,188,113Zm65,15h2l-3,2Q252.5,129,253,128Zm-3,2h0Zm-3,2h0Zm124,4h0Zm-55,7h0Zm-3,2h0Zm247,0h2l-3,2Q559.5,146,560,145Zm-249,1h0Zm231,39h0Zm81,3h2l-10,6Zm-10,6h2l-3,2Q612.5,195,613,194Zm-489,2h0Zm486,0h0Zm-2,1h0Zm-2,1h0Zm-3,2h0Zm-2,1h2l-3,2Q600.5,202,601,201Zm-212,2h2l-3,2Zm209,0h0Zm-212,2h0Zm-2,1h2l-3,2Zm209,0h0Zm-212,2h0Zm43,0h0Zm-45,1h0Zm-3,2h0Zm-207,9h0Zm-2,1h2l-3,2Q166.5,222,167,221Zm-3,2h2l-3,2Q163.5,224,164,223Zm270,4h2l-3,2Zm-3,2h0Zm28,11h0Zm-2,1h0Zm421,8h0ZM127,274h0Zm375,25h0Zm-2,1h0Zm-3,2h0Zm273,0h0Zm-275,1h0Zm-2,1h2l-5,3Zm270,2h0Zm-275,1h2l-87,53c-38.994,24.221-78.887,47.215-119,71l-49,28,60-37Zm264,6h0Zm-652,1h0Zm650,0h0Zm-2,1h0Zm-3,2h0Zm-2,1h0Zm-3,2h0Zm-3,2h0Zm-2,1h0Zm-3,2h0Zm-2,1h0Zm-617,7h0Zm604,1h0ZM132,346h0Zm324,30h0Zm-2,1h0Zm-174,1h2l-5,3Zm-155,1h0Zm326,0h0Zm-2,1h0Zm-174,1h0Zm172,0h2l-8,5Zm-174,1h2l-3,2Zm-3,2h2l-3,2Zm169,2h2l-58,35c-31.671,19.341-79.242,55.584-114,67Zm-285,1h0Zm348,11h0Zm-2,1h0Zm-325,2h0Zm320,1h0Zm-2,1h0Zm-2,1c2.769,1.156.525,0.309,0,3l-4,1Zm-6,4h2l-5,3Zm-5,3h0Zm-2,1h2l-33,20L338,497ZM182,423h0Zm322,24h0Zm-3,2h0Zm-2,1h2l-3,2Zm-3,2h0Zm-315,1h0Zm313,0h2l-5,3Zm-5,3h2L369,529Zm-256,3h0Zm204,4h0Zm-12,7h0Zm-3,2h0Zm-2,1h0Zm-3,2h0Zm-2,1h0Zm-2,1h0Zm-3,2h0Zm-2,1h2l-3,2Zm-3,2h0Zm-3,2h0Zm-2,1h0Zm-2,1h2l-3,2Zm-131,2h2l-5,3Zm128,0h0Zm-2,1h0Zm-131,2h2l-3,2Zm128,0h0Zm-2,1h2l-3,2Zm-3,2h0Zm-49,3h0Zm44,0h0Zm-2,1h0Zm-45,1h0Zm-2,1h0Zm36,29h0Zm-2,1h2l-3,2Zm-3,2h0Zm-61,49h0Zm388,18h2l-3,2Q688.5,600,689,599ZM348,631h0Zm35,6h0Zm79,35h0Zm-3,2h0Zm-2,1h2l-3,2Zm-50,3h0Zm77,9h0Zm84,1h0Zm-87,1h0Zm84,1h0Zm-59,9h0Zm-5,3h0Zm48,54h0Z"/>
</svg>';
		} else if ( $svg === '16' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 800">
<path style="fill:' . $f . '" d="M0,0H1000V800H0V0ZM348,3L274,77c1.011,4.962.7,3.748,4,6,11.411-6.621,72.513-65.818,75-77l-3-2ZM839,6c-27.945,14.338-45.849,38.856-67,60L744,93c-8.9,12.143-6.4,32.2,5,40,8.442,5.775,23.655,6.077,32,0,12.1-8.814,82.691-78.949,87-90C876.059,22.333,859.126,6.069,839,6Zm-2,9c11.788-.361,14.895,2.4,21,7,1.806,5.866,5.071,14.416,1,21l-84,84c-5.672,3.46-14.268,1.445-20,0l-7-10c-6.31-16.107,10.118-25.118,17-32C788.589,61.411,810.543,35.67,837,15ZM573,33l-97,96-5-5-7-4,51-51q-0.5-3-1-6h-5l-53,53-18-5,22-22c9.195-27.464-12.407-57.356-40-37l-66,67-95,95c-3.33,5.557.139,12.754-3,20l-36,37c1.373,1.9.973,1.636,3,3l4,1,33-33c4.856,10.291,22.56,17.724,36,10l70-69,4,16c0.587,5.916-3.564,5.545-3,10l2,3c5.37-.948,3.722-1.622,8,0l7,11c-8.578,3.935-24.557,19.176-27,29l6,3,27-27,16,8L269,374c-18.822,18.818-48.508,33.685-40,68l-87,86c-8.538,8.538-24.608,18.181-28,31l4,3,3-1L235,447c8.54,2.859,13.929,3.765,24,2q2.5,4.5,5,9l-21,20-38,38c-6.58,9.62-9.173,17.176-17,25-7.634,7.632-26.077,18.013-23,35,1.366,7.539,5.549,12.32,11,16,26.568,17.938,37.9-19.489,54-27,5.725-2.67,11.529-1.881,16-4-10.174,19.953-44.651,31.12-26,63-4.08,5.085-10.261,9.756-12,17a27.229,27.229,0,0,0,33,33c21.027-5.167,31.525-31.036,48-42,3.885,14.838,14.948,15.171,28,21l-22,23-35,34,2,6h4l52-51c-13.6,27.461,14.142,59.817,43,42L466,603c-5.013,14.9-2.669,22.534,1,37l-60,60c1.011,4.962.7,3.748,4,6l63-61c33.686,19.866,59.035-23.033,76-40L720,437l-27,28c1.011,4.962.7,3.748,4,6l30-28c33.762,11.309,65.959-15.02,49-49L915,254q-0.5-2.5-1-5l-3-1L770,386l21-25c-2.433-8.257-4.072-8.3,4-14v-1c-3-8.179-12.417-16.176-19-21L887,214q0.5-1,1-2v-4l-2-2h-4L770,318l-9-9c21.493-36.021-21-75.283-54-62L815,138v-3l-3-2h-4L697,245l-7-5c-9.712,2.811-27.077.333-39,6l14-15c7.685-24.672,29.906-32.45,43-51,3.57-5.057.984-10.341,4-17l19-19q-0.5-1.5-1-3l-2-1h-4l-14,14c-21.834-17.611-26.6-12.486-46,3h-4l-7-9,95-94,1-2V49c-3.592-1.905-2.961-2.016-7-2l-98,99-13,1-31,30-2-1c-4.764-39.4,67.58-74.821,84-104,9.193-16.336-5.272-41.863-28-35L633,53c-4.781-12.9-23.923-16.873-36-8L492,151l-2-1q-4-7.5-8-15l97-96V38C577.564,33.291,578.253,33.917,573,33ZM432,55l16,2c15.568,21.043-1.254,33.406-15,47-13.572,13.422-38.9,12.91-51,28-9.662,12.05-8.469,22.959-16,39-4.233,9.016-74.619,75.082-86,76-6.626-3.533-10.324-4.55-14-11l52-54-1-3-2-1h-4l-47,46c11.431-22.784,37.461-40.461,55-58C355.4,129.6,390.023,85.2,432,55ZM212,64c-12.947,12.339-70.424,63.515-74,77l7,2,73-75C215.83,65.336,215.991,65.2,212,64Zm127,4L197,211v4l2,2h4L346,73V70l-2-2h-5ZM322,244L162,403c-12.863,12.863-53.614,44.627-58,61l4,3,3-1L268,308c12.116-12.115,54.5-45.751,58-61Zm-55,13L144,381q1,2.5,2,5h4L273,263v-4Zm61,22L198,411l1,3,2,1h4L335,284v-3l-2-2h-5Zm-165,5c-7.868,3.319-15.371,4.642-20,11-13.318,18.291.977,47.583,24,45C201.659,336.112,200.176,284.964,163,284Zm702,99-59,59c-27.862-11.968-94.01,54.676-55,78,24,14.353,67.785-32.871,71-49,2.537-12.727-8.736-18.073-8-25l57-56q0.5-1.5,1-3c-1.373-1.9-.973-1.636-3-3ZM274,434l6,7-10,10h-1l-4-6Zm516,14,9,1-24,24q-0.5,1.5-1,3c1.373,1.9.973,1.636,3,3l1,1,31-27c2.138,5.451,4.386,8.325,5,16-6.81,12.971-51.577,70.149-66,34C742.479,482.805,778.272,457.016,790,448Zm-65,43L509,708l1,3,2,2h4L732,495q-0.5-1.5-1-3Zm-72,13L437,721l2,5h5L659,510q-1-3-2-6h-4Zm171,23-59,59c-7.384-5.212-18.559-11.428-31-6l-88,86c-6.8,9.488-5.6,25.316,1,34,7.255,9.553,27.038,12.014,38,4,11.914-8.71,81.834-78.177,86-89,2.734-7.1.14-16.837-1-23l60-60C827.973,528.551,828.405,528.372,824,527Zm-94,14L601,671l2,5h5L737,546v-1l-4-4h-3Zm14,45c7.25,0.787,11.509,2.528,15,7h-2l-77,79,4,5,3-1,76-76h1v8c-5.282,13.2-72.168,81.584-85,90-11.261,7.385-24.175.385-28-9-4.691-17.827,9.783-24.783,18-33C691.9,633.106,714.072,601.013,744,586ZM277,617l9,5c-9.983,13.735-38.742,47.42-60,42-13.7-9.451-9.6-22.946-1-34C244.045,640.97,268.534,635.773,277,617Zm583,48-74,74v4l2,2h4c13.053-17.054,69.3-60.718,73-77ZM176,693c-20.13,10.216-104.114,76.936-60,102,7.513,4.269,21.281,3.5,28-1l61-63C213.956,709.483,196.494,692.811,176,693Zm-2,9c13.326-.657,19.878,2.594,23,12,7.033,17.333-54.224,75.182-73,75-5.76-2.765-9.734-5.672-12-12C104.841,758.963,162.2,711.137,174,702Zm413,7c-19.253,8.639-81.064,59.473-35,79C587.721,803.143,653.462,710.353,587,709Zm-184,9-7,7c-28.606-12.247-42.255,11.69-38,38l-28,28q0.5,3,1,6h5l27-28c18.2,11.956,43.332,8.461,48-15,2.41-12.112-8.788-18.109-8-25l6-5v-1C407.564,718.291,408.253,718.917,403,718Zm182,0,15,2c19.369,24.331-19.6,66.421-47,59C533.176,753.5,566.628,729.762,585,718Z"/>
</svg>';
		} else if ( $svg === '17' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1500">
<path style="fill:' . $f . '" d="M0,0H1000V1500H0V0ZM430,1297c-1.721,30.48-11.667,69.42,18,79,6.514,2.1,8.966,1.15,13-4-15.254-10.7-33.719-47.77-15-72,2.118-2.16,3.444-1.99,8-2q8.5,3.495,17,7c6.672,34.99,16.737,65.87,34,94q13.5,19.995,27,40c9.133,20.53,20.6,52.47,44,58q2.5-4.005,5-8c7.387,3.75,12.45,8.19,22,10,0.667-.67,1.333-1.33,2-2v-4l-45-45q-0.5-6.495-1-13-5.5-9-11-18v-11q-9.5-10.005-19-20c-6.744-9.8-27.357-52.93-26-64-1.592-2.85-1.667-3.84-1-7h5c0.845,7.83,2.486,10.87,8,14,20.072-12.14,36.479-48.87,70-43,20.429,37.46,11.021,71.85-2,109,17.785-8.94,30.2-56.66,30-86,2-.33,4-0.67,6-1,6.6-17.71,21.32-5.63,35-11,2.482-.97,3.225-4.56,7-6q5.5,13.995,11,28c2.7,11.37-4.53,17.87-3,28,0.667-.33,1.333-0.67,2-1q6.5-19.995,13-40c2.8-12.1-3.356-29,4-38,2.053-2.51,14.225-12.22,18-16v-1c-5.778,1.99-12.795,5.04-16,4q15.5-17.505,31-35l13-27q22-26.49,44-53l46-33c-0.667-.67-1.333-1.33-2-2q-25,10.005-50,20l1-7q7-8.505,14-17c-1.667-2.33-3.333-4.67-5-7q-8.5,3.495-17,7c-0.333-.33-0.667-0.67-1-1,1.358-20.42,35.184-44.71,28-62h-5c-6.554,11.28-14.778,22.42-25,30-2.333-.67-4.667-1.33-7-2,5.9-9.35,11.887-17.7,13-32-1-.33-2-0.67-3-1-10.924,7.01-58.12,54.96-70,42,17.983-40.48,54.161-68.8,79-103-1.17-4.512-1.771-4.79-5-7-14.339,7.065-30.306,24.263-45,26v-1c3.375-15.428,21.636-18.192,28-31a31.145,31.145,0,0,1-14,2l4-8q-0.5-2-1-4l-12,9-3-1-3-21c1.009-9.276,8.078-15.35,12-22,14.22-24.112,26.529-46.038,37-73l-4-3c-44.252,14.147-78.4,51.992-108,82-14.24,14.437-22.324,27.251-43,36q-0.5-1-1-2,0.5-1,1-2c5.429-11.283,15.611-14.456,16-31l-5,1c-1.562,3.7-1.98,4.815-5,7l-2-3v-4c10.962-25.6,41.279-43.364,64-58,15.58-10.036,27.43-27.973,43-39l29-17,3-11c15.938-14,44.937-13.269,58-30v-1c-40.5-1.922-71.716,29.812-107,35q-0.5-1-1-2,0.5-2.5,1-5c14.579-6.023,14.328-18.518,29-24v-4H728c-9.9,3.5-39.228,15.707-43,7l11-9q-1-2-2-4h-1c-6.92,1.107-12.224,5.531-19,3l-2-1v-1c13.039-3.294,24.242-14.748,33-23v-1l-10-7,2-3,77-46-4-7c8.722-3.813,44.221-26.588,46-35q-0.5-1-1-2h-5c-15.057,6.834-83.753,42.262-94,40l-4-2c8.889-12.385,29.374-14.292,38-27q2.5-8.5,5-17l24-18,11-24c5.307-8.6,12.83-16.531,18-26l-2-1-51,35-3-2v-1c3.813-9.751,13.415-13.527,17-22,3.168-7.488-2.992-14.489-1-21q7.5-12.5,15-25v-1l-20,7c1.282-4.587,2.777-5.609,6-8,4.375-10.564,14.026-15.427,16-28l-4,2-15,13-34,15c-21.681,13.053-51.026,34.932-82,36v-3c6.908-2.176,51.435-26.964,56-32l-26,8q0.5-3,1-6l20-16c19.56-12.117,41.5-20.919,60-34,8.485-6,21.42-3.494,24-16-20.964-.342-31.122,6.306-50,8v-1c4.392-6.828,12.547-8.229,17-15l-27,12q1-2,2-4c0.143-.248,12-20,12-20,12.529-8.384,36.485-10,44-23l1-1-6-12,10-6q-0.5-1.5-1-3h-1l-41,24-58,26c-11.382,5.006-16.772,11.863-34,12v-6c21.264-5.311,37.228-20.536,55-29l46-15q-1-3.5-2-7c11.785-3.846,31.04-12.362,39-21-36.643,8.193-61.176,36.741-102,38l3-8c32.823-10.689,37.656-37.114,56-62l15-15,8-24,24-27v-1c-14.076,1.411-24.038,12.868-34,19l-61,30-4-2,3-4c15.915-7.029,80.324-59.163,90-73l-24,11-5-4v-4l10-12c-27.2,8.345-105.745,63.418-130,58q0.5-1,1-2c37.7-12.081,79.641-51.722,111-74,11.177-7.94,35.6-17.022,41-30-30.673,12.644-57.162,22.563-84,39-10.485,6.422-27.515,21.624-41,20,3.794-9.659,84.41-67.643,98-73v-2l-2-2c-45.381,5.722-79.475,44.2-117,53v-3c16.218-27.151,96.35-86.95,132-95v-1c-34.028-.4-51.262,16.195-79,20q1-2,2-4c13.417-24.821,48.313-26.684,67-46-27.043,1.345-50.271,9.379-68,21-9.3,6.1-18.472,16.751-31,19v-1c18.44-32.453,48.877-40.255,72-65V75c-31.918,2.954-55.795,30.367-79,44h-1c2.349-19.644,20.437-26.793,25-46h-2c-24.129-6.109-38.394,41.692-51,39,4.888-30.907,20.03-56.225,37-78,7.144-9.167,20.845-17.519,25-29-41.451,19.1-57.234,57.859-77,96l-12,29v-2c-2.34-6.6-.081-16.338-4-21v2c-7.322,7.286-7.651,26.2-12,36l-4-3v-1c1.3-11.189,4.588-18.422,2-29l-2-1v2c-8.875,15.761-3.473,45.1-13,61l-3-2c-0.812-47.417,11.037-85.554,30-115l24-31c-18.588,2.914-37.795,25.653-44,41h-6V64l15-29-1-1-3,3c-12.919,6.17-21.471,26.624-26,41,3.583-2.6,4.614-5.486,8-3-10.878,24.726-15.643,55.636-25,83-4.723,13.812.254,37.927-3,53h-1v-2c-8.6-11.6-11.966-55.339-2-63l4,3v-2c2.634-9.15-8.877-13.347-4-26l6-6c-3.4-28.275,7.177-45.931,16-67V47h-4c-10.915,16.007-25.3,60.111-37,70v-2q-1-3-2-6h-4v2q-4,15.5-8,31c-4.046-1.593-3.656-.849-8-1l-1-1,4-12-1-2c-9.554,3.56-6.135,15.21-15,19V133c5.513-15.223,10.3-31.922,19-44l-2-3c-25.354,17.869-32.144,74.23-24,114,2.784,13.6,6.324,21.516-1,34l-2-1-7-42q0.5-11,1-22l-2,1c-2.042,6.385-5.894,22.2-13,24-0.269-22.891,2.69-45.04,1-65l-1,2c-22.822,32.279,7.653,119.367,12,151h-1l-8-7c-4.066-8.263-13.441-17.155-17-26-7.623-18.946-1.406-46.353,0-66l-2,1c-6.38,16.532-9.07,33.618-9,59h-4c-1.062-5.9-8.258-41.778-11-47l-2,1c-2.51,9.221-2.164,29.491-7,39l-1-2c-5.836-7.737-4.855-24.143-11-32l-3,1q-2,11.5-4,23c-4.11,6.018-8.9,7.1-11,17-10.767,50.749,11.594,97.329,25,130,5.737,13.981,36.664,68.808,33,79-21.672,2.642-40.277-37.7-52-51h-1v8l-3-1c-6.374-12.839-15.212-24.948-23-36-8.9-12.638-34.057-91.681-29-111l-3-4h-1l-2,1c-4.246,39.822,5.7,78.75,21,106l15,19c5.743,11.7,7.43,23.477,14,34l21,24c3.523,9.2,1.894,14.081,6,22,3.131,6.038,7.963,5.4,9,15h-1l-2-2c-27.168-16.206-40.94-88.187-65-105l-13,6-22-35c-4.513.215-5.391,0.708-8,2q3,28.5,6,57h-1c-5.084-2.036-5.941-3.291-11-1-8.822,45.949,27.875,75.255,21,115h-2c-3.334-17.778-24.3-71.557-36-81-14.6,6.761-4.533,47.3-1,60,14.208,51.064,38.4,89.111,54,137h-4c-23.331-10.273-61.7-85.642-72-112-4.26-10.9-2.081-17.48-10-24h-4l-2,2c1.679,45.081,34.466,74.844,43,113h-6c-8.325-4.571-40.835-47.021-44-57-4.975-15.688-3.427-41.715-15-51l-3,2c0.153,36.051,19.48,84.686,2,113h-1l-4-3-6-30-6-1v2c-7.491,17.351,7.679,64.156,12,77a613.306,613.306,0,0,0,55,119c10.108,17,30.422,37.154,32,60-27.373-6.58-77.037-64.585-93-87-10.087-14.163-14.518-41.609-37-43-2.584,1.721-3.407,2.111-5,5-6.226,15.8,9.36,38.55,15,48,20.72,34.715,42.938,60.153,67,90,8.509,10.555,24.032,15.83,23,33l-3,1c-24.547-11.7-53.113-43.482-80-44v1c20.531,39.38,49.786,72.159,81,101l-2,3h-1c-26.278-10.457-71.093-63.133-86-87-8.907-14.261-13.426-28.749-25-40-7.159-.24-10.2.626-14,3v1c4.177,27.349,19.583,47.525,31,68l-1,4-9,3c18.492,42.054,46.975,65.843,79,94q0.5,3,1,6h-3c-5.412-3.3-13.074-8.942-19-3,4.185,23.44,39.414,34.79,52,52v3c-0.667.33-1.333,0.67-2,1-14.97-4.03-23.076-12.62-34-16-9.077-2.81-14.8.38-21-4-17.626-12.46-27.194-32.15-52-38v5c9.593,24.11,29.482,52.31,49,67,17.442,13.12,33.239,22.19,36,50-0.667.33-1.333,0.67-2,1-4.144-1.68-6.811-2.36-10,0,2,3.76,3.163,14.72,5,17,7.269,9.03,26.33,13.03,30,25-1,.33-2,0.67-3,1q-4.5-1.995-9-4c-0.333.33-.667,0.67-1,1v5l21,18q11,4.005,22,8,14,15.495,28,31c8.088,6.33,20.557,10.07,26,19-5.343,20.44-26.28,28.82-31,50-4.977,22.33,15.728,25.54,20,38q1.5,16.995,3,34c7.046,31.65,28.032,42.15,53,56,8.842,4.9,17.746,14.67,30,13l-2-3c-10.6-2.43-34.289-13.89-37-24,6.694,0.63,8.917,1.3,13-2-0.333-.67-0.667-1.33-1-2-12.8-3.61-53.442-40.6-39-54,1,0.67,2,1.33,3,2,2.317,9.66,8.009,21.31,17,24v-7c-3.138-5.97-7.253-12.54-5-21,13.134,3.43,14.769,24.39,22,34,15.082,20.05,73.074,29.79,92,5-0.333-.33-0.667-0.67-1-1-29.169,9.17-82.208,6.27-82-23,0.08-11.24-23.727-46.8,0-54,4.816,10.15,1.841,27.76,15,27,1.228-6.78-6.043-25.86,2-32ZM665,7c-39.7,30.317-47.169,38.414-63,93,16.254-8.685,22.973-35.927,33-51l32-36C666.688,8.762,667.062,9.036,665,7ZM503,104c-1.093,7.078-5.31,9.993-2,15l3-2,3-11Zm-42,29c-1.593,3.971-2.181,4.9,0,8v-8Zm38,44h0Zm20,2c3.635,0.644,3.027.4,5,2-3.86,15.341,11.308,42.69,1,57v-2C515.227,223.355,518.688,199.771,519,179Zm-31,43c3.378,7.947,11.99,59.685,9,64C492.8,264.4,478.268,246.506,488,222Zm-99,46,23,64c9.15,23.146,62.7,117.785,81,125l16-4v6l-7,20-7,1c-20.14-6.909-27.659-27.37-38-44C434.885,400.435,377.893,320.785,389,268Zm372,56,2,3ZM361,369v4h3Zm4,9q1,3.5,2,7l3,1v-4Zm438,8c1.8,2.042.015,0.707,3,2C804.2,385.958,805.985,387.293,803,386ZM703,754q-0.5,3.5-1,7h2C704.023,755.937,704.848,756.429,703,754ZM345,1172h0Z"/>
</svg>';
		} else if ( $svg === '18' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1500">
<path style="fill:' . $f . '" d="M0,0H1000V1500H0V0ZM674,8c-11.415,9.644-15.506,23.48-24,35l3,6c-12.3,1.306-8.742,9.931-13,19L627,83q-2,19.5-4,39c-11.224,55-25.349,105.946-25,166l-2,1-3-2c-12.659-53.354,3.352-124.412-6-182q0.5-26,1-52c-6.86,7.738-2.74,25.406-9,34h-1q-2-15.5-4-31l-1-1-2,2c-17.834,9.326.848,84.155-5,108l-3-2L536,17l-1-2-4,3c-1.729,7.266-1.246,19.641-5,28-1.773,3.949-19.517,13.423-24,20l-16,37c-9.057,14.86-21.833,33.305-28,50h-4c0.8-6.837,3.163-11.557-1-14q-7.5,18.5-15,37l-5-1v-2c-4.994-10.514.963-26.831-13-29-1.242,8.405-1.361,21.905,1,28l-1,2-9-3v6c2.715,8.932,2.014,28.8-1,34l-1,2h-1l-4-9-3,2c2.084,18-2.62,17.691-7,29-3.518,9.084,7.88,34.08,3,52h-1l-4-1q-9-31.5-18-63l-4,4-3-2q-1-4.5-2-9l-2,1v11l-1,1-2-1c-1.658-9.185-2.808-17.284-9-22h-1c0.465,12.012.606,24.164-3,34l-2-1-4-18-2,1v2c-3.127,10.382,5.4,27.321,7,38,1.308,8.751-4.736,8.381-4,15,5.895,0.174,5.927.072,8,4q0.5,3,1,6l-4,7c-12.162-8.026-7.716-18.744-14-24-6.7-2.961-13.117,1.6-16,2-1.624-7.39-4.921-38.241-11-42v2c-6.216,13.863.932,32.574,2,46-3.811,3.156-4.524,6.22-10,8l-5-8h-1q-2.5,8.5-5,17l-7-6c0.387,4.012,1.086,3.163-1,6l-5-2c-9.733,14.115-13.693,43.155-27,54l-4-2q-1-6-2-12c3.168-2.329,5.085-4.138,4-8l-2-4-3,2-13,15q-5.5,24.5-11,49c-5.177,24.463,3.344,56.421-1,77l-7,6h-2c-2.4-5.478-4.161-8.237-8-12q1-2.5,2-5l-2-1-1,1-3,21h-4c-1.763-7.376-8-30.183-14-34v5c3.305,8.628,16.967,60.3,16,64l-4-3c-7.252-23-18.144-45.326-25-70h-1v2c-4.311,11,8.745,44.335,9,64l-3-2-6-19-6,2c4.022,31.523,37.85,71.824,17,97-2.961.031-2.032-.215-5,1-1.3,18.308-7.454,34.5-18,44,9.749,40.7,47.851,65.3,68,97l17,36q2.5,10.5,5,21l13,6c6.832,6.634,30.086,48.081,27,56l-12,1-3,9-3-1c-4.03-14.651-14.373-19.935-21-31l-3-11-10-5v-2l-8-16-17-15-1-1q1-4.5,2-9l-13-12q0.5-4.5,1-9l-15-20q-2-9.5-4-19l-10-14c5.329-1.328,5.444-.566,6-7l-3-6c-3.06,1.62-3.152,2.053-6,2-1.784-5.759-4.695-8.871-9-12-9.27.244-14.164,4.51-17,11-5.668,13.509,2.486,30.7,5,39l4,24c5.383,12.245,17.551,18.5,24,29l3,13c7.951,15.686,26.983,32.61,37,49,6.367,10.418,9.021,45.133,22,49l2-1v-1l-3-9,1-1,3,2,6,15c-5.053,2.847-6.036,1.879-3,6,4.24,11.579,14.708,29.723,24,37,5.566-2.724,4.538-4.692,10-3-2.179,12.1-2.248,15.18,3,25,6.544-1.523,7.071-4.572,14-6,10.882,13.149,16.431,17.578,20,40l-2,1-2-2c-25.687-13.351-55.242-49.895-77-70-12.853-11.877-23.776-23.629-36-36l-14-10c-5.1-9.98-6-18.554-11-27l-14,2c-7.823-10.933-17.312-18.71-25-30h-1v2c-3.288,8.719,7.333,17.719,11,24l-2,2c-7.538-3.844-10.036-12.516-17-17v1c3.745,7.351,8.9,11.153,10,21h-1l-6-7-2,1v1c10.958,17.024,45.328,67.043,43,88l-2,1c-6.78-3.619-11.074-8.619-16-14-11.064,1.519-11.648,5.655-18-3-5.684-4.719-.856-12.454-5-20-19.909-1.506-19.39-43.077-49-46v1c2.971,7.29,1.928,8.825,0,16,9.5,7.681,18.772,26.674,28,33,14.319,9.817,62.162,45.825,69,59,4.736,9.125,4.255,24.012,1,33l-9,1c2.793,8.652-8.231,35.72-5,49,1.716,7.05,11.648,16.96,15,23q2,7.005,4,14,31.5,33.99,63,68c21.489,18.15,46.767,36.43,72,50,11,5.92,34.059,11.67,38,24-2.333-.33-4.667-0.67-7-1-31.626,3.07-82.855-10.35-105-23-5.156,1.06-27.048,3.75-30,7,0.333,0.67.667,1.33,1,2,28.2,8.11,55.728,25.16,79,38,8.1,4.47,16.846,4,23,10v1c-17.351,3.94-59.343,4.8-70,17v1h2l27-3c39.93-1.89,78.6,3.36,99,23v4h-2c-19.044,7.1-81.988-1.6-93,10,29.665-.55,68.762-5.76,100,3q11,5.505,22,11c12.885,3.84,19.062-2.22,27,7-16.06,21.58-14.48,47.47-3,73h2c-1.7-36.75.069-54.95,28-69,7.009-3.53,26.063-8.63,34,0v1q-9.5,4.995-19,10c3.229,10.16-5.469,20.83-8,34-5.945,30.94,14.734,58.67,30,70-7.589-39.4-33.652-53.98,0-92h20l1,3c-4.365,1.51-4.605,1.36-6,6,12.275,5.54,23.189,10.71,37,15,0.023,5.06.848,4.57-1,7-5.967,12.74-26.763,52.02-7,68,1-.67,2-1.33,3-2-1.125-37.99,13.216-68.42,49-64,9.3,1.15,24.321-3.49,27-1,22.045,23.89,13.1,102.02,43,115,4.315-5.46,9.269-11.27,10-20l-11-46q-9.5-27.99-19-56c4.709-1.73,17.047-20.73,13-27-3.357-5.21-8.427-1.2-11-9,0.667-.33,1.333-0.67,2-1,43.145-10.28,105.332,30.94,131,49,6.511,4.58,6.849,9.86,17,12q-0.5-1.5-1-3c-33.717-23.28-60.688-64.86-108-74l3-6c38.295,1.14,132.413,21.6,158-6-40.487,4.14-85.69-1.04-120-9-13.756-3.19-28.779-1.5-40-7v-1l2-3c25.107,4.28,58.093-29.14,73-41,41.917-33.35,69.4-69.83,97-118l48-64c-0.667-1.33-1.333-2.67-2-4-2.024-2.08-1-1.36-5-2q-24.5,25.995-49,52c-1.333-.67-2.667-1.33-4-2,5.205-36.6,42.2-85.07,65-106,11.357-10.423,30.751-15.732,39-29-21.353,5.723-46.987,40.23-61,41v-5q10.5-15,21-30c12.956-21.351,16.168-43.394,27-68l17-34c14.758-42.849,13.32-106.769,10-157-1.313-19.867,8.062-44.816,4-62h-2q-5.5,21.5-11,43c-9.989,40.192-13.949,70.19-34,98-9,.205-9.959,4.822-16,3l-2-3c6.009-36.67,23.769-64.991,36-95,8.081-19.827,10.3-40.112,16-62,4.361-16.748,13.482-48.043,8-67l-2,1c-7.585,28-15.773,55.926-29,78l-4-3c-2.511-6.7-5.883-9.917-4-16-4.629-1.077-4.048-1.806-7-4l-2,1c-1.168,4.375-2.075,7.142-6,9,7.66-44.055,22.093-88.54,31-135,2.858-14.908-2.3-26.362-5-39-1.653-7.753,3.658-23.209,4-34l-3,2-23,78-7,5-13,31c-5.364,12.652-6.563,24.949-14,35h-1c5.35-28.877,18.9-89.943,9-114l-3-1-3,2c-1.113,7.722-5.069,17.571-13,19-1.937-22.827,3.445-50.18,7-75,4.531-31.626-8.1-62.836-2-90l-7,2-7-51h-1c-0.4,22.212,5.44,43.5,3,64-1.795,15.08-27.367,52.134-37,62h-1q-0.5-1-1-2,3-46.995,6-94l-4-7c0.64-28.479,15.457-51.589,9-83h-1q-0.5,1-1,2c-9.79,9.976-6.827,33.453-17,43-4.649-30.365-2.935-49.159,1-79H792q-2.5-19-5-38h-1c-3.375,30.787,5.6,72.139-13,93l-2-3c-4.231-7.87-12.188-32.5-8-45,2.514-7.5,9.592-9.224,11-20l-5-1-11,4v-2q-2.5-10.5-5-21l-12-4-6,5c-9.7-9.212-6.913-37.875-19-44v2c-6.534,18.781,4.016,54.986,6,70,1.392,10.532-6.518,21.82-9,30l-2-1v-2c-6.137-13.5,1.493-32.624-4-45h-1c-10.314,10.95-6.891,24.519-14,40l-2-1-10-30q4-12.5,8-25l-2-1h-1c-2.711,9.329-9.2,21.376-18,25l-3-2c-0.412-24.674,8.8-35.3,12-52l-3-2c-13.389,5.2-16.41,25.008-22,38l-3-1-3-3c-1.859-42.481,14.132-108.213,32-136l-2-3h-1ZM400,182q1,8,2,16h3v-5Zm-65,68c-0.081,7.387,1.358,11.489,5,15v-5Q337.5,255,335,250ZM148,453l7,25,5-1v-1l-3-17Zm55,1c1.392,1.923.1,0.6,2,2Zm703,6v4l3-2Zm-20,11-2,2,2,2,2-2ZM109,787q4,9.5,8,19l4,1v-1C118.1,798.354,115.053,791.508,109,787Zm107,397,5,3c4.439-.58,4.668-0.77,7-3H216Zm439,164-4,6c14.011,44.47,66.947,66.68,118,72-0.333-.67-0.667-1.33-1-2-30.066-11.04-75.265-28.67-93-53-5.281-7.25-5.975-16.78-12-23h-8Z"/>
</svg>';
		} else if ( $svg === '19' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000">
<path style="fill:' . $f . '" d="M0,0H1000V1000H0V0ZM350,6l9,24,1-2,13-16-1-2ZM510,30q3,72.493,6,145l-45,27-3-7-1,2c-1.594,3.822-2.252,8.1-4,11l-59,36,59-21q-1,6-2,12l23-12-4-7,36-12q0.5,2.5,1,5l105-20-5-5ZM274,49l27,30C307.42,45.472,303.167,57.209,274,49Zm192,8q-7.5,16.5-15,33,7.5,28.5,15,57h1Q466.5,102,466,57Zm210,6-36,62,50,9Q683,98.5,676,63Zm99,26q0.5-12,1-24l-2,1L760,91ZM403,74L373,86l17,32h1C392.453,109.349,409.012,76.776,403,74Zm339,7-16,26v1h4l11-2Q741.5,93.5,742,81ZM966,92L820,183l76-27,26,29v-2q2.5-11,5-22h-2l-28-5q0.5-1,1-2l60-22C959.486,123.018,970.138,96.639,966,92ZM485,97q9,19.5,18,39l2-1c0.744-5.312,9.515-22.584,6-24Zm125,34,23,67,39-31q-0.5-1-1-2Zm-295,4-66,88-65-64,49,129,2-1,23-38v2l12,32h1Zm29,10-17,27,16-3Q343.5,157,344,145Zm84,0-19,24,21,57C430.243,212.63,433.044,150.673,428,145Zm405,1-29,6,2,3,9,7,20-16h-2ZM720,160l4,6q-6,31-12,62l33,3q-9-30.5-18-61h1v2l30,38,7-7,17-15v-1Zm-57,22L561,244l19-29c-36.051,22.951-44.743,32-102,21l3,4c17.011,7.341,43.9,29.96,51,48l4-6,40,31-31,25,2,1c6.59,3.443,57.361,12.961,60,11l5-7c2.733,1.661,4.189,5.268,6,2q7.5-12.5,15-25h9c-2.939-3.944-5.131-5.123-3-9l32-57H661v-1l7-13-17,13-10-1Q652,217,663,182Zm175,4q-2,12-4,24l-22,12v42l-41-8v1h2l68,40q-2.5,20-5,40l23-12-16-27,24,14-20,44-26-15c1.148-3.1,1.407-2.972,1-6l-27-13q9,19.5,18,39h2l4-14h1v2c4.607,7.727,20.517,52.1,19,59q-2.5,4-5,8l-44-5,32,25q-1,2-2,4c12.518-1.437,24.65,15.605,34,22l23-43-25-1v-3c7.052-22.107,12.628-26.716,27-40q-0.5-1-1-2l-9-5v-1h21q5.5,23.5,11,47c19.115,3.586,23.856,13.269,35,24v-6l53,19q-4.5-23-9-46l9-10-13-5-3-17-2,1-6,10-38-16c7.078,10.921,20.518,20.62,24,34l-7,8-2-1c-8.76-22.3-48.537-60.9-48-82l6,2q0.5-15.5,1-31l6,6q-2.5-15-5-30l-4,3q1.5-21,3-42v2l-20,41-65-14v-1l11-23h1q-0.5,2-1,4l43-11Zm-156,8q-2.5,12-5,24l5-4,15-20H682Zm7,432,60,3,5-12-7-7H714v-1l2-3,15-11c-2.6-3.046-4.258-4.855-9-6l-50,9v-1l22-39-9-9,20-26,14,1c-1.221-5.849-4.206-11.736-2-15l9-13H711c-2.732-11.348-10.8-26.035-9-37,9.413-3.382,24.63-4.491,37-5l-3-4-16-12,12-42h-1v2l-21,32c-3.911-2.081-6.3-3.559-8-8,6.472-17.389,18.7-24,33-33h1v20l49-39-5-12,7-6c-5.093,1.4-6.061,3.008-9-1l-6-14,11-13v-1c-6.964.484-11.666,0.476-14-4l13-46-23,11-8-3q-5.5-14.5-11-29h-1c0.425,11.307.19,20.9-4,27l-3,2-2-1-38-63c-0.422,15.342-13.913,112.36-19,119l-9-32h-1q-3.5,24.5-7,49-2.5-12.5-5-25l-2,1-17,39,14-5v1c-9.856,16.881-19.8,41-34,54-17.516-2.824-20.881-23.432-34-36,0.42,14.46,4.02,35.86-2,41,3.454,3.609,4.221,5.193,4,13l-3,2h-3l-13-14h-2q-0.5,10-1,20c2.827,1.819,1,1.222,5,1q-0.5,1-1,2l-22,12-11-12c3.144-2.473,2.51-.886,0-4l-4-7h-2l-8,17-4-4c-5.3-2.677-4.169-7.066-8-10-3.12-2.39-10.617-2.009-14-7l-17-49-8-2-21-37v2l-9,24-16-3,7-1-4-4-5-8,1-3,10-7h1v20l2-1c4.308-14.105,15.625-33.281,27-41-2-3.6-1.689-1.942-2-6l14-22,3,9,2-4h2c2.385,12.171,9.5,19.869,17,27q-2.5,5-5,10l-24,3,1,2c26.5,2.591,33.213,17.665,49,30q-0.5-12.5-1-25c10.929-5.692,13.739-4.967,25-1l-7-7v-1l23-9v-1l-33,4-9-8q-1.5-23-3-46v2q-6,15.5-12,31l-20-16,12-36c-42.232,17.113-31.878,4.369-61-18v51c-5.4.177-6.727,1.41-10,6l3,14-13-6-16,16v-2L314,206h-1q1,21.5,2,43l-25,4,3,4c5,2.645,5.586,6.166,10,4l12-8q2,45,4,90c-15.41,5.068-66.392,64.392-81,79L30,630,397,998,692,704v-1Q690.5,664.5,689,626ZM350,208q2.5,16.5,5,33l19,8ZM200,268q6,56.994,12,114l36-37Zm89,66q0.5-26,1-52l-29,49Zm116-13c3.686,3.154,5.659,10.735,7,16-4.69.138-6.841,0.184-9-2Q404,328,405,321ZM131,352l72,73c-4.478-12.411-16.8-57.676-25-64Zm603,2h3c0.326,5.267.471,10.518-2,13l-48,14c-1.55-3.831-3.035-6.978-1-9Zm-140,5-8,18-10-1,26,29h1q2.5-12,5-24l-19-4h2l18-13C606.076,360.8,599.258,359.676,594,359Zm60,0c3.037,2.8,13.689,13.92,14,19,7.032-1.943,7.431,1.024,14,4l-2,1-22,7C656.465,380.3,651.959,368.168,654,359ZM395,371l7,1q2.5,8,5,16l-34,8,13-23Zm399,5-11,8,9,22h1C793.6,398.552,797.448,379.411,794,376Zm-371,7c2.854,3.053,5.3,6.585,5,10l-15,5Zm66,14,18,31,30-20-8,18,20-16-8-13C522.513,403.728,508.869,400.477,489,397Zm286,58q-0.5-26.5-1-53v2l-27,48ZM430,408c3.22,7.755-.65,66.449-4,74-8.353-8.713-35.568-36.664-31-46Zm27,1c13.845,10.283,27.056,23.551,30,45l-30,29V409Zm205,5c25.345,11.75,4.375,23.927-3,40h-2q-2.5-7.5-5-15l9,2v-1l-8-16,12,2ZM69,426L28,480l20,46Zm558,0v5l-9,1Zm283,0L814,570l96-33v1q-7.5,17-15,34l34,42q8-76.493,16-153v2l-30,65h-1q-1-35.5-2-71l11,2v-1c-3.023-5.672-5.086-11.67-12-11Q910.5,436.5,910,426ZM695,446l2,3c-1.094,4.986-3.265,8.63-7,11Q692.5,453,695,446Zm-85,11,9,7c-6.19,16.983-11.4,28.693-21,41h7q-1,3.5-2,7h-5l-18-2v-3q0.5-1,1-2h5l-4-4v-1l14-40Zm171,3-36,30,29,5q-0.5,8.5-1,17l21-12-13-22V460Zm-84,3c3.1,1.952-3.887,29.136-6,35H679C681.418,481.979,686.958,471.44,697,463Zm-195,1,15,9v2l-30,17,2-3Zm124,39h12v-1l-13-13v-1q-0.5-9-1-18l31,24-3,17,5-4,3,10h-8l-26-3V503Zm223-22-64,52-71-7q0.5,1,1,2l39,30q-0.5,1-1,2l-26,21c12.205,1,56.31,14.369,62,10ZM460,492l7,9h-3l-2-1C460.562,496.086,459.6,495.684,460,492Zm-54,15h3l3,12-13-9Zm261,31c6.007,5.446,5.18,18.217,12,20-2.4,5.411-5.328,13.688-10,17C664.985,554.969,659.957,557.322,667,538Zm-133,1,5,4h-9l2-3Zm28,22c5.771,2.393,13.069,7.6,15,14l-32-2h2Zm45,36,11,8-15,33-2-1-6-17Zm106,44q7.5,33,15,66l46,14Zm-38,10c4.036,3.084,5.661,10.421,7,16H671Q673,659,675,651Z"/>
</svg>';
		} else if ( $svg === '20' ) {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 387">
<path style="fill:' . $f . '" d="M0,0H1000V387H0V0ZM495,5c-7.3,2.97-14.8,4.543-21,7,5.007,9.805-.191,35.669-9,44-27.1-1.891-61.721-10.965-93-6-17.887,2.84-41.324,8.306-63,5-19.533-2.979-61.829-16.863-80-11l3,7-11,3c-3.665-17.566-74.976-26.371-102-26l1,2,52,22v1L48,22C59.524,36.773,79.6,45.23,99,52c7.767,2.711,17.387,3.162,23,8C82.754,55.378,51.1,42.309,18,33L29,45,85,71,10,53l2,4c9.229,17.423,38.715,15.012,58,23v1L2,72l2,8L50,92c-13.026-.5-25.129-0.487-32,5l4,5c15.529,4.319,35.531.631,54,4v1l-7,3,2,3c17.048,5.186,50.523-2.477,65,3h-2l-45,7,2,1c14.077,10.7,42.363,6.186,62,4v1h-2l-21,7,3,4c6.608,2.482,19.146,2.98,27,7l16,18h9l9,13,18,7c15.01,9.131,12.794,10.94,34,15l4,9c9.355,1.717,19.414-3.636,27-2l19,12,20-4,7,7c11.746,5.657,23.344-1.825,33-4,13.037,21.9,26.979,2.663,43,4,0.807,6.662,3.382,9.349,7,13,11.682-6.18,19.813.019,36-2l3-7,3,2,3,4,8-4-23,42c-14.459,20.4-43.2,37.726-36,73h4l15-9q-2.5,9-5,18c10.133-3.726,18.919-16.236,23-26h2v1c-2.579,6.773-7.746,19.132-4,28l3,4,3-2c6.733-3.441,7.94-11.011,13-16-0.677,8.9-3.368,17.85,0,25,7.2,2.7,10.385.944,18-3l3-10,7,16c9.51-2.078,12.294-12.665,13-23h1c1.324,9.1,5.3,14.293,12,18,8.492-4.268,7.783-8.565,12-17h1c1.282,9.086,5.061,17.42,11,22l2-1,6-18q0.5,1,1,2c4.9,8.907,6.307,12.868,18,15l5-9q-2-10-4-20l3,2a27.483,27.483,0,0,0,15,16l3-2q0.5-1,1-2l-7-29,2,1c3.877,9.227,13.627,20.2,23,24l-6-19c6.206,4.634,9.659,9.142,20,10,3.808-36.867-22.389-48.675-38-69l-26-43,1-1,8,5q1-4,2-8c15.2,17.854,17.711,2.586,33,3l9,5c4.713-1.252,5.154-10.6,7-15,5.9,3.675,20.156,11.312,26,8,8.6-2.595,11.343-6.951,17-12,22.526,10.5,26.123-.352,43-4,19.23,6.752,18.941-5.4,33-10,7.47-2.445,16.159,5.928,25,2,4.406-1.958,3.82-7.863,7-10l17-2,11-11c11.9-9.12,26.8-17.76,40-25l13-17c9.657-7.514,22.4-2.588,30-12q-0.5-1-1-2c-6.59-.223-18.409-2.191-22-6,18.3,5.38,53.97,3.037,64-7-11.264-1.259-43.281-3.168-45-7,19.309,5.657,55.375,3.546,64-8V92l-12-3c22.409,0.5,46.683,1.338,60-7q0.5-2,1-4h-2c-6.863-3.662-18.094-3.041-27-2l1-2,41-13q1-3,2-6c-25.575-.325-44.068,7.4-69,11,19.69-14.275,46.681-8.435,60-29V36c-19.58,3.094-59.48,22.758-76,19,23.7-6.677,53.39-20.5,67-38l-1-1c-30.383,11.931-63.016,27.09-101,30l1-2c26.44-4.664,57.114-18.991,70-38L825,42l53-28c-48.239-.9-79.207,14.5-112,30l3-10c-29.753,0-50.811,9.1-77,14-34.39,6.434-64.336-5.2-98-1-16.806,2.094-53.445,10.373-63,5C524.545,30.247,517.85,11.455,495,5Z"/>
</svg>';
		}

		return $svg;
	}

}