<div class="xl:max-w-screen-xl max-w-screen-lg md:max-w-screen-md md:m-auto">

	<div class="md:my-3 flex-col justify-center items-center px-3 md:p-0 mt-6 md:mt-3 md:mx-3">


		<div class="rounded-md basis-8/12 h-auto flex flex-col md:w-[97%] m-auto">



			<div class="mt-10 border-2 border-slate-200 rounded-md p-3 mb-10">
				<span class="text-gray-900 text-xl font-bold">بخش پرسش و پاسخ</span>

				<?php
				$html5 = 'xhtml';
				$required_attribute = ($html5 ? ' required' : ' required="required"');
				$checked_attribute  = ($html5 ? ' checked' : ' checked="checked"');
				$required_indicator = ' ' . wp_required_field_indicator();
				$required_text      = ' ' . wp_required_field_message();

				$fields = array(

					'author' => sprintf(
						'<div class="md:flex md:flex-nowrap gap-2 p-0 justify-between"> 
			<div class="basis-full md:basis-5/12"> <p class="comment-form-author">%s %s</p>',
						sprintf(
							' <span class="block font-bold text-sm pb-1 text-slate-700 mt-3">نام و نام خانوادگی
				<span class="text-red-600">* </span>
				</span> ',
						),
						sprintf(
							'<input placeholder="مثال: محمدرضا بهداروند" class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3" id="author" name="author" type="text" value="%s" size="30" maxlength="245" autocomplete="name"%s />

				</div>',
							esc_attr($commenter['comment_author']),
							($req ? $required_attribute : '')
						)
					),
					'email'  => sprintf(
						'<div class="basis-full md:basis-7/12 w-full"> <p class="comment-form-email">%s %s</p>',
						sprintf(
							' <span class="block font-bold text-sm pb-1 text-slate-700 mt-3"> آدرس ایمیل 
				<span class="text-red-600">* </span>
				</span>',
							($req ? $required_indicator : '')
						),
						sprintf(
							'<input placeholder="example@gmail.com" class="text-left flex caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3" id="email" name="email" type="email value="%s" size="30" maxlength="100" aria-describedby="email-notes" autocomplete="email"%s /> 

				</div> </div>',
							esc_attr($commenter['comment_author_email']),
							($req ? $required_attribute : '')
						)
					),

				);

				?>



				<?php

				$costomer = wp_get_current_commenter();
				$req = get_option('require_name_email');
				$aria_req = ($req ? "aria-required='true' " : '');
				$consent = empty($commenter['comment_author_email']) ? '' : $checked_attribute;

				$args = array(
					'id_form' => 'commentform',
					'class_form' => 'comment_form',
					'id_submit' => 'submit',
					'class_submit' => 'cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white mt-0 focus:border-transparent text-base p-2 flex justify-center items-center rounded-md',
					'name_submit' => 'ثبت دیدگاه شما',
					'title_reply' => '<span>  </span>',
					'title_reply_to' => '<span> پاسخ دادن به %s </span>',
					'cancel_reply_link' => '<span> حذف دیدگاه </span>',
					'label_submit' => 'ثبت دیدگاه شما',
					'format' => 'html5',
					'comment_field' => '<textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" placeholder="در اینجا متن خود را تایپ کنید..." class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-40 bg-slate-50 p-3 my-6"></textarea>',
					'must_log_in' => '<p class="must-log-in">' .
						sprintf(
							__('
				<span class="text-gray-900 font-bold">
				 لطفا برای نوشتن دیدگاه وارد شوید.
				</span> 
				<a href="%s" class="bg-blue-600 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-blue-200">ورود یا ثبت نام</a>
				'),
							wp_login_url(apply_filters('the_permalink', get_permalink()))
						) . '</p>',

					'logged_in_as' => '' .
						sprintf(
							__('
				<div class="flex items-center flex-wrap">

					<div class="font-bold md:basis-full">  %1$s عزیز الان وارد سایت شدی. </div>

					<div class="flex items-center justify-center md:justify-end w-full mt-3 md:mt-0">
						<span class="bg-blue-600 flex justify-center items-center md:basis-auto basis-1/2 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-blue-200"> <a href="%2$s">ورود به پنل کاربری </a> </span>
						<span class="bg-red-600 flex justify-center items-center md:basis-auto basis-1/2 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-red-200" > <a href="%3$s">خروج از حساب </a> </span>
					</div>
				</div>
				'),

							$user_identity,
							get_edit_user_link(),
							wp_logout_url(apply_filters('the_permalink', get_permalink())),
						),
					'comment_notes_before' => sprintf(
						'<p class="comment-notes">%s%s</p>',
						sprintf(
							'<span id="email-notes">
				از اینکه بتوانیم به شما کمک کنیم خوشحال خواهیم شد.
				</span>',
						),
						$required_text
					),


					'fields'  => apply_filters('comment_form_default_fields', $fields),

				);

				if (has_action('set_comment_cookies', 'wp_set_comment_cookies') && get_option('show_comments_cookies_opt_in')) {
					$consent = empty($commenter['comment_author_email']) ? '' : $checked_attribute;

					$fields['cookies'] = sprintf(

						'
			<div class="flex justify-start items-center h-14 my-5 md:my-3" >
			<p class="comment-form-cookies-consent flex">%s %s</p>',
						sprintf(
							'
				<input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"%s class="cursor-pointer ml-2 w-6 h-6 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
				',
							$consent
						),
						sprintf(
							'<label for="wp-comment-cookies-consent" class="cursor-pointer">
				میخواهم نام و ایمیل من را ذخیره کنید تا مجدد وارد نکنم.
				</label> 
				
				</div>',
						)
					);

					// Ensure that the passed fields include cookies consent.
					if (isset($args['fields']) && !isset($args['fields']['cookies'])) {
						$args['fields']['cookies'] = $fields['cookies'];
					}
				}



				comment_form($args);




				if (get_comments_number() > 0) { ?>
					<div class="text-gray-900 text-xl font-bold my-8 py-5">پرسش و پاسخ های قبلی</div>
				<?php }


				wp_list_comments(
					array(
						'style' => 'ol',
						'max_depth' => '5',
						'callback' =>  'list_comment_template',

					)
				);

				function list_comment_template($comment, $args, $depth)
				{
				?>
					<div class="mt-5 p-3 relative comment__befor_into_<?php echo $depth; ?> border-2 border-slate-200 rounded-md">

						<div class="border-b-2 border-slate-200 pb-3 flex justify-between items-center comment__befor_into_bg_<?php echo $depth; ?>">

							<div class="w-full">
								<div class="flex justify-center items-center">

									<div class="basis-1/4 md:basis-1/6">
										<img class="w-16 h-w-16 rounded-full shadow-md border-2 border-slate-200" src="<?php echo get_avatar_url($comment->comment_author_email); ?>" alt="">
									</div>

									<div class="basis-3/4 md:basis-5/6 w-full text-gray-900 mr-3 overflow-scroll md:overflow-visible">
										<div class="">
											<span class="font-bold text-base block w-max mb-1">
												<?php comment_author(); ?>
											</span>
											<span class="block text-sm w-max">
												<?php

												echo ' ' . get_comment_time('Y/m/d ساعت: H:i');
												?>
											</span>
										</div>
									</div>

								</div>
							</div>

							<?php if ($depth >= 5) {
								echo '';
							} else { ?>

								<!-- <div class="">
						<button class="bg-slate-200 text-base text-gray-900 p-2 flex justify-center items-center rounded-md absolute top-[0.10rem] left-[0.10rem]">
							<span class="mr-2">
								<?php comment_reply_link(array_merge(
									$args,
									array(
										'reply_text' => __(' <span class="flex justify-center items-center" >

									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 ml-2 hidden md:block">
									<path stroke-linecap="round" stroke-linejoin="round" d="M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3" />
								    </svg>
									پاسخ
									</span>
								
									', 'textdomain'),
										'depth'      => $depth,
										'max_depth'  => $args['max_depth']
									)
								)); ?>

							</span>
						</button>
					</div> -->

							<?php }; ?>




						</div>
						<div class="py-5">
							<p>
								<?php comment_text() ?>
							</p>
							<?php if ($comment->comment_approved == 0) { ?>
								<em>پیام شما در دست بررسی است و قبل از انتشار فقط برای شما نمایش داده می شود</em>
							<?php } ?>
						</div>
					</div>
				<?php
				}









				?>


			</div>



		</div>


	</div>