<?php

if (is_home()) {
    get_template_part('template-blog');
} else { ?>

    <?php get_header(); ?>



    <?php
    // تابع برای تشخیص نوع دستگاه
    function isMobile()
    {
        return preg_match('/(android|ipad|iphone|ipod)/i', $_SERVER['HTTP_USER_AGENT']);
    }

    // تابع برای تشخیص عرض صفحه
    function getScreenWidth()
    {
        return isset($_SERVER['HTTP_X_RESOLUTION']) ? (int)$_SERVER['HTTP_X_RESOLUTION'] : 0;
    }

    // شرط بر اساس نوع دستگاه و عرض صفحه
    if (isMobile() && getScreenWidth() < 600) {
        // موبایل
        include('template-parts/slider-width/slider-mobile-main-page.php');
    } else {
        // دسکتاپ
        include('template-parts/slider-width/slider-desktop-main-page.php');
    }  ?>



    <?php
    // شرط بر اساس نمایش دادن دسته بندی محصولات یا نمایش ندادن آنها
    if ($data_var_option_theme['display-product-category-in-front-page'] == 1) { ?>

        <!-- نمایش دسته بندی محصولات ووکامرس -->
        <?php include('template-parts/category-product/category-product-not-slide.php'); ?>

    <?php } ?>



    <?php
    // شرط بر اساس نمایش دادن دسته بندی مقالات یا نمایش ندادن آنها
    if ($data_var_option_theme['display-post-category-in-front-page'] == 1) { ?>

        <!-- نمایش دسته بندی مقالات وردپرس -->
        <?php include('template-parts/category-product/category-post-not-slide.php'); ?>


    <?php } ?>









    <div class="w-screen bg-cover px-5 mt-5">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto flex justify-center items-center">


            <div class="w-full flex flex-col md:flex-row text-xl justify-between items-center mb-5 px-4 py-2  h-auto font-bold bg-slate-100 rounded-md ring-4 ring-gray-800 shadow-md">



                <div class="">




                    <?php
                    if ($data_var_option_theme['bg__title_call_woo']) {
                    ?>

                        <p class="mb-3 font-extrabold text-2xl">
                            <?php echo $data_var_option_theme['bg__title_call_woo'] ?>
                        </p>

                    <?php

                    } else {
                    ?>
                        <p class="mb-3 font-extrabold text-2xl">
                            اگر سوالی دارید؟ یا قصد خرید دارید! با ما تماس بگیرید.


                        </p>
                    <?php
                    };
                    ?>



                    <?php
                    if ($data_var_option_theme['editor__title_call_woo']) {
                    ?>
                        <span class="text-gray-800 text-lg font-medium">
                            <?php echo $data_var_option_theme['editor__title_call_woo'] ?>
                        </span>

                    <?php

                    } else {
                    ?>
                        <span class="text-gray-800 text-lg font-medium">
                            شما می‌توانید هر گونه درخواست و همچنین انتقاد یا پیشنهادی را با ما در میان بگذارید.
                        </span>
                    <?php
                    };
                    ?>






                </div>



                <div class="">
                    <a class="w-max h-max my-5 p-5 rounded-md bg-gray-800 text-base font-normal text-white flex justify-center items-center" href="tel:+98<?php echo $data_var_option_theme['bg__title_call_number'] ?>">


                        <?php
                        if ($data_var_option_theme['bg__title_call_number_text']) {
                        ?>
                            <?php echo $data_var_option_theme['bg__title_call_number_text'] ?>
                        <?php

                        } else {
                        ?>
                            مشاوره سریع و رایگان با کارشناسان

                        <?php
                        };
                        ?>


                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 mr-2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 002.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106c-.44-.11-.902.055-1.173.417l-.97 1.293c-.282.376-.769.542-1.21.38a12.035 12.035 0 01-7.143-7.143c-.162-.441.004-.928.38-1.21l1.293-.97c.363-.271.527-.734.417-1.173L6.963 3.102a1.125 1.125 0 00-1.091-.852H4.5A2.25 2.25 0 002.25 4.5v2.25z"></path>
                        </svg>
                    </a>

                </div>

            </div>


        </div>
    </div>






    <?php
// بررسی اینکه آیا هر سه متغیر آرایه مقدار دارند یا خیر
if (
    !empty($data_var_option_theme['introducing_important_products_for_home_img']) &&
    !empty($data_var_option_theme['introducing_important_products_for_home_text']) &&
    !empty($data_var_option_theme['introducing_important_products_for_home_description'])
    
) {
?>


    <div class="w-screen bg-cover px-5">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto flex justify-center items-center relative flex-col pb-8">


            <div class="flex flex-col md:flex-row md:my-10">





                <div class="w-full md:w-3/12">
                    <div class="md:pe-8 sticky top-14 text-center md:text-start pb-3 md:p-0">

                        <span class="my-3 relative h-full block w-full">
                            <span class="w-4 h-4 rounded-full bg-black absolute left-[-42px] top-0 hidden md:block"></span>
                        </span>

                        <?php
                        if ($data_var_option_theme['introducing_important_products_for_home_title']) {
                        ?>
                        <span class="text-xl font-bold text-center pb-1">  <?php echo $data_var_option_theme['introducing_important_products_for_home_title'] ?></span>
                          
                        <?php

                        } else {
                        ?>
                       <span class="text-xl font-bold text-center pb-1">محصولات ما را بهتر بشناسید</span>


                        <?php
                        };
                        


                        if ($data_var_option_theme['introducing_important_products_for_home_title_des']) {
                            ?>

                             <p>
                                <?php echo $data_var_option_theme['introducing_important_products_for_home_title_des'] ?>
                            </p>

                            <?php
    
                            } 
    
                            
                        ?>





                    </div>
                </div>





    <div class="w-full md:w-9/12 relative">
        <?php
        // تعداد آرایه‌ها
        $numArrays = count($data_var_option_theme['introducing_important_products_for_home_description']);

        // حلقه برای نمایش آرایه‌ها
        for ($i = 0; $i < $numArrays; $i++) {
        ?>
            <div class="flex flex-col md:flex-row relative border-t-2 border-slate-200 md:border-0 pt-5">
                <div class="flex flex-col w-full md:w-3/4 justify-center">
                    <span class="w-1 h-[102%] rounded-full bg-black absolute right-0 top-3 hidden md:block"></span>
                    <span class="font-bold px-4"> 
                        <?php echo $data_var_option_theme['introducing_important_products_for_home_text'][$i]; ?> 
                    </span>
                    <span class="my-3 relative h-1 bg-gradient-to-l from-black to-primary/0 duration-300 to-primary/0 w-full hidden md:block">
                        <span class="w-6 h-6 rounded-full bg-black absolute right-[-10px] top-[-10px] hidden md:block"></span>
                    </span>
                    <p class="px-4 relative">
                        <?php echo $data_var_option_theme['introducing_important_products_for_home_description'][$i]; ?>
                    </p>
                </div>
                <div class="flex w-full md:w-1/4 justify-center items-center">
                    <img class="object-cover w-64 h-64" src="<?php echo $data_var_option_theme['introducing_important_products_for_home_img'][$i]['url']; ?>" />
                </div>
            </div>
        <?php } ?>
    </div>




            </div>


        </div>

    </div>
    
    <?php 
} // پایان شرط
?>




    <div class="w-screen bg-cover p-5 bg-slate-50">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

            <div class="flex flex-col w-full justify-center items-center text-center mb-5">



                <?php
                if ($data_var_option_theme['bg__title__home']) {
                ?>
                    <span class="text-base text-gray-500 font-bold h-max mb-3">
                        <?php echo $data_var_option_theme['bg__title__home'] ?>
                    </span>
                <?php

                } else {
                ?>
                    <span class="text-base text-gray-500 font-bold h-max mb-3">محبوب ترین مقالات</span>
                <?php
                };
                ?>



                <?php
                if ($data_var_option_theme['editor__title__home_des']) {
                ?>
                    <span class="text-xl text-gray-900 font-bold h-max mb-3">
                        <?php echo $data_var_option_theme['editor__title__home_des'] ?>
                    </span>
                <?php

                } ?>



            </div>


      <div dir="rtl" class="swiper mySwiper-post-slider ">
    <div class="swiper-wrapper">

        <?php
        // تعداد کاراکتر‌ها در هر کلمه
        $charactersPerWord = 5;

        // میانگین سرعت خواندن کلمه در دقیقه
        $averageReadingSpeed = 225;

        $args_top_blog_grid = array(
            'offset' => 0,
            'posts_per_page' => 7,
        );

        $the_query_top_blog_grid = new WP_Query($args_top_blog_grid);
        ?>

        <?php if ($the_query_top_blog_grid->have_posts()) : ?>
            <?php while ($the_query_top_blog_grid->have_posts()) : $the_query_top_blog_grid->the_post(); ?>

                <div class="swiper-slide">
                    <?php
                    $content = get_the_content();

                    // تعداد کاراکتر‌های محتوا را محاسبه
                    $totalCharacters = mb_strlen($content);

                    // محاسبه تعداد کلمه‌ها
                    $totalWords = ceil($totalCharacters / $charactersPerWord);

                    // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                    $timeInMinutes = $totalWords / $averageReadingSpeed;

                    // تبدیل به ثانیه
                    $timeInSeconds = $timeInMinutes * 60;

                    // اصلاح تبدیل به عدد صحیح برای جلوگیری از هشدار Deprecated
                    $timeInSeconds = (int) round($timeInSeconds);

                    // تبدیل ثانیه به دقیقه و ثانیه
                    $minutes = floor($timeInSeconds / 60);
                    $seconds = $timeInSeconds % 60;
                    ?>

                    <a class="cursor-pointer text-right" href="<?php the_permalink(); ?>">
                        <div class="relative overflow-hidden aspect-w-16 aspect-h-9 border-2 rounded-md border-slate-200 mb-4 inline-block hover:shadow-lg">
                            <div class="relative">

                                <?php
                                $alt_text = get_the_title(); // اگر alt تعریف نشده، حداقل عنوان رو قرار بدیم
                                if (has_post_thumbnail()) { ?>
                                    <img class="w-full h-40 object-cover rounded-md" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } else { ?>
                                    <img class="w-full h-40 object-cover rounded-md" src="<?php echo get_template_directory_uri(); ?>/inc/img/replace.webp" alt="<?php echo esc_attr($alt_text); ?>">
                                <?php } ?>

                                <div class="flex items-center justify-center absolute top-3 left-3 text-xs text-gray-800 font-thin backdrop-blur-sm bg-white/50 h-6 w-max px-1 rounded-md">
                                    <span class="text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                                        <?php
                                        if ($minutes > 0 && $seconds > 0) {
                                            echo "زمان خواندن: $minutes دقیقه و $seconds ثانیه";
                                        } elseif ($minutes > 0 && $seconds == 0) {
                                            echo "زمان خواندن: $minutes دقیقه";
                                        } elseif ($minutes == 0) {
                                            echo "زمان خواندن: $seconds ثانیه";
                                        }
                                        ?>
                                    </span>
                                </div>
                            </div>
                            <div class="h-40 text-gray-900 text-base bg-slate-50 p-2 flex flex-col justify-around items-start">
                                <span class="min-h-[3.1rem] font-bold overflow-hidden text-ellipsis whitespace-normal line-clamp-2">
                                    <?php the_title(); ?>
                                </span>
                                <div class="w-full pb-4 bt-2">
                                    <p class="overflow-hidden text-ellipsis whitespace-normal line-clamp-3">
                                        <?php echo get_the_excerpt(); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>

    <div class="swiper-pagination pagination_post_page-main"></div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
</div>




        </div>

    </div>





    <div class="w-screen px-5 my-5">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

            <div class="block md:hidden w-full h-full bg-slate-50 rounded-md overflow-hidden">

                <a href="<?php if ($data_var_option_theme['bg__title_mdu_home_page_desktop_url_tag_a'][$i]) {
                                echo esc_url($data_var_option_theme['bg__title_mdu_home_page_desktop_url_tag_a'][$i]);
                            } else {
                                echo "#";
                            } ?>">
                    <?php
                    if ($data_var_option_theme['bg__title_mdu_home_page_mobile']['url']) {
                    ?>
                        <img class="" src="<?php echo $data_var_option_theme['bg__title_mdu_home_page_mobile']['url'] ?>" alt="<?php echo esc_attr($alt_text); ?>">
                    <?php } ?>

                </a>


            </div>

            <div class="hidden md:block w-full h-full bg-slate-50 rounded-md overflow-hidden">

                <a href="<?php if ($data_var_option_theme['bg__title_mdu_home_page_desktop_url_tag_a'][$i]) {
                                echo esc_url($data_var_option_theme['bg__title_mdu_home_page_desktop_url_tag_a'][$i]);
                            } else {
                                echo "#";
                            } ?>">

                    <?php
                    if ($data_var_option_theme['bg__title_mdu_home_page_desktop']['url']) {
                    ?>
                        <img class="" src="<?php echo $data_var_option_theme['bg__title_mdu_home_page_desktop']['url'] ?>" alt="<?php echo esc_attr($alt_text); ?>">
                    <?php } ?>

                </a>

            </div>

        </div>

    </div>







    <div class="w-screen p-5 bg-top md:bg-left bg-slate-50">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

            <div class="flex flex-col w-full justify-center items-center text-center mb-7">


                <?php
                if ($data_var_option_theme['bg__title__home_work']) {
                ?>
                    <span class="text-base text-gray-500 font-bold h-max mb-3">
                        <?php echo $data_var_option_theme['bg__title__home_work'] ?>
                    </span>
                <?php

                } else {
                ?>
                    <span class="text-base text-gray-500 font-bold h-max mb-3">همکاری با شرکت ها</span>
                <?php
                };
                ?>



                <?php
                if ($data_var_option_theme['editor__title__home__work']) {
                ?>
                    <span class="text-xl text-gray-900 font-bold h-max">
                        <?php echo $data_var_option_theme['editor__title__home__work'] ?>
                    </span>
                <?php

                } else {
                ?>
                    <span class="text-xl text-gray-900 font-bold h-max">با افتخار با شرکت های بزرگ همکاری های محکمی داریم</span>
                <?php
                };
                ?>



            </div>

            <div dir="rtl" class="swiper mySwiper-brand ">
                <div class="swiper-wrapper">

                    <?php
                    // تعداد آرایه‌ها
                    $numArrays = count($data_var_option_theme['img_slider_mobile__home__work']);
                    // حلقه برای نمایش آرایه‌ها
                    for ($i = 0; $i < $numArrays; $i++) {
                    ?>

                        <div class="swiper-slide w-full h-[200px] relative">
                            <div class="flex items-center h-full w-full p-1">
                                <img class="w-full h-auto overflow-hidden rounded-full shadow-md" src="<?php echo $data_var_option_theme['img_slider_mobile__home__work'][$i]['url']; ?>" alt="<?php
                                                                                                                                                                                                if ($data_var_option_theme['img_slider_mobile__home__work_text']) {
                                                                                                                                                                                                    echo $data_var_option_theme['img_slider_mobile__home__work_text'];
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    echo "تصویر لوگو همکاران";
                                                                                                                                                                                                }
                                                                                                                                                                                                ?>" />
                            </div>
                        </div>

                    <?php } ?>

                </div>
            </div>


        </div>

    </div>


    <div class="w-screen px-5 my-5">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">


            <div class="flex justify-center items-center gap-y-5 flex-wrap flex-col md:flex-row md:flex-nowrap md:gap-5">




                <?php
                // تعداد آرایه‌ها
                $numArrays = count($data_var_option_theme['img_slider_mobile__home__work_end_page']);

                // حلقه برای نمایش آرایه‌ها
                for ($i = 0; $i < $numArrays; $i++) {
                ?>

                    <div class="text-white text-center w-full md:w-1/2 h-auto flex flex-col justify-center items-center">
                        <div class="w-full h-full bg-slate-50 rounded-md overflow-hidden">
                            <a href="<?php if ($data_var_option_theme['img_slider_mobile__home__work_text_end_page_url'][$i]) {
                                            echo esc_url($data_var_option_theme['img_slider_mobile__home__work_text_end_page_url'][$i]);
                                        } else {
                                            echo "#";
                                        } ?>">
                                <img class="w-full h-auto overflow-hidden shadow-md" src="<?php echo $data_var_option_theme['img_slider_mobile__home__work_end_page'][$i]['url']; ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                            </a>

                        </div>
                    </div>

                <?php } ?>





            </div>





        </div>

    </div>




    <div class="w-screen bg-cover p-5 bg-top md:bg-left bg-slate-50">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto relative">

            <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

                <div class="flex flex-col w-full justify-center items-center pb-5">



                    <?php
                    if ($data_var_option_theme['bg__title__home_comment-user']) {
                    ?>
                        <span class="text-xl text-gray-900 font-normal h-max block text-center">
                            <?php echo $data_var_option_theme['bg__title__home_comment-user'] ?>
                        </span>
                    <?php

                    } else {
                    ?>
                        <span class="text-xl text-gray-900 font-normal h-max block text-center">نظرات برخی از خریداران درباره </span>
                    <?php
                    };
                    ?>




                    <?php
                    if ($data_var_option_theme['editor__title__home___comment-user']) {
                    ?>
                        <span class="text-xl text-gray-900 font-bold h-max block pt-3 text-center">
                            " <?php echo $data_var_option_theme['editor__title__home___comment-user'] ?> "
                        </span>
                    <?php

                    } else {
                    ?>
                        <span class="text-xl text-gray-900 font-bold h-max block pt-3 text-center">"<?php bloginfo() ?>"</span>
                    <?php
                    };
                    ?>




                </div>

                <div class="swiper mySwiper-comment h-auto bg-white rounded-md overflow-hidden">
                    <div class="swiper-wrapper">


                        <?php
                        // تعداد آرایه‌ها
                        $numArrays = count($data_var_option_theme['img_slider__home___comment-user']);
                        // حلقه برای نمایش آرایه‌ها
                        for ($i = 0; $i < $numArrays; $i++) {
                        ?>



                            <div class="swiper-slide h-52 w-auto">
                                <div class="w-full h-full flex justify-center items-center bg-white">
                                    <div class="w-[80%] flex flex-col items-center justify-center">

                                        <p class="text-gray-900 text-center h-auto py-5 max-h-72 md:max-h-40 overflow-hidden flex justify-center items-center font-medium text-base">
                                            <?php echo $data_var_option_theme['img_slider__home___comment-user'][$i]; ?>
                                        </p>
                                        <span class="font-bold text-lg text-center mb-14 block pt-3 border-t-2 border-slate-200 w-max">
                                            <?php echo $data_var_option_theme['img_slider__home___comment-user-name'][$i]; ?>
                                        </span>

                                    </div>

                                </div>
                            </div>

                        <?php } ?>




                    </div>

                    <div class="swiper-pagination"></div>
                </div>






            </div>

        </div>

    </div>





    <div class="w-screen px-5 my-5">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">


            <div class="gap-y-5 flex-wrap flex-col md:flex-row md:flex-nowrap md:gap-5">



                <div class="flex flex-col w-full justify-center items-center text-center mb-7">
                    <span class="text-base text-gray-500 font-bold h-max mb-3">شبکه های اجتماعی میاناب</span>
                    <span class="text-xl text-gray-900 font-bold h-max">ما را در شبکه های اجتماعی دنبال کنید</span>
                </div>


                <div class="text-center md:text-end mt-4 mb-4 h-auto md:mt-0 md:mb-0 md:order-2 flex gap-5 flex-wrap md:h-auto items-center justify-center md:w-full">




                    <?php if ($data_var_option_theme['social_network_twitter']) { ?>
                        <a href="https://x.com/<?php echo $data_var_option_theme['social_network_twitter']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M18.42,14.009L27.891,3h-2.244l-8.224,9.559L10.855,3H3.28l9.932,14.455L3.28,29h2.244l8.684-10.095,6.936,10.095h7.576l-10.301-14.991h0Zm-3.074,3.573l-1.006-1.439L6.333,4.69h3.447l6.462,9.243,1.006,1.439,8.4,12.015h-3.447l-6.854-9.804h0Z"></path>
                            </svg>
                        </a>
                    <?php } ?>

                    <?php if ($data_var_option_theme['social_network_telegram']) { ?>
                        <a href="https://t.me/<?php echo $data_var_option_theme['social_network_telegram']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M16,2c-7.732,0-14,6.268-14,14s6.268,14,14,14,14-6.268,14-14S23.732,2,16,2Zm6.489,9.521c-.211,2.214-1.122,7.586-1.586,10.065-.196,1.049-.583,1.401-.957,1.435-.813,.075-1.43-.537-2.218-1.053-1.232-.808-1.928-1.311-3.124-2.099-1.382-.911-.486-1.412,.302-2.23,.206-.214,3.788-3.472,3.858-3.768,.009-.037,.017-.175-.065-.248-.082-.073-.203-.048-.29-.028-.124,.028-2.092,1.329-5.905,3.903-.559,.384-1.065,.571-1.518,.561-.5-.011-1.461-.283-2.176-.515-.877-.285-1.574-.436-1.513-.92,.032-.252,.379-.51,1.042-.773,4.081-1.778,6.803-2.95,8.164-3.517,3.888-1.617,4.696-1.898,5.222-1.907,.116-.002,.375,.027,.543,.163,.142,.115,.181,.27,.199,.379,.019,.109,.042,.357,.023,.551Z" fill-rule="evenodd"></path>
                            </svg>
                        </a>
                    <?php } ?>


                    <?php if ($data_var_option_theme['social_network_facebook']) { ?>
                        <a href="https://www.facebook.com/<?php echo $data_var_option_theme['social_network_facebook']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M16,2c-7.732,0-14,6.268-14,14,0,6.566,4.52,12.075,10.618,13.588v-9.31h-2.887v-4.278h2.887v-1.843c0-4.765,2.156-6.974,6.835-6.974,.887,0,2.417,.174,3.043,.348v3.878c-.33-.035-.904-.052-1.617-.052-2.296,0-3.183,.87-3.183,3.13v1.513h4.573l-.786,4.278h-3.787v9.619c6.932-.837,12.304-6.74,12.304-13.897,0-7.732-6.268-14-14-14Z"></path>
                            </svg>
                        </a>
                    <?php } ?>


                    <?php if ($data_var_option_theme['social_network_youtube']) { ?>
                        <a href="https://www.youtube.com/channel/<?php echo $data_var_option_theme['social_network_youtube']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M31.331,8.248c-.368-1.386-1.452-2.477-2.829-2.848-2.496-.673-12.502-.673-12.502-.673,0,0-10.007,0-12.502,.673-1.377,.37-2.461,1.462-2.829,2.848-.669,2.512-.669,7.752-.669,7.752,0,0,0,5.241,.669,7.752,.368,1.386,1.452,2.477,2.829,2.847,2.496,.673,12.502,.673,12.502,.673,0,0,10.007,0,12.502-.673,1.377-.37,2.461-1.462,2.829-2.847,.669-2.512,.669-7.752,.669-7.752,0,0,0-5.24-.669-7.752ZM12.727,20.758V11.242l8.364,4.758-8.364,4.758Z"></path>
                            </svg>
                        </a>
                    <?php } ?>


                    <?php if ($data_var_option_theme['social_network_aparat']) { ?>
                        <a href="https://www.aparat.com/<?php echo $data_var_option_theme['social_network_aparat']; ?>" class="text-black  inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                        <svg viewBox="0 0 32 32" width="65" height="65" fill="currentColor" class="block" title="Aparat logo">
                                <path d="M28.057 25.12l-.853 3.202a4.955 4.955 0 01-6.06 3.515l-3.02-.814a15.185 15.185 0 009.933-5.904v.001zM16.007 2.127c7.66.004 13.871 6.214 13.871 13.873a13.873 13.873 0 01-16.586 13.604A13.881 13.881 0 012.39 18.703a13.867 13.867 0 015.905-14.24 13.877 13.877 0 017.71-2.335l.002-.001zM.892 18.415a15.172 15.172 0 005.606 9.527l-2.81-.749A4.952 4.952 0 01.17 21.135l.722-2.72zm19.825-.112a3.96 3.96 0 10-1.497 7.779 3.96 3.96 0 001.497-7.779zm-9.943-1.915a3.96 3.96 0 10-1.506 7.775 3.96 3.96 0 001.506-7.775zm5.48-2.02a1.76 1.76 0 10-.656 3.46 1.76 1.76 0 00.657-3.46zm6.482-6.544a3.961 3.961 0 00-1.5 7.778 3.94 3.94 0 002.974-.607 3.96 3.96 0 001.658-4.08 3.96 3.96 0 00-3.132-3.091zm2.43-3.86l3.152.837a4.953 4.953 0 013.522 6.044l-.866 3.277a15.168 15.168 0 00-5.808-10.159v.001zm-12.38 1.945a3.962 3.962 0 10-1.496 7.782 3.962 3.962 0 001.496-7.782zM7.107.673A4.957 4.957 0 0110.868.17l2.946.768a15.176 15.176 0 00-9.746 5.524l.735-2.776A4.953 4.953 0 017.107.673z" fill-rule="evenodd"></path>
                            </svg>
                        </a>
                    <?php } ?>

                    <?php if ($data_var_option_theme['social_network_instagram']) { ?>
                        <a href="https://instagram.com/<?php echo $data_var_option_theme['social_network_instagram']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M10.202,2.098c-1.49,.07-2.507,.308-3.396,.657-.92,.359-1.7,.84-2.477,1.619-.776,.779-1.254,1.56-1.61,2.481-.345,.891-.578,1.909-.644,3.4-.066,1.49-.08,1.97-.073,5.771s.024,4.278,.096,5.772c.071,1.489,.308,2.506,.657,3.396,.359,.92,.84,1.7,1.619,2.477,.779,.776,1.559,1.253,2.483,1.61,.89,.344,1.909,.579,3.399,.644,1.49,.065,1.97,.08,5.771,.073,3.801-.007,4.279-.024,5.773-.095s2.505-.309,3.395-.657c.92-.36,1.701-.84,2.477-1.62s1.254-1.561,1.609-2.483c.345-.89,.579-1.909,.644-3.398,.065-1.494,.081-1.971,.073-5.773s-.024-4.278-.095-5.771-.308-2.507-.657-3.397c-.36-.92-.84-1.7-1.619-2.477s-1.561-1.254-2.483-1.609c-.891-.345-1.909-.58-3.399-.644s-1.97-.081-5.772-.074-4.278,.024-5.771,.096m.164,25.309c-1.365-.059-2.106-.286-2.6-.476-.654-.252-1.12-.557-1.612-1.044s-.795-.955-1.05-1.608c-.192-.494-.423-1.234-.487-2.599-.069-1.475-.084-1.918-.092-5.656s.006-4.18,.071-5.656c.058-1.364,.286-2.106,.476-2.6,.252-.655,.556-1.12,1.044-1.612s.955-.795,1.608-1.05c.493-.193,1.234-.422,2.598-.487,1.476-.07,1.919-.084,5.656-.092,3.737-.008,4.181,.006,5.658,.071,1.364,.059,2.106,.285,2.599,.476,.654,.252,1.12,.555,1.612,1.044s.795,.954,1.051,1.609c.193,.492,.422,1.232,.486,2.597,.07,1.476,.086,1.919,.093,5.656,.007,3.737-.006,4.181-.071,5.656-.06,1.365-.286,2.106-.476,2.601-.252,.654-.556,1.12-1.045,1.612s-.955,.795-1.608,1.05c-.493,.192-1.234,.422-2.597,.487-1.476,.069-1.919,.084-5.657,.092s-4.18-.007-5.656-.071M21.779,8.517c.002,.928,.755,1.679,1.683,1.677s1.679-.755,1.677-1.683c-.002-.928-.755-1.679-1.683-1.677,0,0,0,0,0,0-.928,.002-1.678,.755-1.677,1.683m-12.967,7.496c.008,3.97,3.232,7.182,7.202,7.174s7.183-3.232,7.176-7.202c-.008-3.97-3.233-7.183-7.203-7.175s-7.182,3.233-7.174,7.203m2.522-.005c-.005-2.577,2.08-4.671,4.658-4.676,2.577-.005,4.671,2.08,4.676,4.658,.005,2.577-2.08,4.671-4.658,4.676-2.577,.005-4.671-2.079-4.676-4.656h0"></path>
                            </svg>
                        </a>
                    <?php } ?>

                    <?php if ($data_var_option_theme['social_network_linkedin']) { ?>
                        <a href="https://www.linkedin.com/company/<?php echo $data_var_option_theme['social_network_linkedin']; ?>" class="text-zinc-500 hover:text-blue-600 inline-block align-middle text-center " rel="noopener noreferrer" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 32 32">
                                <path d="M26.111,3H5.889c-1.595,0-2.889,1.293-2.889,2.889V26.111c0,1.595,1.293,2.889,2.889,2.889H26.111c1.595,0,2.889-1.293,2.889-2.889V5.889c0-1.595-1.293-2.889-2.889-2.889ZM10.861,25.389h-3.877V12.87h3.877v12.519Zm-1.957-14.158c-1.267,0-2.293-1.034-2.293-2.31s1.026-2.31,2.293-2.31,2.292,1.034,2.292,2.31-1.026,2.31-2.292,2.31Zm16.485,14.158h-3.858v-6.571c0-1.802-.685-2.809-2.111-2.809-1.551,0-2.362,1.048-2.362,2.809v6.571h-3.718V12.87h3.718v1.686s1.118-2.069,3.775-2.069,4.556,1.621,4.556,4.975v7.926Z" fill-rule="evenodd"></path>
                            </svg>
                        </a>
                    <?php } ?>

                </div>



            </div>





        </div>

    </div>



    <div class="w-screen hidden">

        <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto  ">

            <div class="flex justify-between flex-wrap md:flex-nowrap md:gap-4 my-8 text-slate-600">


                <div class="basis-1/2 p-2 flex md:flex-wrap md:items-center md:justify-center h-36 py-3">
                    <div class="flex flex-wrap justify-center items-center w-full h-auto">

                        <img class="w-1h-16 h-16" src="<?php echo get_template_directory_uri(); ?>/inc/img/truck.png" alt="<?php echo esc_attr($alt_text); ?>">

                        <span class="block w-full text-center text-base font-bold py-3"> ارسال برای شما </span>
                        <span class="w-full text-center text-sm text-gray-500 hidden md:block"> ارسال به تمام شهر های ایران </span>

                    </div>
                </div>



                <div class="basis-1/2 p-2 flex md:flex-wrap md:items-center md:justify-center h-36 py-3">
                    <div class="flex flex-wrap justify-center items-center w-full h-auto">
                        <img class="w-1h-16 h-16" src="<?php echo get_template_directory_uri(); ?>/inc/img/wrap.png" alt="<?php echo esc_attr($alt_text); ?>">

                        <span class="block w-full text-center text-base font-bold py-3"> بسته بندی مخصوص</span>
                        <span class="w-full text-center text-sm text-gray-500 hidden md:block"> بسته به نوع سفارش بسته انجام می شود</span>

                    </div>
                </div>




                <div class="basis-1/2 p-2 flex md:flex-wrap md:items-center md:justify-center h-36 py-3">
                    <div class="flex flex-wrap justify-center items-center w-full h-auto">
                        <img class="w-1h-16 h-16" src="<?php echo get_template_directory_uri(); ?>/inc/img/boxes.png" alt="<?php echo esc_attr($alt_text); ?>">

                        <span class="block w-full text-center text-base font-bold py-3"> خدمات باربری</span>
                        <span class="w-full text-center text-sm text-gray-500 hidden md:block"> خدمات باربری با توجه به نیاز شما </span>

                    </div>
                </div>




                <div class="basis-1/2 p-2 flex md:flex-wrap md:items-center md:justify-center h-36 py-3">
                    <div class="flex flex-wrap justify-center items-center w-full h-auto">
                        <img class="w-1h-16 h-16" src="<?php echo get_template_directory_uri(); ?>/inc/img/send.png" alt="<?php echo esc_attr($alt_text); ?>">

                        <span class="block w-full text-center text-base font-bold py-3"> ارسال سفارشی</span>
                        <span class="w-full text-center text-sm text-gray-500 hidden md:block"> ارسال سفارشی محصولات شما در کمترین زمان</span>

                    </div>
                </div>



            </div>

        </div>

    </div>



    <script>
        var swiper = new Swiper(".mySwiper-head-front-page", {
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            pagination: {
                el: ".swiper-pagination",
                type: "fraction",
            },
            autoplay: {
                delay: 5000,
            },
            effect: 'fade',
            fadeEffect: {
                crossFade: true
            },
        });



        var swiper = new Swiper(".mySwiper-brand", {
            slidesPerView: 2.5,
            spaceBetween: 15,
            autoplay: {
                delay: 2000,
            },
            breakpoints: {
                640: {
                    slidesPerView: 8,
                },

            },
        });


        var swiper = new Swiper(".mySwiper-comment", {
            slidesPerView: 1,
            spaceBetween: 30,
            loop: true,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            autoplay: {
                delay: 5000,
            },
            effect: 'fade',
        });

        var swiper = new Swiper(".mySwiper-post-slider", {
            slidesPerView: 1.3,
            spaceBetween: 15,
            autoplay: {
                delay: 3000,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            breakpoints: {
                640: {
                    slidesPerView: 4.2,
                },

            },

        });
    </script>





    <?php get_footer(); ?>



<?php  }   ?>