<?php
/**
 * MohammadrezaBehdarvand functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package MohammadrezaBehdarvand
 */
if (!defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.0.0');
}
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function mohammadrezabehdarvand_setup()
{
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on MohammadrezaBehdarvand, use a find and replace
		* to change 'mohammadrezabehdarvand' to the name of your theme in all the template files.
		*/
	load_theme_textdomain('mohammadrezabehdarvand', get_template_directory() . '/languages');
	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');
	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support('title-tag');
	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support('post-thumbnails');
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'mohammadrezabehdarvand'),
		)
	);
	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);
	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'mohammadrezabehdarvand_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);
	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');
	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'mohammadrezabehdarvand_setup');
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function mohammadrezabehdarvand_content_width()
{
	$GLOBALS['content_width'] = apply_filters('mohammadrezabehdarvand_content_width', 640);
}
add_action('after_setup_theme', 'mohammadrezabehdarvand_content_width', 0);
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function mohammadrezabehdarvand_widgets_init()
{
	register_sidebar(
		array(
			'name'          => esc_html__('Sidebar', 'mohammadrezabehdarvand'),
			'id'            => 'sidebar-1',
			'description'   => esc_html__('Add widgets here.', 'mohammadrezabehdarvand'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action('widgets_init', 'mohammadrezabehdarvand_widgets_init');
/**
 * Enqueue scripts and styles.
 */
function mohammadrezabehdarvand_scripts()
{
	wp_enqueue_style('mohammadrezabehdarvand-style', get_stylesheet_uri(), array(), _S_VERSION);
	// wp_style_add_data( 'mohammadrezabehdarvand-style', 'rtl', 'replace' );
	// wp_enqueue_script('mohammadrezabehdarvand-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);
	// wp_enqueue_script('jquery-3-7-1', get_template_directory_uri() . '/js/jquery-3.7.1.min.js', array(), _S_VERSION, true);
	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
	wp_enqueue_style('custom-css', get_template_directory_uri() . '/inc/custom/custom.css');
	// wp_enqueue_style('videojs-css', get_template_directory_uri() . '/inc/css/video-js.css');
	wp_enqueue_style('swiper_css', get_template_directory_uri() . '/inc/custom/swiper.css');
	// اضافه کردن alpine.min.js (یک کتابخانه جاوا اسکریپتی)
	wp_enqueue_script('alpine-JS', get_template_directory_uri() . '/inc/js/alpine.min.js');
	wp_enqueue_script('swiper-js', get_template_directory_uri() . '/inc/js/swiper.js');
	// اضافه کردن کد های جاوا اسکریپتی شخصی قالب
	wp_enqueue_script('custom-js', get_template_directory_uri() . '/inc/js/custom.js');
	wp_enqueue_script('custom-search', get_template_directory_uri() . '/search/search.js');
	// wp_enqueue_script('videojs-js', get_template_directory_uri() . '/inc/js/video.min.js',	array());
}
add_action('wp_enqueue_scripts', 'mohammadrezabehdarvand_scripts');
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
// add taxonomy-images plugin mohammadreza
// require get_template_directory() . '/inc/plugins/taxonomy-images/taxonomy-images.php';
/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}
function mytheme_add_woocommerce_support()
{
	add_theme_support('woocommerce');
}
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
/**
 * Implement Ajax search plugin.
 */
// require get_template_directory() . '/inc/plugins/searchwp-live-ajax-search/searchwp-live-ajax-search.php';
function Before_the_theme_is_activated()
{
	// اضافه کردن عنوان title
	add_theme_support('title-tag');
	// اضافه کردن آخرین مقالات و خوراک های وردپرس
	add_theme_support('automatic-feed-links');
	// اضافه کردن لوگو به سایت
	$defaults = array(
		'height'               => 40,
		'width'                => "auto",
		'flex-height'          => true,
		'flex-width'           => true,
		'header-text'          => array('site-title', 'site-description'),
		'unlink-homepage-logo' => true,
	);
	add_theme_support('custom-logo', $defaults);
	add_image_size('153x153', 153, 153);
	add_image_size('thumbnail_search_size_60', 60);
	add_image_size('thumbnail_product_archive_edu_60', 600);
	add_image_size('thumbnail_page-service', 600);
	add_image_size('thumbnail_product_archive_60', 150);
	// اضافه کردن منو به سایت
	register_nav_menus(
		array(
			'header-menu' => __('هدر منو بالای صفحه'),
			'extra-menu' => __('منو فوتر'),
			'category-product-menu' => __('دسته بندی محصول')
		)
	);
}
add_action('after_setup_theme', 'Before_the_theme_is_activated');
// اضافه کردن ابزارک به قالب
/* Better way to add multiple widgets areas */
function widget_registration($name, $id, $description, $beforeWidget, $afterWidget, $beforeTitle, $afterTitle)
{
	register_sidebar(array(
		'name' => $name,
		'id' => $id,
		'description' => $description,
		'before_widget' => $beforeWidget,
		'after_widget' => $afterWidget,
		'before_title' => $beforeTitle,
		'after_title' => $afterTitle,
	));
}
function multiple_widget_init()
{
	widget_registration(
		'آدرس فوتر',
		'footer-address',
		'جایگاه این ویجت در فوتر از سمت راست اولی می باشد ( البته در زبان فارسی )',
		'<li id="" class="text-base font-light text-zinc-500 mb-4 block text-center md:text-center lg:text-left pb-3">',
		'</li>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-3 block ">',
		'</span>',
	);
	widget_registration(
		'منو فوتر - اول',
		'footer-right-one',
		'جایگاه این ویجت در فوتر از سمت راست اولی می باشد ( البته در زبان فارسی )',
		'<li id="" class="text-base font-light text-zinc-500 mb-1 block text-center lg:text-right pb-3">',
		'</li>  <li class="flex justify-center">   <div class=" md:border-b-0 md:border-0 md:pb-0 border-b-2 border-slate-200 w-4/5">  </div> </li> ',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-3 block ">',
		'</span>',
	);
	widget_registration(
		'منو فوتر - دوم',
		'footer-right-two',
		'جایگاه این ویجت در فوتر از سمت راست دومی می باشد ( البته در زبان فارسی )',
		'<li id="" class="text-base font-light text-zinc-500 mb-1 block text-center lg:text-right pb-3">',
		'</li>  <li class="flex justify-center">   <div class=" md:border-b-0 md:border-0 md:pb-0 border-b-2 border-slate-200 w-4/5">  </div> </li> ',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-3 block ">',
		'</span>',
	);
	widget_registration(
		'منو فوتر - سوم',
		'footer-right-three',
		'جایگاه این ویجت در فوتر از سمت راست سومی می باشد ( البته در زبان فارسی )',
		'<li id="" class="text-base font-light text-zinc-500 mb-1 block text-center lg:text-right pb-3">',
		'</li>  <li class="flex justify-center">   <div class=" md:border-b-0 md:border-0 md:pb-0 border-b-2 border-slate-200 w-4/5">  </div> </li> ',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-3 block ">',
		'</span>',
	);
	widget_registration(
		' حق کپی رایت در فوتر',
		'footer_copyright',
		'جایگاه بلوک های شبکه اجتماعی در فوتر',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 block text-center lg:text-right pb-14 lg:pb-0 px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		'</p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-3 block ">',
		'</span>',
	);
	widget_registration(
		'فیلتر صفحه محصول',
		'filter_product_archive',
		'فیلتر محصولات در صفحه آرشیو',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden lg:block text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
	widget_registration(
		'قراردادن لینک مجوز اول',
		'footer_majavez_one',
		'قراردادن لینک مجوز اول',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
	widget_registration(
		'قراردادن لینک مجوز دوم',
		'footer_majavez_two',
		'قراردادن لینک مجوز دوم',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
	widget_registration(
		'قراردادن لینک مجوز سوم',
		'footer_majavez_three',
		'قراردادن لینک مجوز سوم',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
	widget_registration(
		'قراردادن لینک مجوز چهارم',
		'footer_majavez_four',
		'قراردادن لینک مجوز چهارم',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
	widget_registration(
		'قراردادن لینک مجوز پنجم',
		'footer_majavez_five',
		'قراردادن لینک مجوز پنجم',
		'<p id="" class="text-base font-light text-zinc-500 mb-1 md:mb-0 hidden text-center lg:text-right px-3 mt-6 md:px-0 md:mt-0 lg:min-w-max">',
		' </p>',
		'<span class="text-base font-bold text-zinc-800 mt-6 mb-2 block ">',
		'</span>',
	);
}
add_action('widgets_init', 'multiple_widget_init');
// غیر فعال کردن ویرایشگر جدید وردپرس
// Disable Gutenberg on the back end.
add_filter('use_block_editor_for_post', '__return_false');
// Disable Gutenberg for widgets.
add_filter('use_widgets_block_editor', '__return_false');
add_action('wp_enqueue_scripts', function () {
	// Remove CSS on the front end.
	wp_dequeue_style('wp-block-library');
	// Remove Gutenberg theme.
	wp_dequeue_style('wp-block-library-theme');
	// Remove inline global CSS on the front end.
	wp_dequeue_style('global-styles');
	// Remove classic-themes CSS for backwards compatibility for button blocks.
	wp_dequeue_style('classic-theme-styles');
}, 20);
// اضافه کردن تصویر شاخص به وردپرس
add_theme_support('post-thumbnails');
// اضافه کردن ریداکس
if (!class_exists('ReduxFramework') && file_exists(WP_PLUGIN_DIR . '/redux-framework/redux-core/framework.php')) {
	require_once(WP_PLUGIN_DIR . '/redux-framework/redux-core/framework.php');
}
if (class_exists('ReduxFramework')) {
	require_once(get_parent_theme_file_path('/inc/panel-option/sample-config.php'));
}
// این کد فایل‌های CSS که نام آنها با عبارت "woocommerce" یا "dashicons.min.css" یا "admin-bar-rtl.min.css" شروع می‌شود را حذف می‌کند. این روش برای حذف فایل‌های CSS مشکل‌ساز از ووکامرس و دیگر فایل‌ها کارآمد است. به عنوان مثال، این کد به حذف فایل‌های مربوط به ووکامرس کمک خواهد کرد
// function remove_woocommerce_styles($src)
// {
// 	if (strpos($src, 'woocommerce') !== false || strpos($src, 'dashicons.min.css') !== false || strpos($src, 'admin-bar-rtl.min.css') !== false) {
// 		return false;
// 	}
// 	return $src;
// }
// add_filter('style_loader_src', 'remove_woocommerce_styles', 9999);
// remove woocommerce
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
add_filter('woocommerce_enqueue_styles', '__return_empty_array');
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('woocommerce_single_product_custom_meta', 'woocommerce_template_single_meta', 40);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
remove_action('woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
remove_action('woocommerce_single_product_summary', 'WC_Structured_Data::generate_product_data()', 60);
// remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
// انتخاب تعداد در برای اضافه کردن به سبد خرید
// function woocommerce_quantity_input($args = array(), $product = null, $echo = true)
// {
// 	if (is_null($product)) {
// 		$product = $GLOBALS['product'];
// 	}
// 	$defaults = array(
// 		'input_id' => uniqid('quantity_'),
// 		'input_name' => 'quantity',
// 		'input_value' => '1',
// 		'classes' => apply_filters('woocommerce_quantity_input_classes', array('input-text', 'qty', 'text'), $product),
// 		'max_value' => apply_filters('woocommerce_quantity_input_max', -1, $product),
// 		'min_value' => apply_filters('woocommerce_quantity_input_min', 0, $product),
// 		'step' => apply_filters('woocommerce_quantity_input_step', 1, $product),
// 		'pattern' => apply_filters('woocommerce_quantity_input_pattern', has_filter('woocommerce_stock_amount', 'intval') ? '[0-9]*' : ''),
// 		'inputmode' => apply_filters('woocommerce_quantity_input_inputmode', has_filter('woocommerce_stock_amount', 'intval') ? 'numeric' : ''),
// 		'product_name' => $product ? $product->get_title() : '',
// 	);
// 	$args = apply_filters('woocommerce_quantity_input_args', wp_parse_args($args, $defaults), $product);
// 	// Apply sanity to min/max args - min cannot be lower than 0.
// 	$args['min_value'] = max($args['min_value'], 0);
// 	// Note: change 20 to whatever you like
// 	$args['max_value'] = 0 < $args['max_value'] ? $args['max_value'] : 20;
// 	// Max cannot be lower than min if defined.
// 	if ('' !== $args['max_value'] && $args['max_value'] < $args['min_value']) {
// 		$args['max_value'] = $args['min_value'];
// 	}
// 	$options = '';
// 	for ($count = $args['min_value']; $count <= $args['max_value']; $count = $count + $args['step']) {
// 		// Cart item quantity defined?
// 		if ('' !== $args['input_value'] && $args['input_value'] >= 1 && $count == $args['input_value']) {
// 			$selected = 'selected';
// 		} else $selected = '';
// 		$options .= '<option value="' . $count . '"' . $selected . '>' . $count . '</option>';
// 	}
// 	$string = '<div class="quantity"><span>  </span><select name="' . $args['input_name'] . '">' . $options . '</select></div>';
// 	if ($echo) {
// 		echo $string;
// 	} else {
// 		return $string;
// 	}
// }
// افزودن یک فیلتر برای تغییر تصویر محصول در سبد خرید
function my_custom_cart_item_thumbnail($product_image, $cart_item, $cart_item_key)
{
	// افزودن یک کلاس به تصویر
	$product_image_with_class = preg_replace('/<img(.*?)class=[\'"](.*?)[\'"](.*?)>/i', '<img$1class="$2 rounded-md overflow-hidden border-2 border-slate-200"$3>', $product_image);
	// بازگرداندن تصویر با کلاس جدید
	return $product_image_with_class;
}
add_filter('woocommerce_cart_item_thumbnail', 'my_custom_cart_item_thumbnail', 10, 3);
// فیلدهای پرداخت
// function custom_modify_checkout_fields($fields)
// {
// 	// حذف تمامی فیلدها
// 	$fields = array();
// 	// اضافه کردن فیلد نام
// 	$fields['billing']['billing_first_name'] = array(
// 		'label'       => __('نام', 'your-domain'),
// 		'placeholder' => _x('نام', 'placeholder', 'your-domain'),
// 		'required'    => true,
// 		'class'       => array('form-row-first', 'custom-class'),
// 	);
// 	// اضافه کردن فیلد شماره موبایل یا ایمیل
// 	$fields['billing']['billing_email_mobile'] = array(
// 		'label'       => __('شماره موبایل یا ایمیل', 'your-domain'),
// 		'placeholder' => _x('شماره موبایل یا ایمیل', 'placeholder', 'your-domain'),
// 		'required'    => true,
// 		'class'       => array('form-row-last', 'custom-class'),
// 		'type'        => 'text',
// 	);
// 	// اضافه کردن فیلد شهر به صورت انتخابی
// 	$fields['billing']['billing_city'] = array(
// 		'label'       => __('شهر', 'your-domain'),
// 		'placeholder' => _x('شهر', 'placeholder', 'your-domain'),
// 		'required'    => true,
// 		'class'       => array('form-row-first', 'custom-class'),
// 		'type'        => 'select', // تغییر نوع به select
// 		'options'     => array(
// 			''       => __('انتخاب کنید', 'your-domain'),
// 			'city1'  => __('شهر 1', 'your-domain'),
// 			'city2'  => __('شهر 2', 'your-domain'),
// 			// ادامه...
// 		),
// 	);
// 	// اضافه کردن فیلد آدرس پستی
// 	$fields['billing']['billing_address_1'] = array(
// 		'label'       => __('آدرس پستی', 'your-domain'),
// 		'placeholder' => _x('آدرس پستی', 'placeholder', 'your-domain'),
// 		'required'    => true,
// 		'class'       => array('form-row-wide', 'custom-class'),
// 	);
// 	// اضافه کردن فیلد کد پستی
// 	$fields['billing']['billing_postcode'] = array(
// 		'label'       => __('کد پستی (اعداد انگلیسی)', 'your-domain'),
// 		'placeholder' => _x('کد پستی', 'placeholder', 'your-domain'),
// 		'required'    => true,
// 		'class'       => array('form-row-wide', 'custom-class'),
// 		'type'        => 'text',
// 		'pattern'     => '[0-9]*',
// 	);
// 	return $fields;
// }
// add_filter('woocommerce_checkout_fields', 'custom_modify_checkout_fields');
function custom_remove_last_name_field($fields)
{
	// حذف فیلد نام خانوادگی از بخش billing
	unset($fields['billing']['billing_last_name']);
	// حذف فیلد نام شرکت از بخش billing
	unset($fields['billing']['billing_company']);
	// حذف فیلد کشور از بخش billing
	unset($fields['billing']['billing_country']);
	// حذف فیلد billing_address_2 از بخش billing
	unset($fields['billing']['billing_address_2']);
	// تغییر نام فیلد "نام" به "نام و نام خانوادگی" در بخش billing
	$fields['billing']['billing_first_name']['label'] = __('نام و نام خانوادگی', 'woocommerce');
	unset($fields['billing']['billing_last_name']); // حذف فیلد "نام خانوادگی"
	return $fields;
}
add_filter('woocommerce_checkout_fields', 'custom_remove_last_name_field');
function custom_optional_address_fields($fields)
{
	// علامت گذاری فیلدهای آدرس به عنوان اختیاری
	// $fields['billing']['billing_last_name']['required'] = false;
	// $fields['billing']['billing_company']['required'] = false;
	$fields['billing']['billing_country']['required'] = false;
	$fields['billing']['billing_address_2']['required'] = false;
	return $fields;
}
add_filter('woocommerce_checkout_fields', 'custom_optional_address_fields');
// اضافه کردن اسکریپت jQuery برای اضافه کردن کلاس‌های دلخواه به label و input
function custom_add_classes_to_checkout_fields_script()
{
?>
	<script>
		jQuery(document).ready(function($) {
			// اضافه کردن کلاس‌های دلخواه به label و input
			$('#billing_first_name_field label, #billing_state_field label , #billing_city_field label , #billing_address_1_field label , #billing_postcode_field label , #billing_phone_field label , #billing_email_field label').addClass('mt-5 mb-3 block');
			$('#billing_first_name_field input , #billing_state_field input , #billing_city_field input , #billing_address_1_field input , #billing_address_1_field input , #billing_postcode_field input , #billing_phone_field input , #billing_email_field input').addClass('caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center w-auto');
			$('#billing_first_name_field, #billing_state_field , #billing_city_field , #billing_address_1_field, #billing_address_1_field , #billing_postcode_field , #billing_phone_field , #billing_email_field').addClass('basis-1/2 px-3');
		});
	</script>
<?php
}
add_action('wp_footer', 'custom_add_classes_to_checkout_fields_script');
add_action('admin_head', 'my_custom_fonts');
function my_custom_fonts()
{
	echo '<style>
  .postbox .redux-container.redux-no-sections .redux-main {
    margin: 0 !important;
}
.redux-container .redux-main img {
	margin-right: 0 !important;
	width: 200px !important;
}
.redux-container .redux-main {
margin-left:0 !important;
}
.select2-dropdown.select2-dropdown--above{
width:auto !important;
padding:0 !important;
margin:0 !important;
}
  </style>';
}
// add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );
// add_filter( 'woocommerce_loop_add_to_cart_link', 'quantity_inputs_for_woocommerce_loop_add_to_cart_link', 10, 2 );
// function quantity_inputs_for_woocommerce_loop_add_to_cart_link( $html, $product ) {
// 	if ( is_user_logged_in() && is_shop() && $product && $product->is_type( 'simple' ) && $product->is_purchasable() && $product->is_in_stock() && ! $product->is_sold_individually() ) {
// 		$html = '<form action="' . esc_url( $product->add_to_cart_url() ) . '" class="cart" method="post" enctype="multipart/form-data">';
// 		$html .= woocommerce_quantity_input( array(), $product, false );
// 		$html .= '<button type="submit" class="button alt">' . esc_html( $product->add_to_cart_text() ) . '</button>';
// 		$html .= '</form>';
// 	}
// 	return $html;
// }
// تابع اضافه کردن محصول به سبد خرید
function add_to_cart_ajax_callback()
{
	// بررسی ورودی‌های دریافتی از جانب کاربر
	$product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
	$quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
	// اضافه کردن محصول به سبد خرید
	WC()->cart->add_to_cart($product_id, $quantity);
	// بازگشت پاسخ به جاوا اسکریپت
	echo json_encode(array(
		'success' => true
	));
	// پایان اجرای کد
	die();
}
// ثبت تابع به عنوان یک فراخوانی AJAX در وردپرس
add_action('wp_ajax_add_to_cart', 'add_to_cart_ajax_callback');
add_action('wp_ajax_nopriv_add_to_cart', 'add_to_cart_ajax_callback');
/**
 * Snippet Name:	WooCommerce Automatically Update Cart On Quantity Change
 * Snippet Author:	ecommercehints.com
 */
// First, hide the Update Cart button
add_action('wp_head', 'ecommercehints_hide_update_cart_button');
function ecommercehints_hide_update_cart_button()
{ ?>
	<style>
		button[name="update_cart"],
		input[name="update_cart"] {
			display: none;
		}
	</style>
<?php }
// Second, add the jQuery to update the cart automaitcally on quantity change
add_action('wp_footer', 'ecommercehints_update_cart_on_quantity_change');
function ecommercehints_update_cart_on_quantity_change()
{ ?>
	<script>
		jQuery(function($) {
			let timeout;
			$('.woocommerce').on('change', 'input.qty', function() {
				if (timeout !== undefined) {
					clearTimeout(timeout);
				}
				timeout = setTimeout(function() {
					$("[name='update_cart']").trigger("click");
				}, 500); // 500 being MS (half a second)
			});
		});
	</script>
<?php }
// To change add to cart text on single product page
add_filter('woocommerce_product_single_add_to_cart_text', 'woocommerce_custom_single_add_to_cart_text');
function woocommerce_custom_single_add_to_cart_text()
{
	return __('افزودن', 'woocommerce');
}
// To change add to cart text on product archives(Collection) page
add_filter('woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text');
function woocommerce_custom_product_add_to_cart_text()
{
	return __('افزودن', 'woocommerce');
}
function wps_increase_products_per_page($query)
{
	if (!is_admin() && $query->is_main_query() && $query->is_post_type_archive('product')) {
		$query->set('posts_per_page', 300); // عدد 12 را با تعداد مورد نظر خودتان جایگزین کنید.
	}
}
add_action('pre_get_posts', 'wps_increase_products_per_page');
function wps_increase_products_per_pages($query)
{
	if (!is_admin() && $query->is_main_query() && ($query->is_tax('product_cat') || $query->is_tax('product_tag'))) {
		$query->set('posts_per_page', 300); // عدد 300 را با تعداد مورد نظر خودتان جایگزین کنید.
	}
}
add_action('pre_get_posts', 'wps_increase_products_per_pages');
add_filter('woocommerce_get_catalog_ordering_args', 'mihanwp_sort_by_stock', 9999);
function mihanwp_sort_by_stock($args)
{
	$args['orderby'] = 'meta_value';
	$args['order'] = 'ASC';
	$args['meta_key'] = '_stock_status';
	return $args;
}
add_filter('comment_form_defaults', 'custom_reply_title');
function custom_reply_title($defaults)
{
	$defaults['title_reply_before'] = '<strong id="reply-title" class="comment-reply-title">';
	$defaults['title_reply_after'] = '</strong>';
	return $defaults;
}
// در بالای هر فرم در گراویتی فرم می نویسد که بخش های مهم با * مشخص شده اند. با این کار من آن را حذف کرده ام
add_filter('gform_required_legend', '__return_empty_string');
// حل مشکل Invalid ISO 4217 currency code (optional) در سرچ کنسول گوگل
add_filter('woocommerce_currency', 'mohammadreza_irr_custom_woocommerce_currency', 10, 1);
function mohammadreza_irr_custom_woocommerce_currency($currency)
{
	$backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 5); // Inspect the last few calls in the stack
	foreach ($backtrace as $trace) {
		// Check if any call is from the RankMath OpenGraph class
		if (isset($trace['class']) && strpos($trace['class'], 'RankMath\WooCommerce\Opengraph') !== false) {
			return 'IRR'; // Replace 'IRR' with your desired currency code
		}
	}
	return $currency; // Return the default currency otherwise
}
// اضافه کردن عکس به دسته بندی مقالات وردپرس
add_action('wp_ajax_custom_ajax_search', 'custom_ajax_search');
add_action('wp_ajax_nopriv_custom_ajax_search', 'custom_ajax_search');
function custom_ajax_search()
{
	$search_query = isset($_GET['q']) ? sanitize_text_field($_GET['q']) : '';
	if (empty($search_query)) {
		wp_send_json([]);
		wp_die();
	}
	$results = [];
	// جستجو در مقالات و محصولات
	$args = array(
		'post_type'      => array('product', 'post'),
		'posts_per_page' => 10,
		's'              => $search_query,
	);
	$query = new WP_Query($args);
	if ($query->have_posts()) {
		while ($query->have_posts()) {
			$query->the_post();
			$image_url = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') ?: 'path/to/default-image.jpg';
			$results[] = array(
				'title' => get_the_title(),
				'link'  => get_permalink(),
				'type'  => get_post_type(),
				'image' => $image_url,
			);
		}
	}
	wp_reset_postdata();
	// جستجو در دسته‌بندی‌های محصولات و مقالات
	$categories = get_terms(array(
		'taxonomy'   => array('product_cat', 'category'), // دسته‌بندی محصولات و مقالات
		'hide_empty' => false,
		'name__like' => $search_query,
		'number'     => 10,
	));
	if (!is_wp_error($categories)) {
		foreach ($categories as $category) {
			$image_id = get_term_meta($category->term_id, 'thumbnail_id', true);
			$image_url = $image_id ? wp_get_attachment_url($image_id) : 'path/to/default-image.jpg';
			// بررسی اینکه آیا این دسته‌بندی مربوط به محصولات است یا مقالات
			$taxonomy_type = (strpos($category->taxonomy, 'product_cat') !== false) ? 'category_product' : 'category_post';
			$results[] = array(
				'title' => $category->name,
				'link'  => get_term_link($category),
				'type'  => $taxonomy_type, // نوع دسته‌بندی
				'image' => $image_url,
			);
		}
	}
	wp_send_json($results);
	wp_die();
}
function enqueue_custom_ajax_script()
{
	wp_enqueue_script('custom-ajax-search', get_template_directory_uri() . '/custom-ajax.js', array('jquery'), null, true);
	wp_localize_script('custom-ajax-search', 'ajaxData', array(
		'ajaxurl' => admin_url('admin-ajax.php'),
	));
}
add_action('wp_enqueue_scripts', 'enqueue_custom_ajax_script');




// متاباکس گالری پست ها
function padafan_add_image_gallery_metabox() {
    add_meta_box(
        'padafan_image_gallery',
        'گالری تصاویر (تکرارشونده)',
        'padafan_image_gallery_callback',
        'post',
        'normal',
        'default'
    );
}
add_action('add_meta_boxes', 'padafan_add_image_gallery_metabox');

function padafan_enqueue_image_gallery_assets($hook) {
    if ($hook === 'post.php' || $hook === 'post-new.php') {
        wp_enqueue_script('jquery-ui-sortable');
        wp_enqueue_media(); // لود کتابخانه رسانه وردپرس
    }
}
add_action('admin_enqueue_scripts', 'padafan_enqueue_image_gallery_assets');


function padafan_image_gallery_callback($post) {
    wp_nonce_field('padafan_image_gallery_nonce_action', 'padafan_image_gallery_nonce');

    $images = get_post_meta($post->ID, 'padafan_image_gallery', true);
    if (!is_array($images)) $images = [];

    ?>
    <ul id="padafan-gallery-sortable" style="list-style: none; padding: 0;">
        <?php foreach ($images as $image): ?>
            <li class="gallery-item" style="margin-bottom: 10px; background: #f1f1f1; padding: 10px;">
                <input type="hidden" name="padafan_image_gallery[]" value="<?php echo esc_url($image); ?>">
                <img src="<?php echo esc_url($image); ?>" style="width: 100px; height: auto; display: block;">
                <button type="button" class="remove-image">حذف</button>
            </li>
        <?php endforeach; ?>
    </ul>
    <button type="button" id="add-gallery-image">افزودن تصویر</button>

    <script>
        jQuery(document).ready(function ($) {
            $('#padafan-gallery-sortable').sortable();

            $('#add-gallery-image').click(function (e) {
                e.preventDefault();
                const frame = wp.media({
                    title: 'انتخاب تصویر',
                    multiple: false,
                    library: { type: 'image' },
                    button: { text: 'افزودن' }
                });

                frame.on('select', function () {
                    const attachment = frame.state().get('selection').first().toJSON();
                    const li = `
                        <li class="gallery-item" style="margin-bottom: 10px; background: #f1f1f1; padding: 10px;">
                            <input type="hidden" name="padafan_image_gallery[]" value="${attachment.url}">
                            <img src="${attachment.url}" style="width: 100px; height: auto; display: block;">
                            <button type="button" class="remove-image">حذف</button>
                        </li>
                    `;
                    $('#padafan-gallery-sortable').append(li);
                });

                frame.open();
            });

            $('#padafan-gallery-sortable').on('click', '.remove-image', function () {
                $(this).closest('li').remove();
            });
        });
    </script>
    <?php
}


function padafan_save_image_gallery($post_id) {
    if (!isset($_POST['padafan_image_gallery_nonce']) || !wp_verify_nonce($_POST['padafan_image_gallery_nonce'], 'padafan_image_gallery_nonce_action')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (isset($_POST['padafan_image_gallery'])) {
        $clean_images = array_map('esc_url_raw', $_POST['padafan_image_gallery']);
        update_post_meta($post_id, 'padafan_image_gallery', $clean_images);
    } else {
        delete_post_meta($post_id, 'padafan_image_gallery');
    }
}
add_action('save_post', 'padafan_save_image_gallery');



// متاباکس صفحه تماس با ما

/**
 * متاباکس برای صفحات (Page) شامل تصویر، عنوان، متن با ویرایشگر کامل و لینک نقشه (تکرارشونده)
 */

function padafan_add_page_contact_metabox() {
    add_meta_box(
        'padafan_page_contact_box',
        'بلوک‌های آدرس تماس (تکرارشونده)',
        'padafan_page_contact_metabox_callback',
        'page',
        'normal',
        'default'
    );
}
add_action('add_meta_boxes', 'padafan_add_page_contact_metabox');

function padafan_enqueue_page_contact_assets($hook) {
    if (in_array($hook, ['post.php', 'post-new.php'])) {
        wp_enqueue_script('jquery-ui-sortable');
        wp_enqueue_media();
        wp_enqueue_editor();
    }
}
add_action('admin_enqueue_scripts', 'padafan_enqueue_page_contact_assets');

function padafan_page_contact_metabox_callback($post) {
    wp_nonce_field('padafan_page_contact_nonce_action', 'padafan_page_contact_nonce');
    $data = get_post_meta($post->ID, 'padafan_page_contact_blocks', true);
    if (!is_array($data)) $data = [];
    ?>
    <ul id="padafan-page-contact-sortable" style="list-style:none;padding:0;">
        <?php foreach ($data as $index => $block) :
            $title = esc_attr($block['title'] ?? '');
            $map = esc_url($block['map'] ?? '');
            $image = esc_url($block['image'] ?? '');
            $text = $block['text'] ?? '';
            ?>
            <li class="contact-item" style="margin-bottom:10px;background:#f1f1f1;padding:10px;">
                <input type="text" name="padafan_page_contact_blocks[<?php echo $index; ?>][title]" value="<?php echo $title; ?>" placeholder="عنوان" style="width:100%; margin-bottom:5px;">
                <?php
                wp_editor(
                    $text,
                    'padafan_page_contact_blocks_' . $index . '_text',
                    [
                        'textarea_name' => "padafan_page_contact_blocks[{$index}][text]",
                        'media_buttons' => false,
                        'textarea_rows' => 5,
                        'teeny' => true,
                    ]
                );
                ?>
                <input type="text" name="padafan_page_contact_blocks[<?php echo $index; ?>][map]" value="<?php echo $map; ?>" placeholder="لینک نقشه" style="width:100%; margin-bottom:5px;">
                <input type="hidden" name="padafan_page_contact_blocks[<?php echo $index; ?>][image]" value="<?php echo $image; ?>">
                <img src="<?php echo $image; ?>" style="width:100px; height:auto; display:block; margin-bottom:5px;">
                <button type="button" class="upload-image-button">آپلود تصویر</button>
                <button type="button" class="remove-contact-block">حذف</button>
            </li>
        <?php endforeach; ?>
    </ul>
    <button type="button" id="add-contact-block">افزودن بلوک</button>

    <script>
        jQuery(document).ready(function ($) {
            $('#padafan-page-contact-sortable').sortable();

            let index = <?php echo count($data); ?>;

            $('#add-contact-block').click(function () {
                const block = `
                    <li class="contact-item" style="margin-bottom:10px;background:#f1f1f1;padding:10px;">
                        <input type="text" name="padafan_page_contact_blocks[\${index}][title]" placeholder="عنوان" style="width:100%; margin-bottom:5px;">
                        <textarea name="padafan_page_contact_blocks[\${index}][text]" style="width:100%; height:100px; margin-bottom:5px;"></textarea>
                        <input type="text" name="padafan_page_contact_blocks[\${index}][map]" placeholder="لینک نقشه" style="width:100%; margin-bottom:5px;">
                        <input type="hidden" name="padafan_page_contact_blocks[\${index}][image]" value="">
                        <img src="" style="width:100px; height:auto; display:none; margin-bottom:5px;">
                        <button type="button" class="upload-image-button">آپلود تصویر</button>
                        <button type="button" class="remove-contact-block">حذف</button>
                    </li>`;
                $('#padafan-page-contact-sortable').append(block);
                index++;
            });

            $('#padafan-page-contact-sortable').on('click', '.remove-contact-block', function () {
                $(this).closest('li').remove();
            });

            $('#padafan-page-contact-sortable').on('click', '.upload-image-button', function () {
                const button = $(this);
                const frame = wp.media({ title: 'انتخاب تصویر', multiple: false, library: { type: 'image' }, button: { text: 'افزودن' } });
                frame.on('select', function () {
                    const attachment = frame.state().get('selection').first().toJSON();
                    button.siblings('input[type="hidden"]').val(attachment.url);
                    button.siblings('img').attr('src', attachment.url).show();
                });
                frame.open();
            });
        });
    </script>
    <?php
}

function padafan_save_page_contact_metabox($post_id) {
    if (!isset($_POST['padafan_page_contact_nonce']) || !wp_verify_nonce($_POST['padafan_page_contact_nonce'], 'padafan_page_contact_nonce_action')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_page', $post_id)) return;

    if (isset($_POST['padafan_page_contact_blocks'])) {
        $clean = [];
        foreach ($_POST['padafan_page_contact_blocks'] as $block) {
            $clean[] = [
                'title' => sanitize_text_field($block['title']),
                'text' => wp_kses_post($block['text']),
                'map' => esc_url_raw($block['map']),
                'image' => esc_url_raw($block['image'])
            ];
        }
        update_post_meta($post_id, 'padafan_page_contact_blocks', $clean);
    } else {
        delete_post_meta($post_id, 'padafan_page_contact_blocks');
    }
}
add_action('save_post', 'padafan_save_page_contact_metabox');
