<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <?php global $data_var_option_theme; ?>
    <meta charset="<?php bloginfo('charset') ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head() ?>
</head>

<body class="">
    <header class=" bg-white print:hidden">


        <div class="w-screen h-16 bg-white border-b-2 border-gray-200 hidden md:block md:w-full md:px-3">
            <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md mx-auto block">

                <div class="h-16 flex justify-between items-center">
                    <div class="flex">
                        <div class="">
                            <div class="w-auto h-16 flex items-center justify-center">
                                <div class="">

                                    <?php
                                    if ($data_var_option_theme['header-logo']['url']) {
                                    ?>
                                        <a href="<?php bloginfo('url'); ?>">
                                            <img class="h-14 w-auto" src=" <?php echo $data_var_option_theme['header-logo']['url']; ?>" alt=" <?php bloginfo('name'); ?>  لوگو">
                                        </a>
                                    <?php

                                    } else {
                                    ?> <div class="h-12 w-28 bg-slate-100 rounded-md ring-2 ring-cyan-600">
                                            <span class="w-full h-full flex justify-center items-center text-center font-bold">
                                                محل درج لوگو هدر
                                            </span>

                                        </div>
                                    <?php
                                    };
                                    ?>


                                </div>
                            </div>
                        </div>


						

<div class="md:mr-5 lg:mr-24 h-16 flex items-center justify-center">
    <form>
        <div class="relative">
            <div class="absolute inset-y-0 right-3 flex items-center pl-3 pointer-events-none">


                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                </svg>

                
            </div>


<div class="search-box">
<input type="text" class="search-input block lg:w-[32rem] md:w-[20rem] h-11 p-4 pr-10 text-sm text-gray-900 border border-gray-200 rounded-md bg-white focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="جستجو در محصولات..." required placeholder="جستجو در محصولات..." autocomplete="off">
<div class="search-dropdown"></div>
</div>




</div>


</form>
</div>




<style>

    mark {
        background: yellow;
        color: black;
        font-weight: bold;
        padding: 2px;
        border-radius: 3px;
    }
    
    
    .search-item {
        display: flex;
        align-items: center;
        padding: 10px;
        text-decoration: none;
        color: black;
        border-bottom: 1px solid #eee;
        transition: background 0.2s ease;
    }
    
    .search-item:hover {
        background: #f8f8f8;
    }
    
    .search-item img {
        width: 40px;
        height: 40px;
        object-fit: cover;
        margin-right: 10px;
        border-radius: 5px;
    }
    
    
    .search-box {
        position: relative;
        /* width: 100%;
        max-width: 400px; */
    }
    
    /* ✅ استایل فیلد ورودی */
    .search-input {
        /* width: 100%; */
        padding: 12px;
        border: 1px solid #ccc;
        border-radius: 6px;
        font-size: 14px;
        outline: none;
    }
    
    /* ✅ استایل لیست نتایج جستجو */
    .search-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        background: white;
        border: 1px solid #ddd;
        border-radius: 6px;
        box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        display: none; /* پیش‌فرض مخفی */
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.2s ease, visibility 0.2s ease;
        max-height: 250px;
        overflow-y: auto;
        z-index: 9999;
    }
    
    /* ✅ استایل هر محصول در لیست */
    .search-item {
        display: flex;
        align-items: center;
        padding: 10px;
        text-decoration: none;
        color: black;
        border-bottom: 1px solid #eee;
        transition: background 0.2s ease;
    }
    
    .search-item:hover {
        background: #f8f8f8;
    }
    
    /* ✅ استایل عکس محصول */
    .search-item img {
        width: 40px;
        height: 40px;
        object-fit: cover;
        margin-right: 10px;
        border-radius: 5px;
    }
    
    /* ✅ پیام "محصولی یافت نشد" */
    .no-results {
        padding: 10px;
        color: red;
        text-align: center;
    }
    
    
    </style>







                    </div>

                    <div class="flex justify-center items-center">
                        <button class="rounded-md bg-blue-600 p-4 h-11 text-sm font-light text-slate-100 flex items-center justify-center">
                            <a href="<?php echo get_home_url(); ?>/contact/">
                                همکاری با ما
                            </a>
                        </button>
                        <button class="rounded-md py-4 h-11 text-sm font-light text-zinc-800 flex items-center justify-center mr-4">
                            <a class="flex items-center justify-center" href="<?php echo get_home_url(); ?>/contact/">

                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                                    </svg>
                                </span>
                                <span>
                                    مرکز پشتیبانی آنلاین
                                </span>
                            </a>
                        </button>
                    </div>

                </div>


            </div>
        </div>


        <div class="w-screen h-16 bg-white border-b-2 border-gray-200 md:w-full md:px-3">
            <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md mx-auto block">

                <nav class="h-16 flex justify-between items-center">

                    <div class="hidden md:block">
                        <div class="flex items-center">

                            <div class="relative py-4 pl-4 h-16 text-sm font-light text-zinc-800 flex items-center justify-center ml-4 mr-1 border-l-2 border-slate-200 cursor-pointer ddds">

                                <div class="category-hover-show flex h-full items-center">
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" />
                                        </svg>
                                    </span>

                                    <span>
                                        دسته بندی
                                    </span>
                                </div>


                                <div class="z-50 h-auto shadow-lg p-0 w-64 absolute right-0 top-[62px] category-product-menu-des">
                                    <div class="z-10">
                                        <?php wp_nav_menu(array(
                                            'theme_location' => 'category-product-menu',
                                            'container' => '',
                                            'container_class' => 'h-auto',
                                            'link_before' => '<div class="text-sm font-light text-zinc-800 h-10 px-2 flex items-center justify-start border-b-2 border-slate-200">',
                                            'link_after' => '</div>',
                                            'menu_class' => 'flex flex-col category-product-menu-category border-2 border-slate-200 rounded-md bg-white',
                                            'menu_id' => 'b',

                                        ));  ?>
                                    </div>
                                </div>

                            </div>

                            <div class="z-10">
                                <?php wp_nav_menu(array(
                                    'theme_location' => 'header-menu',
                                    'container' => '',
                                    'container_class' => 'h-11',
                                    'link_before' => '<div class="py-1 pl-5 text-sm font-light text-zinc-800 ">',
                                    'link_after' => '</div>',
                                    'menu_class' => 'h-16 flex justify-between items-center menu-hover-main-header',
                                    'menu_id' => 'b',

                                ));  ?>
                            </div>

                        </div>
                    </div>

                    <div class="block md:hidden z-10">

                        <div x-data="{ open: false }" class="h-16 flex items-center justify-center ">

                            <div x-on:click="open = ! open" onclick="toggleCustomClass()" id="add_header_js_bar-button" class="rounded-md text-sm font-light text-zinc-800 mr-3 block cursor-pointer">

                                <span class="bar__header w-11 h-1 bg-slate-950 mt-0 block bar_one"></span>
                                <span class="bar__header w-11 h-1 bg-slate-950 mt-3 block bar_two"></span>
                                <span class="bar__header w-11 h-1 bg-slate-950 mt-3 block bar_three"></span>

                            </div>



                            <div x-show="open" class="bg-white w-screen h-full fixed right-0 top-0 z-20">

                                <div class="h-14 w-full flex justify-end pl-3 items-center">
                                    <span class="text-base font-bold text-zinc-800 block ">تلفن پشتیبانی:
                                        <a class="contents rounded-md text-blue-600 px-2 h-11 md:flex justify-center items-center" href="tell:<?php print_r($data_var_option_theme['Support_contact_number_to_solve_problems_text']); ?>">
                                            <?php print_r($data_var_option_theme['Support_header_contact_number_to_solve_problems_text']); ?>
                                        </a>
                                    </span>
                                </div>

                                <div class="mt-14 px-1 pb-20">
                                    <div class="">
                                        <?php wp_nav_menu(array(
                                            'theme_location' => 'header-menu',
                                            'container' => '',
                                            'container_class' => 'h-11',
                                            'link_before' => '<div class="my-1 p-3 text-base font-light text-zinc-800 bg-slate-200 list-menu-for-mobile">',
                                            'link_after' => '</div>',
                                            'menu_class' => 'h-auto block',
                                            'menu_id' => 'b',

                                        ));  ?>
                                    </div>
                                </div>

                            </div>

                            <div class="w-auto h-16 flex items-center justify-center mr-5 md:hidden">
                                <div class="">
                                    <?php
                                    if ($data_var_option_theme['header-logo']['url']) {
                                    ?>
                                        <a href="<?php bloginfo('url'); ?>">
                                            <img class="w-auto h-11" src=" <?php echo $data_var_option_theme['header-logo']['url']; ?>" alt=" <?php bloginfo('name'); ?>  لوگو">
                                        </a>
                                    <?php

                                    } else {
                                    ?> <div class="h-12 w-28 bg-slate-100 rounded-md ring-2 ring-cyan-600">
                                            <span class="w-full h-full flex justify-center items-center text-center font-bold">
                                                محل درج لوگو هدر
                                            </span>

                                        </div>
                                    <?php
                                    };
                                    ?>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div x-data="{ totalbuywoocommerce: false }" class="flex justify-center items-center ml-1 md:ml-0">

                        <div x-data="{ searchmobile: false }" class="order-1 rounded-md py-4 h-11 text-sm font-light text-zinc-800 flex items-center justify-center mx-1 md:hidden">
                            <span>
                                <svg x-on:click="searchmobile = ! searchmobile" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-1 md:w-6 md:h-6 md:ml-1 cursor-pointer">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                                </svg>
                            </span>

                            <div x-show="searchmobile" class="h-screen w-screen bg-white flex justify-center items-center fixed top-0 right-0 bg-opacity-95 z-[801]">
                                <div x-on:click="searchmobile = ! searchmobile" class="text-red-500 h-screen w-screen flex justify-center items-center fixed top-0 right-0 z-40">
                                    <span class="absolute flex justify-center top-32 w-screen h-screen">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-16 h-16">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                                        </svg>
                                    </span>

                                </div>

                                <div class="z-[999]">
                                    <div class="md:mr-5 lg:mr-24 h-16 flex items-center justify-center">
                                        <form class="w-full">
                                            <div class="relative">
                                                <div class="absolute inset-y-0 left-0 flex items-center pointer-events-none">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z"></path>
                                                    </svg>
                                                </div>
                                                <input type="search" data-swplive="true" id="search-mobile" class="w-[85vw] block h-11 p-4 lg:pr-10 text-sm text-gray-900 border border-gray-200 rounded-md bg-white focus:ring-blue-500 focus:border-blue-500 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 placeholder:text-gray-900 md:hidden" placeholder="جستجو کنید..." required="" autocomplete="off" aria-owns="searchwp_live_search_results_658edacfab2a3" aria-autocomplete="both" aria-label="زمانی که نتایج خودکار نمایش داده شده از دکمه های بالا و پایین صفحه کلید برای رفتن به صفحه مورد نظرتون استفاده کنید. کاربران تجهیزات لمسی به کشیدن نتایج را مشاهده نمایید.">
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                        </div>



                        <!-- <div x-show="totalbuywoocommerce">

                            <div class="w-screen h-screen bg-black bg-opacity-80 z-[801] fixed left-0 top-0">


                                <div class="h-screen w-11/12 md:w-[23rem] bg-white shadow-sm z-[802] fixed top-0 right-0 flex flex-col justify-between items-center">


                                    <div x-on:click="totalbuywoocommerce = ! totalbuywoocommerce" class="cursor-pointer h-12 w-full bg-slate-100 flex justify-between items-center absolute right-0 top-0 h-12 z-[999]">
                                        <div class="w-10 h-2">
                                            <div class="w-10 h-2 bg-red-600 absolute left-1 top-5 rotate-45"></div>
                                            <div class="w-10 h-2 bg-red-600 absolute left-1 top-5 -rotate-45"></div>
                                        </div>
                                        <span class="ml-12 font-bold"> خروج </span>
                                    </div>


                                    <div class="">

                                        <div class="ic-cart-sidebar-wrapper">
                                            <div class="ic-cart-sidebar-wrapper_header">
                                                <div class="ic-cart-header-btn-close"><i class="ri-close-line"></i></div>
                                            </div>
                                            <div class="ic-cart-sidebar-wrapper_body">
                                                <div class="cartcontents">
                                                    <div class="widget_shopping_cart_content">
                                                        <?php
                                                        woocommerce_mini_cart(['list_class' => 'my-css-class']);
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>






                                    </div>

                                </div>

                                <div x-on:click="totalbuywoocommerce = ! totalbuywoocommerce" class="hidden md:block fixed right-[23rem] top-0 h-screen w-full bg-black bg-opacity-60 shadow-sm z-20"> </div>

                            </div>

                        </div> -->



                        <!-- <button x-on:click="totalbuywoocommerce = ! totalbuywoocommerce" class="md:border-none md:static fixed bottom-20 rounded-r-md rounded-b-md left-0 backdrop-blur-md px-2 md:pl-0 bg-white/80 md:bg-white text-black w-max lg:order-3 py-1 h-11 text-sm font-light lg:bg-white lg:w-auto lg:text-zinc-800 flex items-center justify-center mr-2 border-2 border-slate-200 z-[9]">

                            <span class="">

                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 ml-1 md:w-6 md:h-6 md:ml-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
                                </svg>


                            </span>

                            <span id="cart_container" class="pr-1 rounded-md font-bold text-sm">

                                <span class="cart-contents">
                                    <?php echo WC()->cart->get_cart_contents_count(); ?>
                                    <span class="px-1">/</span>
                                    <?php echo WC()->cart->get_cart_total(); ?>
                                </span>




                            </span>

                        </button> -->
                        <div class="order-2 rounded-md pl-3 md:pl-0 h-11 text-sm font-light text-zinc-800 flex items-center justify-center mr-2">
                            <a title="ثبت نام و ورود یا ورود به حساب کاربری" class="flex items-center justify-center" href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
                                <?php if (is_user_logged_in()) { ?>
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 md:w-6 md:h-6 md:ml-1">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                        </svg>
                                    </span>

                                    <span class="hidden lg:block">
                                        مشاهده حساب کاربری
                                    </span>

                                <?php } else { ?>


                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 md:w-6 md:h-6 md:ml-1">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                                        </svg>
                                    </span>

                                    <span class="hidden lg:block">
                                        ورود یا ثبت نام
                                    </span>

                                <?php } ?>

                            </a>
                        </div>
                    </div>

                </nav>


            </div>
        </div>





    </header>



    <script>
        var menuItems = document.querySelectorAll('li.menu-item-has-children');

        menuItems.forEach(function(menuItem) {
            menuItem.addEventListener('click', function(event) {
                var subMenu = this.querySelector('ul.sub-menu');
                // بررسی وضعیت نمایش زیرمنو
                if (subMenu.style.display === 'block') {
                    subMenu.style.display = 'none'; // اگر قبلاً نمایش داده شده بود، پنهان شود
                } else {
                    // بررسی اگر زیرمنو دیگری باز است آن را پنهان کنید
                    document.querySelectorAll('ul.sub-menu').forEach(function(menu) {
                        if (menu !== subMenu && menu.style.display === 'block') {
                            menu.style.display = 'none';
                        }
                    });
                    subMenu.style.display = 'block'; // در غیر این صورت نمایش داده شود
                }
            });
        });
    </script>







