<?php get_header(); ?>

<div class="w-screen z-0">
    <div class="h-44 md:h-80 flex justify-center items-center relative">
        <div class="">

            <?php global $data_var_option_theme; ?>

            <?php
            if ($data_var_option_theme['bg__title_faq']['url']) {
            ?>
                <?php $img_position_banner_title = $data_var_option_theme['bg_arrow_radio_items_faq'] ?>
                <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo $data_var_option_theme['bg__title_faq']['url']; ?>" style="<?php echo $img_position_banner_title; ?>" alt="">
            <?php
            } else {
            ?>
                <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo get_template_directory_uri(); ?>/inc/img/banner-def.jpg " alt="تصویر 404 -  <?php bloginfo('name'); ?>">
            <?php
            };
            ?>

        </div>

        <div class="absolute">
            <h1 class="text-4xl font-bold text-white"> <?php the_title(); ?> </h1>
        </div>

    </div>

  <?php
$contact_blocks = get_post_meta(get_the_ID(), 'padafan_page_contact_blocks', true);
if (!empty($contact_blocks)) :
?>
<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">
    <div class="mt-6 md:my-12 flex justify-center items-center flex-wrap px-3 md:p-0">
        <div class="w-full rounded-md pb-3 pt-1 px-3">
            <?php foreach ($contact_blocks as $block) : ?>
                <div class="w-full flex flex-wrap rounded-md shadow-lg border-2 border-slate-200 overflow-hidden mb-6">
                    <div class="basis-1/2 hidden md:block">
                        <?php if (!empty($block['image'])) : ?>
                            <img class="w-screen h-44 md:h-80 object-cover" src="<?php echo esc_url($block['image']); ?>" alt="">
                        <?php else : ?>
                            <img class="w-screen h-44 md:h-80 object-cover" src="<?php echo get_template_directory_uri(); ?>/inc/img/location.jpg" alt="تصویر پیش‌فرض">
                        <?php endif; ?>
                    </div>
                    <div class="basis-full md:basis-1/2 p-5 bg-slate-50 border-r-2 border-slate-200 flex flex-wrap justify-center items-center">
                        <div class="full text-lg font-bold basis-10/12">
                            <div class="w-full text-lg font-bold text-center text-slate-900 pb-8 flex items-center justify-center">
                                <span><?php echo esc_html($block['title']); ?></span>
                            </div>
                            <div class="w-full text-base font-light text-center text-slate-700">
                                <p><?php echo esc_html($block['text']); ?></p>
                            </div>
                            <?php if (!empty($block['map'])) : ?>
                                <div class="w-full text-4xl font-bold text-center mt-5">
                                    <a target="_blank" rel="nofollow" href="<?php echo esc_url($block['map']); ?>">
                                        <button class="rounded-md text-base font-bold bg-green-900 text-white border-2 border-white px-4 py-2 hover:text-green-900 hover:bg-white hover:border-2 hover:border-green-900 hover:transition-all duration-300">
                                            مشاهده آدرس بر روی نقشه
                                        </button>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>


</div>

<?php get_footer(); ?>