<?php get_header(); ?>

<div class="w-screen z-0">
    <div class="h-44 md:h-80 flex justify-center items-center relative">
        <div class="">

            <?php global $data_var_option_theme; ?>

            <?php
            if ($data_var_option_theme['bg__title_faq']['url']) {
            ?>
                <?php $img_position_banner_title = $data_var_option_theme['bg_arrow_radio_items_faq'] ?>
                <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo $data_var_option_theme['bg__title_faq']['url']; ?>" style="<?php echo $img_position_banner_title; ?>" alt="">
            <?php
            } else {
            ?>
                <img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo get_template_directory_uri(); ?>/inc/img/banner-def.jpg " alt="تصویر 404 -  <?php bloginfo('name'); ?>">
            <?php
            };
            ?>

        </div>

        <div class="absolute">
            <h1 class="text-4xl font-bold text-white"> <?php the_title(); ?> </h1>
        </div>

    </div>

    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

        <div class="my-6 md:my-12 flex justify-center items-center px-3 md:p-0">

            <div class="w-full max-w-lg md:max-w-6xl bg-slate-100 rounded-md px-3 pb-3 pt-1">


                <?php

                // تعداد آرایه‌ها
                $numArrays = count($data_var_option_theme['title_field_accordion']);

                // حلقه برای نمایش آرایه‌ها
                for ($i = 0; $i < $numArrays; $i++) {

                ?>

                    <div :class="one_operation ? 'ring-offset-2 ring ring-blue-500 rounded-md transition-all duration-500':' ' " x-data="{ one_operation: false }" class="">
                        <!-- header -->
                        <div x-on:click="one_operation = ! one_operation" class="bg-blue-500 w-full h-auto p-3 rounded-md flex justify-between items-center text-white cursor-pointer mt-3">
                            <h2 class="text-lg font-bold basis-10/12 m-0">

                                <?php

                                print_r($data_var_option_theme['title_field_accordion'][$i]);

                                ?>

                            </h2>
                            <div class="basis-2/12 flex justify-end">
                                <svg :class="one_operation ? 'rotate-180':'' " xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="h-6 transition-all duration-700">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5" />
                                </svg>
                            </div>
                        </div>
                        <!-- footer -->
                        <div x-show="one_operation" class="bg-white w-full h-auto px-4 py-2 mt-1 mb-2 rounded-md transition-all duration-1000">
                            <p class="transition-all duration-500">

                                <?php

                                print_r($data_var_option_theme['editor-text-lic'][$i]);
                                ?>
                            </p>
                        </div>
                    </div>




                <?php

                }




                ?>



            </div>


        </div>

    </div>




</div>


<?php get_footer(); ?>