document.addEventListener("DOMContentLoaded", function() {
    let searchInput = document.querySelector(".search-input");
    let searchDropdown = document.querySelector(".search-dropdown");
    let productData = [];

    // دریافت لیست محصولات از JSON
    fetch('/wp-content/themes/mohammadrezabehdarvand/search/product-titles.json')
        .then(response => response.json())
        .then(data => {
            productData = data;
        })
        .catch(error => console.error("❌ خطا در دریافت JSON:", error));

    // نمایش نتایج وقتی کاربر تایپ می‌کند
    searchInput.addEventListener("input", function() {
        let query = searchInput.value.trim().toLowerCase();
        
        if (query.length < 2) {  // کاهش شرط به 2 کاراکتر برای بهبود UX
            hideSearchDropdown();
            return;
        }

        // تبدیل ورودی جستجو به یک آرایه از کلمات جداگانه
        let searchWords = query.split(" ").filter(word => word.length > 1);

        // فیلتر کردن محصولات: بررسی می‌کند که تمام کلمات ورودی در عنوان محصول باشند
        let filteredProducts = productData.filter(product => {
            let title = product.title.toLowerCase();
            return searchWords.every(word => title.includes(word));  // بررسی وجود تمام کلمات در عنوان
        });

        // نمایش نتایج
        if (filteredProducts.length > 0) {
            searchDropdown.innerHTML = filteredProducts
                .map(product => `
                    <a href="${decodeURIComponent(product.url)}" class="search-item">
                        <img src="${product.image ? product.image : '/default-image.jpg'}" alt="${product.title}">
                        <span>${highlightText(product.title, searchWords)}</span>
                    </a>
                `)
                .join("");
            showSearchDropdown();
        } else {
            searchDropdown.innerHTML = "<p class='no-results'>❌ محصولی یافت نشد</p>";
            showSearchDropdown();
        }
    });

    // تابع نمایش لیست جستجو
    function showSearchDropdown() {
        searchDropdown.style.display = "block";
        searchDropdown.style.opacity = "1";
        searchDropdown.style.visibility = "visible";
    }

    // تابع مخفی کردن لیست جستجو
    function hideSearchDropdown() {
        searchDropdown.style.display = "none";
        searchDropdown.style.opacity = "0";
        searchDropdown.style.visibility = "hidden";
    }

    // بستن نتایج وقتی بیرون کلیک شد
    document.addEventListener("click", function(event) {
        if (!searchInput.contains(event.target) && !searchDropdown.contains(event.target)) {
            hideSearchDropdown();
        }
    });

    // تابعی برای هایلایت کردن متن جستجو شده در نتایج
    function highlightText(text, words) {
        let regex = new RegExp("(" + words.join("|") + ")", "gi");
        return text.replace(regex, "<mark>$1</mark>");
    }
});
