<?php



// مسیر وردپرس رو لود می‌کنیم
require_once('../../../../wp-load.php');

global $wpdb;

// دریافت تمام محصولات منتشر شده ووکامرس
$results = $wpdb->get_results("
    SELECT ID, post_title 
    FROM {$wpdb->posts} 
    WHERE post_type = 'product' 
    AND post_status = 'publish'
", ARRAY_A);

// بررسی اینکه محصولی وجود دارد یا نه
if ($results) {
    $product_list = [];
    foreach ($results as $product) {
        $product_id = $product['ID'];
        $product_title = html_entity_decode($product['post_title'], ENT_QUOTES, 'UTF-8');
        $product_url = get_permalink($product_id);

        // دریافت تصویر شاخص محصول
        $product_image = get_the_post_thumbnail_url($product_id, 'thumbnail');
        if (!$product_image) {
            $product_image = '/wp-content/uploads/default-product.jpg'; // تصویر پیش‌فرض در صورت نداشتن تصویر
        }

        $product_list[] = [
            'title' => $product_title,
            'url' => urldecode($product_url),
            'image' => $product_image
        ];
    }

    // ذخیره در فایل JSON
    file_put_contents(__DIR__ . '/product-titles.json', json_encode($product_list, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

    echo "✅ فایل JSON با موفقیت ایجاد شد و تصاویر محصولات ذخیره شدند!";
} else {
    echo "❌ هیچ محصولی یافت نشد!";
}
?>
