<?php get_header(); ?>
<?php
global $post;
global $data_var_option_theme;;

$author_id = $post->post_author;
?>
    <?php global $data_var_option_theme; ?>

<div class="w-screen z-0">
    <div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">
        <div class="md:flex md:justify-between md:items-start md:gap-2">
            <div class="hidden md:block rounded-md basis-auto mt-12 h-auto">
                <div class="md:flex flex-col gap-6 items-cente mt-10">
                    <a href="https://telegram.me/share/url?url=<?php echo get_permalink(); ?>" aria-label="دکمه انتشار مقاله حال حاضر در تلگرام" class="w-8 h-8  text-zinc-500 hover:text-blue-600 inline-block align-middle text-center" rel="noopener noreferrer" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-telegram" viewBox="0 0 16 16">
                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM8.287 5.906c-.778.324-2.334.994-4.666 2.01-.378.15-.577.298-.595.442-.03.243.275.339.69.47l.175.055c.408.133.958.288 1.243.294.26.006.549-.1.868-.32 2.179-1.471 3.304-2.214 3.374-2.23.05-.012.12-.026.166.016.047.041.042.12.037.141-.03.129-1.227 1.241-1.846 1.817-.193.18-.33.307-.358.336a8.154 8.154 0 0 1-.188.186c-.38.366-.664.64.015 1.088.327.216.589.393.85.571.284.194.568.387.936.629.093.06.183.125.27.187.331.236.63.448.997.414.214-.02.435-.22.547-.82.265-1.417.786-4.486.906-5.751a1.426 1.426 0 0 0-.013-.315.337.337 0 0 0-.114-.217.526.526 0 0 0-.31-.093c-.3.005-.763.166-2.984 1.09z" />
                        </svg>
                    </a>
                    <a href="https://twitter.com/share?url=<?php echo get_permalink(); ?>" aria-label="دکمه انتشار مقاله حال حاضر در توییتر" class="w-8 h-8 text-zinc-500 hover:text-blue-600 inline-block align-middle text-center" rel="noopener noreferrer" target="_blank">
                        <svg viewBox="0 0 32 32" fill="currentColor" class="block w-8 h-8" title="Twitter logo">
                            <path d="M32 5.745a13.14 13.14 0 01-3.77 1.034 6.585 6.585 0 002.886-3.632 13.148 13.148 0 01-4.169 1.593 6.557 6.557 0 00-4.792-2.073 6.565 6.565 0 00-6.395 8.061 18.638 18.638 0 01-13.532-6.86 6.534 6.534 0 00-.89 3.301 6.562 6.562 0 002.922 5.464 6.539 6.539 0 01-2.974-.82v.082a6.569 6.569 0 005.266 6.437 6.574 6.574 0 01-2.965.113 6.572 6.572 0 006.133 4.56 13.173 13.173 0 01-8.154 2.81c-.53 0-1.052-.032-1.566-.092a18.583 18.583 0 0010.064 2.95c12.076 0 18.679-10.004 18.679-18.68 0-.285-.006-.568-.019-.85A13.343 13.343 0 0032 5.746" fill-rule="evenodd"></path>
                        </svg>
                    </a>
                    <a href="https://www.linkedin.com/shareArticle?url=<?php echo get_permalink(); ?>" aria-label="دکمه انتشار مقاله حال حاضر در لینکدین" class="w-8 h-8 text-zinc-500 hover:text-blue-600 inline-block align-middle text-center" rel="noopener noreferrer" target="_blank">
                        <svg viewBox="0 0 32 32" fill="currentColor" class="block" title="Linkedin logo">
                            <path d="M25.333 0A6.667 6.667 0 0132 6.667v18.666A6.667 6.667 0 0125.333 32H6.667A6.667 6.667 0 010 25.333V6.667A6.667 6.667 0 016.667 0h18.666zm-8.637 11.13h-4.174v15.305h4.174v-7.797c0-4.331 5.565-4.686 5.565 0v7.797h4.174V17.03c0-7.309-7.797-7.043-9.74-3.445V11.13h.001zm-6.957 0H5.565v15.305H9.74V11.13h-.001zM7.652 4.458a2.445 2.445 0 00-2.435 2.454 2.445 2.445 0 002.435 2.454 2.444 2.444 0 002.435-2.454 2.444 2.444 0 00-2.435-2.454z" fill-rule="evenodd"></path>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="rounded-md basis-8/12 h-auto flex flex-col w-[97%] m-auto md:w-[70%] overflow-hidden">
                <div class="">
                    <h1 class="font-bold text-2xl text-gray-900"> <?php the_title(); ?> </h1>
                </div>
                <div class="rounded-md mt-4 overflow-hidden">
                    <?php
                    $alt_text = get_post_meta(get_the_ID(), '_wp_attachment_image_alt', true);
                    if (empty($alt_text)) {
                        $alt_text = get_the_title();
                    }
                    ?>
                    <?php if (has_post_thumbnail()) { ?>
                        <img class="w-full h-44 md:h-80 object-cover rounded-md" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                    <?php } else { ?>
                        <img class="w-full h-44 md:h-80 object-cover rounded-md" src="<?php echo get_template_directory_uri(); ?>/inc/img/replace-banner.webp" alt="<?php echo esc_attr($alt_text); ?>">
                    <?php } ?>
                    <div class="h-auto py-3 md:h-14 border-b-2 border-slate-200 flex gap-3 flex-wrap justify-between items-center">
                        <div class="flex items-center text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                            <div class="h-5 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 ml-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                                </svg>
                            </div>
                            <div class="">
                                <?php
                                echo get_the_author_meta('display_name', $author_id);
                                ?>
                            </div>
                        </div>
                        <div class="">
                            <span class="text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                                <?php
                                $modified_time = get_the_modified_time('Y/m/d ساعت: H:i');
                                echo " بروزرسانی: " .  $modified_time;
                                ?>
                            </span>
                        </div>
                        <div class="">
                            <?php
                            $content = get_the_content();
                            // تعداد کاراکتر‌های محتوا را محاسبه
                            $totalCharacters = mb_strlen($content);
                            // تعداد کاراکتر‌ها در هر کلمه
                            $charactersPerWord = 5;
                            // میانگین سرعت خواندن کلمه در دقیقه
                            $averageReadingSpeed = 225;
                            // محاسبه تعداد کلمه‌ها
                            $totalWords = ceil($totalCharacters / $charactersPerWord);
                            // محاسبه زمان لازم بر اساس میانگین سرعت خواندن
                            $timeInMinutes = $totalWords / $averageReadingSpeed;
                            // تبدیل به ثانیه
                            $timeInSeconds = $timeInMinutes * 60;
                            // تبدیل ثانیه به دقیقه و ثانیه
                            $minutes = floor($timeInSeconds / 60);
                            $seconds = $timeInSeconds % 60;
                            ?>
                            <span class="text-sm text-gray-900 bg-slate-100 p-1 rounded-md">
                                <?php
                                echo "زمان خواندن $minutes دقیقه و $seconds ثانیه";
                                ?>
                            </span>
                            <?php
                            ?>
                        </div>
                    </div>
                </div>
                <div class="px-3 my-4">
                    <?php the_excerpt(); ?>
                </div>
               <?php
$images = get_post_meta(get_the_ID(), 'padafan_image_gallery', true) ?? [];
$alt_text = get_the_title(); // یا هر متن دلخواهی
if (!empty($images)) {
?>
<div class="md:p-0 md:sticky top-0 right-0 px-3">
    <div class="flex flex-col gap-2">
        <!-- Thumbnails -->
        <div class="order-last flex-col justify-center items-center gap-2 w-full md:max-h-24">
            <div thumbsSlider="" class="swiper swiper-class-top-page-product Swiper--in-single_product relative !h-max">
                <div class="swiper-wrapper">
                    <?php foreach ($images as $image): ?>
                        <div class="swiper-slide rounded-md overflow-hidden gallery-all__img">
                            <img class="overflow-hidden md:h-24 shadow-md border-2 border-slate-200"
                                src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Main Slider -->
        <div class="w-full md:h-auto">
            <div class="h-full rounded-md overflow-hidden">
                <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff"
                    class="swiper Swiper--in-single_product2 bg-slate-50">
                    <div class="swiper-wrapper">
                        <?php foreach ($images as $image): ?>
                            <div class="swiper-slide rounded-md overflow-hidden bg-slate-50">
                                <img class="md:rounded-md md:h-auto shadow-md border-2 border-slate-200"
                                    src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if (count($images) >= 1): ?>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>



                <div class="px-3 my-4">
                    <?php the_content(); ?>
                </div>
                <?php
                // شرط بر اساس نمایش دادن برچسب ها یا نمایش ندادن آنها
                if ($data_var_option_theme['switch-learn-phy_singe_post'] == 1) { ?>
                    <div class="h-auto p-3">
                        <div class="p-3 mt-4 border-2 border-slate-200 rounded-md">
                            <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                                برچسب ها
                            </span>
                            <ul id="" class="flex flex-wrap gap-2 list-none">
                                <?php
                                $post_tags = get_the_tags();
                                if ($post_tags) {
                                    foreach ($post_tags as $tag) {
                                        $tag_link = get_tag_link($tag->term_id);
                                ?>
                                        <li class="rounded-md bg-slate-200 h-max">
                                            <a href="<?php echo $tag_link; ?>" title="<?php echo $tag->name; ?>" class="p-2 w-max block <?php echo $tag->slug; ?>">
                                                <?php echo $tag->name; ?>
                                            </a>
                                        </li>
                                <?php
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                <?php  }   ?>
                <div class="" id="comment-single-post-blog">
                    <?php
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;
                    ?>
                </div>
                <div class="pt-6 max-w-4xl">
                </div>
            </div>
        </div>
        <div class="basis-3/12 px-5 pb-5">
            <div class="hidden md:flex rounded-md overflow-hidden h-auto mt-24 justify-center items-center flex-wrap p-3 shadow-md">
                <div class="basis-1/5">
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/img/question.png" alt="">
                </div>
                <div class="basis-4/5 p-5">
                    <span class="text-base font-bold text-gray-900"> سوالات و پیشنهادات خود را به صورت دیدگاه مطرح کنید </span>
                </div>
                <a href="#comment-single-post-blog">
                    <div class="basis-full pb-1 flex justify-end">
                        <span class="text-base font-bold text-blue-600"> ارسال دیدگاه </span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="text-blue-600 w-6 h-6">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5" />
                        </svg>
                    </div>
                </a>
            </div>
            <?php
            // شرط بر اساس نمایش دادن دسته بندی ها یا نمایش ندادن آنها
            if ($data_var_option_theme['switch-learn-phy_category_singe_post'] == 1) { ?>
                <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">
                    <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                        دسته بندی ها
                    </span>
                    <ul class="list-none">
                        <?php
                        $categories = get_categories();
                        foreach ($categories as $category) {
                            echo '<li><a href="' . get_category_link($category->term_id) . '">' . $category->name . '</a></li>';
                        }
                        ?>
                    </ul>
                </div>
            <?php } ?>
            <?php
            // شرط بر اساس نمایش دادن ماه های انتشار یا نمایش ندادن آنها
            if ($data_var_option_theme['switch-learn-phy_monthly_singe_post'] == 1) { ?>
                <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">
                    <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                        نمایش بر ماه انتشار
                    </span>
                    <ul class="list-none">
                        <?php
                        $args = array(
                            'type'            => 'monthly',
                            'show_post_count' => false,
                        );
                        wp_get_archives($args);
                        ?>
                    </ul>
                </div>
            <?php } ?>
            <?php
            // شرط بر اساس نمایش دادن ماه های انتشار یا نمایش ندادن آنها
            if ($data_var_option_theme['switch_learn_phy_Latest_articles_singe_post'] == 1) { ?>
                <div class="mt-3 rounded-md overflow-hidden h-auto justify-center items-center flex-wrap p-3 shadow-md">
                    <span class="block pb-2 font-bold border-b-2 border-slate-200 mb-3">
                        آخرین مقالات
                    </span>
                    <ul class="list-none">
                        <?php
                        $args = array(
                            'posts_per_page' => 5, // تعداد مقالات
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                        );
                        $recent_posts = get_posts($args);
                        foreach ($recent_posts as $post) :
                            setup_postdata($post);
                        ?>
                            <li class="py-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                        <?php
                        endforeach;
                        wp_reset_postdata();
                        ?>
                    </ul>
                </div>
            <?php } ?>
        </div>
    </div>
    <?php
    // wp_list_comments();
    ?>
</div>
<?php get_footer(); ?>
<script>
    var swiper = new Swiper(".Swiper--in-single_product", {
        spaceBetween: 10,
        slidesPerView: 2.5,
        freeMode: true,
        watchSlidesProgress: true,
        direction: "horizontal",
        delay: 1000,
        disableOnInteraction: false,
        breakpoints: {
            640: {
                slidesPerView: 3.6,
            },
        },
    });
    var swiper2 = new Swiper(".Swiper--in-single_product2", {
        spaceBetween: 10,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        zoom: true,
        autoplay: {
            delay: 5000,
        },
        thumbs: {
            swiper: swiper,
        },
    });
</script>