<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');




?>



<div class="w-screen md:pt-4 bg-cover">

	<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">



		<div class="h-44 md:h-44 overflow-hidden md:rounded-md flex justify-center items-center relative print:hidden">
			<div class="">




				<?php global $data_var_option_theme; ?>



				<?php
				if ($data_var_option_theme['bg__title_archive_shop']['url']) {
				?>
					<?php $img_position_banner_title = $data_var_option_theme['bg_arrow_radio_items_archive_shop'] ?>
					<img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo $data_var_option_theme['bg__title_archive_shop']['url']; ?>" style="<?php echo $img_position_banner_title; ?>" alt="">
				<?php
				} else {
				?>
					<img class="w-screen h-44 md:h-80 object-cover filter brightness-50" src="<?php echo get_template_directory_uri(); ?>/inc/img/banner-def.jpg " alt="تصویر 404 -  <?php bloginfo('name'); ?>">
				<?php
				};
				?>



			</div>
			<div class="absolute flex gap-2 text-white">
				<?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
					<span class="h1 p-0 m-0 text-xl font-bold">دسته بندی: </span>
					<h1 class="p-0 m-0 text-xl"> <?php woocommerce_page_title(); ?></h1>
				<?php endif; ?>
			</div>
		</div>

		<div class="hidden print:block w-full">
			<div class=" flex justify-between items-center">

				<div class="text-black font-bold text-right">
					<span>
						فکراگیم، یادگیری و سرگرمی در کنار هم!
					</span>
				</div>


				<div class="w-28 h-16 flex items-center justify-center">
					<div class="">

						<?php
						if ($data_var_option_theme['header-logo']['url']) {
						?>
							<a href="<?php bloginfo('url'); ?>">
								<img class="w-36 h-auto" src=" <?php echo $data_var_option_theme['header-logo']['url']; ?>" alt=" <?php bloginfo('name'); ?>  لوگو">
							</a>
						<?php

						} else {
						?> <div class="h-12 w-28 bg-slate-100 rounded-md ring-2 ring-cyan-600">
								<span class="w-full h-full flex justify-center items-center text-center font-bold">
									محل درج لوگو هدر
								</span>

							</div>
						<?php
						};
						?>


					</div>
				</div>

			</div>
		</div>

		<div class="lg:flex mb-10">

			<div class="w-full lg:w-[20%] lg:pl-4 p-2 print:hidden">
				<span class="text-base font-bold text-zinc-800 lg:mt-6 py-4 px-1 block">محل جستجو محصول</span>
				<div class="h-12 items-center justify-center flex-col mb-2 md:mb-0">
					<!-- <span class="text-base font-bold text-zinc-800 mt-6 mb-6 block">محل جستجو محصول.</span> -->
					<form class="w-full">
						<div class="relative">
							<div class="absolute inset-y-0 right-3 flex items-center pl-3 pointer-events-none">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-w-10 ml-2 md:w-6 md:h-6 md:ml-1">
									<path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
								</svg>
							</div>
							<input type="search" data-swplive="true" id="search" class="w-full block h-11 p-4 pr-14 lg:pr-10 text-sm text-gray-900 border border-gray-200 rounded-md bg-white focus:ring-blue-500 focus:border-blue-500 dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="جستجو کنید..." required>
						</div>
					</form>
				</div>




				<div class="footer__right">
					<?php if (is_active_sidebar('filter_product_archive')) { ?>
						<ul id="sidebar">
							<?php dynamic_sidebar('filter_product_archive'); ?>
						</ul>
					<?php } ?>
				</div>



				<div class=" pt-14">
					<div :class="one_operation ? 'ring-offset-2 ring border-gray-200 rounded-md transition-all duration-500':' ' " x-data="{ one_operation: false }" class="">
						<!-- header -->
						<div x-on:click="one_operation = ! one_operation" class="px-2 bg-gray-200 w-full h-10 rounded-md flex justify-between items-center text-black cursor-pointer">
							<h2 class="text-sm font-light text-zinc-800 p-0 m-0 flex justify-center items-center">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 ml-1">
									<path stroke-linecap="round" d="M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25h-9A2.25 2.25 0 002.25 7.5v9a2.25 2.25 0 002.25 2.25z"></path>
								</svg>
								راهنمای خرید فروشگاهی
							</h2>
							<div class="basis-2/12 flex justify-end">
								<svg :class="one_operation ? 'rotate-180':'' " xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 transition-all duration-700">
									<path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5" />
								</svg>
							</div>
						</div>
						<!-- footer -->
						<div x-show="one_operation" class="bg-white w-full h-auto rounded-md transition-all duration-1000">
							<div class="mt-2">
								<video class="rounded-md object-cover w-full" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
							</div>
						</div>
					</div>
				</div>









			</div>

			<div class="w-full lg:w-[80%]">



				<?php

				?>
				<header class="woocommerce-products-header p-2">


					<div class="flex w-full justify-end items-center h-12 print:hidden mb-2">




						<a href="<?php echo esc_url(wc_get_cart_url()); ?>">
							<div class="flex text-sm font-light text-zinc-800 items-center justify-center  lg:mr-1 border-2 border-gray-200 rounded-md p-1 h-8">

								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-1 w-6 h-6 md:h-6 md:ml-1">
									<path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
								</svg>
								<span class="pr-1"> تکمیل خرید </span>
							</div>

						</a>




						<div class="flex text-sm font-light text-zinc-800 items-center justify-center lg:mr-2 border-2 border-gray-200 rounded-md p-1 h-8">
							<button onclick="window.print()" class="flex justify-between items-center">
								<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-1 w-6 h-6 md:h-6 md:ml-1">
									<path stroke-linecap="round" stroke-linejoin="round" d="M6.72 13.829c-.24.03-.48.062-.72.096m.72-.096a42.415 42.415 0 0 1 10.56 0m-10.56 0L6.34 18m10.94-4.171c.24.03.48.062.72.096m-.72-.096L17.66 18m0 0 .229 2.523a1.125 1.125 0 0 1-1.12 1.227H7.231c-.662 0-1.18-.568-1.12-1.227L6.34 18m11.318 0h1.091A2.25 2.25 0 0 0 21 15.75V9.456c0-1.081-.768-2.015-1.837-2.175a48.055 48.055 0 0 0-1.913-.247M6.34 18H5.25A2.25 2.25 0 0 1 3 15.75V9.456c0-1.081.768-2.015 1.837-2.175a48.041 48.041 0 0 1 1.913-.247m10.5 0a48.536 48.536 0 0 0-10.5 0m10.5 0V3.375c0-.621-.504-1.125-1.125-1.125h-8.25c-.621 0-1.125.504-1.125 1.125v3.659M18 10.5h.008v.008H18V10.5Zm-3 0h.008v.008H15V10.5Z" />
								</svg>
								دریافت لیست چاپی محصولات
							</button>

						</div>



					</div>




					<?php



					$current_category = get_queried_object(); // دریافت دسته بندی فعلی


					if (has_term($current_category->slug, 'product_cat')) {

						// اگر دسته فعلی "educational-products" یا یکی از زیرمجموعه‌های آن است




						// نام اسلاگ دسته بندی مادر
						$parent_slug = 'educational-products';

						// دریافت شی دسته بندی مادر بر اساس اسلاگ
						$category = get_term_by('slug', $parent_slug, 'product_cat');

						// اگر دسته بندی مادر پیدا شد
						if ($category) {
							// دریافت زیر دسته‌های دسته بندی مادر
							$subcategories = get_terms(array(
								'taxonomy' => 'product_cat',
								'child_of' => $category->term_id,
								'hide_empty' => false, // اگر بخواهید زیر دسته‌های خالی را نیز دریافت کنید
							));

							// آرایه‌ای برای ذخیره نام اسلاگ‌های زیر دسته‌ها
							$subcategory_slugs = array();

							// جمع آوری نام اسلاگ‌های زیر دسته‌ها
							foreach ($subcategories as $subcategory) {
								$subcategory_slugs[] = $subcategory->slug;
							}

							// بررسی آیا نام اسلاگ فعلی در زیر دسته‌ها قرار دارد یا خیر
							if ($current_category->slug === 'educational-products' || in_array($current_category->slug, $subcategory_slugs)) { ?>



								<div class="flex flex-wrap gap-4 px-5 mt-8 md:p-0">
									<div class="grid grid-cols-1 md:grid-cols-3 gap-x-4 gap-y-8 w-full">
										<?php
										if (woocommerce_product_loop()) {
											/**
											 * Hook: woocommerce_before_shop_loop.
											 *
											 * @hooked woocommerce_output_all_notices - 10
											 * @hooked woocommerce_result_count - 20
											 * @hooked woocommerce_catalog_ordering - 30
											 */
											// do_action('woocommerce_before_shop_loop');

											woocommerce_product_loop_start();

											$current_category = get_queried_object(); // دریافت دسته بندی فعلی

											if (wc_get_loop_prop('total')) {
												while (have_posts()) {
													the_post();

													// بررسی اینکه آیا محصول به دسته بندی فعلی تعلق دارد یا نه
													// if (has_term($current_category->slug, 'product_cat')) {

													if (has_term($current_category->slug, 'product_cat')) {

														// اگر دسته فعلی "educational-products" یا یکی از زیرمجموعه‌های آن است




														// نام اسلاگ دسته بندی مادر
														$parent_slug = 'educational-products';

														// دریافت شی دسته بندی مادر بر اساس اسلاگ
														$category = get_term_by('slug', $parent_slug, 'product_cat');

														// اگر دسته بندی مادر پیدا شد
														if ($category) {
															// دریافت زیر دسته‌های دسته بندی مادر
															$subcategories = get_terms(array(
																'taxonomy' => 'product_cat',
																'child_of' => $category->term_id,
																'hide_empty' => false, // اگر بخواهید زیر دسته‌های خالی را نیز دریافت کنید
															));

															// آرایه‌ای برای ذخیره نام اسلاگ‌های زیر دسته‌ها
															$subcategory_slugs = array();

															// جمع آوری نام اسلاگ‌های زیر دسته‌ها
															foreach ($subcategories as $subcategory) {
																$subcategory_slugs[] = $subcategory->slug;
															}

															// بررسی آیا نام اسلاگ فعلی در زیر دسته‌ها قرار دارد یا خیر
															if ($current_category->slug === 'educational-products' || in_array($current_category->slug, $subcategory_slugs)) {
																/**
																 * Hook: woocommerce_shop_loop.
																 */
																do_action('woocommerce_shop_loop');

																wc_get_template_part('content-education', 'product');
															} else {
																/**
																 * Hook: woocommerce_shop_loop.
																 */
																do_action('woocommerce_shop_loop');

																wc_get_template_part('content', 'product');
															}
														}
													}
												}
											}

											woocommerce_product_loop_end();

											/**
											 * Hook: woocommerce_after_shop_loop.
											 *
											 * @hooked woocommerce_pagination - 10
											 */
											do_action('woocommerce_after_shop_loop');
										} else {
											/**
											 * Hook: woocommerce_no_products_found.
											 *
											 * @hooked wc_no_products_found - 10
											 */
											do_action('woocommerce_no_products_found');
										}
										?> </div>

								</div>

							<?php	} else { ?>


								<div class="flex flex-wrap gap-4 px-5 mt-8 md:p-0">
									<div class="grid grid-cols-1 md:grid-cols-2 gap-4 w-full">



										<?php
										if (woocommerce_product_loop()) {
											/**
											 * Hook: woocommerce_before_shop_loop.
											 *
											 * @hooked woocommerce_output_all_notices - 10
											 * @hooked woocommerce_result_count - 20
											 * @hooked woocommerce_catalog_ordering - 30
											 */
											// do_action('woocommerce_before_shop_loop');

											woocommerce_product_loop_start();

											$current_category = get_queried_object(); // دریافت دسته بندی فعلی

											if (wc_get_loop_prop('total')) {
												while (have_posts()) {
													the_post();

													// بررسی اینکه آیا محصول به دسته بندی فعلی تعلق دارد یا نه
													// if (has_term($current_category->slug, 'product_cat')) {

													if (has_term($current_category->slug, 'product_cat')) {

														// اگر دسته فعلی "educational-products" یا یکی از زیرمجموعه‌های آن است




														// نام اسلاگ دسته بندی مادر
														$parent_slug = 'educational-products';

														// دریافت شی دسته بندی مادر بر اساس اسلاگ
														$category = get_term_by('slug', $parent_slug, 'product_cat');

														// اگر دسته بندی مادر پیدا شد
														if ($category) {
															// دریافت زیر دسته‌های دسته بندی مادر
															$subcategories = get_terms(array(
																'taxonomy' => 'product_cat',
																'child_of' => $category->term_id,
																'hide_empty' => false, // اگر بخواهید زیر دسته‌های خالی را نیز دریافت کنید
															));

															// آرایه‌ای برای ذخیره نام اسلاگ‌های زیر دسته‌ها
															$subcategory_slugs = array();

															// جمع آوری نام اسلاگ‌های زیر دسته‌ها
															foreach ($subcategories as $subcategory) {
																$subcategory_slugs[] = $subcategory->slug;
															}

															// بررسی آیا نام اسلاگ فعلی در زیر دسته‌ها قرار دارد یا خیر
															if ($current_category->slug === 'educational-products' || in_array($current_category->slug, $subcategory_slugs)) {
																/**
																 * Hook: woocommerce_shop_loop.
																 */
																do_action('woocommerce_shop_loop');

																wc_get_template_part('content-education', 'product');
															} else {
																/**
																 * Hook: woocommerce_shop_loop.
																 */
																do_action('woocommerce_shop_loop');

																wc_get_template_part('content', 'product');
															}
														}
													}
												}
											}

											woocommerce_product_loop_end();

											/**
											 * Hook: woocommerce_after_shop_loop.
											 *
											 * @hooked woocommerce_pagination - 10
											 */
											do_action('woocommerce_after_shop_loop');
										} else {
											/**
											 * Hook: woocommerce_no_products_found.
											 *
											 * @hooked wc_no_products_found - 10
											 */
											do_action('woocommerce_no_products_found');
										}
										?>


									</div>

								</div> <?php





									}
								}
							}


										?>










				</header>

















			</div>


		</div>

	</div>

</div>

</div>




<?php




get_footer('shop');
