<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

global $data_var_option_theme;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
	return;
} ?>


<div class="border-2 border-slate-200 h-auto w-auto px-5 pb-5 rounded-md hover:shadow-lg">
	<div class="">

		<a href="<?php echo get_permalink(); ?>">

			<div class="">
				<div class="h-44">
					<?php the_post_thumbnail('thumbnail_product_archive_edu_60', ['class' => 'w-full h-full -mt-5 rounded-md overflow-hidden hover:shadow-lg object-cover print:h-20 print:w-20']) ?>
				</div>


				<div class="h-auto flex justify-start items-center">
					<span class="whitespace-nowrap overflow-hidden pr-1 print:w-full overflow-x-scroll md:overflow-hidden w-full block font-bold text-lg pt-4 pb-3 print:overflow-hidden ">
						<?php the_title(); ?>
					</span>
				</div>



				<div class="flex h-11 justify-between items-center">
					<div class="flex flex-nowrap">
						<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 mx-1">
							<path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
						</svg>
						<?php print_r($data_var_option_theme['time_lesson_number']); ?>
					</div>

					<div class="text-green-600 flex flex-nowrap">
						<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 mx-1">
							<path stroke-linecap="round" stroke-linejoin="round" d="M12 18.75a6 6 0 0 0 6-6v-1.5m-6 7.5a6 6 0 0 1-6-6v-1.5m6 7.5v3.75m-3.75 0h7.5M12 15.75a3 3 0 0 1-3-3V4.5a3 3 0 1 1 6 0v8.25a3 3 0 0 1-3 3Z" />
						</svg>

						<?php print_r($data_var_option_theme['level-learn-select-position']); ?>
					</div>

				</div>

				<div class="text-blue-500 cursor-pointer hover:text-blue-900 transition-all duration-300">
					<span class="flex items-center gap-x-2 text-sm font-bold" href="#">
						<span>مشاهده اطلاعات دوره</span>
						<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 20 20" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" d="M7.707 14.707a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l2.293 2.293a1 1 0 010 1.414z" clip-rule="evenodd"></path>
						</svg>
					</span>
				</div>

			</div>

		</a>

		<div class="border-b-2 border-gray-100/80 my-6"></div>


		<?php
		if (wc_customer_bought_product('', get_current_user_id(), $product->get_id())) { ?>

			<a href="<?php echo get_permalink(); ?>">

				<div class="h-11 w-full px-2 flex justify-center gap-2 items-center bg-slate-50 text-gray-600 rounded-md border-2 border-slate-200">
					شما دانشجوی این دوره هستید
					<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 20 20" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M7.707 14.707a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l2.293 2.293a1 1 0 010 1.414z" clip-rule="evenodd"></path>
					</svg>
				</div>
			</a>

		<?php	} else {
			// اگر کاربر محصول را خریده نباشد، کدهای دیگری را اجرا کنید
		?>





			<div class="flex justify-between items-center">

				<div class="basis-2/5">

					<?php

					woocommerce_template_single_add_to_cart();
					?>

					<?php add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart'); ?>

				</div>

				<div class="basis-3/5 flex flex-col justify-center items-end text-left">


					<?php

					// بررسی موجودی محصول
					$stock_status = get_post_meta(get_the_ID(), '_stock_status', true);

					// اگر محصول موجود است
					if ('instock' === $stock_status) {
						$regular_price = $product->get_regular_price();
						$regular_get_price = $product->get_price();
						$formatted_regular_price = number_format($regular_price);
						$formatted_regular_get_price = number_format($regular_get_price);

					?>

						<span class="flex gap-2">
							<?php if ($regular_price > $regular_get_price) { ?>
								<span class="text-secondary-300 text-sm line-through">
									<?php echo $formatted_regular_price;  ?>
								</span>
							<?php
							}
							?>
							<span>
								<?php
								if ($regular_price > $regular_get_price) {
									$discount_percentage = (1 - ($regular_get_price / $regular_price)) * 100;
									$formatted_discount = number_format($discount_percentage, 2); // حداکثر دو رقم اعشار
									$formatted_discount = intval($formatted_discount);
								?>
									<div class="flex bg-red-800 px-1 text-white rounded-md mr-1">
										<span><?php echo "$formatted_discount"; ?></span>%
									</div>
								<?php
								}
								?>
							</span>
						</span>

						<span class="flex gap-2 font-bold text-2xl">
							<span>
								<?php echo $formatted_regular_get_price;  ?>
								<span class="font-normal text-sm">تومان</span>
							</span>
						</span>

					<?php
					} elseif (empty($regular_price) && empty($regular_get_price)) { ?>
						<span class="text-red-500">بدون قیمت</span>
					<?php } else { ?>
						<span class="text-red-500">غیرقابل خرید</span>
					<?php } ?>




				</div>


			</div>






		<?php	} ?>


	</div>
</div>