<?php

/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

do_action('woocommerce_before_customer_login_form'); ?>

<?php global $data_var_option_theme; ?>


<div class="px-3">
	<div class="rounded-md h-auto w-full bg-slate-50 border-2 border-slate-200 md:flex justify-center items-center md:justify-start my-6 p-2 text-justify">
		در صورت وجود هر گونه مشکل لطفا با شماره پشتیبانی
		<a class="contents rounded-md text-blue-600 px-2 h-auto md:flex justify-center items-center" href="tell:<?php print_r($data_var_option_theme['Support_contact_number_to_solve_problems_text']); ?>">
			<?php print_r($data_var_option_theme['Support_contact_number_to_solve_problems_text']); ?>
		</a>
		تماس بگیرید.
		در سریع ترین حالت ممکن، مشکلتان را حل می کنیم.
	</div>
</div>


<div class="w-full flex justify-center items-center">


	<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>


		<div class="w-[90%] md:w-[34rem] h-auto rounded-md border-2 border-slate-200 mt-3 mb-6" x-data="{ open: false }">


			<div class="">


				<!-- ثبت نام -->
				<div x-show="open" class="">


					<div class="flex gap-3 p-3">

						<div x-on:click="open = ! open" class="rounded-md border-2 border-slate-200 h-auto p-3 w-full font-bold flex justify-center items-center hover:bg-slate-50 cursor-pointer">
							<span>
								برای ورود کلیک کنید.
							</span>
						</div>

					</div>


					<form method="post" class="flex w-full flex-col justify-center items-center woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?>>


						<h2 class="mt-6 mb-3">فرم <?php esc_html_e('Register', 'woocommerce'); ?></h2>


						<?php do_action('woocommerce_register_form_start'); ?>

						<?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>

							<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
								<label for="reg_username" class="mt-5 mb-3 block"><?php esc_html_e('Username', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
								<input type="text" class="woocommerce-Input woocommerce-Input--text input-text caret-blue-500 border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full md:w-[32rem] woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																																															?>
							</p>

						<?php endif; ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
							<label for="reg_email" class="mt-5 mb-3 block"><?php esc_html_e('Email address', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
							<input type="email" class="woocommerce-Input woocommerce-Input--text input-text caret-blue-500 border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full md:w-[32rem] woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																																											?>
						</p>

						<?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>

							<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
								<label for="reg_password" class="mt-5 mb-3 block"><?php esc_html_e('Password', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
								<input type="password" class="woocommerce-Input woocommerce-Input--text input-text caret-blue-500 border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full md:w-[32rem] woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
							</p>

						<?php else : ?>

							<p><?php esc_html_e('یک لینک برای تنظیم رمز عبور جدید به آدرس ایمیل شما ارسال می شود.', 'woocommerce'); ?></p>

						<?php endif; ?>

						<?php do_action('woocommerce_register_form'); ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
							<?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
							<button type="submit" class="mb-4 mt-6 cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white focus:border-transparent text-base p-2 flex justify-center items-center rounded-md woocommerce-button button woocommerce-form-login__submit woocommerce-Button woocommerce-button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?> woocommerce-form-register__submit" name="register" value="<?php esc_attr_e('Register', 'woocommerce'); ?>"><?php esc_html_e('Register', 'woocommerce'); ?></button>
						</p>

						<?php do_action('woocommerce_register_form_end'); ?>

						<span x-on:click="open = ! open" class="my-3 font-bold text-blue-600 cursor-pointer">
							آیا قبلا ثبت نام کرده اید؟ ورود به سایت
						</span>

						<p class="my-3 text-right font-normal w-[90%] md:w-[32rem]">
							ثبت نام در این سایت به شما امکان می دهد به وضعیت سفارش و سابقه خود دسترسی پیدا کنید. کافی است فیلدهای زیر را پر کنید ، و ما سریعا یک حساب جدید برای شما راه اندازی می کنیم. ما فقط اطلاعات لازم را برای سریعتر و آسان تر شدن روند خرید را از شما دریافت خواهیم نمود .
						</p>

					</form>




				</div>

				<!-- ورود -->
				<div x-show="! open" class="">


					<div class="flex gap-3 p-3">

						<div x-on:click="open = ! open" class="rounded-md border-2 border-slate-200 h-auto p-3 w-full font-bold flex justify-center items-center hover:bg-slate-50 cursor-pointer">
							<span>
								برای ثبت نام کلیک کنید.
							</span>
						</div>


					</div>



					<form class="flex w-full flex-col justify-center items-center woocommerce-form woocommerce-form-login login" method="post">

						<h2 class="mt-6 mb-3">فرم <?php esc_html_e('Login', 'woocommerce'); ?></h2>

						<?php do_action('woocommerce_login_form_start'); ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
							<label class="mt-5 mb-3 block" for="username"><?php esc_html_e('Username or email address', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
							<input type="text" class="caret-blue-500 border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full md:w-[32rem] woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																																?>
						</p>
						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide w-[90%] md:w-[32rem]">
							<label class="mt-5 mb-3 block" for="password"><?php esc_html_e('Password', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
							<input class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md w-full:md:w-[32rem] woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
						</p>

						<?php do_action('woocommerce_login_form'); ?>

						<p class="form-row w-[90%] md:w-[32rem] mt-5 font-bold">
							<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
								<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e('Remember me', 'woocommerce'); ?></span>
							</label>
							<?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
							<button type="submit" class="my-4 cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white focus:border-transparent text-base p-2 flex justify-center items-center rounded-md woocommerce-button button woocommerce-form-login__submit<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="login" value="<?php esc_attr_e('Log in', 'woocommerce'); ?>">ورود به پنل</button>
						</p>

						<div class="block md:flex justify-between items-center w-[90%] md:[32rem]">

							<span>
								<p class="woocommerce-LostPassword lost_password w-[90%] md:w-max my-3 font-bold text-blue-600">
									<a href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Lost your password?', 'woocommerce'); ?></a>
								</p>
							</span>

							<span x-on:click="open = ! open" class="my-3 font-bold text-blue-600 cursor-pointer">
								ثبت نام در سایت
							</span>

						</div>

						<?php do_action('woocommerce_login_form_end'); ?>

						<p class="my-3 text-right font-normal w-[90%] md:w-[32rem]">
							ورود در این سایت به شما امکان می دهد به وضعیت سفارش و سابقه خود دسترسی پیدا کنید. کافی است اطلاعات خود را وارد نمایید
						</p>

					</form>


				</div>

			</div>

		</div>

</div>


<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>