<?php

/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.3.0
 */

defined('ABSPATH') || exit;

global $product;

$html5 = 'xhtml';
$required_attribute = ($html5 ? ' required' : ' required="required"');
$checked_attribute  = ($html5 ? ' checked' : ' checked="checked"');
$required_indicator = ' ' . wp_required_field_indicator();
$required_text      = ' ' . wp_required_field_message();




if (!comments_open()) {
	return;
}

?>
<div id="reviews" class="woocommerce-Reviews">
	<div id="comments">
		<h2 class="text-lg text-gray-950 font-bold mb-6 ">
			<?php
			$count = $product->get_review_count();
			if ($count && wc_review_ratings_enabled()) {
				/* translators: 1: reviews count 2: product name */
				$reviews_title = sprintf(esc_html(_n('%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'woocommerce')), esc_html($count), '<span>' . get_the_title() . '</span>');
				echo apply_filters('woocommerce_reviews_title', $reviews_title, $count, $product); // WPCS: XSS ok.
			} else {
				esc_html_e('Reviews', 'woocommerce');
			}
			?>
		</h2>


		<?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) : ?>
		<div id="review_form_wrapper" class="border-2 border-slate-200 p-3 rounded-md mb-14">
			<div id="review_form"> 
				<?php
				$commenter    = wp_get_current_commenter();
				$comment_form = array(
					'id_form' => 'commentform',
					'class_form' => 'comment_form',
					// 'reply_text' => __(' <span class="flex justify-center items-center" >

					// 				<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 ml-2 hidden md:block">
					// 				<path stroke-linecap="round" stroke-linejoin="round" d="M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3" />
					// 			    </svg>
					// 				پاسخ
					// 				</span>
								
					// 				', 'textdomain'),
					

					'id_submit' => 'submit',
					'class_submit' => 'mt-4 cursor-pointer bg-blue-600 w-full font-bold focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 focus:shadow-lg hover:shadow-lg hover:transition-all hover:duration-150 shadow-blue-600 text-white mt-0 focus:border-transparent text-base p-2 flex justify-center items-center rounded-md',
					'name_submit' => 'ثبت دیدگاه شما',
					'title_reply' => '<span>  </span>',
					'title_reply_to' => '<span> پاسخ دادن به %s </span>',
					'cancel_reply_link' => '<span> حذف دیدگاه </span>',
					'label_submit' => 'ثبت دیدگاه شما',
					'format' => 'html5',
					'comment_field' => '<textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" placeholder="در اینجا متن خود را تایپ کنید..." class="relative caret-blue-500 w-full border-2 border-slate-200 rounded-md h-40 bg-slate-50 p-3 my-6"></textarea>',
					'must_log_in' => '<p class="must-log-in">' .
						sprintf(
							__('
								<span class="text-gray-900 font-bold">
								 لطفا برای نوشتن دیدگاه وارد شوید.
								</span> 
								<a href="%s" class="bg-blue-600 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-blue-200">ورود یا ثبت نام</a>
								'),
							wp_login_url(apply_filters('the_permalink', get_permalink()))
						) . '</p>',

					'logged_in_as' => '' .
						sprintf(
							__('
								<div class="flex items-center flex-wrap">
				
									<div class="font-bold md:basis-full">  %1$s عزیز الان وارد سایت شدی. </div>
				
									<div class="flex items-center justify-center md:justify-end w-full mt-3 md:mt-0">
										<span class="bg-blue-600 flex justify-center items-center md:basis-auto basis-1/2 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-blue-200"> <a href="%2$s">ورود به پنل کاربری </a> </span>
										<span class="bg-red-600 flex justify-center items-center md:basis-auto basis-1/2 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-red-200" > <a href="%3$s">خروج از حساب </a> </span>
									</div>
								</div>
								'),

							$user_identity,
							get_edit_user_link(),
							wp_logout_url(apply_filters('the_permalink', get_permalink())),
						),
					'comment_notes_before' => sprintf(
						'<p class="comment-notes">%s%s</p>',
						sprintf(
							'<span id="email-notes">
								از اینکه بتوانیم به شما کمک کنیم خوشحال خواهیم شد.
								</span>',
						),
						$required_text
					),


					$name_email_required = (bool) get_option('require_name_email', 1),
					$fields              = array(
						'author' => array(
							'label'    => __('Name', 'woocommerce'),
							'type'     => 'text',
							'value'    => $commenter['comment_author'],
							'required' => $name_email_required,
						),
						'email'  => array(
							'label'    => __('Email', 'woocommerce'),
							'type'     => 'email',
							'value'    => $commenter['comment_author_email'],
							'required' => $name_email_required,
						),
					),


					'fields'  => apply_filters('comment_form_default_fields', $fields),

				);



				$comment_form['fields'] = array();

				foreach ($fields as $key => $field) {

					
					$field_html  = '<p class="comment-form-' . esc_attr($key) . '">';
					$field_html .= '<label class="mt-5 mb-3 block" for="' . esc_attr($key) . '">' . esc_html($field['label']);

					if ($field['required']) {
						$field_html .= '&nbsp;<span class="text-red-500 required">*</span>';
					}

					$field_html .= '</label><input class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-9 bg-slate-50 p-3 flex items-center gap-3 md:w-1/2" id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' /></p>';

					$comment_form['fields'][$key] = $field_html;
				}

				$account_page_url = wc_get_page_permalink('myaccount');
				if ($account_page_url) {
					/* translators: %s opening and closing link tags respectively */
					$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(__(' <span class="text-gray-900 font-bold"> لطفا برای نوشتن دیدگاه وارد شوید. </span> <a href="%s" class="bg-blue-600 rounded-md p-2 mx-2 text-white hover:shadow-md hover:transition-all hover:duration-200 hover:shadow-blue-200">ورود یا ثبت نام</a> '), wp_login_url(apply_filters('the_permalink', get_permalink()))) . '</p>';
				}

				if (wc_review_ratings_enabled()) {
					$comment_form['comment_field'] = '<div class="comment-form-rating"> <select class="bg-white text-sm font-bold text-slate-950 border-2 border-slate-950 rounded-md mt-5 w-full md:w-1/2 px-2 h-9" name="rating" id="rating" aria-required="true" required>
						<option value="">' . esc_html__('امتیاز را انتخاب کنید', 'woocommerce') . '</option>
						<option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
						<option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
						<option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
						<option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
						<option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
					</select></div>';
				}

				$comment_form['comment_field'] .= '<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" placeholder="در اینجا متن خود را تایپ کنید..." class="caret-blue-500 w-full border-2 border-slate-200 rounded-md h-40 bg-slate-50 p-3 mt-6"></textarea></p>';

				comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
				?>
			</div>
		</div>
	<?php else : ?>
		<p class="woocommerce-verification-required"><?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?></p>
	<?php endif; ?>




		<?php if (have_comments()) : ?>
			<ol class="commentlist relative">
				<?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
			</ol>

			<?php
			if (get_comment_pages_count() > 1 && get_option('page_comments')) :
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links(
					apply_filters(
						'woocommerce_comment_pagination_args',
						array(
							'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
							'next_text' => is_rtl() ? '&larr;' : '&rarr;',
							'type'      => 'list',
						)
					)
				);
				echo '</nav>';
			endif;
			?>
		<?php else : ?>
			<p class="woocommerce-noreviews"><?php esc_html_e('There are no reviews yet.', 'woocommerce'); ?></p>
		<?php endif; ?>
	</div>



	<div class="clear"></div>
</div>