<?php

/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;

if (!$product->is_purchasable()) {
	return;
}

echo wc_get_stock_html($product); // WPCS: XSS ok.

if ($product->is_in_stock()) : ?>

	<?php do_action('woocommerce_before_add_to_cart_form'); ?>

	<form class="cart" action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action('woocommerce_before_add_to_cart_button'); ?>

		<?php
		do_action('woocommerce_before_add_to_cart_quantity');

		// چک کردن اینکه محصول در دسته بندی educational-products یا زیر شاخه‌های آن است یا نه
		if (!has_term('educational-products', 'product_cat', $product->get_id())) {
			// نمایش دکمه تعداد محصول در صورتی که محصول در دسته بندی educational-products و زیر شاخه‌های آن نیست
			woocommerce_quantity_input(
				array(
					'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
					'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
					'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
				)
			);
		}


		do_action('woocommerce_after_add_to_cart_quantity');
		?>

		<?php if (!has_term('educational-products', 'product_cat', $product->get_id())) { ?>


			<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="bg-green-800 text-white rounded-md px-1 text-sm mr-1 single_add_to_cart_button button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"><?php echo esc_html($product->single_add_to_cart_text()); ?></button>


		<?php } else { ?>

			<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="bg-blue-600 ring-offset-2 ring ring-blue-500 transition-all duration-500 text-white rounded-md px-1 text-sm mr-1 w-full h-11 flex justify-center items-center single_add_to_cart_button button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"> شرکت در دوره </button>

		<?php } ?>

		<?php do_action('woocommerce_after_add_to_cart_button'); ?>
	</form>

	<?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>