<?php

/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}


?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
	<?php
	$max_depth = get_option('thread_comments_depth');
	$args = array(
		'depth' => 2,
		// 'reply_text' => __(' <span class="flex justify-center items-center" >

		// <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 ml-2 hidden md:block">
		// <path stroke-linecap="round" stroke-linejoin="round" d="M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3" />
		// </svg>
		// پاسخ
		// </span>
	
		// ', 'textdomain'),
	// 	'resond_id' => 'respond',
	// 	'before' => '<div class="">
	// 	<button class="bg-slate-200 text-base text-gray-900 p-2 flex justify-center items-center rounded-md absolute top-[0.10rem] left-[0.10rem]">
	// 		<span class="mr-2">',
	// 	'after' => '	</span>
	// 	</button>
	// </div>',
		'max_depth' => $max_depth
	);
	// comment_reply_link($args, get_comment_ID()); ?>
	<div id="comment-<?php comment_ID(); ?>" class="comment_container">
		<?php
		/**
		 * The woocommerce_review_before hook
		 *
		 * @hooked woocommerce_review_display_gravatar - 10
		 */
		?>

		<div class="comment-text">

			<?php
			/**
			 * The woocommerce_review_before_comment_meta hook.
			 *
			 * @hooked woocommerce_review_display_rating - 10
			 */
			 ?>


			<div class="comment-header">
				<div class="overflow-hidden mt-5 p-3 relative comment__befor_into_<?php echo $depth; ?> border-2 border-slate-200 rounded-md">
					<div class="w-full overflow-x-scroll md:overflow-auto border-b-2 border-slate-200 pb-3 flex justify-between items-center comment__befor_into_bg_<?php echo $depth; ?>">
						<div class="">
							<div class="flex justify-center items-center">


								<div class="basis-1/2 w-16 h-16">

									<img class="w-16 h-16 rounded-full shadow-md border-2 border-slate-200" src="<?php echo get_avatar_url($comment->comment_author_email); ?>" alt="">
								</div>


								<div class="basis-1/2 w-full text-gray-900 mr-3">
									<span class="font-bold text-base block w-max mb-1">

										<?php comment_author();
										do_action('woocommerce_review_before_comment_meta', $comment);
										?>


									</span>
									<span class="block text-sm w-max">
										<?php

										echo ' ' . get_comment_time('Y/m/d ساعت: H:i')
										?>
									</span>

									<span>
										<?php if (user_can($comment->user_id, 'administrator')) { ?>
											<span class="bg-blue-700 text-xs font-bold text-white rounded-md px-1 absolute right-5 top-16">مدیریت </span>
											<?php } else {
											if (wc_customer_bought_product($comment->comment_author_email, $comment->user_id, $comment->comment_post_ID)) { ?>
												<span class="bg-green-700 text-xs font-bold text-white rounded-md px-1 absolute right-6 top-16">خریدار</span>
										<?php }
										} ?>
									</span>

								</div>




							</div>
						</div>






					</div>

					<div class="py-5">
						<p>
							<?php comment_text() ?>
						</p>
						<?php if ($comment->comment_approved == 0) { ?>
							<em>پیام شما در دست بررسی است و قبل از انتشار فقط برای شما نمایش داده می شود</em>
						<?php } ?>
					</div>




				</div>
			</div>





			<?php do_action('woocommerce_review_before_comment_text', $comment);

			/**
			 * The woocommerce_review_comment_text hook
			 *
			 * @hooked woocommerce_review_display_comment_text - 10
			 */

			?>

		</div>
	</div>