<?php get_header();

global $data_var_option_theme;

global $product;

?>



<div class="w-screen z-0">

	<div class="xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">


		<div class="h-11 shadow-md md:flex items-center justify-center rounded-md p-2 mx-5 my-5 md:full block overflow-x-scroll md:overflow-x-auto md:w-max">

			<?php if (class_exists('WooCommerce') && is_woocommerce()) : ?>

				<?php woocommerce_breadcrumb(); ?>

			<?php endif; ?>

		</div>

		<?php wc_print_notices(); ?>



		<div class="md:flex md:justify-between md:items-start md:gap-5 h-auto overflow-hidden relative px-5">


			<div class="md:p-0 md:w-[470px] md:sticky top-0 right-0">

				<div class="flex flex-col gap-2">










					<?php
					// گرفتن ID محصول فعلی
					$product_id = get_the_ID();


					// دریافت شیء محصول
					$product = wc_get_product($product_id);


					// دریافت آرایه از شناسه‌های تصاویر گالری
					$gallery_image_ids = $product->get_gallery_image_ids();


					// چک کردن برای وجود تصاویر گالری
					if (!empty($gallery_image_ids) && count($gallery_image_ids) >= 1) { // اگر تعداد تصاویر گالری یک یا بیشتر بود
					?>
						<div class="order-last flex-col justify-center items-center gap-2 w-full md:w-[400px] md:max-h-24 ">
							<div thumbsSlider="" class="swiper swiper-class-top-page-product mySwiper relative h-auto">
								<div class="swiper-wrapper">


									<!-- تصویر اصلی محصول -->
									<div class="swiper-slide rounded-md overflow-hidden gallery-all__img">
										<img class="overflow-hidden md:h-24 shadow-md border-2 border-slate-200" src="<?php echo wp_get_attachment_image_url($product->get_image_id(), ''); ?>" />
									</div>


									<?php
									// حلقه برای نمایش تصاویر گالری
									foreach ($gallery_image_ids as $image_id) {
										$image_url = wp_get_attachment_url($image_id);
									?>
										<div class="swiper-slide rounded-md overflow-hidden gallery-all__img">
											<img class="overflow-hidden md:rounded-md md:h-24 shadow-md border-2 border-slate-200" src="<?php echo esc_url($image_url); ?>" />
										</div>
									<?php
									}
									?>


								</div>
							</div>
						</div>
					<?php
					}
					?>














					<div class="w-full md:w-[400px] md:h-auto">
						<div class="h-full rounded-md overflow-hidden">



							<div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff" class="swiper mySwiper2 bg-slate-50">
								<div class="swiper-wrapper">

									<div class="swiper-slide rounded-md overflow-hidden bg-slate-50">
										<img class="md:rounded-md h-auto shadow-md border-2 border-slate-200" src="<?php echo wp_get_attachment_image_url($product->get_image_id(), ''); ?>" />
									</div>


									<?php
									// گرفتن ID محصول فعلی
									$product_id = get_the_ID();

									// دریافت شیء محصول
									$product = wc_get_product($product_id);

									// دریافت آرایه از شناسه‌های تصاویر گالری
									$gallery_image_ids = $product->get_gallery_image_ids();

									// چک کردن برای وجود تصاویر گالری
									if (!empty($gallery_image_ids)) {
										foreach ($gallery_image_ids as $image_id) {
											$image_url = wp_get_attachment_url($image_id);
									?>
											<div class="swiper-slide rounded-md overflow-hidden bg-slate-50">
												<img class="md:rounded-md md:h-auto shadow-md border-2 border-slate-200" src="<?php echo esc_url($image_url); ?>" />
											</div>
									<?php
										}
									}
									?>


								</div>


								<?php
								// چک کردن برای وجود تصاویر گالری
								if (!empty($gallery_image_ids) && count($gallery_image_ids) >= 1) { // اگر تعداد تصاویر گالری یک یا بیشتر بود
								?>


									<div class="swiper-button-next"></div>
									<div class="swiper-button-prev"></div>

								<?php } ?>

							</div>


						</div>
					</div>

				</div>

			</div>

			<div class="w-full md:w-1/2 md:pl-5">

				<div class="">
					<h1 class="pb-3 my-5 text-lg font-bold text-gray-900"> <?php the_title(); ?> </h1>
					<!-- <div class="w-full h-6 flex justify-between items-center">
						<div class="flex justify-start items-center gap-2">

							<div class="flex justify-center items-center divide-x-2 divide-slate-200">

								<span class="ml-2">
									<?php echo esc_attr($product->get_average_rating()) ?>
									<span>میانگین رای</span>
								</span>

							</div>

							<span></span>

							<div class="flex justify-center items-center">
								<?php if (get_comments_number($post->ID) > 0) { ?>
									<span class="px-1">
										<?php echo get_comments_number($post->ID); ?>
									</span>
									<span> دیدگاه </span>
								<?php } else { ?>

									<a href="#comment_product">

										<div class="flex items-center">

											نوشتن دیدگاه جدید

											<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 pr-1">
												<path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5" />
											</svg>



										</div>
									<?php	}; ?>

									</a>
							</div>

						</div>

					</div> -->
				</div>







				<?php if ($data_var_option_theme['display-disable_store'] == 0) { ?>




					<div class="flex justify-start items-center py-4 h-auto w-full relative">
						<div class="">
							<span>قیمت:</span>
						</div>
						<div class="text-base font-bold mr-2">

							<?php if ($product->get_regular_price() > 0) : ?>
								<!-- get_regular_price() قیمت تخفیف -->
								<span class="font-normal">
									<?php
									$regular_price = $product->get_regular_price();
									echo number_format($regular_price, 0); // این دستور عدد اعشاری را با دقت دو رقم اعشار نمایش می‌دهد 
									?> تومان
								</span>
							<?php endif; ?>
							<?php if ($product->get_price() < $product->get_regular_price()) : ?>
								<!-- get_price() قیمت فروش با اعمال تخفیف -->
								<span class="font-bold text-base px-2">
									<?php
									$regular_get_price = $product->get_price();
									echo number_format($regular_get_price, 0); // این دستور عدد اعشاری را با دقت دو رقم اعشار نمایش می‌دهد 
									?>
									تومان
								</span>
							<?php endif; ?>

							<?php if ($product->get_price() < $product->get_regular_price()) : ?>
								<!-- get_regular_price() قیمت تخفیف -->
								<span class="bg-red-800 px-2 text-white w-max block md:inline absolute left-0 -top-3 md:static rounded-md">
									<?php
									$regular_price = $product->get_regular_price();
									$regular_get_price = $product->get_price();
									if ($regular_price > $regular_get_price) {
										$discount_percentage = (1 - ($regular_get_price / $regular_price)) * 100;
										$formatted_discount = number_format($discount_percentage, 2); // حداکثر دو رقم اعشار
										$formatted_discount = intval($formatted_discount);
										echo "$discount_percentage% تخفیف";
									} else {
										echo "هیچ تخفیفی وجود ندارد";
									}
									?>
								</span>
							<?php endif; ?>
						</div>
					</div>


					<?php
					if (has_excerpt()) {
					?>
						<div class="py-4 h-max w-full md:border-none">
							<p>
								<?php the_excerpt(); ?>
							</p>
						</div>
					<?php
					}
					?>


					<div class="flex justify-center bg-white shadow-2xl md:shadow-none md:justify-start items-center h-auto pb-5 pt-2 w-full md:relative fixed bottom-0 right-0 left-0 z-[9]">
						<?php woocommerce_template_single_add_to_cart(); ?>
					</div>





					<?php $attributes = $product->get_attributes();

					if (!empty($attributes)) { ?>

						<div class="flex justify-start items-center h-auto pt-4 pb-8 w-full md:border-slate-200 relative">
							<table>
								<tbody class="text-sm text-gray-900">

									<?php

									$iteration = 0; // تعریف شمارنده

									foreach ($attributes as $attribute_key => $attribute) {
										$name = $attribute->get_data()['name'];
										$options = $attribute->get_data()['options']; ?>

										<tr class="min-h-[2.5rem] h-auto flex justify-start items-center">
											<td class="font-bold min-w-[11rem] w-44"> <?php echo "$name"; ?> : </td>
											<td class="font-thin pr-5"> <?php echo implode(", ", $options); ?> </td>
											<br>
										</tr>

									<?php
										$iteration++; // افزایش مقدار شمارنده

										if ($iteration >= 3) {
											break; // متوقف کردن حلقه در صورت رسیدن به حداکثر سه بار
										}
									} ?>

								</tbody>
							</table>
							<?php if ($iteration >= 3) { ?>

								<a href="#detail_product" class="transition-all duration-200">
									<div class="backdrop-blur-sm bg-white/10 w-full absolute bottom-0 right-0 flex justify-center items-center h-14 font-bold text-blue-700 text-sm">

										<span>
											نمایش جزئیات
										</span>

										<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="h-6 rotate-180 mx-2">
											<path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5"></path>
										</svg>

									</div>
								</a>

							<?php } ?>

						</div>

					<?php } ?>




				<?php } ?>







































				<?php
// بررسی اینکه آیا آرایه موجود است و اولین آیتم حداقل 20 کاراکتر داشته باشد
if (!empty($data_var_option_theme['editor-detail-text-lic']) && is_array($data_var_option_theme['editor-detail-text-lic']) && strlen($data_var_option_theme['editor-detail-text-lic'][0]) >= 20) {
?>
    <div class="flex md:max-w-[589px] md:border-t-2 md:border-slate-200">
        <div class="w-full">
            <!-- header -->
            <div class="text-gray-900 h-auto py-2 rounded-md border-2 md:border-none border-slate-200 flex justify-between items-center cursor-pointer mt-3">
                <span class="text-sm font-bold basis-10/12 m-0">
                    موارد تکمیلی محصول
                </span>
            </div>

            <!-- footer -->
            <div class="bg-white h-auto md:px-4 py-2 mt-1 mb-2 rounded-md transition-all duration-1000">
                <ul class="transition-all duration-500 text-sm font-normal flex flex-col flex-wrap list-disc">
                    <div class="w-full max-w-lg md:max-w-6xl bg-slate-100 rounded-md px-3 pb-3 pt-1">
                        <ul class="list-disc p-4">
                            <?php
                            // تعداد آرایه‌ها
                            $numArrays = count($data_var_option_theme['editor-detail-text-lic']);

                            // حلقه برای نمایش آرایه‌ها
                            for ($i = 0; $i < $numArrays; $i++) { ?>
                                <li class="py-2">
                                    <?php echo esc_html($data_var_option_theme['editor-detail-text-lic'][$i]); ?>
                                </li>
                            <?php
                            }
                            ?>
                        </ul>
                    </div>
                </ul>
            </div>
        </div>
    </div>
<?php } ?>





			</div>


			<div class="basis-3/12">

				<div class="border-2 border-slate-200 my-2 p-5 rounded-md text-sm text-gray-900">
					<span class="font-bold pb-4 block">پشتیبانی و خرید محصول</span>
					<ul>
						<?php
						// تعداد آرایه‌ها
						$numArrays = count($data_var_option_theme['title_field_add_item_for_sale']);
						// حلقه برای نمایش آرایه‌ها
						for ($i = 0; $i < $numArrays; $i++) {
						?>
							<li class="pb-2 flex">

								<span>
									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 text-green-600 ml-1">
										<path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5" />
									</svg>
								</span>

								<?php print_r($data_var_option_theme['title_field_add_item_for_sale'][$i]); ?>

							</li>

						<?php } ?>
					</ul>

				</div>

			</div>

		</div>


		<div class=" md:flex md:justify-between md:items-start md:gap-4 h-auto relative md:border-t-2 md:border-slate-200 md:mt-10 pt-4">

			<div class="w-full h-auto px-3">

				<div class="w-full border-slate-200 border-2 h-14 flex md:justify-start justify-center items-center gap-x-2 rounded-md px-2 sticky top-2 mt-3 bg-white shadow-lg z-[8]">

					<div class="bg-slate-200 hover:font-bold hover:text-white hover:bg-blue-600 hover:rounded-md hover:overflow-hidden font-bold text-base cursor-pointer text-gray-900 grow md:grow-0 md:px-3 text-center justify-center items-center w-max h-10 rounded-md flex">
						<a href="#content_product" class="hidden md:block w-full h-auto transition-all duration-200"> <span class="w-full h-10 flex justify-center items-center">توضیحات محصول</span> </a>
						<a href="#content_product" class="md:hidden block w-full h-auto transition-all duration-200"> <span class="w-full h-10 flex justify-center items-center">توضیحات </span> </a>
					</div>

					<div class="bg-slate-200 hover:font-bold hover:text-white hover:bg-blue-600 hover:rounded-md hover:overflow-hidden font-bold text-base cursor-pointer text-gray-900 grow md:grow-0 md:px-3 text-center justify-center items-center w-max h-10 rounded-md flex">
						<a href="#detail_product" class="md:block w-full h-auto transition-all duration-200"> <span class="w-full h-10 flex justify-center items-center">جزئیات </span> </a>
					</div>

					<!-- <div class="bg-slate-200 hover:font-bold hover:text-white hover:bg-blue-600 hover:rounded-md hover:overflow-hidden font-bold text-base cursor-pointer text-gray-900 justify-center items-center w-max h-10 rounded-md flex">
						<a href="#gallery_video_product" class="transition-all duration-200"> <span class="w-full h-full block">ویدئو و گالری عکس</span> </a>
					</div> -->
					<!-- <div class="bg-slate-200 hover:font-bold hover:text-white hover:bg-blue-600 hover:rounded-md hover:overflow-hidden font-bold text-base cursor-pointer text-gray-900 justify-center items-center w-max h-10 rounded-md flex">
						<a href="#download_pdf_product" class="transition-all duration-200"> <span class="w-full h-full block"> دانلود کاتالوگ محصول </span> </a>
					</div> -->
					<div class="bg-slate-200 hover:font-bold hover:text-white hover:bg-blue-600 hover:rounded-md hover:overflow-hidden font-bold text-base cursor-pointer text-gray-900 grow md:grow-0 md:px-3 text-center justify-center items-center w-max h-10 rounded-md flex">
						<a href="#comment_product" class="hidden md:block w-full h-auto transition-all duration-200"> <span class="w-full h-10 flex justify-center items-center">نظرات کاربران</span> </a>
						<a href="#comment_product" class="md:hidden block w-full h-auto transition-all duration-200"> <span class="w-full h-10 flex justify-center items-center">نظرات</span> </a>
					</div>

				</div>

				<div id="content_product" class="w-full py-10">
					<div class=""> <?php the_content(); ?> </div>
				</div>

				<div id="detail_product" class="h-auto w-full px-5 pb-10">
					<h2 class="border-t-2 border-slate-200 pt-10"> جزئیات محصول </h2>
					<div class="pt-8">

						<table class="w-full">
							<tbody class="text-base text-gray-900">

								<?php
								$attributes = $product->get_attributes();
								foreach ($attributes as $attribute_key => $attribute) {
									$name = wc_attribute_label($attribute->get_name()); // تبدیل شناسه به نام قابل‌خواندن
									$options = $product->get_attribute($attribute_key); // مقدار ویژگی به‌عنوان یک رشته


								?>
									<tr class="min-h-[2.5rem] py-2 flex justify-start items-center h-auto md:h-11 bg-slate-50 w-full border-b-2 border-slate-400">
										<td class="flex items-center px-3 font-bold w-44 basis-5/12 md:w-44 md:basis-3/12"> <?php echo esc_html($name); ?> : </td>
										<td class="basis-6/12 md:basis-9/12 font-normal pr-5"> <?php echo esc_html($options); ?> </td>
									</tr>
								<?php
								}
								?>






							</tbody>
						</table>

					</div>
				</div>

				<!-- <div id="gallery_video_product" class="h-auto w-full px-5 pb-10 z-0">
					<h2 class="border-t-2 border-slate-200 pt-10"> گالری عکس و ویدئو </h2>



					<div class="pt-8">

						<div dir="rtl" class="swiper Swiper--in-single_product">
							<div class="swiper-wrapper">

								<div class="swiper-slide w-auto h-96">
									<video class="rounded-md min-w-full absolute object-cover w-auto" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
								</div>

								<div class="swiper-slide w-auto h-96 rounded-md">
									<video class="rounded-md min-w-full absolute object-cover w-auto" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
								</div>

								<div class="swiper-slide w-auto h-64 rounded-md">
									<img class="w-screen h-44 md:h-80 object-contain rounded-md" src="<?php echo get_template_directory_uri(); ?>./inc/img/banner-def.jpg " alt="">
								</div>

								<div class="swiper-slide w-auto h-96 rounded-md">
									<video class="rounded-md min-w-full absolute object-cover w-auto" src="<?php echo get_template_directory_uri(); ?>./inc/video/1.mp4" type="video/mp4" controls preload muted loop></video>
								</div>

								<div class="swiper-slide w-auto h-96 rounded-md">
									<video class="rounded-md min-w-full absolute object-cover w-auto" src="<?php echo get_template_directory_uri(); ?>./inc/video/3.mp4" type="video/mp4" controls preload muted loop></video>
								</div>

							</div>
							<div class="swiper-pagination"></div>

							<div class="swiper-button-prev"></div>
							<div class="swiper-button-next"></div>

						</div>

					</div>
				</div> -->

				<!-- <div id="download_pdf_product" class="h-auto w-full px-5 pb-10">
					<h2 class="border-t-2 border-slate-200 pt-10"> دانلود کاتالوگ محصول </h2>
					<div class="pt-3">

						<div class="">
							<p class="text-gray-900 mb-5">
								دقیقا همین صفحه ای که در آن قرار دارید را می توانید بصورت pdf در استایل مناسب دانلود و مشاهده کنید.
							</p>
							<div class="flex justify-between items-center h-16 rounded-md border-2 border-slate-200 bg-slate-50 p-2">
								<div class="">
									<p class="font-bold">
										برای دانلود کاتالوگ بر روی دکمه
										<span class="text-blue-700">دانلود فایل PDF</span>
										کلیک نمایید.
									</p>
								</div>
								<div class="text-md text-white font-bold flex items-center justify-center rounded-md border-2 border-blue-700 bg-blue-700">
									<a class="h-12 px-8 flex items-center justify-center" href="#">
										دانلود فایل PDF
									</a>
								</div>
							</div>
						</div>

					</div>
				</div> -->

				<div id="comment_product" class="h-auto w-full px-5 pb-10">
					<div class="flex justify-between items-center h-auto pt-10 border-t-2 border-slate-200">
						<h2 class=""> نظرات کاربران </h2>
						<div class="average_star_rating">
							<?php woocommerce_template_loop_rating(); ?>
							<?php echo wc_get_rating_html($product->get_average_rating()); ?>
						</div>
					</div>


					<div class="">
						<?php
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;
						?>
					</div>
				</div>

			</div>

		</div>


		<div id="fixedBox" class="flex justify-center items-center relative">
			<div class="w-full h-24 bg-white shadow-2xl hidden md:block fixed z-10 bottom-2 px-5 border-2 border-slate-200 rounded-md  xl:max-w-screen-xl lg:max-w-screen-lg md:max-w-screen-md md:m-auto">

				<?php if ($product->get_price() < $product->get_regular_price()) : ?>
					<!-- get_regular_price() قیمت تخفیف -->
					<span class="bg-red-800 px-2 text-white w-max block md:inline absolute left-5 -top-3 rounded-md">
						<?php
						$regular_price = $product->get_regular_price();
						$regular_get_price = $product->get_price();
						if ($regular_price > $regular_get_price) {
							$discount_percentage = (1 - ($regular_get_price / $regular_price)) * 100;
							$formatted_discount = number_format($discount_percentage, 2); // حداکثر دو رقم اعشار
							$formatted_discount = intval($formatted_discount);
							echo "$discount_percentage% تخفیف";
						} else {
							echo "هیچ تخفیفی وجود ندارد";
						}
						?>
					</span>
				<?php endif; ?>


				<div class="flex justify-between">

					<div class="flex gap-3 h-24 items-center">
						<div class="rounded-md overflow-hidden h-16 w-auto"><img class="overflow-hidden h-full w-auto object-cover" src="<?php echo wp_get_attachment_image_url($product->get_image_id(), ''); ?>" /></div>
						<div class="w-3/4 font-bold"><?php the_title(); ?></div>
					</div>

					<div class="flex justify-start items-center py-4 h-auto w-auto relative">

						<div class="text-base font-bold mr-2 w-max">

							<?php if ($product->get_regular_price() > 0) : ?>
								<!-- get_regular_price() قیمت تخفیف -->
								<span class="font-normal">
									<?php
									$regular_price = $product->get_regular_price();
									echo number_format($regular_price, 0); // این دستور عدد اعشاری را با دقت دو رقم اعشار نمایش می‌دهد 
									?> تومان
								</span>
							<?php endif; ?>
							<?php if ($product->get_price() < $product->get_regular_price()) : ?>
								<!-- get_price() قیمت فروش با اعمال تخفیف -->
								<span class="font-bold text-base px-2">
									<?php
									$regular_get_price = $product->get_price();
									echo number_format($regular_get_price, 0); // این دستور عدد اعشاری را با دقت دو رقم اعشار نمایش می‌دهد 
									?>
									تومان
								</span>
							<?php endif; ?>


						</div>
					</div>

					<div class="w-[413px] flex items-center justify-end"><?php woocommerce_template_single_add_to_cart(); ?></div>
				</div>
			</div>
		</div>


	</div>

</div>



<?php get_footer(); ?>




<style>

</style>



<script>
	// اسلایدرهای صفحه محصول 

	var swiper = new Swiper(".Swiper--in-single_product", {
		slidesPerView: "2",
		centeredSlides: true,
		spaceBetween: 30,
		pagination: {
			el: ".swiper-pagination",
			dynamicBullets: true,
		},
		autoplay: {
			delay: 5000,
		},
		a11y: {
			prevSlideMessage: 'Previous slide',
			nextSlideMessage: 'Next slide',
		},
		navigation: {
			nextEl: '.swiper-button-next',
			prevEl: '.swiper-button-prev',
		},
		mousewheel: {
			invert: true,
		},

	})





	var swiper = new Swiper(".mySwiper", {
		spaceBetween: 10,
		slidesPerView: 2.5,
		freeMode: true,
		watchSlidesProgress: true,
		direction: "horizontal",
		delay: 1000,
		disableOnInteraction: false,

		breakpoints: {
			640: {
				slidesPerView: 3.6,
			},

		},


	});
	var swiper2 = new Swiper(".mySwiper2", {
		spaceBetween: 10,
		navigation: {
			nextEl: ".swiper-button-next",
			prevEl: ".swiper-button-prev",
		},
		zoom: true,
		autoplay: {
			delay: 5000,
		},
		thumbs: {
			swiper: swiper,
		},

	});






	/* بعد از یک اسکرول مشخص باکس قیمت و نام محصول در پایین صفحه فیکس شود */

	var btn = document.getElementById('fixedBox');
	window.addEventListener('scroll', function() {
		if (window.scrollY > 350) {
			btn.classList.add('show');
		} else {
			btn.classList.remove('show');
		}
	});
</script>